
PolarTriples::usage = "PolarTriples[{r0, r1, dr}, {t0, t1, dt}] gives a 
list of points with r coordinates running from r0 to r1 in steps of dr and t 
coordinates running from t0 to t1 in steps of dt."

( PolarTriples[{r0_, r1_, dr_}, {t0_, t1_, dt_}] := Module[
	{r, t}, 
	Table[
		ToTriple[r Exp[I t]], 
		{r, r0, r1, dr}, {t, t0, t1, dt}
	]
] )

