
Moebius::usage = "Moebius[a, b, c, d][g] gives the transformation of the 
figure g under the mapping z -> (a z + b) / (c z + d), where a, b, c, d are 
complex numbers."

( Moebius[a_, b_, c_, d_] @ g_ := 
	(* If c is zero we just have (a z + b) / d *)
	Linear[a / d, b / d] @ g 
	/; c == 0 || c == N[0] )

( Moebius[a1_, b1_, c1_, d1_] @ g_ := Module[
	{a, b, c, d},
	{a, b, c, d} = {a1, b1, c1, d1} / Sqrt[a1 d1 - b1 c1];

	(* This gives a d - b c = 1, 
	and we compute (a g + b) / (c g + d) as 
	 a / c + (- 1 / c) / (c g + d), 
	using the fact that 1 / z is the conjugate of the inverse of z. *)

	Linear[- 1 / c, a / c] @ Invert[Circle[$o, 1]] @ Mapping[Conjugate] @ 
		Linear[c, d] @ g
] )

