 /*
  * Khoros: $Id: animate.h,v 1.3 1991/12/18 09:06:50 dkhoros Exp $
  */

 /*
  * $Log: animate.h,v $
 * Revision 1.3  1991/12/18  09:06:50  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: animate.h
 >>>>            Author: 
 >>>> Date Last Updated: Thu Dec  5 16:24:37 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _animate_h_
#define _animate_h_

#include "xvinclude.h"


/* -include_includes */

#include "xvforms.h"
#include "xvdisplay.h"
#include "form_info.h"

/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    animate Argument Structure
*
****************************************************************/

typedef struct _animate  {

/*
 *  input clip mask filename (Optional infile)
 */
char	*c;     	/* input clip mask filename FILENAME */
int	 c_flag;	/* input clip mask filename FLAG */

/*
 *  input shape mask filename (Optional infile)
 */
char	*s;     	/* input shape mask filename FILENAME */
int	 s_flag;	/* input shape mask filename FLAG */

/*
 *  image with alternate colormap filename (Optional infile)
 */
char	*cmap_image;     	/* image with alternate colormap filename FILENAME */
int	 cmap_image_flag;	/* image with alternate colormap filename FLAG */

/*
 *  Use pixmap memory (Optional logical)
 */
int	 use_pixmap;      	/* Use pixmap memory LOGIC */
int	 use_pixmap_flag;  	/* Use pixmap memory FLAG */

/*
 *  Use rootwindow to display animation (Optional logical)
 */
int	 use_root;      	/* Use rootwindow to display animation LOGIC */
int	 use_root_flag;  	/* Use rootwindow to display animation FLAG */

/*
 *  Creates an iconic animation when iconified (Optional logical)
 */
int	 use_iconic;      	/* Creates an iconic animation when iconified LOGIC */
int	 use_iconic_flag;  	/* Creates an iconic animation when iconified FLAG */

/*
 *  use colormap? (Optional logical)
 */
int	 use_cmap;      	/* use colormap? LOGIC */
int	 use_cmap_flag;  	/* use colormap? FLAG */

/*
 *  x location of GUI (Optional integer)
 */
int	 x;    	/* x location of GUI INT */
int	 x_flag;	/* x location of GUI FLAG */

/*
 *  y location of GUI (Optional integer)
 */
int	 y;    	/* y location of GUI INT */
int	 y_flag;	/* y location of GUI FLAG */

/*
 *  initial update time (Optional float)
 */
float	 update;      	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

/*
 *  host:display.screen (Optional string)
 */
char	*display;       	/* host:display.screen STRING */
int	 display_flag;   	/* host:display.screen FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  basename to a set of images (Required string)
 */
char	*base;       	/* basename to a set of images STRING */
int	 base_flag;   	/* basename to a set of images FLAG */

/*
 *  image to do slide show animation (Required infile)
 */
char	*i;     	/* image to do slide show animation FILENAME */
int	 i_flag;	/* image to do slide show animation FLAG */

/*-------------------------------------------*/

}  animate_struct;

animate_struct *animate;

/* -include_additions */

typedef struct _Image
{
        int       num, depth;
        XImage    *ximage, *icon_ximage;
        Pixmap    pixmap, icon_pixmap;

        struct    _Image  *next, *prev;
} Image;

typedef struct _AnimateStructure
{
        float     speed;
        int       direction, control, continous;

        int       number, iconified;
        int       use_iconic, use_pixmap;
        int       use_root, rootx, rooty;

        XFontStruct *font;
        int         font_height, show_band;

        int       width, height;
        int       icon_width, icon_height;

        Image     *head, *tail;
        Image     *current;
        XtIntervalId id;
} AnimateStructure;

AnimateStructure *xvanimate;
DisplayStructure *xvdisplay;

GC      gc;
Display *display;

int     read_from_memory;
/* -include_additions_end */

/* -include_macros */

/*
 *  Defines for the direction in which the animation will playback it's
 *  images.
 */
#define STOP      0
#define FORWARD   1
#define REVERSE   2

/*
 *  Defines for the control in which the animation will playback it's
 *  images.  We use this when we come to the either end of the image
 *  list.
 */
#define LOOP         1
#define SINGLE       2
#define AUTOREVERSE  3

/* -include_macros_end */

#endif
