 /*
  * Khoros: $Id: vclose.c,v 1.2 1992/03/20 23:11:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vclose.c,v 1.2 1992/03/20 23:11:29 dkhoros Exp $";
#endif

 /*
  * $Log: vclose.c,v $
 * Revision 1.2  1992/03/20  23:11:29  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vclose.c
 >>>>
 >>>>      Program Name: vclose
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Close boundaries in images
 >>>>	
 >>>>	

 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Fri Feb 28 19:46:25 1992
 >>>>
 >>>>          Routines: main- the main program for vclose
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vclose.h"


/****************************************************************
 *
 * Routine Name:  main program for vclose
 *
 *       Input:  
 *        -i1  Input Boundary Image (resulting from vdrf, vgef, vsdef ...) 
 *        -i2  Input Gradient Image (resulting from vdrf, vsdef, sobel...) 
 *        -o  resulting output image or file 
 *
 *
 *        [-grad] Gradient Threshold (used by the closing process)  (value >= 0)
 *        [-len] Minimum Gap Size In Pixels  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *edge, *gradient,*readimage();
    int length, thresh;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    program = "vclose";

    READINPUT (edge,gradient);
    CHECKINPUT (program,edge,gradient);

    if (edge -> row_size != gradient -> row_size ||
        edge -> col_size != gradient -> col_size )
    {
       (void) fprintf(stderr,"vclose: Input Images Are Not The Same Size\n\n");
       exit(1);
    }

   
    length = vclose->len_int;
    thresh = vclose->grad_int;
/* -main_before_lib_call_end */

/* -main_library_call */
   if(! lvclose(edge->imagedata,
                gradient->imagedata,
                edge->row_size,
                edge->col_size,
                length,
                thresh))
    {
        (void) fprintf(stderr, "vclose: lvclose Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vclose -> o_file,edge); 
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vclose 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vclose :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tClose boundaries in images\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Input Boundary Image (resulting from vdrf, vgef, vsdef ...)  (infile)\n");
	fprintf(stderr,"\t-i2  Input Gradient Image (resulting from vdrf, vsdef, sobel...)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image or file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-grad]  Gradient Threshold (used by the closing process) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-len]  Minimum Gap Size In Pixels (integer, >= 0) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vclose\n");
	fprintf(stderr, "\t[-U] Gives the usage for vclose\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vclose.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vclose.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vclose
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Input Boundary Image (resulting from vdrf, vgef, vsdef ...) \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Input Gradient Image (resulting from vdrf, vsdef, sobel...) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image or file \n        {outfile}: "; 
char	*grad_pstr = 
	"\nEnter: (grad) Gradient Threshold (used by the closing process) \n        {integer, >= 0 [0] }: "; 
char	*len_pstr = 
	"\nEnter: (len) Minimum Gap Size In Pixels \n        {integer, >= 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vclose", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vclose.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vclose: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vclose.ans");
		}

	     }

	}

	/*
	 * allocate the vclose structure
	 */
	vclose = (vclose_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vclose_struct));

	/*
	 * get required arguments for vclose
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vclose->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vclose->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vclose->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vclose->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vclose->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vclose->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vclose->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vclose->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vclose->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vclose->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vclose->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vclose->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vclose->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vclose->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vclose->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vclose
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vclose->grad_flag = vget_int(fid, prompt_flag,
	"-grad", grad_pstr, &(vclose->grad_int),
	0, 1, 1);

	vclose->len_flag = vget_int(fid, prompt_flag,
	"-len", len_pstr, &(vclose->len_int),
	1, 1, 1);


}



