 /*
  * Khoros: $Id: vspatial.c,v 1.1 1991/05/10 15:47:37 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vspatial.c,v 1.1 1991/05/10 15:47:37 khoros Exp $";
#endif

 /*
  * $Log: vspatial.c,v $
 * Revision 1.1  1991/05/10  15:47:37  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vspatial.c
 >>>>
 >>>>      Program Name: vspatial
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Spatial Feature Operators
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:27:15 1991
 >>>>
 >>>>          Routines: main- the main program for vspatial
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vspatial.h"


/****************************************************************
 *
 * Routine Name:  main program for vspatial
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *          [-w] window width argument  (1 < value < 64)
 *          [-h] window height argument  (1 < value < 64)
 *          [-m] choose Mean Spatial Operator 
 *          [-v] choose Variance Spatial Operator 
 *          [-c] choose Contrast Spatial Operator 
 *          [-s] choose Ang 2nd Moment Spatial Operator 
 *          [-e] choose Entropy Spatial Operator 
 *          [-d] choose Dispersion Spatial Operator 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT(image);
CHECKINPUT(program, image);
/* -main_before_lib_call_end */

/* -main_library_call */
/* Call the lib routine for calculation of spatial operators */

if(! lvspatial(image, vspatial->w_int, vspatial->h_int, vspatial->m_logic, vspatial->v_logic, vspatial->c_logic, vspatial->s_logic, vspatial->e_logic, vspatial->d_logic))
 {
     (void) fprintf(stderr, "lvspatial Failed\\n");
     exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vspatial->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vspatial 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vspatial :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSpatial Feature Operators\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-w]  window width argument (integer, 1 to 64) [3]\n");
	fprintf(stderr,"\t[-h]  window height argument (integer, 1 to 64) [3]\n");
	fprintf(stderr,"\t[-m]  choose Mean Spatial Operator  (boolean) [true]\n");
	fprintf(stderr,"\t[-v]  choose Variance Spatial Operator  (boolean) [false]\n");
	fprintf(stderr,"\t[-c]  choose Contrast Spatial Operator  (boolean) [false]\n");
	fprintf(stderr,"\t[-s]  choose Ang 2nd Moment Spatial Operator  (boolean) [false]\n");
	fprintf(stderr,"\t[-e]  choose Entropy Spatial Operator  (boolean) [false]\n");
	fprintf(stderr,"\t[-d]  choose Dispersion Spatial Operator  (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vspatial\n");
	fprintf(stderr, "\t[-U] Gives the usage for vspatial\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vspatial.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vspatial.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vspatial
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) window width argument \n        {integer, 1 to 64 [3] }: "; 
char	*h_pstr = 
	"\nEnter: (h) window height argument \n        {integer, 1 to 64 [3] }: "; 
char	*m_pstr = 
	"\nEnter: (m) choose Mean Spatial Operator  \n        {boolean, (y/n)  [yes] }: "; 
char	*v_pstr = 
	"\nEnter: (v) choose Variance Spatial Operator  \n        {boolean, (y/n)  [no] }: "; 
char	*c_pstr = 
	"\nEnter: (c) choose Contrast Spatial Operator  \n        {boolean, (y/n)  [no] }: "; 
char	*s_pstr = 
	"\nEnter: (s) choose Ang 2nd Moment Spatial Operator  \n        {boolean, (y/n)  [no] }: "; 
char	*e_pstr = 
	"\nEnter: (e) choose Entropy Spatial Operator  \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = 
	"\nEnter: (d) choose Dispersion Spatial Operator  \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vspatial", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vspatial.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vspatial: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vspatial.ans");
		}

	     }

	}

	/*
	 * allocate the vspatial structure
	 */
	vspatial = (vspatial_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vspatial_struct));

	/*
	 * get required arguments for vspatial
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vspatial->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vspatial->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vspatial->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vspatial->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vspatial->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vspatial->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vspatial->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vspatial->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vspatial->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vspatial->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vspatial
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vspatial->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(vspatial->w_int),
	3, 1, 64);

	vspatial->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(vspatial->h_int),
	3, 1, 64);

	vspatial->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vspatial->m_logic), 1);

	vspatial->v_flag = vget_logic(fid, prompt_flag,
	"-v", v_pstr, &(vspatial->v_logic), 0);

	vspatial->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(vspatial->c_logic), 0);

	vspatial->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vspatial->s_logic), 0);

	vspatial->e_flag = vget_logic(fid, prompt_flag,
	"-e", e_pstr, &(vspatial->e_logic), 0);

	vspatial->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(vspatial->d_logic), 0);


}



