 /*
  * Khoros: $Id: lvmspan.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmspan.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmspan.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmspan.c
 >>>>
 >>>>      Program Name: vmspan
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:51 1991 
 >>>>
 >>>>          Routines: lvmspan - the library call for vmspan
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmspan - library call for vmspan
*
* Purpose:
*    
*    Dilate a binary image region by a single pixel.
*    
*    
* Input:
*    
*         img1 -- xvimage structure
*         source -- integer (source color)
*         medium -- integer (medium color)
*         wave -- integer (wave color)
*         iter -- number of iterations
*    
*    
* Output:
*    
*         img1 -- holds the result of the dilation
*    
*    
*
* Written By: Greg Donohoe  Pascal Adam 
*    
*    
****************************************************************/


/* -library_def */
#define BLACK 0
#define GREY  128
#define LIGHT 192
#define WHITE 255
int
lvmspan(image,source,medium,wave,iter)
struct xvimage *image;
int source, medium, wave, iter;
/* -library_def_end */

/* -library_code */
{
    int nc,        /* number of columns of image */ 
        nr;        /*   "    "  rows    "  "    */

    unsigned char *result; /* storage of final result */
    unsigned char *tag;    /* tag image */

    char   *program = "lvmspan";

    int i,j,k,ii,jj,ki,kj;
    int icount;
    unsigned char *imgptr, *tagptr, *resptr;

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmspan: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nc = image->row_size; /* number of columns */
    nr = image->col_size; /* number of rows    */

    imgptr = (unsigned char *)(image->imagedata); /* pointer to image's pixels */

    /* dynamic memory allocation for temporary result storage */
    result = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (result == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    /* dynamic memory allocation for tag image storage */
    tag = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (tag == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }


    k = nc * nr;                              /* Normal operation count */
    resptr = result;
    tagptr = tag;

    /* Make a binary 'tag image' to keep track of what we've done */
    for (i=0; i<k; i++) {
         resptr[i] = imgptr[i];
         if (imgptr[i] == source)
            tagptr[i] = GREY;
         else if (imgptr[i] == medium)
            tagptr[i] = LIGHT;
         else
            tagptr[i] = BLACK;
      }

    icount = 1;
    while (icount++ <= iter) {

          for (i=1; i<nr-1; i++) 
              for (j=1; j<nc-1; j++) 
                  if (*(tagptr + i*nc + j) == GREY)  
                       for (ki = -1; ki <= 1; ki++)
                          for (kj = -1; kj <= 1; kj++)
                               if (*(tagptr + (i+ki)*nc + j+kj) == LIGHT) {
                                      *(resptr + (i+ki)*nc + j+kj) = wave;
                                      *(tagptr + (i+ki)*nc + j+kj) = WHITE;
                                   }
          for (i=1; i<k; i++)
             if (tagptr[i] == WHITE)
                 tagptr[i] = GREY;
      }

    imgptr = (unsigned char *) image->imagedata;
    resptr = result;
    for (i=0;i<k;i++)
        *imgptr++ = *resptr++;


    free(result);
    free(tag);

    return(1);
}
/* -library_code_end */
