 /*
  * Khoros: $Id: lvheaded.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvheaded.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvheaded.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvheaded.c
 >>>>
 >>>>      Program Name: vheaded
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:04:12 1991 
 >>>>
 >>>>          Routines: lvheaded - the library call for vheaded
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvheaded - library call for vheaded
*
* Purpose:
*    
*    Edit the header fields of a VIFF image
*    
*    
* Input:
*    
*    image          Pointer to xvimage structure to be edited
*    
*    danger         integer, 0 means edit "safe" fields, 1 means  edit
*                   all fields (dangerous ones too)
*    
*    
* Output:
*    
*    image          Pointer to xvimage structure that has  been  modi-
*                   fied.  This  overwrites  the  original header data
*                   values.
*    
*    
*
* Written By: Scott Wilson
****************************************************************/


/* -library_def */
int
lvheaded(image,danger)
struct xvimage *image;
int danger;
/* -library_def_end */

/* -library_code */
  {
    int i;

    i = 0;
    giti(&i,"You are about to edit the VIFF header. 0: quit, 1: cont");
    if (i == 0) return(0);
    i = 0;
    giti(&i,"ARE YOU SURE? 0: quit, 1: cont");
    if (i == 0) return(0);

    if (!danger)
      {
        /* Ask for non-dangerous items in order defined in viff.h */
        printf("Editing non-dangerous header fields:\n");
        gits(image->comment,"Image comment");
        giti(&(image->startx),"Subimage corner position, X component");
        giti(&(image->starty),"Subimage corner position, Y component");
        gitf(&(image->pixsizx),"Pixel dimension, X direction");
        gitf(&(image->pixsizy),"Pixel dimension, Y direction");
        giti(&(image->color_space_model),"Color space model");
      }
    else
      {
        /* Edit ALL fields */
        printf("Editing ALL header fields:\n");

        i = image->identifier;
        giti(&i,"Image identifier (decimal)");
        image->identifier = i;

        i = image->file_type;
        giti(&i,"File type (decimal)");
        image->file_type = i;
    
        i = image->release;
        giti(&i,"Release number (decimal)");
        image->release = i;
    
        i = image->version;
        giti(&i,"Version number (decimal)");
        image->version = i;
    
        i = image->machine_dep;
        giti(&i,"Machine dependency number (decimal)");
        image->machine_dep = i;
    
        gits(image->comment,"Image comment");
        giti(&(image->row_size),"Number of columns");
        giti(&(image->col_size),"Number of rows");
        giti(&(image->subrow_size),"Subrow length");
        giti(&(image->startx),"Subimage starting coordinate, X component");
        giti(&(image->starty),"Subimage starting coordinate, Y component");
        gitf(&(image->pixsizx),"Pixel size in X direction (meters)");
        gitf(&(image->pixsizy),"Pixel size in Y direction (meters)");
        giti(&(image->location_type),"Location type");
        giti(&(image->location_dim),"Location data dimension");
        giti(&(image->num_of_images),"Number of images");
        giti(&(image->num_data_bands),"Number of data bands");
        giti(&(image->data_storage_type),"Data storage type");
        giti(&(image->data_encode_scheme),"Data encoding scheme");
        giti(&(image->map_scheme),"Mapping scheme");
        giti(&(image->map_storage_type),"Map storage type");
        giti(&(image->map_row_size),"Number of columns in map");
        giti(&(image->map_col_size),"Number of rows (entries) in map");
        giti(&(image->map_subrow_size),"Number of subrows per row in map");
        giti(&(image->map_enable),"Map enable");
        giti(&(image->maps_per_cycle),"Maps per cycle");
        giti(&(image->color_space_model),"Color space model");
        giti(&(image->ispare1),"Integer spare #1");
        giti(&(image->ispare2),"Integer spare #2");
        gitf(&(image->fspare1),"Float spare #1");
        gitf(&(image->fspare2),"Float spare #2");
      }
    return(1);
  }

giti(i,msg)
int *i;
char *msg;
  {
    char str[1024];
    printf("%s : <%d> ? ",msg,*i);
    gets(str);
    if (strlen(str) != 0) *i = atoi(str);
  }

gitf(f,msg)
float *f;
char *msg;
  {
    char str[1024];
    printf("%s : <%e> ? ",msg,*f);
    gets(str);
    if (strlen(str) != 0) *f = atof(str);
  }

gits(s,msg)
char *s;
char *msg;
  {
    char str[1024];
    printf("%s : <%s> ? ",msg,s);
    gets(str);
    if (strlen(str) != 0) strcpy(s,str);
  }

/* -library_code_end */
