 /*
  * Khoros: $Id: tga2viff.c,v 1.3 1991/12/18 09:50:53 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: tga2viff.c,v 1.3 1991/12/18 09:50:53 dkhoros Exp $";
#endif

 /*
  * $Log: tga2viff.c,v $
 * Revision 1.3  1991/12/18  09:50:53  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: tga2viff.c
 >>>>
 >>>>      Program Name: tga2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a TGA image to a viff image.
 >>>>	
 >>>>	

 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Thu Aug 22 13:20:57 1991
 >>>>
 >>>>          Routines: main- the main program for tga2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "tga2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for tga2viff
 *
 *       Input:  
 *          -i  input Truevision image file 
 *          -o  resulting output image (viff file) 
 *
 *
 *          [-e] Number of bytes to skip over when reading the file  (0 < value < 512)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
tga *tga_image, *read_tga();
struct xvimage *image;
int file;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if ( (file = kopen(tga2viff->i_file, O_RDONLY)) < 0)
  {
     fprintf(stderr,"tga2viff: Unable to access file %s\n",tga2viff->i_file);
     exit(1);
  }

tga_image = read_tga(file,tga2viff->e_int);
kclose(file);
if (tga_image == NULL) {
     (void) fprintf(stderr,
      "%s: Read_tga failed, Checked your input tga image !!.\n",program);
      exit(1);     
    }
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ltga2viff(tga_image,&image)) {
    (void) fprintf(stderr, "ltga2viff Failed.\n");
    exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(tga2viff->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for tga2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "tga2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a TGA image to a viff image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input Truevision image file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-e]  Number of bytes to skip over when reading the file (integer, 0 to 512) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for tga2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for tga2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called tga2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses tga2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for tga2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input Truevision image file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*e_pstr = 
	"\nEnter: (e) Number of bytes to skip over when reading the file \n        {integer, 0 to 512 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "tga2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "tga2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "tga2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "tga2viff.ans");
		}

	     }

	}

	/*
	 * allocate the tga2viff structure
	 */
	tga2viff = (tga2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (tga2viff_struct));

	/*
	 * get required arguments for tga2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(tga2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(tga2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(tga2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    tga2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(tga2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(tga2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(tga2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(tga2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    tga2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(tga2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for tga2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	tga2viff->e_flag = vget_int(fid, prompt_flag,
	"-e", e_pstr, &(tga2viff->e_int),
	0, 0, 512);


}



