 /*
  * Khoros: $Id: keynames.c,v 1.3 1992/03/20 23:41:26 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: keynames.c,v 1.3 1992/03/20 23:41:26 dkhoros Exp $";
#endif

 /*
  * $Log: keynames.c,v $
 * Revision 1.3  1992/03/20  23:41:26  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "ghost.h"
#include "vinclude.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>  	File Name: keynames.c                         <<<<
   >>>>                                                       <<<<
   >>>>               gw_init_keynames()		      <<<<
   >>>>               gw_init_config_keys()		      <<<<
   >>>>               kraftsman_init_info_keys()              <<<<
   >>>>               kraftsman_init_config_keys()            <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */



/************************************************************
*
*  Routine Name: gw_init_keynames
*
*      Purpose:  This routine initializes the key names for the
*		 text blocks in the program specification file
*
*        Input:  keynames - double string array of key names where
*			    the first index acesses the textblock, and
*			    the second index acesses the begin or end key
*
*		 for example,
*		 keynames[Authors][0] is the begin key for authors text seg.
*		 keynames[Authors][1] is the end key for authors text seg.
*
*       Output:  the string name of that type
*
*    Called by:  print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_init_keynames(keynames)
char **keynames[2];
{
     int i;

     keynames[0] = (caddr_t *) calloc(1,sizeof(char *)*MaxProgSpecSize);
     keynames[1] = (caddr_t *) calloc(1,sizeof(char *)*MaxProgSpecSize);
     for (i = 0; i < MaxProgSpecSize; i++)
            keynames[0][i] = NULL;
     for (i = 0; i < MaxProgSpecSize; i++)
            keynames[1][i] = NULL;

     keynames[0][Authors] = VStrcpy("-authors");
     keynames[1][Authors] = VStrcpy("-authors_end");

     keynames[0][ShortProgDesc] = VStrcpy("-short_prog_description");
     keynames[1][ShortProgDesc] = VStrcpy("-short_prog_description_end");

     keynames[0][ShortLibDesc] = VStrcpy("-short_lib_description");
     keynames[1][ShortLibDesc] = VStrcpy("-short_lib_description_end");

     keynames[0][Man1LongDesc] = VStrcpy("-man1_long_description");
     keynames[1][Man1LongDesc] = VStrcpy("-man1_long_description_end");

     keynames[0][Man1Restrictions] = VStrcpy("-man1_restrictions");
     keynames[1][Man1Restrictions] = VStrcpy("-man1_restrictions_end");

     keynames[0][Man1SeeAlso] = VStrcpy("-man1_see_also");
     keynames[1][Man1SeeAlso] = VStrcpy("-man1_see_also_end");

     keynames[0][Man1Examples] = VStrcpy("-man1_examples");
     keynames[1][Man1Examples] = VStrcpy("-man1_examples_end");

     keynames[0][Man3LongDesc] = VStrcpy("-man3_long_description");
     keynames[1][Man3LongDesc] = VStrcpy("-man3_long_description_end");

     keynames[0][Man3Restrictions] = VStrcpy("-man3_restrictions");
     keynames[1][Man3Restrictions] = VStrcpy("-man3_restrictions_end");

     keynames[0][Man3SeeAlso] = VStrcpy("-man3_see_also");
     keynames[1][Man3SeeAlso] = VStrcpy("-man3_see_also_end");

     keynames[0][UsageAdd] = VStrcpy("-usage_additions");
     keynames[1][UsageAdd] = VStrcpy("-usage_additions_end");

     keynames[0][IncludeAdd] = VStrcpy("-include_additions");
     keynames[1][IncludeAdd] = VStrcpy("-include_additions_end");

     keynames[0][IncludeIncludes] = VStrcpy("-include_includes");
     keynames[1][IncludeIncludes] = VStrcpy("-include_includes_end");

     keynames[0][IncludeMacros] = VStrcpy("-include_macros");
     keynames[1][IncludeMacros] = VStrcpy("-include_macros_end");

     keynames[0][MainVariables] = VStrcpy("-main_variable_list");
     keynames[1][MainVariables] = VStrcpy("-main_variable_list_end");

     keynames[0][MainBeforeLib] = VStrcpy("-main_before_lib_call");
     keynames[1][MainBeforeLib] = VStrcpy("-main_before_lib_call_end");

     keynames[0][MainLibCall] = VStrcpy("-main_library_call");
     keynames[1][MainLibCall] = VStrcpy("-main_library_call_end");

     keynames[0][MainAfterLib] = VStrcpy("-main_after_lib_call");
     keynames[1][MainAfterLib] = VStrcpy("-main_after_lib_call_end");

     keynames[0][LibraryInput] = VStrcpy("-library_input");
     keynames[1][LibraryInput] = VStrcpy("-library_input_end");

     keynames[0][LibraryOutput] = VStrcpy("-library_output");
     keynames[1][LibraryOutput] = VStrcpy("-library_output_end");

     keynames[0][LibraryDef] = VStrcpy("-library_def");
     keynames[1][LibraryDef] = VStrcpy("-library_def_end");

     keynames[0][LibraryCode] = VStrcpy("-library_code");
     keynames[1][LibraryCode] = VStrcpy("-library_code_end");

     keynames[0][LibraryIncludes] = VStrcpy("-library_includes");
     keynames[1][LibraryIncludes] = VStrcpy("-library_includes_end");

     keynames[0][LibraryMods] = VStrcpy("-library_mods");
     keynames[1][LibraryMods] = VStrcpy("-library_mods_end");

}

/************************************************************
*
*  Routine Name: gw_init_config_keys
*
*      Purpose:  This routine initializes the key names for the
*		 config file
*
*        Input:  keynames - string array of key names for the config file
*
*       Output:  none 
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_init_config_keys(config_keys)
char *config_keys[];
{
        config_keys[CPATH]        = VStrcpy("cfile");
        config_keys[HPATH]        = VStrcpy("hfile");
        config_keys[LPATH]        = VStrcpy("lfile");
        config_keys[MAN1PATH]     = VStrcpy("man1file");
        config_keys[MAN3PATH]     = VStrcpy("man3file");
        config_keys[PROGPATH]     = VStrcpy("progfile");
        config_keys[PANEPATH]     = VStrcpy("panefile");
        config_keys[HELPPATH]     = VStrcpy("helpfile");
        config_keys[SUBHELPPATH]  = VStrcpy("subhelpfile");
        config_keys[TOPSRC]       = VStrcpy("topsrc");
}

/************************************************************
*
*  Routine Name: kraftsman_init_info_keys
*
*      Purpose:  This routine initializes the key names for the
*                kraftsman toolbox log file
*
*        Input:  keynames - string array of key names for the log file
*
*       Output:  none
*
*   Written By:  Steven Jorgensen
*
*************************************************************/

kraftsman_init_info_keys(keynames)
char **keynames[2];
  {
     keynames[0] = (caddr_t *) calloc(MaxKraftInfo, sizeof(char *));
     keynames[1] = (caddr_t *) calloc(MaxKraftInfo, sizeof(char *));

     keynames[0][VersionNum] = VStrcpy("-version_start");
     keynames[1][VersionNum] = VStrcpy("-version_end");

     keynames[0][AuthorsList] = VStrcpy("-authors_start");
     keynames[1][AuthorsList] = VStrcpy("-authors_end");

     keynames[0][RevisionLog] = VStrcpy("-revision_log_start");
     keynames[1][RevisionLog] = VStrcpy("-revision_log_end");

     keynames[0][LibPath] = VStrcpy("-library_path_start");
     keynames[1][LibPath] = VStrcpy("-library_path_end");

     keynames[0][BinPath] = VStrcpy("-binary_path_start");
     keynames[1][BinPath] = VStrcpy("-binary_path_start");

     keynames[0][LibSearch] = VStrcpy("-library_search_start");
     keynames[1][LibSearch] = VStrcpy("-library_search_end");

     keynames[0][IncSearch] = VStrcpy("-include_search_start");
     keynames[1][IncSearch] = VStrcpy("-include_search_end");

     keynames[0][CompDef] = VStrcpy("-compiler_defines_start");
     keynames[1][CompDef] = VStrcpy("-compiler_defines_end");

     keynames[0][ToolLibs] = VStrcpy("-toolbox_libs_start");
     keynames[1][ToolLibs] = VStrcpy("-toolbox_libs_end");

     keynames[0][XLibs] = VStrcpy("-x_libs_start");
     keynames[1][XLibs] = VStrcpy("-x_libs_end");

     keynames[0][ForLibs] = VStrcpy("-for_libs_start");
     keynames[1][ForLibs] = VStrcpy("-for_libs_end");
  }

/************************************************************
*
*  Routine Name: kraftsman_init_config_keys
*
*      Purpose:  This routine initializes the key names for the
*                kraftsman toolbox log file
*
*        Input:  keynames - string array of key names for the log file
*
*       Output:  none
*
*   Written By:  Steven Jorgensen
*
*************************************************************/

kraftsman_init_config_keys(keynames)
char **keynames[2];
  {
     keynames[0] = (caddr_t *) calloc(MaxKraftConfig, sizeof(char *));
     keynames[1] = (caddr_t *) calloc(MaxKraftConfig, sizeof(char *));

     keynames[0][DirFlag] = VStrcpy("-dir_start");
     keynames[1][DirFlag] = VStrcpy("-dir_end");

     keynames[0][FileCreate] = VStrcpy("-file_create_start");
     keynames[1][FileCreate] = VStrcpy("-file_create_end");

     keynames[0][FileVars] = VStrcpy("-file_vars_start");
     keynames[1][FileVars] = VStrcpy("-file_vars_end");

     keynames[0][VarDefs] = VStrcpy("-vardef_start");
     keynames[1][VarDefs] = VStrcpy("-vardef_end");
  }
