/*****************************************************************************
* Setting attributes for objects.					     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#ifndef MISCATTR_H
#define MISCATTR_H

#include "irit_sm.h"

typedef enum {
    IP_ATTR_NONE,
    IP_ATTR_INT,
    IP_ATTR_REAL,
    IP_ATTR_STR,
    IP_ATTR_OBJ,
    IP_ATTR_PTR
} IPAttributeType;

#define IP_ATTR_BAD_INT		-32767
#define IP_ATTR_BAD_REAL	1e30
#define IP_ATTR_NO_COLOR	999

/*****************************************************************************
* Attributes - an attribute has a name and can be one of the following:	     *
* an integer, real, string, or a pointer to an Object.			     *
*****************************************************************************/
typedef struct IPAttributeStruct {
    struct IPAttributeStruct *Pnext;
    char *Name;
    IPAttributeType Type;
    union {
	char *Str;
   	int I;
	RealType R;
	struct IPObjectStruct *PObj;
	VoidPtr Ptr;
    } U;
} IPAttributeStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void AttrSetIntAttrib(IPAttributeStruct **Attrs, char *Name, int Data);
int AttrGetIntAttrib(IPAttributeStruct *Attrs, char *Name);

void AttrSetRealAttrib(IPAttributeStruct **Attrs, char *Name, RealType Data);
RealType AttrGetRealAttrib(IPAttributeStruct *Attrs, char *Name);

void AttrSetPtrAttrib(IPAttributeStruct **Attrs, char *Name, VoidPtr Data);
VoidPtr AttrGetPtrAttrib(IPAttributeStruct *Attrs, char *Name);

void AttrSetStrAttrib(IPAttributeStruct **Attrs, char *Name, char *Data);
char *AttrGetStrAttrib(IPAttributeStruct *Attrs, char *Name);

IPAttributeStruct *AttrTraceAttributes(IPAttributeStruct *TraceAttrs,
				       IPAttributeStruct *FirstAttrs);
char *Attr2String(IPAttributeStruct *Attr);

void AttrResetAttributes(IPAttributeStruct **Attrs);

void AttrFreeOneAttribute(IPAttributeStruct **Attrs, char *Name);
void AttrFreeAttributes(IPAttributeStruct **Attrs);

IPAttributeStruct *AttrFindAttribute(IPAttributeStruct *Attrs, char *Name);

IPAttributeStruct *_AttrMallocAttribute(char *Name, IPAttributeType Type);
void _AttrFreeAttributeData(IPAttributeStruct *Attr);

IPAttributeStruct *AttrCopyAttributes(IPAttributeStruct *Src);
IPAttributeStruct *AttrCopyOneAttribute(IPAttributeStruct *Src);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* MISCATTR_H */
