


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef GROUPDEFS
#define GROUPDEFS

#include "oogl/geom.h"
#include "oogl/bbox.h"

/*
 * A Group is a collection of 4x4 transformation matrices
 * all applied to one object.  Generalization of an Inst.
 */

typedef struct geomgroup {
    Geom *unit;
    int   nelements;
    Transform *elements;
    GeomReference *unitref;
} Group;

extern GeomClass *GroupMethods( void );
extern char *GroupName( void );
extern Group *GroupCreate( Geom *obj, int nelements, Transform *elements );
extern Group *GroupDelete( Group * );
extern Group *GroupLoad( char * );
extern Group *GroupFLoad( FILE * );
extern Group *GroupSave( Group *, char * );
extern Group *GroupFSave( Group *, FILE * );
extern BBox *GroupBound( Group *, Transform );
extern Group *GroupTransform( Group *, Transform );
extern Group *GroupRotate( Group *, float, Point * );
extern Group *GroupTranslate( Group *, float, float, float );
extern Group *GroupScale( Group *, float, float, float );
extern Group *GroupEvert( Group * );
extern Group *GroupDraw( Group *, ContextObject *object_context );
extern Group *GroupDrawIrisGl( Group *, ContextObject *object_context );
extern Group *GroupDrawRenderman( Group *, ContextObject *object_context );
extern Group *GroupDrawXWindows( Group *, ContextObject *object_context );
extern Geom *GroupReplace( Group *group, Geom *newunit );

#ifdef GEOM_SM
typedef struct {
    SharedGeom *sunit;
    int  nelements;
    Transform *elements;
} SharedGroup;
extern SharedGroup *GroupShare();
extern Group *GroupPrivate();
extern Group *GroupUnshare();
#endif

#endif
