* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION PAKSZ0 (ANG,IPFILE,IFLG)
*
* FUNCTION TO CONVERT DMS PACKED ANGLE INTO SECONDS OF ARC.
*
      IMPLICIT REAL*8 (A-H,M-Z)
      DIMENSION CODE(2)
      DATA CODE /10000.0D0,100.0D0/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA C1,C2 /3600.0D0,60.0D0/
*
* SEPERATE DEGREE FIELD.
*
      IFLG = 0
      FACTOR = ONE
      IF (ANG .LT. ZERO) FACTOR = - ONE
      SEC = DABS(ANG)
      TMP = CODE(1)
      I = SEC / TMP
      IF (I .GT. 360) GO TO 020
      DEG = I
*
* SEPERATE MINUTES FIELD.
*
      SEC = SEC - DEG * TMP
      TMP = CODE(2)
      I = SEC / TMP
      IF (I .GT. 60) GO TO 020
      MIN = I
*
* SEPERATE SECONDS FIELD.
*
      SEC = SEC - MIN * TMP
      IF (SEC .GT. C2) GO TO 020
      SEC = FACTOR * (DEG * C1 + MIN * C2 + SEC)
      GO TO 040
*
* ERROR DETECTED IN DMS FORM.
*
  020 IF (IPFILE .NE. 0) WRITE (IPFILE,2000) ANG
 2000 FORMAT (' ILLEGAL PACKED DMS FIELD = ',F15.3)
      IFLG = 10
      RETURN
*
  040 PAKSZ0 = SEC
*
      RETURN
      END
