/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.ext;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicConstraints
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.19");
    private final boolean ca;
    private final int pathLenConstraint;
    static /* synthetic */ Class class$gnu$crypto$pki$ext$BasicConstraints;

    public boolean isCA() {
        return this.ca;
    }

    public int getPathLengthConstraint() {
        return this.pathLenConstraint;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList<DERValue> bc = new ArrayList<DERValue>(2);
            bc.add(new DERValue(1, new Boolean(this.ca)));
            if (this.pathLenConstraint >= 0) {
                bc.add(new DERValue(2, BigInteger.valueOf(this.pathLenConstraint)));
            }
            this.encoded = new DERValue(48, bc).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$crypto$pki$ext$BasicConstraints;
        if (clazz == null) {
            clazz = class$gnu$crypto$pki$ext$BasicConstraints = BasicConstraints.class("[Lgnu.crypto.pki.ext.BasicConstraints;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ isCA=").append(this.ca).append(" pathLen=").append(this.pathLenConstraint).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public BasicConstraints(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue bc = der.read();
        if (!bc.isConstructed()) {
            throw new IOException("malformed BasicConstraints");
        }
        DERValue val = bc;
        if (bc.getLength() > 0) {
            val = der.read();
        }
        if (val.getTag() == 1) {
            this.ca = (Boolean)val.getValue();
            if (val.getEncodedLength() < bc.getLength()) {
                val = der.read();
            }
        } else {
            this.ca = false;
        }
        this.pathLenConstraint = val.getTag() == 2 ? ((BigInteger)val.getValue()).intValue() : -1;
    }

    public BasicConstraints(boolean ca, int pathLenConstraint) {
        this.ca = ca;
        this.pathLenConstraint = pathLenConstraint;
    }
}

