/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.ext;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.Util;
import gnu.crypto.pki.ext.Extension;
import gnu.crypto.pki.ext.GeneralNames;
import java.io.IOException;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AuthorityKeyIdentifier
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.35");
    private final byte[] keyIdentifier;
    private final GeneralNames authorityCertIssuer;
    private final BigInteger authorityCertSerialNumber;
    static /* synthetic */ Class class$gnu$crypto$pki$ext$AuthorityKeyIdentifier;

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier != null ? (byte[])this.keyIdentifier.clone() : null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$crypto$pki$ext$AuthorityKeyIdentifier;
        if (clazz == null) {
            clazz = class$gnu$crypto$pki$ext$AuthorityKeyIdentifier = AuthorityKeyIdentifier.class("[Lgnu.crypto.pki.ext.AuthorityKeyIdentifier;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ keyId=").append(this.keyIdentifier != null ? Util.toHexString(this.keyIdentifier, ':') : "nil").append(" authorityCertIssuer=").append(this.authorityCertIssuer).append(" authorityCertSerialNumbe=").append(this.authorityCertSerialNumber).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public AuthorityKeyIdentifier(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed AuthorityKeyIdentifier");
        }
        if (val.getLength() > 0) {
            val = der.read();
        }
        if (val.getTagClass() == 64 && val.getTag() == 0) {
            this.keyIdentifier = (byte[])val.getValue();
            val = der.read();
        } else {
            this.keyIdentifier = null;
        }
        if (val.getTagClass() == 64 && val.getTag() == 1) {
            byte[] b = val.getEncoded();
            b[0] = 48;
            this.authorityCertIssuer = new GeneralNames(b);
            der.skip(val.getLength());
            val = der.read();
        } else {
            this.authorityCertIssuer = null;
        }
        this.authorityCertSerialNumber = val.getTagClass() == 64 && val.getTag() == 2 ? new BigInteger((byte[])val.getValue()) : null;
    }
}

