# Manifest file for WEBFUNDS.
# This is an example "everything" manifest.
# Make this way:
#
#	mkdir cj303
#	cd cj303
#	unzip /tmp/Cryptix_src_3-0-3.zip
#	util/buildjar.sh ../webfunds.man
#	cp src/dist.o/Web* ../Cryptix.jar
#
# or somesuch.
#

name=WebFundsCryptix
version=1-0-1

#
# I'm not sure about this.  The IJCE likes to access the netscape security
# manager, and I don't know what the reason is.  Goes first, is clean.
netscape/security/*.java

java/lang/*.java
java/security/*.java

ijce-lib/IJCE.properties

cryptix/provider/*.java

* This includes
*      IJCE
*      Cryptix Support
*      Algorithms - RSA, Blowfish, DES
* @author Cryptix Development Team <http://cryptix.org/>

#
#  install the provider / check the provider.
#  This should return 1 if it failed to install the provider (Unix), else 0.
#  It will also return 0 if the provider is already installed.
#  STOP_ON_ERROR is a signal to testjar.sh to treat this test as fatal
#
tests= cryptix.provider.Install.STOP_ON_ERROR

#Important notice:
#
# cryptix/util/core/FileUtil.java -> FileUtil.class FileUtil$IdentityFilter.class
#
# cryptix/util/core/FileUtil$IdentityFilter.class

cryptix/provider/mode/*.java
cryptix/provider/padding/*.java
cryptix/provider/key/Raw*.java
cryptix/provider/cipher/NativeLink.java
cryptix/provider/md/NativeLink.java
# only needed for SHA/MD5? old code?
# cryptix/provider/md/BlockMessageDigest.java
cryptix/provider/mac/HMAC.java

cryptix-lib/Cryptix.properties
cryptix/CryptixProperties.java
cryptix/CryptixException.java

cryptix/util/core/*.java
cryptix/util/math/*.java
cryptix/util/checksum/*.java

cryptix/util/mime/Base64*Stream.java

#
#  algorithms
#
# cipher=Blowfish
cipher=Blowfish DES DES_EDE3
cryptix/provider/cipher/<cipher>.java
cryptix/provider/key/<cipher>KeyGenerator.java

java/security/interfaces/RSA*.java
cryptix/provider/rsa/Any_RSA_PKCS1Signature.class
cryptix/provider/rsa/Base*.java
cryptix/provider/rsa/MD5_RSA_PKCS1Signature.java
cryptix/provider/rsa/RSAAlgorithm.java
cryptix/provider/rsa/Raw*.java
cryptix/provider/rsa/SHA1_RSA_PKCS1Signature.java
