/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String FORMAT = "RAW";
    private String algorithm;
    private byte[] data;

    public RawKey(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = (byte[])byArray.clone();
    }

    public RawKey(String string, byte[] byArray, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            n ^= this.data[n2];
            n2 += 4;
        }
        n <<= 8;
        int n3 = 1;
        while (n3 < this.data.length) {
            n ^= this.data[n3];
            n3 += 4;
        }
        n <<= 8;
        int n4 = 2;
        while (n4 < this.data.length) {
            n ^= this.data[n4];
            n4 += 4;
        }
        n <<= 8;
        int n5 = 3;
        while (n5 < this.data.length) {
            n ^= this.data[n5];
            n5 += 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof RawKey) {
            return ArrayUtil.areEqual(this.data, ((RawKey)object).data);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return FORMAT;
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }
}

