/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.DecryptException;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyID;
import cryptix.pgp.KeyRing;
import cryptix.pgp.KeyRingEntry;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.PacketInputStream;
import cryptix.pgp.Passphrase;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import cryptix.util.EmailAddress;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class SecretKeyRing
extends KeyRing {
    protected SecretKeyRing() {
    }

    public SecretKeyRing(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public SecretKeyRing(String string) throws FileNotFoundException, IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(new PacketInputStream(fileInputStream));
        fileInputStream.close();
    }

    public final PublicKey getKey(String string) throws FormatException {
        return null;
    }

    public final SecretKey getKey(String string, Passphrase passphrase) throws IOException, DecryptException {
        KeyID keyID = (KeyID)((Object)this.users.get(string));
        if (keyID == null) {
            return null;
        }
        return this.getKey(keyID, passphrase);
    }

    public final PublicKey getKey(KeyID keyID) {
        return null;
    }

    public final SecretKey getKey(KeyID keyID, Passphrase passphrase) throws DecryptException {
        return this.getSecretKey(keyID, passphrase);
    }

    public final SecretKey getKey(EmailAddress emailAddress, Passphrase passphrase) throws DecryptException {
        return this.getSecretKey(emailAddress, passphrase);
    }

    public final int getKeyTrust(KeyID keyID) {
        if (this.entriesById.get((Object)keyID) != null) {
            return 3;
        }
        return -1;
    }

    protected final void init(PacketInputStream packetInputStream) throws IOException {
        KeyRingEntry keyRingEntry;
        while ((keyRingEntry = packetInputStream.readKeyRingEntry(KeyRingTrust.SECRING)) != null) {
            if (keyRingEntry.certificate().expired()) continue;
            this.add(keyRingEntry);
        }
    }
}

