/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.MessageDigest;

class TestMD4
extends BaseTest {
    public static void main(String[] stringArray) {
        new TestMD4().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(7);
        String[][] stringArrayArray = new String[][]{{"", "31D6CFE0D16AE931B73C59D7E0C089C0"}, {"a", "BDE52CB31DE33E46245E05FBDBD6FB24"}, {"abc", "A448017AAF21D8525FC10AE87AA6729D"}, {"message digest", "D9130A8164549FE818874806E1C7014B"}, {"abcdefghijklmnopqrstuvwxyz", "D79E1C308AA5BBCDEEA8ED63DF412DA9"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "043F8582F241DB351CE627E153E7F0E4"}, {"12345678901234567890123456789012345678901234567890123456789012345678901234567890", "E33B4DDC9C38F2199C3E7B164FCC0536"}};
        MessageDigest messageDigest = MessageDigest.getInstance("MD4", "Cryptix");
        int n = 0;
        while (n < stringArrayArray.length) {
            String string = Hex.toString((byte[])messageDigest.digest(stringArrayArray[n][0].getBytes()));
            this.out.println("  test vector: " + stringArrayArray[n][0]);
            this.out.println("  computed md: " + string);
            this.out.println(" certified md: " + stringArrayArray[n][1]);
            this.passIf(string.equals(stringArrayArray[n][1]), "MD4 #" + (n + 1));
            ++n;
        }
    }

    TestMD4() {
    }
}

