/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Cipher;
import java.security.CipherInputStream;
import java.security.CipherOutputStream;
import java.security.FeedbackCipher;
import java.security.Key;
import java.util.Random;

public class TestIJCE
extends BaseTest {
    private static byte[] input = new byte[288];
    private static final byte[] b = new byte[]{66, 67, 27, -92, 13, 41, 31, -127, -42, 96, -125, -58, 5, -45, -92, -42};
    private static final byte[] anIV = new byte[]{116, 83, 110, -67, -62, 17, 72, 74};
    private static final RawSecretKey aKey = new RawSecretKey("SAFER", b);

    public static void main(String[] stringArray) {
        new TestIJCE().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n;
        this.setExpectedPasses(4);
        int n2 = 0;
        while (n2 < 2) {
            n = 1;
            while (n < 9) {
                TestIJCE.input[16 * n2 + n + 7] = (byte)n;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 256) {
            TestIJCE.input[32 + n] = (byte)n;
            ++n;
        }
        this.out.println("input data\n" + Hex.dumpString((byte[])input));
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        this.out.println("\nSAFER (K-128) in CBC mode (crypt vs. update):\nKey = 42431BA40D291F81D66083C605D3A4D6, IV = 74536EBDC211484A\n");
        Cipher cipher = Cipher.getInstance((String)"SAFER/CBC/PKCS#7", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)aKey);
        byte[] byArray = cipher.crypt(input);
        int n = input.length / 2 - 3;
        cipher.initEncrypt((Key)aKey);
        byte[] byArray2 = new byte[byArray.length];
        int n2 = cipher.update(input, 0, n, byArray2, 0);
        cipher.crypt(input, n, input.length - n, byArray2, n2);
        this.compareIt(byArray, byArray2);
        this.out.println("\nSAFER (SK-128) in CFB mode (crypt vs. update):\nKey = 42431BA40D291F81D66083C605D3A4D6; IV = 74536EBDC211484A\n");
        cipher = Cipher.getInstance((String)"SAFER/CFB");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)aKey);
        byArray = cipher.crypt(input);
        n = input.length / 2 - 3;
        cipher.initEncrypt((Key)aKey);
        byArray2 = new byte[byArray.length];
        n2 = cipher.update(input, 0, n, byArray2, 0);
        cipher.crypt(input, n, input.length - n, byArray2, n2);
        this.compareIt(byArray, byArray2);
    }

    private void test2() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 251;
        nArray[1] = 221;
        nArray[2] = 148;
        nArray[3] = 3;
        nArray[4] = 222;
        nArray[5] = 99;
        nArray[6] = 246;
        nArray[7] = 105;
        nArray[8] = 226;
        nArray[9] = 42;
        nArray[10] = 71;
        nArray[11] = 84;
        nArray[12] = 68;
        nArray[13] = 15;
        nArray[14] = 77;
        nArray[15] = 253;
        nArray[16] = 159;
        nArray[17] = 242;
        nArray[18] = 171;
        nArray[19] = 246;
        nArray[20] = 112;
        nArray[21] = 85;
        nArray[22] = 1;
        nArray[23] = 17;
        nArray[24] = 201;
        nArray[25] = 140;
        nArray[26] = 36;
        nArray[27] = 25;
        nArray[28] = 241;
        nArray[29] = 217;
        nArray[30] = 207;
        nArray[31] = 44;
        nArray[32] = 80;
        nArray[33] = 203;
        nArray[34] = 156;
        nArray[35] = 123;
        nArray[36] = 6;
        nArray[37] = 117;
        nArray[38] = 108;
        nArray[39] = 33;
        nArray[40] = 253;
        nArray[41] = 118;
        nArray[42] = 156;
        nArray[43] = 50;
        nArray[44] = 215;
        nArray[45] = 83;
        nArray[46] = 192;
        nArray[47] = 211;
        nArray[48] = 192;
        nArray[49] = 96;
        nArray[50] = 132;
        nArray[51] = 205;
        nArray[52] = 118;
        nArray[53] = 92;
        nArray[54] = 206;
        nArray[55] = 254;
        nArray[56] = 202;
        nArray[57] = 230;
        nArray[58] = 171;
        nArray[59] = 236;
        nArray[60] = 51;
        nArray[61] = 135;
        nArray[62] = 233;
        nArray[63] = 194;
        nArray[64] = 53;
        nArray[65] = 57;
        nArray[66] = 72;
        nArray[67] = 89;
        nArray[69] = 227;
        nArray[70] = 222;
        nArray[71] = 39;
        nArray[72] = 185;
        nArray[73] = 94;
        nArray[74] = 100;
        nArray[75] = 159;
        nArray[76] = 46;
        nArray[77] = 224;
        nArray[78] = 186;
        nArray[79] = 134;
        nArray[80] = 232;
        nArray[81] = 36;
        nArray[82] = 54;
        nArray[83] = 169;
        nArray[84] = 81;
        nArray[85] = 223;
        nArray[86] = 150;
        nArray[87] = 161;
        nArray[88] = 105;
        nArray[89] = 97;
        nArray[90] = 100;
        nArray[91] = 184;
        nArray[92] = 37;
        nArray[93] = 205;
        nArray[94] = 111;
        nArray[95] = 144;
        nArray[96] = 43;
        nArray[97] = 156;
        nArray[98] = 135;
        nArray[99] = 129;
        nArray[100] = 56;
        nArray[101] = 57;
        nArray[102] = 2;
        nArray[103] = 115;
        nArray[104] = 59;
        nArray[105] = 120;
        nArray[106] = 171;
        nArray[107] = 26;
        nArray[108] = 204;
        nArray[109] = 97;
        nArray[110] = 254;
        nArray[111] = 53;
        nArray[112] = 164;
        nArray[113] = 17;
        nArray[114] = 135;
        nArray[115] = 22;
        nArray[116] = 23;
        nArray[117] = 121;
        nArray[118] = 49;
        nArray[119] = 144;
        nArray[120] = 173;
        nArray[121] = 38;
        nArray[122] = 181;
        nArray[123] = 61;
        nArray[124] = 227;
        nArray[125] = 132;
        nArray[126] = 145;
        nArray[127] = 40;
        nArray[128] = 75;
        nArray[129] = 69;
        nArray[130] = 65;
        nArray[131] = 164;
        nArray[132] = 65;
        nArray[133] = 64;
        nArray[134] = 25;
        nArray[135] = 9;
        nArray[136] = 199;
        nArray[137] = 38;
        nArray[138] = 132;
        nArray[139] = 165;
        nArray[140] = 135;
        nArray[141] = 97;
        nArray[142] = 129;
        nArray[143] = 144;
        nArray[144] = 4;
        nArray[145] = 179;
        nArray[146] = 112;
        nArray[147] = 60;
        nArray[148] = 182;
        nArray[149] = 250;
        nArray[150] = 222;
        nArray[151] = 252;
        nArray[152] = 248;
        nArray[153] = 23;
        nArray[154] = 59;
        nArray[155] = 228;
        nArray[156] = 191;
        nArray[158] = 56;
        nArray[159] = 237;
        nArray[160] = 163;
        nArray[161] = 20;
        nArray[162] = 30;
        nArray[163] = 104;
        nArray[164] = 216;
        nArray[165] = 45;
        nArray[166] = 209;
        nArray[167] = 254;
        nArray[168] = 107;
        nArray[169] = 188;
        nArray[170] = 169;
        nArray[171] = 97;
        nArray[172] = 173;
        nArray[173] = 41;
        nArray[174] = 205;
        nArray[175] = 249;
        nArray[176] = 164;
        nArray[177] = 128;
        nArray[178] = 120;
        nArray[179] = 201;
        nArray[180] = 215;
        nArray[181] = 188;
        nArray[182] = 35;
        nArray[183] = 103;
        nArray[184] = 108;
        nArray[185] = 202;
        nArray[186] = 174;
        nArray[187] = 140;
        nArray[188] = 138;
        nArray[189] = 95;
        nArray[190] = 241;
        nArray[191] = 71;
        nArray[192] = 83;
        nArray[193] = 199;
        nArray[194] = 70;
        nArray[195] = 162;
        nArray[196] = 73;
        nArray[197] = 226;
        nArray[198] = 87;
        nArray[199] = 84;
        nArray[200] = 43;
        nArray[201] = 17;
        nArray[202] = 178;
        nArray[203] = 203;
        nArray[204] = 21;
        nArray[205] = 250;
        nArray[206] = 128;
        nArray[207] = 159;
        nArray[208] = 137;
        nArray[209] = 190;
        nArray[210] = 174;
        nArray[211] = 11;
        nArray[212] = 215;
        nArray[213] = 22;
        nArray[214] = 155;
        nArray[215] = 34;
        nArray[216] = 34;
        nArray[217] = 169;
        nArray[218] = 13;
        nArray[219] = 95;
        nArray[220] = 208;
        nArray[221] = 118;
        nArray[222] = 231;
        nArray[223] = 89;
        nArray[224] = 88;
        nArray[225] = 179;
        nArray[226] = 4;
        nArray[227] = 29;
        nArray[228] = 176;
        nArray[229] = 17;
        nArray[230] = 64;
        nArray[231] = 235;
        nArray[232] = 58;
        nArray[233] = 88;
        nArray[234] = 114;
        nArray[235] = 65;
        nArray[236] = 57;
        nArray[237] = 96;
        nArray[238] = 211;
        nArray[239] = 163;
        nArray[240] = 188;
        nArray[241] = 18;
        nArray[242] = 100;
        nArray[243] = 4;
        nArray[244] = 91;
        nArray[245] = 45;
        nArray[246] = 233;
        nArray[247] = 80;
        nArray[248] = 217;
        nArray[249] = 90;
        nArray[250] = 45;
        nArray[251] = 93;
        nArray[252] = 144;
        nArray[253] = 82;
        nArray[254] = 60;
        nArray[255] = 203;
        nArray[256] = 224;
        nArray[257] = 81;
        nArray[258] = 113;
        nArray[259] = 231;
        nArray[260] = 159;
        nArray[261] = 185;
        nArray[262] = 171;
        nArray[263] = 128;
        nArray[264] = 109;
        nArray[265] = 224;
        nArray[266] = 154;
        nArray[267] = 141;
        nArray[268] = 33;
        nArray[269] = 66;
        nArray[270] = 255;
        nArray[271] = 44;
        nArray[272] = 112;
        nArray[273] = 41;
        nArray[274] = 125;
        nArray[275] = 205;
        nArray[276] = 154;
        nArray[277] = 174;
        nArray[278] = 226;
        nArray[279] = 225;
        nArray[280] = 173;
        nArray[281] = 243;
        nArray[282] = 107;
        nArray[283] = 172;
        nArray[284] = 214;
        nArray[285] = 234;
        nArray[286] = 22;
        nArray[287] = 186;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER (K-128) in CBC mode:\nKey = 42431BA40D291F81D66083C605D3A4D6, IV = 74536EBDC211484A\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        this.out.println("Checking an encryptor input stream...\n");
        Cipher cipher = Cipher.getInstance((String)"SAFER/CBC", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)aKey);
        CipherInputStream cipherInputStream = new CipherInputStream((InputStream)new ByteArrayInputStream(input), cipher);
        byte[] byArray2 = new byte[288];
        Random random = new Random();
        int n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            n2 = cipherInputStream.read(byArray2, n3 += n2, random.nextInt() & 0xF);
        }
        cipherInputStream.close();
        this.compareIt(byArray2, byArray);
        this.out.println("\nChecking a decryptor output stream...\n");
        cipher.initDecrypt((Key)aKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)byteArrayOutputStream, cipher);
        cipherOutputStream.write(byArray2, 0, 100);
        cipherOutputStream.write(byArray2, 100, 100);
        cipherOutputStream.write(byArray2, 200, 88);
        cipherOutputStream.flush();
        cipherOutputStream.close();
        this.compareIt(byteArrayOutputStream.toByteArray(), input);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.println(" computed output: " + Hex.dumpString((byte[])byArray));
        this.out.println("certified output: " + Hex.dumpString((byte[])byArray2));
        this.passIf(ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2), "IJCE test");
    }
}

