#include "pch.h"
#include "diamond.h"

#ifdef DIAMOND_USE_PERMTABLE

NAMESPACE_BEGIN(CryptoPP)

#ifndef IS_LITTLE_ENDIAN
const word32 Diamond2LiteBase::permtable[8][256] =
{{0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020},

{0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040},

{0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180},

{0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201},

{0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402},

{0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010}};
#else
const word32 Diamond2LiteBase::permtable[8][256] =
{{0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001},

{0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102},

{0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204},

{0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408},

{0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810},

{0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080}};
#endif

#ifndef IS_LITTLE_ENDIAN
const word32 Diamond2LiteBase::ipermtable[8][256] =
{{0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408},

{0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204,
0x80000000,0x80010000,0x80000200,0x80010200,0x80000004,0x80010004,0x80000204,0x80010204},

{0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x40000000,0x40000100,0x40000002,0x40000102,0x40000000,0x40000100,0x40000002,0x40000102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x800000,0x800100,0x800002,0x800102,0x800000,0x800100,0x800002,0x800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102,
0x40800000,0x40800100,0x40800002,0x40800102,0x40800000,0x40800100,0x40800002,0x40800102},

{0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,0x20000000,0x20000001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,0x400000,0x400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,0x20400000,0x20400001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,0x8000,0x8001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,0x20008000,0x20008001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,0x408000,0x408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,
0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001,0x20408000,0x20408001},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040},

{0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020},

{0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810}};
#else
const word32 Diamond2LiteBase::ipermtable[8][256] =
{{0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201},

{0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180,
0x80,0x180,0x20080,0x20180,0x4000080,0x4000180,0x4020080,0x4020180},

{0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x40,0x10040,0x2000040,0x2010040,0x40,0x10040,0x2000040,0x2010040,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8000,0x18000,0x2008000,0x2018000,0x8000,0x18000,0x2008000,0x2018000,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040,
0x8040,0x18040,0x2008040,0x2018040,0x8040,0x18040,0x2008040,0x2018040},

{0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,0x0,0x1000000,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,0x20,0x1000020,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,0x4000,0x1004000,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,0x4020,0x1004020,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,0x800000,0x1800000,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,0x800020,0x1800020,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,0x804000,0x1804000,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,
0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020,0x804020,0x1804020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008},

{0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804},

{0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402}};
#endif

#ifndef IS_LITTLE_ENDIAN
const word32 Diamond2Base::permtable[9][256] =
{{0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000},

{0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100},

{0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201},

{0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402},

{0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040}};
#else
const word32 Diamond2Base::permtable[9][256] =
{{0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102},

{0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204},

{0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408},

{0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810},

{0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000}};
#endif

#ifndef IS_LITTLE_ENDIAN
const word32 Diamond2Base::ipermtable[9][256] =
{{0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102,
0x0,0x100,0x2,0x102,0x0,0x100,0x2,0x102},

{0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204,
0x0,0x10000,0x200,0x10200,0x4,0x10004,0x204,0x10204},

{0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408,
0x0,0x1000000,0x20000,0x1020000,0x400,0x1000400,0x20400,0x1020400,
0x8,0x1000008,0x20008,0x1020008,0x408,0x1000408,0x20408,0x1020408},

{0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810,
0x0,0x0,0x2000000,0x2000000,0x40000,0x40000,0x2040000,0x2040000,
0x800,0x800,0x2000800,0x2000800,0x40800,0x40800,0x2040800,0x2040800,
0x10,0x10,0x2000010,0x2000010,0x40010,0x40010,0x2040010,0x2040010,
0x810,0x810,0x2000810,0x2000810,0x40810,0x40810,0x2040810,0x2040810},

{0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020,
0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,
0x80000,0x80000,0x80000,0x80000,0x4080000,0x4080000,0x4080000,0x4080000,
0x1000,0x1000,0x1000,0x1000,0x4001000,0x4001000,0x4001000,0x4001000,
0x81000,0x81000,0x81000,0x81000,0x4081000,0x4081000,0x4081000,0x4081000,
0x20,0x20,0x20,0x20,0x4000020,0x4000020,0x4000020,0x4000020,
0x80020,0x80020,0x80020,0x80020,0x4080020,0x4080020,0x4080020,0x4080020,
0x1020,0x1020,0x1020,0x1020,0x4001020,0x4001020,0x4001020,0x4001020,
0x81020,0x81020,0x81020,0x81020,0x4081020,0x4081020,0x4081020,0x4081020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,0x8000000,
0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,
0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,0x8100000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,0x8002000,
0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,0x102000,
0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,0x8102000,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,0x8000040,
0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,0x100040,
0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,0x8100040,
0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,0x2040,
0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,0x8002040,
0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,0x102040,
0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040,0x8102040},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,0x10000000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,0x10200000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,0x10004000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,0x204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,0x10204000,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,0x10000080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,0x200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,0x10200080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,0x10004080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,0x204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,
0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080,0x10204080},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,0x20400000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,0x20008000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,0x408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,
0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000,0x20408000},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,
0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000,0x40800000}};
#else
const word32 Diamond2Base::ipermtable[9][256] =
{{0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000,
0x0,0x10000,0x2000000,0x2010000,0x0,0x10000,0x2000000,0x2010000},

{0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100,
0x0,0x100,0x20000,0x20100,0x4000000,0x4000100,0x4020000,0x4020100},

{0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201,
0x0,0x1,0x200,0x201,0x40000,0x40001,0x40200,0x40201,
0x8000000,0x8000001,0x8000200,0x8000201,0x8040000,0x8040001,0x8040200,0x8040201},

{0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402,
0x0,0x0,0x2,0x2,0x400,0x400,0x402,0x402,
0x80000,0x80000,0x80002,0x80002,0x80400,0x80400,0x80402,0x80402,
0x10000000,0x10000000,0x10000002,0x10000002,0x10000400,0x10000400,0x10000402,0x10000402,
0x10080000,0x10080000,0x10080002,0x10080002,0x10080400,0x10080400,0x10080402,0x10080402},

{0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804,
0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,
0x800,0x800,0x800,0x800,0x804,0x804,0x804,0x804,
0x100000,0x100000,0x100000,0x100000,0x100004,0x100004,0x100004,0x100004,
0x100800,0x100800,0x100800,0x100800,0x100804,0x100804,0x100804,0x100804,
0x20000000,0x20000000,0x20000000,0x20000000,0x20000004,0x20000004,0x20000004,0x20000004,
0x20000800,0x20000800,0x20000800,0x20000800,0x20000804,0x20000804,0x20000804,0x20000804,
0x20100000,0x20100000,0x20100000,0x20100000,0x20100004,0x20100004,0x20100004,0x20100004,
0x20100800,0x20100800,0x20100800,0x20100800,0x20100804,0x20100804,0x20100804,0x20100804},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,
0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,0x200008,
0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,0x201000,
0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,0x201008,
0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,
0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,
0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,0x40001000,
0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,0x40001008,
0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,0x40200000,
0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,0x40200008,
0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,0x40201000,
0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008,0x40201008},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,0x2010,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,0x400000,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,0x400010,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,0x402000,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,0x402010,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,0x80000010,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,0x80002000,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,0x80002010,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,0x80400000,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,0x80400010,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,0x80402000,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,
0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010,0x80402010},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,0x4020,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,0x800020,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,0x804000,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,
0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020,0x804020},

{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,
0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040,0x8040}};
#endif

NAMESPACE_END

#endif // DIAMOND_USE_PERMTABLE
