/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 *
 */
package cryptix.pgp;

import java.io.DataOutput;
import java.io.IOException;

import cryptix.math.RandomStream;
import cryptix.crypt.MD5;
import cryptix.crypt.rsa.SecretKey;
import cryptix.crypt.rsa.PublicKey;

import cryptix.util.StreamInterface;

public final class SignedMessage extends Message
{
	private Signature messageSignature;
	
	public SignedMessage( byte data[], SecretKey secretkey, byte key[], RandomStream rand )
	throws IOException
	{
		super( data, secretkey, key, rand );
		MD5 md = new MD5();
		md.add( data );
		messageSignature = new Signature( secretkey, md );
	}

	public void
	write( DataOutput out )
	throws IOException
	{
		super.write( out ); // this will call finish which will then create the signature.
		messageSignature.write( out );
	}
}
