/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 *
 */

package cryptix.pgp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class KeyRingTrust extends Packet
{
	public static final byte CTB = (byte)0x30;
	
	private byte trust;

	public KeyRingTrust( byte trust0 )
	{
		trust = trust0;
	}
	
	public KeyRingTrust( DataInput in, int length )
		throws IOException
	{
		super( in, length );
	}

	public int 
	trustValue()
	{
		return trust;
	}

	public void 
	read( DataInput in, int length )
		throws IOException
	{
		if ( length != 1 )
			throw new FormatException( "Length invalid." );
		trust = in.readByte();
	}

	public int
	write( DataOutput out )
		throws IOException
	{
		out.write( trust );
		return 1;
	}
	
	public String
	toString()
	{
		return "trust: 0x"+Integer.toString( trust & 0xFF, 16 );
	}
}

