//
//	Workaround for win95/NT show() blocking bug, and non-modal dialogs
//

// if ( screensize == null )
// screensize = Toolkit.getDefaultToolkit().getScreenSize();
// Dimension d = size();
// move( ( screensize.width - d.width ) / 2, ( screensize.height - d.height ) / 2 );
//		move(100, 100);

package  cryptix.gui;

import java.awt.*;

public class ErrorDialog extends Dialog implements Runnable
{
	private Thread dialogThread;
    private Button ok = new Button("OK");
	private boolean finished;

	public ErrorDialog(Frame parent, String err)
	{
		super(parent, "Appname: Error", true);

		finished = false;

		// Doesn't work
		// setResizable(false);

        setLayout(new BorderLayout());

        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(ok);

        add("North", new Label("An error has occurred:"));
        add("Center", new Label(err));
        add("South", buttonPanel);

		pack();
	}

	public void show()
	{
		// Create a new thread to do the show
		dialogThread = new Thread(this, "ErrorDialog");
		dialogThread.start();
	}

	// Hack - this call not needed when bugs are fixed
	// Must not call from action or event handler
	public void show(boolean wait)
	{
		show();
		if (!finished && wait)
			try {
				dialogThread.join();
			}
			catch(Exception e) {
				throw new RuntimeException("Unexpected error: "+e.getMessage());
			}
	}

	public void run()
	{
		super.show();
		if (!finished)
			dialogThread.suspend();	// Block until woken up
	}

    public boolean action(Event event, Object arg)
    {
		finished = true;
		hide();
		if (dialogThread != null)
			dialogThread.resume();	// Wake up waiting thread
		return true;
    }


    public static void main( String argv[] )
    {
	    MainFrame top = new MainFrame("ErrorDialog (mainframe)");

	    ErrorDialog test = new ErrorDialog(top, "Testing testing ...");
		test.show(true);

		System.exit(-1);
    }
}

class MainFrame extends Frame
{
	MainFrame(String title)
	{
		super(title);
	}

	public boolean
	handleEvent(Event event)
	{
		if (event.id == Event.WINDOW_DESTROY)
			System.exit(0);

		return super.handleEvent(event);
	}
}
