/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicInternalFrameUI;
import com.sun.java.swing.plaf.metal.MetalInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    private MetalInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";

    public MetalInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.paletteListener = new PaletteListener();
        this.contentPaneListener = new ContentPaneListener();
        jComponent.addPropertyChangeListener(this.paletteListener);
        jComponent.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_PALETTE);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        jComponent.removePropertyChangeListener(this.paletteListener);
        jComponent.removePropertyChangeListener(this.contentPaneListener);
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == handyEmptyBorder) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(handyEmptyBorder);
        }
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MetalInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public void setPalette(boolean bl) {
        if (bl) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(bl);
    }

    class PaletteListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(IS_PALETTE)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MetalInternalFrameUI.this.setPalette((Boolean)propertyChangeEvent.getNewValue());
                    return;
                }
                MetalInternalFrameUI.this.setPalette(false);
            }
        }

        PaletteListener() {
            MetalInternalFrameUI.this = MetalInternalFrameUI.this;
        }
    }

    class ContentPaneListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("contentPane")) {
                MetalInternalFrameUI.this.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }

        ContentPaneListener() {
            MetalInternalFrameUI.this = MetalInternalFrameUI.this;
        }
    }
}

