/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.StyleSheet;
import sunw.hotjava.misc.Globals;
import sunw.html.Attributes;
import sunw.html.Element;
import sunw.html.HTMLOutputWriter;
import sunw.html.Tag;

public class TagItem
extends DocItem
implements Tag {
    protected StyleSheet style;
    protected Attributes atts;
    static Font tagFont = null;
    static Image emptyTagImg = null;
    static Image bulletTagImg = null;
    static Image startBlockTagImg = null;
    static Image endBlockTagImg = null;
    static Image startFlowTagImg = null;
    static Image endFlowTagImg = null;
    private static boolean lazyLoadingNotDone = true;
    static /* synthetic */ Class class$sunw$hotjava$doc$TagItem;

    public TagItem() {
        Class clazz = class$sunw$hotjava$doc$TagItem != null ? class$sunw$hotjava$doc$TagItem : (class$sunw$hotjava$doc$TagItem = TagItem.class$("sunw.hotjava.doc.TagItem"));
        synchronized (clazz) {
            if (lazyLoadingNotDone) {
                tagFont = Globals.getFont("hotjava.tagfont");
                emptyTagImg = Globals.getImage("tag.empty.24.gif");
                bulletTagImg = Globals.getImage("tag.bullet.24.gif");
                startBlockTagImg = Globals.getImage("tag.block.start.34.gif");
                endBlockTagImg = Globals.getImage("tag.block.end.34.gif");
                startFlowTagImg = Globals.getImage("tag.flow.start.26.gif");
                endFlowTagImg = Globals.getImage("tag.flow.end.26.gif");
                lazyLoadingNotDone = false;
            }
            return;
        }
    }

    public TagItem getTag(Document document) {
        return this;
    }

    public Font getFont() {
        return Font.decode(this.style.fontName);
    }

    public Element getElement() {
        return this.style.elem;
    }

    public Attributes getAttributes() {
        return this.atts;
    }

    public String getType() {
        return this.style.type;
    }

    public boolean isStart() {
        return this.offset > 0;
    }

    public boolean isPreformatted() {
        return false;
    }

    public void init(Document document) {
    }

    public String getName() {
        return this.style.elem.getName();
    }

    public void modifyStyle(DocStyle docStyle) {
        this.style.apply(docStyle);
    }

    public String getLinkTarget() {
        String string = null;
        Attributes attributes = this.getAttributes();
        if (attributes != null) {
            string = attributes.get("target");
        }
        return string;
    }

    public void write(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.emptyTag(this);
    }

    public void writeStartTag(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.startTag(this);
    }

    public void writeEndTag(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.endTag(this);
    }

    public int paintEndTag(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        formatter.displayPos += 65536;
        return 0;
    }

    public void paintTag(Graphics graphics, Image image, int n, int n2, String string, int n3, int n4, ImageObserver imageObserver) {
        if (graphics.drawImage(image, n, n2, imageObserver)) {
            graphics.setFont(tagFont);
            graphics.setColor(Color.black);
            graphics.drawString(string, n + n3 - graphics.getFontMetrics(tagFont).stringWidth(string) / 2, n2 + n4);
        }
    }

    protected static final int parseInt(Attributes attributes, String string, int n, int n2) {
        String string2 = attributes.get(string);
        if (string2 != null) {
            try {
                return Math.max(Integer.parseInt(string2), n);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n2;
    }

    public String tagString() {
        if (this.isStart()) {
            return "<" + this.getName() + ">";
        }
        if (this.isEnd()) {
            return "</" + this.getName() + ">";
        }
        return "[" + this.getName() + "]";
    }

    public String toString() {
        return String.valueOf(this.tagString()) + ", " + super.toString();
    }

    public String filterString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= ' ') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

