/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.doc.ClientPuller;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.DocumentStack;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.tags.TagAppletPanel;

public abstract class MasterDocumentPanel
extends DocumentPanel
implements Runnable {
    private URL currentURL;
    private DocumentStack documentStack = new DocumentStack(this);
    private DocumentListener topDocEventsListener;
    private ActionListener topActionEventsListener;

    public MasterDocumentPanel(DocFont docFont) {
        super(docFont);
    }

    public MasterDocumentPanel() {
    }

    public void setDocFont(DocFont docFont) {
        if (this.font != docFont) {
            this.font = docFont;
            if (this.current != null) {
                this.current.setDocFont(docFont);
            }
            this.documentStack.setDocFont(docFont);
        }
    }

    public static void setAllDocFonts(DocFont docFont) {
        Vector vector = DocumentPanel.panels;
        synchronized (vector) {
            Enumeration enumeration = DocumentPanel.panels.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof MasterDocumentPanel)) continue;
                ((MasterDocumentPanel)e).setDocFont(docFont);
            }
            return;
        }
    }

    public boolean canForward() {
        return this.documentStack.canForward();
    }

    public void forward() {
        this.documentStack.forward();
    }

    public Document getForwardDocument() {
        return this.documentStack.getForwardDocument();
    }

    public boolean canBack() {
        return this.documentStack.canBack();
    }

    public void back() {
        this.documentStack.back();
    }

    public Document getBackDocument() {
        return this.documentStack.getBackDocument();
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        Document document = DocumentCache.getDocument(uRL, uRL2);
        documentPanel.show(new DocumentFormatterRef(documentPanel.panel, document, this.font));
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, Properties properties) {
        this.replaceCurrentDocument(documentPanel, uRL, null, properties);
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, URL uRL2, Properties properties) {
        Document document = new Document(uRL, uRL2);
        if (properties != null) {
            document.setParserProperties(properties);
        }
        documentPanel.show(new DocumentFormatterRef(documentPanel.panel, document, this.font));
    }

    public DocumentPanel findPanel(Container container, String string) {
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            DocumentPanel documentPanel;
            Component component = container.getComponent(n2);
            if (component instanceof DocumentPanel && string.equals((documentPanel = (DocumentPanel)component).getName())) {
                return documentPanel;
            }
            if (component instanceof Container && (documentPanel = this.findPanel((Container)component, string)) != null) {
                return documentPanel;
            }
            ++n2;
        }
        return null;
    }

    public void push(DocumentPanel documentPanel, URL uRL) {
        this.push(documentPanel, uRL, null);
    }

    public void push(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        if (this.isSetCurrentDocumentAllowed(uRL, null, false)) {
            this._push(documentPanel, uRL, uRL2);
        }
    }

    protected void _push(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        this.push(documentPanel, DocumentCache.getDocument(uRL, uRL2));
        documentPanel.gotoLabel(uRL.getRef());
    }

    protected void _push(DocumentPanel documentPanel, Document document, URL uRL) {
        this.push(documentPanel, document);
        documentPanel.gotoLabel(document.getURL().getRef());
    }

    public void push(DocumentPanel documentPanel, Document document) {
        DocumentFormatterRef documentFormatterRef = new DocumentFormatterRef(documentPanel.panel, document, this.font);
        documentFormatterRef.addClient();
        DocumentStack documentStack = this.documentStack;
        synchronized (documentStack) {
            this.documentStack.push(documentPanel, documentFormatterRef);
            documentPanel.show(documentFormatterRef);
        }
        documentFormatterRef.removeClient();
    }

    private void pushInternalLink(DocumentPanel documentPanel) {
        this.documentStack.push(documentPanel, this.current);
    }

    public void push(Document document) {
        this.push((DocumentPanel)this, document);
    }

    public void push(URL uRL) {
        this.push(this, uRL, null);
    }

    public void push(URL uRL, URL uRL2) {
        this.push(this, uRL, uRL2);
    }

    public void push(Component component, String string, Document document) {
        this.push(component, string, document.getURL(), null, document);
    }

    public void push(Component component, String string, URL uRL) {
        this.push(component, string, uRL, null, null);
    }

    protected boolean isSetCurrentDocumentAllowed(URL uRL, String string, boolean bl) {
        return true;
    }

    protected void setCurrentDocument(URL uRL, String string, boolean bl) {
        this._push((DocumentPanel)this, uRL, null);
    }

    protected void setCurrentDocument(Document document, String string, boolean bl) {
        this._push((DocumentPanel)this, document, null);
    }

    public void push(Component component, String string, URL uRL, URL uRL2) {
        this.push(component, string, uRL, uRL2, null);
    }

    public void push(Component component, String string, URL uRL, URL uRL2, Document document) {
        boolean bl;
        if (string == null || string.equals("")) {
            string = "_self";
        }
        if (string.equals("_blank")) {
            if (this.isSetCurrentDocumentAllowed(uRL, string, true)) {
                if (document == null) {
                    this.setCurrentDocument(uRL, string, true);
                    return;
                }
                this.setCurrentDocument(document, null, true);
            }
            return;
        }
        string = string.toLowerCase();
        DocumentPanel documentPanel = null;
        boolean bl2 = bl = documentPanel == null;
        if (string.startsWith("_")) {
            bl = false;
            documentPanel = this;
        } else {
            documentPanel = this.findPanel(this, string);
        }
        if (!this.isSetCurrentDocumentAllowed(uRL, string, bl)) {
            return;
        }
        if (string.equals("_top")) {
            if (document == null) {
                this._push((DocumentPanel)this, uRL, uRL2);
                return;
            }
            this._push((DocumentPanel)this, document, uRL2);
            return;
        }
        if (component != null) {
            if (string.equals("_parent")) {
                Container container;
                if (!(component instanceof DocumentPanel)) {
                    container = component.getParent();
                    while (!(container instanceof DocumentPanel)) {
                        container = container.getParent();
                    }
                } else {
                    container = (Container)component;
                }
                container = container.getParent();
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        DocumentPanel documentPanel2 = (DocumentPanel)container;
                        if (document == null) {
                            this._push(documentPanel2, uRL, uRL2);
                            return;
                        }
                        this._push(documentPanel2, document, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.equals("_self")) {
                if (component instanceof DocumentPanel) {
                    DocumentPanel documentPanel3 = (DocumentPanel)component;
                    if (document == null) {
                        this._push(documentPanel3, uRL, uRL2);
                        return;
                    }
                    this._push(documentPanel3, document, uRL2);
                    return;
                }
                Container container = component.getParent();
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        DocumentPanel documentPanel4 = (DocumentPanel)container;
                        if (document == null) {
                            this._push(documentPanel4, uRL, uRL2);
                            return;
                        }
                        this._push(documentPanel4, document, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.equals("_replace")) {
                Container container = (Container)component;
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        this.replaceCurrentDocument((DocumentPanel)container, uRL, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.startsWith("_refresh")) {
                if (!(component instanceof DocumentPanel)) {
                    return;
                }
                this.setupClientPull(string, uRL, (DocumentPanel)component);
                return;
            }
        }
        if (string.startsWith("_")) {
            if (document == null) {
                this._push((DocumentPanel)this, uRL, uRL2);
                return;
            }
            this._push((DocumentPanel)this, document, uRL2);
            return;
        }
        if (documentPanel != null) {
            if (document == null) {
                this._push(documentPanel, uRL, uRL2);
                return;
            }
            this._push(documentPanel, document, uRL2);
            return;
        }
        if (document == null) {
            if (this.pushInNamedPanel(uRL, uRL2, string)) {
                return;
            }
            this.setCurrentDocument(uRL, string, true);
            return;
        }
        if (this.pushInNamedPanel(document, string)) {
            return;
        }
        this.setCurrentDocument(document, string, true);
    }

    protected boolean pushInNamedPanel(URL uRL, URL uRL2, String string) {
        return false;
    }

    protected boolean pushInNamedPanel(Document document, String string) {
        return false;
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1002: {
                if (documentEvent.isShiftDown()) break;
                NamedLink namedLink = (NamedLink)documentEvent.getArgument();
                this.push((DocumentPanel)documentEvent.getSource(), namedLink.name, namedLink.url, namedLink.referer, documentEvent.getDocument());
                String string = System.getProperty("dopplegangerProg");
                if (string != null) {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        runtime.exec(String.valueOf(string) + " " + namedLink.url + " " + namedLink.name);
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                return;
            }
            case 1019: {
                super.processDocumentEvent(documentEvent);
                return;
            }
            case 1004: {
                Document document = null;
                document = this.next != null ? this.next.getDocument() : this.getDocument();
                if (documentEvent.getSource() != document) break;
                String string = (String)documentEvent.getArgument();
                if (string.equals("url")) {
                    URL uRL = document.getURL();
                    this.gotoLabel(uRL.getRef());
                    return;
                }
                if (!string.equals("refresh")) break;
                this.requestTimedRefresh(document);
                return;
            }
            case 1010: {
                DocumentPanel documentPanel = (DocumentPanel)documentEvent.arg;
                this.pushInternalLink(documentPanel);
                return;
            }
            case 1003: {
                this.fitPanelToDocument();
                return;
            }
            case 1036: {
                this.repaintComponents(this.panel);
                return;
            }
            default: {
                super.processDocumentEvent(documentEvent);
            }
        }
    }

    protected void repaintComponents(Container container) {
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Container) {
                    this.repaintComponents((Container)componentArray[n]);
                }
                ++n;
            }
            if (container instanceof DocumentFormatterPanel) {
                container.repaint();
            }
        }
    }

    protected void processPanelKeyEvent(KeyEvent keyEvent) {
        Hax.debugln("hotjava.debug.MasterDocPanelEvents", "MasterDocumentPanel.processKeyEvent(" + keyEvent + ")");
        switch (keyEvent.getKeyCode()) {
            case 23: {
                this.list();
                return;
            }
        }
    }

    public boolean canReload() {
        Document document = this.getDocument();
        return document != null && document.getURL() != null;
    }

    public void reload() {
        this.tryToEnableAppletReload();
        super.reload();
    }

    protected abstract Vector getAllMasterDocumentPanels();

    protected void tryToEnableAppletReload() {
        Serializable serializable;
        Serializable serializable2;
        Vector vector = new Vector();
        this.getFormatter().getAppletPanels(vector, true);
        if (vector.size() == 0) {
            return;
        }
        Vector<Serializable> vector2 = new Vector<Serializable>();
        int n = 0;
        while (n < vector.size()) {
            serializable2 = ((TagAppletPanel)vector.elementAt(n)).getCodeBase();
            if (!vector2.contains(serializable2)) {
                vector2.addElement(serializable2);
            }
            ++n;
        }
        serializable2 = this.getAllMasterDocumentPanels();
        int n2 = 0;
        while (n2 < ((Vector)serializable2).size()) {
            MasterDocumentPanel masterDocumentPanel = (MasterDocumentPanel)((Vector)serializable2).elementAt(n2);
            if (masterDocumentPanel != null && masterDocumentPanel != this) {
                serializable = new Vector();
                masterDocumentPanel.getFormatter().getAppletPanels((Vector)serializable, true);
                int n3 = 0;
                while (n3 < ((Vector)serializable).size()) {
                    boolean bl = false;
                    TagAppletPanel tagAppletPanel = (TagAppletPanel)((Vector)serializable).elementAt(n3);
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        TagAppletPanel tagAppletPanel2 = (TagAppletPanel)vector.elementAt(n4);
                        bl = bl || tagAppletPanel.getItem() == tagAppletPanel2.getItem();
                        ++n4;
                    }
                    if (!bl) {
                        vector2.removeElement(tagAppletPanel.getCodeBase());
                        if (vector2.size() == 0) {
                            return;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < ((Vector)serializable2).size()) {
            serializable = (MasterDocumentPanel)((Vector)serializable2).elementAt(n5);
            ((MasterDocumentPanel)serializable).documentStack.flushDocumentsContainingCodebases(vector2);
            ++n5;
        }
    }

    public boolean canStopLoading() {
        Document document;
        Document document2 = document = this.next != null ? this.next.getDocument() : null;
        return document != null && (document.getState() == 11 || document.getState() == 12 || this.appletLoadingCount > 0 || !document.isOkToFormat());
    }

    public void stopLoading() {
        Document document;
        Document document2 = document = this.next != null ? this.next.getDocument() : null;
        if (document != null) {
            document.interruptOwnerWaitCompletion();
        }
    }

    public boolean showingTags() {
        return this.current != null && this.current.getFormatter().ds.tags;
    }

    public void flipTags() {
        if (this.current != null) {
            DocumentFormatter documentFormatter = this.current.getFormatter();
            documentFormatter.setShowingTags(!documentFormatter.ds.tags);
            documentFormatter.reformat();
        }
    }

    public DocStyle getStyle() {
        return new DocStyle();
    }

    public void print() {
        new Thread((Runnable)this, "Document Printer").start();
    }

    public void run() {
        Frame frame = this.getContainingFrame();
        PrintJob printJob = this.getToolkit().getPrintJob(frame, this.getDocument().getTitle(), Globals.props);
        if (printJob != null) {
            int n = frame.getCursorType();
            try {
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
                Globals.props.save();
                try {
                    this.print(printJob, this);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    printJob.end();
                    String string = Globals.localProps.handleGetString("printjob.err.msg");
                    this.setErrorMessage(string);
                    Object var5_6 = null;
                    frame.setCursor(n);
                    return;
                }
                printJob.end();
            }
            finally {
                Object var5_7 = null;
                frame.setCursor(n);
            }
            this.setErrorMessage(Globals.localProps.handleGetString("printjob.done.msg"));
            return;
        }
        this.setErrorMessage(Globals.localProps.handleGetString("printjob.cancelled.msg"));
    }

    public void setTopEventListeners(DocumentListener documentListener, ActionListener actionListener) {
        this.topDocEventsListener = documentListener;
        this.topActionEventsListener = actionListener;
    }

    public void addTopDocListenerToSource(DocumentEventSource documentEventSource) {
        documentEventSource.addDocumentListener(this.topDocEventsListener);
    }

    public void removeTopDocListenerFromSource(DocumentEventSource documentEventSource) {
        documentEventSource.removeDocumentListener(this.topDocEventsListener);
    }

    public void setMessage(String string) {
        if (this.topDocEventsListener != null) {
            this.topDocEventsListener.documentChanged(new DocumentEvent(this, 1024, string));
        }
    }

    public void internalGoto(DocPanel docPanel, URL uRL, URL uRL2, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink("_top", uRL, uRL2);
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, namedLink));
        }
    }

    public void internalGoto(DocPanel docPanel, Document document, boolean bl) {
        if (this.topDocEventsListener != null) {
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, document));
        }
    }

    public void internalGoto(DocPanel docPanel, String string, URL uRL, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink(string, uRL);
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, namedLink));
        }
    }

    public void internalGoto(DocPanel docPanel, String string, Document document, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink(string, document.getURL());
            DocumentEvent documentEvent = new DocumentEvent(docPanel, 1025, bl, namedLink);
            documentEvent.setDocument(document);
            this.topDocEventsListener.documentChanged(documentEvent);
        }
    }

    ActionListener getTopActionEventsListener() {
        return this.topActionEventsListener;
    }

    public static MasterDocumentPanel getContainingMasterDocumentPanel(Container container) {
        while (container != null) {
            if (container instanceof MasterDocumentPanel) {
                return (MasterDocumentPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public DocumentStack getDocumentStack() {
        return this.documentStack;
    }

    protected void setErrorMessage(String string) {
    }

    private void setupClientPull(String string, URL uRL, DocumentPanel documentPanel) {
        Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "Client-pull:\n... spec '" + string + "', source '" + uRL + "'");
        int n = string.indexOf(32);
        if (n < 0) {
            System.err.println("Client-pull: bad refresh spec, " + string);
            return;
        }
        try {
            String string2;
            int n2;
            String string3 = string.substring(n).trim();
            StringTokenizer stringTokenizer = string3.indexOf(59) > 0 ? new StringTokenizer(string3, ";") : (string3.indexOf(44) > 0 ? new StringTokenizer(string3, ",") : new StringTokenizer(string3));
            int n3 = stringTokenizer.countTokens();
            switch (n3) {
                case 1: {
                    String string4 = stringTokenizer.nextToken().trim();
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Client-pull: bad refresh spec, " + string);
                        return;
                    }
                    string2 = uRL.toExternalForm();
                    Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... refresh original, delay = " + n2);
                    break;
                }
                case 2: {
                    String string5 = stringTokenizer.nextToken().trim();
                    try {
                        n2 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Client-pull: bad refresh spec, " + string);
                        return;
                    }
                    string2 = stringTokenizer.nextToken().trim();
                    if (string2 != null && (string2.startsWith("URL") || string2.startsWith("url"))) {
                        n = string2.indexOf(61);
                        if (n == -1) {
                            System.err.println("Client-pull: bad refresh doc spec, " + string2);
                            return;
                        }
                        string2 = string2.substring(n + 1);
                    }
                    Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... refresh with '" + string2 + "', delay = " + n2);
                    break;
                }
                default: {
                    System.err.println("Client-pull: bad spec, " + n3 + " tokens in spec, " + string3);
                    return;
                }
            }
            ClientPuller clientPuller = new ClientPuller(this, documentPanel, uRL, string2, n2);
            Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... start puller thread");
            clientPuller.start();
            return;
        }
        catch (Exception exception) {
            Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... exception occurred!");
            exception.printStackTrace();
            return;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.documentStack.flush(true);
    }

    public void flushDocumentStack(boolean bl) {
        this.documentStack.flush(bl);
    }

    public void clear() {
        this.documentStack.flush(true);
    }

    public void destroy() {
        this.documentStack.flush(true);
        super.destroy();
    }

    public void destroyAllApplets(boolean bl) {
        Vector vector = new Vector();
        this.getFormatter().getAppletPanels(vector, true);
        this.documentStack.addAppletPanels(vector);
        int n = 0;
        while (n < vector.size()) {
            TagAppletPanel tagAppletPanel = (TagAppletPanel)vector.elementAt(n);
            tagAppletPanel.destroyIfNeeded(bl);
            ++n;
        }
    }
}

