/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Container;
import java.util.Vector;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPresentation;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.MasterDocumentPanel;

public class DocumentStack {
    private int purgeContentsThreshold;
    private int purgeURLThreshold;
    private boolean initCalled = false;
    private MasterDocumentPanel owner;
    Vector nodes = new Vector();
    private int currentPos;

    public DocumentStack(MasterDocumentPanel masterDocumentPanel) {
        this.owner = masterDocumentPanel;
    }

    private synchronized void init() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.setContentsDepth(Integer.getInteger("hotjava.docstack.contents.depth", 10));
        this.setLogicalDepth(Integer.getInteger("hotjava.docstack.logical.depth", 100));
    }

    public synchronized void setContentsDepth(int n) {
        this.init();
        n = Math.max(n, 0) + 1;
        int n2 = this.purgeContentsThreshold;
        while (n2 >= n) {
            this.enforceContentsThreshold(this.currentPos - n2);
            this.enforceContentsThreshold(this.currentPos + n2);
            --n2;
        }
        this.purgeContentsThreshold = n;
    }

    public int getContentsDepth() {
        this.init();
        return this.purgeContentsThreshold - 1;
    }

    public synchronized void setLogicalDepth(int n) {
        this.init();
        n = Math.max(n, 0) + 1;
        int n2 = this.purgeURLThreshold;
        while (n2 >= n) {
            this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
            this.enforceURLThreshold(this.currentPos + this.purgeURLThreshold);
            --n2;
        }
        this.purgeURLThreshold = n;
    }

    public int getLogicalDepth() {
        this.init();
        return this.purgeURLThreshold + 1;
    }

    public synchronized void push(DocumentPanel documentPanel, DocumentFormatterRef documentFormatterRef) {
        this.init();
        DocumentFormatterRef documentFormatterRef2 = documentPanel.current;
        if (documentFormatterRef2 == null) {
            return;
        }
        Node node = new Node();
        node.target = documentPanel;
        node.newContents = new DocumentFormatterPresentation(documentFormatterRef);
        node.oldContents = new DocumentFormatterPresentation(documentFormatterRef2);
        if (!(documentPanel instanceof MasterDocumentPanel)) {
            Vector<DocumentFormatterRef> vector = new Vector<DocumentFormatterRef>();
            Container container = documentPanel.getParent();
            while (container != null) {
                if (container instanceof DocumentPanel) {
                    vector.addElement(((DocumentPanel)container).current);
                    if (container instanceof MasterDocumentPanel) break;
                }
                container = container.getParent();
            }
            node.parents = new DocumentFormatterRef[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                node.parents[n] = (DocumentFormatterRef)vector.elementAt(n);
                node.parents[n].addClient();
                ++n;
            }
        }
        node.oldContents.setScrollPosition(documentPanel.getScrollPosition());
        node.oldContents.getFormatterRef().offsetStored = true;
        this.pruneCurrentToTop();
        this.nodes.addElement(node);
        ++this.currentPos;
        this.enforceContentsThreshold(this.currentPos - this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
    }

    public boolean canForward() {
        return this.currentPos < this.nodes.size();
    }

    public boolean canBack() {
        return this.currentPos > 0;
    }

    public synchronized void forward() {
        if (!this.canForward()) {
            return;
        }
        Node node = (Node)this.nodes.elementAt(this.currentPos);
        node.oldContents.setScrollPosition(node.target.getScrollPosition());
        node.oldContents.getFormatterRef().offsetStored = true;
        ++this.currentPos;
        node.newContents.showIn(node.target);
        this.enforceContentsThreshold(this.currentPos - this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
    }

    public void back() {
        if (!this.canBack()) {
            return;
        }
        --this.currentPos;
        Node node = (Node)this.nodes.elementAt(this.currentPos);
        node.newContents.setScrollPosition(node.target.getScrollPosition());
        node.newContents.getFormatterRef().offsetStored = true;
        node.oldContents.showIn(node.target);
        this.enforceContentsThreshold(this.currentPos + this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos + this.purgeURLThreshold);
    }

    public synchronized Document getForwardDocument() {
        if (!this.canForward()) {
            return null;
        }
        Node node = (Node)this.nodes.elementAt(this.currentPos);
        return node.newContents.getDocument();
    }

    public synchronized Document getBackDocument() {
        if (!this.canBack()) {
            return null;
        }
        Node node = (Node)this.nodes.elementAt(this.currentPos - 1);
        return node.oldContents.getDocument();
    }

    public synchronized void flushDocumentsContainingCodebases(Vector vector) {
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            Node node = (Node)this.nodes.elementAt(n3);
            this.flushForCodebase(node.oldContents, vector);
            this.flushForCodebase(node.newContents, vector);
            ++n3;
        }
    }

    private void flushForCodebase(DocumentFormatterPresentation documentFormatterPresentation, Vector vector) {
        if (!documentFormatterPresentation.getIsFlushed()) {
            DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
            Vector vector2 = new Vector();
            documentFormatter.getAppletPanels(vector2, true);
            int n = 0;
            while (n < vector2.size()) {
                if (vector.contains(vector2.elementAt(n))) {
                    documentFormatterPresentation.flush();
                    return;
                }
                ++n;
            }
        }
    }

    public void addAppletPanels(Vector vector) {
        Vector vector2 = new Vector();
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            DocumentFormatter documentFormatter;
            Node node = (Node)this.nodes.elementAt(n3);
            if (!node.oldContents.getIsFlushed()) {
                documentFormatter = node.oldContents.getFormatterRef().getFormatter();
                documentFormatter.getAppletPanels(vector2, true);
            }
            if (!node.newContents.getIsFlushed()) {
                documentFormatter = node.newContents.getFormatterRef().getFormatter();
                documentFormatter.getAppletPanels(vector2, true);
            }
            if (node.parents != null) {
                int n4 = 0;
                while (n4 < node.parents.length) {
                    DocumentFormatter documentFormatter2 = node.parents[n4].getFormatter();
                    documentFormatter2.getAppletPanels(vector2, true);
                    ++n4;
                }
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < vector2.size()) {
            Object e = vector2.elementAt(n5);
            if (!vector.contains(e)) {
                vector.addElement(e);
            }
            ++n5;
        }
    }

    public synchronized void flush(boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.nodes.size()) {
                Node node = (Node)this.nodes.elementAt(n);
                this.flushNode(node);
                ++n;
            }
            this.nodes = new Vector();
            this.currentPos = 0;
            return;
        }
        int n = this.getContentsDepth();
        this.setContentsDepth(0);
        this.setContentsDepth(n);
    }

    public void setDocFont(DocFont docFont) {
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            DocumentFormatter documentFormatter;
            Node node = (Node)this.nodes.elementAt(n3);
            if (!node.oldContents.getIsFlushed()) {
                documentFormatter = node.oldContents.getFormatterRef().getFormatter();
                documentFormatter.setDocFont(docFont);
            }
            if (!node.newContents.getIsFlushed()) {
                documentFormatter = node.newContents.getFormatterRef().getFormatter();
                documentFormatter.setDocFont(docFont);
            }
            if (node.parents != null) {
                int n4 = 0;
                while (n4 < node.parents.length) {
                    DocumentFormatter documentFormatter2 = node.parents[n4].getFormatter();
                    documentFormatter2.setDocFont(docFont);
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private void pruneCurrentToTop() {
        int n;
        while ((n = this.nodes.size() - 1) >= this.currentPos) {
            this.flushNode((Node)this.nodes.elementAt(n));
            this.nodes.removeElementAt(n);
        }
    }

    private void enforceContentsThreshold(int n) {
        if (n >= 0 && n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            if (node.parents != null) {
                if (n + 1 < this.nodes.size()) {
                    Node node2 = (Node)this.nodes.elementAt(n + 1);
                    if (node2.target == node.target) {
                        DocumentFormatterPresentation documentFormatterPresentation = node2.oldContents;
                        node2.oldContents = node.oldContents;
                        node.oldContents = documentFormatterPresentation;
                    }
                }
                this.flushNode(node);
                this.nodes.removeElementAt(n);
                if (n <= this.currentPos) {
                    --this.currentPos;
                    return;
                }
            } else {
                this.flushNode(node);
            }
        }
    }

    private void enforceURLThreshold(int n) {
        if (n >= 0 && n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            this.flushNode(node);
            this.nodes.removeElementAt(n);
            if (n <= this.currentPos) {
                --this.currentPos;
            }
        }
    }

    private void flushNode(Node node) {
        node.oldContents.flush();
        node.newContents.flush();
        if (node.parents != null) {
            int n = 0;
            while (n < node.parents.length) {
                node.parents[n].removeClient();
                ++n;
            }
        }
        node.parents = null;
    }

    private class Node {
        DocumentPanel target;
        DocumentFormatterPresentation oldContents;
        DocumentFormatterPresentation newContents;
        DocumentFormatterRef[] parents;

        Node() {
            DocumentStack.this = DocumentStack.this;
        }
    }
}

