/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Vector;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocItemEnumeration;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.DocView;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentBackground;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.DragThread;
import sunw.hotjava.doc.EndTagItem;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.ItemComponent;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.PageInfo;
import sunw.hotjava.doc.PageMargins;
import sunw.hotjava.doc.PageMarker;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.SelectionOwner;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.ScalingGraphics;

public class DocumentFormatter
extends Formatter
implements DocView,
UpdateClient,
SelectionOwner,
Serializable {
    public Container parent;
    private DocumentPanel scroller;
    static final long serialVersionUID = 7159451397616758869L;
    private static final Integer FORMAT_SCREEN = new Integer(10000);
    private static final Integer FORMAT_DOCUMENT = new Integer(10001);
    private static final Integer REPAINT = new Integer(10003);
    private Object SYNC_PAINTS = new Object();
    boolean bFormatDone = false;
    int scrollBarWidth;
    boolean repair;
    boolean repaintOnWake = false;
    private int xToScroll;
    private int yToScroll;
    private boolean needScrollOnFinish = false;
    TagItem active;
    private int marginWidth = 20;
    private int docX;
    private int docY;
    private int newY;
    DragThread dragThread;
    Object dragLock = new Object();
    int dragDelay = 100;
    String label = "safety";
    long lastFormatedTime;
    int pendingFormatRequest;
    PopupMenu popupMenu;
    private Formatter.FormatterMouseListener formatterMouseListener;
    private DocListener formatterDocListener;
    private KeyListener keyListener;

    public DocumentFormatter(Container container, Document document, DocFont docFont) {
        this.bFormatDone = false;
        this.parent = container;
        this.scroller = (DocumentPanel)container.getParent();
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document2 = document;
            synchronized (document2) {
                this.stdInit(document, docFont);
                this.itemComponents = new ItemComponent[6];
                document.addView(this);
            }
        }
        this.formatterDocListener = new DocListener();
        object = this.getParent();
        if (object == null) {
            return;
        }
        this.formatterMouseListener = new Formatter.FormatterMouseListener(this);
        new 1();
    }

    public DocumentFormatter(DocumentFormatter documentFormatter, DocFont docFont) {
        this.parent = null;
        this.scroller = null;
        this.stdInit(documentFormatter.doc, docFont);
        this.copyPanelsForPrinting(documentFormatter, this.ds);
    }

    public DocumentFormatter() {
        this.parent = null;
        this.scroller = null;
    }

    public void removeListeners() {
        this.doc.removeDocumentListener(this.formatterDocListener);
        this.parent.removeMouseListener(this.formatterMouseListener);
        this.parent.removeMouseMotionListener(this.formatterMouseListener);
        this.parent.removeKeyListener(this.keyListener);
    }

    public void unregisterListeners() {
        this.removeListeners();
        super.unregisterListeners();
    }

    public void addListeners() {
        this.doc.addDocumentListener(this.formatterDocListener);
        this.parent.addMouseListener(this.formatterMouseListener);
        this.parent.addMouseMotionListener(this.formatterMouseListener);
        this.parent.addKeyListener(this.keyListener);
    }

    private void stdInit(Document document, DocFont docFont) {
        this.docHeight = 10;
        this.doc = document;
        this.lines = new DocLine[100];
        this.lines[0] = new DocLine(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.nlines = 0;
        this.ds.docStyle = new DocStyle(docFont);
        this.ds.docStyle.doc = document;
        this.ds.docStyle.win = this;
        this.ds.started = true;
        this.ds.background = Globals.getColor("hotjava.docbgcolor", Color.white);
        this.ds.topFormatter = this;
        this.resetDocStyle();
        this.ds.selStart = -1;
        this.ds.selEnd = -1;
    }

    void setPopup(PopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    PopupMenu getPopup() {
        return this.popupMenu;
    }

    protected void setVScrollBarWidth(int n) {
        this.scrollBarWidth = n;
    }

    public int getVScrollBarWidth() {
        return this.scrollBarWidth;
    }

    protected int getStartIndex() {
        return 0;
    }

    protected boolean getRepair() {
        return this.repair;
    }

    protected void setRepair(boolean bl) {
        if (this.bFormatDone) {
            this.repair = bl;
        }
    }

    public void stop() {
        this.reset();
        super.stop();
    }

    public boolean isFormatDone() {
        return this.bFormatDone;
    }

    public void reset() {
        this.bFormatDone = false;
    }

    protected int getMaxIndex() {
        return this.doc.nitems;
    }

    public void getBackgroundDisplacement(Point point) {
    }

    public boolean hasSelection() {
        return this.hasSelection(this.ds);
    }

    boolean hasSelection(DocumentState documentState) {
        if (documentState.selStart == documentState.selEnd) {
            return false;
        }
        return documentState.selStart != -1 && documentState.selEnd != -1;
    }

    public Vector getAppletPanels() {
        Vector vector = new Vector();
        this.getAppletPanels(vector);
        return vector;
    }

    public Vector getAppletPanelsAcrossFrames() {
        Vector vector = new Vector();
        this.getAppletPanels(vector, true);
        return vector;
    }

    public void gotoLabel(String string) {
        Document document = this.doc;
        synchronized (document) {
            this.label = string;
            if (this.ds.started && this.label != null) {
                this.touch(false, 0);
            }
            return;
        }
    }

    public void setDocFont(DocFont docFont) {
        Document document = this.doc;
        synchronized (document) {
            if (docFont != this.ds.docStyle.font) {
                this.ds.docStyle.font = docFont;
                this.reformat();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSize(int n, int n2, int n3) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.width != n || this.scrollBarWidth != n3) {
                    this.setVScrollBarWidth(n3);
                    this.width = n;
                    this.height = n2;
                    this.reformat();
                    return true;
                }
                if (this.height == n2) return false;
                this.height = n2;
                this.touch(false, 100);
            }
            return false;
        }
    }

    public void setMargins(int n, int n2) {
        Document document = this.doc;
        synchronized (document) {
            if (this.marginWidth != n || this.marginHeight != n2) {
                this.marginWidth = n;
                this.marginHeight = n2;
                this.resetDocStyle();
                this.reformat();
            }
            return;
        }
    }

    public void setRepaintOnWake(boolean bl) {
        this.repaintOnWake = bl;
    }

    protected void wakeScreenUpdater() {
        if (this.repaintOnWake) {
            ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)REPAINT);
        }
        this.repaintOnWake = false;
    }

    protected void setVisible(Component component, BitSet bitSet, int n) {
        if (bitSet != null && bitSet.get(n)) {
            component.setVisible(true);
        }
    }

    protected void setInvisible(Component component, BitSet bitSet, int n) {
        if (component.isVisible()) {
            bitSet.set(n);
            component.setVisible(false);
        }
    }

    protected void connectBackgroundClient() {
        if (this.ds.bg != null && this.parent != null) {
            this.ds.bg.addClient(this.parent);
        }
    }

    protected void disconnectBackgroundClient() {
        if (this.ds.bg != null && this.parent != null) {
            this.ds.bg.removeClient(this.parent);
        }
    }

    protected void quitViewingDoc() {
        this.doc.removeView(this);
    }

    protected void disconnectFromParent(Component component) {
        if (this.parent != null) {
            this.parent.remove(component);
        }
    }

    protected void setFormatterStarted(boolean bl) {
        this.ds.started = bl;
    }

    public Container getParent() {
        return this.parent;
    }

    public void interruptLoading() {
        this.doc.interruptOwner();
    }

    protected boolean handleMouseDown(MouseEvent mouseEvent) {
        this.parent.requestFocus();
        this.dispatchDocumentEvent(1026, null);
        return super.handleMouseDown(mouseEvent);
    }

    public Graphics getGraphics() {
        if (this.parent != null && this.ds.started) {
            return this.parent.getGraphics();
        }
        return null;
    }

    void repaint() {
        if (this.ds.started) {
            ScreenUpdater.updater.notify((UpdateClient)this, 100L, (Object)REPAINT);
        }
    }

    public int countPanels() {
        return this.nItemComponents;
    }

    public Component getPanel(int n) {
        if (n < this.nItemComponents) {
            return this.itemComponents[n].getComponent();
        }
        return null;
    }

    public DocStyle getStyle() {
        return this.ds.docStyle;
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getDocumentX() {
        return this.docX;
    }

    public void setDocumentX(int n) {
        this.docX = n;
    }

    public void setDocumentY(int n) {
        this.docY = n;
    }

    public int getDocumentY() {
        if (this.scroller != null) {
            Point point = this.scroller.getScrollPosition();
            this.docY = point.y;
            return point.y;
        }
        this.docY = 0;
        return 0;
    }

    public TagItem getActive() {
        if (this.down == null) {
            return null;
        }
        return this.down.tag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getAvailableWidth() {
        return this.width - 2 * this.marginWidth;
    }

    public int getAvailableHeight() {
        return this.height - 2 * this.marginHeight;
    }

    public void initializeParent() {
        if (this.parent != null) {
            this.parent.setBackground(this.ds.background);
        }
    }

    public Color getDocBackgroundColor() {
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return null;
    }

    void resetDocStyle() {
        String string;
        Color color;
        if (this.doc == null) {
            return;
        }
        if (this.ds.bg != null) {
            this.ds.bg.removeClient(this.parent);
            this.ds.bg = null;
        }
        if ((color = (Color)this.doc.getProperty("text.color")) != null) {
            this.ds.docStyle.color = color;
        }
        this.ds.background = (Color)this.doc.getProperty("background.color");
        if (this.ds.background == null) {
            this.ds.background = Globals.getColor("hotjava.docbgcolor", Color.white);
        }
        if (this.ds.bg != null) {
            if (this.ds.started && this.parent != null) {
                this.ds.bg.removeClient(this.parent);
            }
            this.ds.bg = null;
        }
        if ((string = (String)this.doc.getProperty("background.img")) != null) {
            try {
                this.ds.bg = DocumentBackground.getDocumentBackground(new URL(this.doc.getBaseURL(), string), this.ds.background);
                if (this.ds.started && this.parent != null) {
                    this.ds.bg.addClient(this.parent);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.ds.docStyle.left = this.ds.docStyle.right = this.marginWidth;
    }

    public void notify(Document document, int n, int n2, int n3) {
        int n4 = this.findAffected(n2);
        switch (n) {
            case 10: {
                int n5 = n2 & 0x7FFF0000;
                int n6 = 65536 - (n2 & 0xFFFF);
                int n7 = n5 + 65536;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFF0000) == n5 && this.ds.selStart > n2) {
                        this.ds.selStart += n6;
                    } else if (this.ds.selStart > n7) {
                        this.ds.selStart += 65536;
                    }
                    if ((this.ds.selEnd & 0x7FFF0000) == n5 && this.ds.selEnd >= n2) {
                        this.ds.selEnd += n6;
                    } else if (this.ds.selEnd > n7) {
                        this.ds.selEnd += 65536;
                    }
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFF0000) == n5 && docLine.start > n2) {
                        docLine.start += n6;
                    } else if (docLine.start >= n7) {
                        docLine.start += 65536;
                    }
                    docLine.end = (docLine.end & 0x7FFF0000) == n5 && docLine.end >= n2 ? (docLine.end += n6) : (docLine.end += 65536);
                    docLine.tail = (docLine.tail & 0x7FFF0000) == n5 && docLine.tail >= n2 ? (docLine.tail += n6) : (docLine.tail += 65536);
                    ++n4;
                }
                if (n4 > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 12: {
                int n8 = n2 & 0x7FFF0000;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFF0000) == n8 && this.ds.selStart > n2) {
                        this.ds.selStart += n3;
                    }
                    if ((this.ds.selEnd & 0x7FFF0000) == n8 && this.ds.selEnd >= n2) {
                        this.ds.selEnd += n3;
                    }
                }
                int n9 = n8 + 65536;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start > n9) break;
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFF0000) == n8 && docLine.start > n2) {
                        docLine.start += n3;
                    }
                    if ((docLine.end & 0x7FFF0000) == n8 && docLine.end >= n2) {
                        docLine.end += n3;
                    }
                    if ((docLine.tail & 0x7FFF0000) == n8 && docLine.tail >= n2) {
                        docLine.tail += n3;
                    }
                    ++n4;
                }
                if (n4 > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 13: {
                this.notifyResponsiblesInRange(document, n, n2, n3);
                int n10 = n2 & 0x7FFF0000;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFF0000) == n10 && this.ds.selStart > n2) {
                        this.ds.selStart -= n3;
                    }
                    if ((this.ds.selEnd & 0x7FFF0000) == n10 && this.ds.selEnd > n2) {
                        this.ds.selEnd -= n3;
                    }
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start <= n2) {
                        this.invalidateFloatersInRange(docLine.start, docLine.end);
                        docLine.updated = true;
                    }
                    if ((docLine.start & 0x7FFF0000) == n10 && docLine.start > n2) {
                        docLine.start -= n3;
                    }
                    if ((docLine.end & 0x7FFF0000) == n10 && docLine.end > n2) {
                        docLine.end -= n3;
                    }
                    if ((docLine.tail & 0x7FFF0000) == n10 && docLine.tail > n2) {
                        docLine.tail -= n3;
                    }
                    ++n4;
                }
                return;
            }
            case 15: {
                if (this.hasSelection(this.ds)) {
                    this.adjustSelectionBy(n2, n3);
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start != docLine.end) {
                        if (docLine.start > n2) break;
                        if (docLine.end >= n2) {
                            docLine.end += n3;
                        }
                        docLine.tail += n3;
                        docLine.updated = true;
                    }
                    ++n4;
                }
                this.adjustSubsequentLinesBy(n4, n3);
                if (this.nlines > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[this.nlines - 1].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 16: {
                DocLine docLine;
                int n11 = n2 + n3;
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.removeFloatersInRange(n2, n11);
                if (this.hasSelection(this.ds)) {
                    this.adjustSelectionBy(n2, -n3);
                }
                if (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.start < n2) {
                        if (docLine.end > n2) {
                            docLine.end = n2;
                        }
                        docLine.tail = n2;
                        docLine.updated = true;
                        ++n4;
                    }
                }
                while (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.tail > n11) {
                        if (docLine.start >= n11) break;
                        docLine.start = n2;
                        docLine.end = docLine.end <= n11 ? n2 : (docLine.end -= n3);
                        docLine.tail -= n3;
                        docLine.updated = true;
                        ++n4;
                        break;
                    }
                    docLine.end = docLine.tail = n2;
                    docLine.start = docLine.tail;
                    docLine.updated = true;
                    ++n4;
                }
                this.adjustSubsequentLinesBy(n4, -n3);
                return;
            }
            case 18: 
            case 19: {
                Object object = this.SYNC_PAINTS;
                synchronized (object) {
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        try {
                            try {
                                this.paintRangeNoFloaters(graphics, n2, n2 + n3, n == 18);
                            }
                            catch (Exception exception) {
                            }
                            Object var10_32 = null;
                            graphics.dispose();
                        }
                        catch (Throwable throwable) {
                            Object var10_33 = null;
                            graphics.dispose();
                            throw throwable;
                        }
                    }
                    Object var7_18 = null;
                    return;
                }
            }
            case 17: {
                int n12 = n2 + n3;
                int n13 = n4;
                boolean bl = false;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start >= n12) break;
                    docLine.updated = true;
                    bl = true;
                    ++n4;
                }
                while (n4 < this.nlines) {
                    if (this.lines[n4].y == this.lines[n13].y) {
                        this.lines[n4].updated = true;
                        n12 = this.lines[n4].end;
                        bl = true;
                    } else if (this.lines[n4].y > this.lines[n13].y) break;
                    ++n4;
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.dirtyFloaterLines(new FormatState(), n2, n12);
                this.touch(bl, 200);
                return;
            }
            case 22: {
                this.processActivationQueue();
                return;
            }
            case 20: {
                this.activateItem(n2);
                return;
            }
            case 21: {
                this.notifyResponsiblesInRange(document, n, n2, n3);
                DocItem docItem = document.items[n2 >> 16];
                n4 = 0;
                while (n4 < this.nItemComponents) {
                    Component component = this.itemComponents[n4].getComponent();
                    int n14 = this.itemComponents[n4].getIndex();
                    DocItem docItem2 = document.items[n14];
                    if (docItem2 == docItem) {
                        if (this.ds.started) {
                            ((DocPanel)((Object)component)).stop();
                        }
                        ((DocPanel)((Object)component)).destroy();
                        if (this.parent != null) {
                            this.parent.remove(component);
                        }
                        System.arraycopy(this.itemComponents, n4 + 1, this.itemComponents, n4, this.nItemComponents - n4 - 1);
                        this.itemComponents[this.nItemComponents - 1] = null;
                        --this.nItemComponents;
                        --n4;
                    }
                    ++n4;
                }
                if (this.itemsNeedingDeactivation == null) break;
                int n15 = 0;
                while (n15 < this.itemsNeedingDeactivation.size()) {
                    DocItem docItem3 = (DocItem)this.itemsNeedingDeactivation.elementAt(n15);
                    docItem3.deactivate(this);
                    ++n15;
                }
                return;
            }
        }
    }

    private void adjustSelectionBy(int n, int n2) {
        if (this.ds.selStart > n) {
            this.ds.selStart += n2;
        }
        if (this.ds.selEnd >= n) {
            this.ds.selEnd += n2;
        }
    }

    private void adjustSubsequentLinesBy(int n, int n2) {
        int n3 = n;
        while (n3 < this.nlines) {
            DocLine docLine = this.lines[n3];
            if (docLine.start != docLine.end) {
                docLine.start += n2;
                docLine.end += n2;
                docLine.tail += n2;
            }
            ++n3;
        }
    }

    public void activateSubItems() {
    }

    synchronized boolean paint(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n5 = n2;
        int n6 = n5 + n4;
        DocStyle docStyle = null;
        Object object = this.SYNC_PAINTS;
        synchronized (object) {
            int n7 = this.findY(n2);
            while (n7 < this.nlines) {
                DocLine docLine = this.lines[n7];
                if (docLine.y >= n6) break;
                n5 = docLine.y;
                if (bl) {
                    this.paintBack(graphics, n, n5, n3, docLine.height);
                }
                if (!docLine.updated) {
                    docStyle = this.paintLine(graphics, docLine, n5, n, n3, docStyle, bl2);
                } else {
                    bl3 = true;
                    docStyle = null;
                }
                n5 += docLine.height;
                ++n7;
            }
            if (bl && n5 < n6) {
                this.paintBack(graphics, n, n5, n3, n6 - n5);
            }
            this.paintFloaters(graphics, n, n2, n3, n4);
        }
        if (this.bFormatDone) {
            return bl3;
        }
        return false;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.ds.started) {
            ScreenUpdater.updater.notify((UpdateClient)this, 200L, (Object)REPAINT);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void copyLines(Graphics var1_1, int var2_2, int var3_3, int var4_4) {
        ** GOTO lbl23
        {
            var4_4 += this.lines[var2_2].height;
            ++var2_2;
            do {
                if (var2_2 < var3_3 && this.lines[var2_2].updated) continue block0;
                if (var2_2 >= var3_3) continue;
                var5_5 = this.lines[var2_2];
                var6_6 = var5_5.y;
                var7_7 = var5_5.height;
                var8_8 = var2_2 + 1;
                while (var8_8 < var3_3 && !this.lines[var8_8].updated) {
                    var7_7 += this.lines[var8_8++].height;
                }
                if (var6_6 > var4_4) {
                    var1_1.copyArea(0, var6_6, this.width, var7_7, 0, var4_4 - var6_6);
                } else if (var6_6 < var4_4) {
                    this.copyLines(var1_1, var8_8, var3_3, var4_4 + var7_7);
                    var1_1.copyArea(0, var6_6, this.width, var7_7, 0, var4_4 - var6_6);
                    return;
                }
                var2_2 = var8_8;
                var4_4 += var7_7;
lbl23:
                // 3 sources

            } while (var2_2 < var3_3);
        }
    }

    void notifyDocSize() {
        if (this.ds.started) {
            this.dispatchDocumentEvent(1003, this);
        }
    }

    public void forceFormatScreen() {
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)FORMAT_SCREEN);
    }

    /*
     * Unable to fully structure code
     */
    void formatScreen() {
        Globals.registerTimeStamp(this, "BEGIN FORMAT SCREEN");
        var1_1 = null;
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = 0;
        var12_12 = false;
        var13_13 = this.docHeight;
        var14_14 = var4_4;
        var15_15 = this.docWidth;
        var16_16 = (Vector)(this.floaters == null ? null : this.floaters.clone());
        do {
            block46: {
                block47: {
                    this.setCompleted(false);
                    this.docHeight = var13_13;
                    this.docWidth = var15_15;
                    var4_4 = var14_14;
                    this.floaters = (Vector)(var16_16 == null ? null : var16_16.clone());
                    var1_1 = this.lines;
                    var2_2 = this.nlines;
                    var3_3 = this.doc.nitems << 16;
                    var4_4 = this.getDocumentY();
                    var5_5 = this.height + var4_4;
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    var17_17 = new FormatState();
                    var18_18 = new FormatState();
                    var17_17.pos = -1;
                    if (var2_2 <= 0) break block46;
                    if (var4_4 > 0) {
                        var19_19 = this.getFloatersStartY(var4_4);
                        var7_7 = this.findY(var19_19);
                        var8_8 = this.doc.startPos(var1_1[var7_7].start);
                        while (var7_7 > 0 && var8_8 < var1_1[var7_7].start) {
                            --var7_7;
                        }
                    }
                    if (var8_8 <= var1_1[var7_7].start) ** GOTO lbl47
                    var1_1[var7_7].updated = true;
                    break block47;
lbl-1000:
                    // 1 sources

                    {
                        ++var7_7;
lbl47:
                        // 2 sources

                        ** while (var7_7 < var2_2 && !var1_1[var7_7].updated)
                    }
                }
                if (var7_7 > 0) {
                    var19_20 = var1_1[var7_7 - 1];
                    var6_6 = var19_20.y + var19_20.height;
                    var8_8 = var19_20.end;
                }
                if (var6_6 >= var5_5 || var8_8 > var3_3) {
                    ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
                    return;
                }
            }
            var10_10 = var6_6;
            var9_9 = var7_7;
            var11_11 = var7_7;
            while (var6_6 < var5_5 && var8_8 < var3_3) {
                var19_21 = this.formatLine(var6_6, var8_8, (FormatState)var17_17, var18_18);
                if (var19_21 == null) break;
                var19_21.updated = true;
                var8_8 = var19_21.end;
                var19_21.y = var6_6;
                var20_24 = var19_21.height;
                var6_6 += var20_24;
                while (var11_11 < var2_2 && var1_1[var11_11].end <= var8_8) {
                    var20_24 -= var1_1[var11_11].height;
                    ++var11_11;
                }
                this.docHeight += var20_24;
                if (var4_4 > this.docHeight) {
                    var4_4 = this.docHeight;
                }
                if ((var21_26 = var19_21.margin >> 16) < 0) {
                    var22_32 = this.doc.getStyle(this.ds.docStyle, var19_21.start);
                    var21_26 = this.getMargin(var22_32, var19_21.start, var19_21.y) >> 16;
                }
                if (this.docWidth < var21_26 + var19_21.width) {
                    this.docWidth = var21_26 + var19_21.width;
                }
                if (var11_11 == var7_7) {
                    var22_33 = 10;
                    if (var2_2 + var22_33 > var1_1.length) {
                        var23_34 = Math.max(var2_2 + var22_33, 3 * (var1_1.length + 1) / 2);
                        var24_36 = new DocLine[var23_34];
                        System.arraycopy(var1_1, 0, var24_36, 0, var2_2);
                        var1_1 = var24_36;
                    }
                    System.arraycopy(var1_1, var11_11, var1_1, var11_11 + var22_33, var2_2 - var11_11);
                    var11_11 += var22_33;
                    var2_2 += var22_33;
                }
                var1_1[var7_7++] = var19_21;
                if (var11_11 >= var2_2 || var6_6 >= var5_5 || var1_1[var11_11].updated || var1_1[var11_11].start != var8_8 || var1_1[var11_11].margin != var17_17.margin) continue;
                do {
                    var19_21 = var1_1[var11_11++];
                    v0 = var19_21.updated = this.ds.bg != null && var19_21.y != var6_6;
                    if (var19_21.updated) {
                        this.invalidateFloatersInRange(var19_21.start, var19_21.end);
                    }
                    var1_1[var7_7++] = var19_21;
                } while (var11_11 < var2_2 && (var6_6 += var19_21.height) < var5_5 && !var1_1[var11_11].updated);
                var8_8 = var1_1[var11_11 - 1].end;
            }
            if (this.hasFrameSetPanel()) {
                var12_12 = true;
                continue;
            }
            var19_22 = var6_6;
            if (var9_9 < var7_7) {
                var20_24 = var9_9;
                while (var20_24 < var7_7) {
                    var21_27 = var1_1[var20_24++];
                    var19_22 += var21_27.height;
                }
            }
            if (var11_11 < var2_2) {
                var20_24 = var11_11;
                if (var1_1[var11_11].y != var19_22) {
                    do {
                        var21_28 = var1_1[var20_24++];
                        var19_22 += var21_28.height;
                    } while (var20_24 < var2_2);
                } else {
                    var19_22 = var1_1[var2_2 - 1].y;
                }
            }
            if (var19_22 > var5_5) {
                if (this.scroller != null) {
                    var20_24 = this.scroller.getVScrollbarWidth();
                    if (this.getVScrollBarWidth() != var20_24) {
                        var21_29 = this.width + this.getVScrollBarWidth();
                        if (var21_29 > var20_24) {
                            this.width = var21_29 - var20_24;
                            this.setVScrollBarWidth(var20_24);
                            continue;
                        }
                        var12_12 = true;
                        continue;
                    }
                    var12_12 = true;
                    continue;
                }
                var12_12 = true;
                continue;
            }
            var12_12 = true;
        } while (!var12_12);
        var17_17 = this.SYNC_PAINTS;
        synchronized (var17_17) {
            var19_23 = this.getGraphics();
            Globals.registerTimeStamp(this, "BEGIN PAINTING");
            if (var19_23 != null) {
                try {
                    if (var9_9 < var7_7) {
                        var6_6 = var10_10;
                        var22_32 = null;
                        try {
                            this.ds.paintingScreen = true;
                            while (var9_9 < var7_7) {
                                var25_37 = var1_1[var9_9++];
                                var25_37.y = var6_6;
                                if (var25_37.updated) {
                                    var25_37.updated = false;
                                    this.paintBack(var19_23, 0, var6_6, this.width, var25_37.height);
                                    var22_32 = this.paintLine(var19_23, var25_37, var6_6, 0, this.width, var22_32, false);
                                } else {
                                    var22_32 = null;
                                }
                                var6_6 += var25_37.height;
                            }
                        }
                        finally {
                            var24_36 = null;
                            this.ds.paintingScreen = false;
                        }
                    }
                    if (var6_6 < var5_5) {
                        this.paintBack(var19_23, 0, var6_6, this.width, this.height - var6_6);
                    }
                    this.paintFloaters(var19_23, 0, var10_10, this.width, this.height - (var10_10 - var4_4));
                }
                finally {
                    var21_30 = null;
                    var19_23.dispose();
                }
            }
            Globals.registerTimeStamp(this, "END PAINTING");
        }
        if (var11_11 < var2_2 && var1_1[var11_11].y != var6_6) {
            this.updateFloatersYInRange(var8_8, var3_3, var6_6 - var1_1[var11_11].y);
            do {
                var17_17 = var1_1[var11_11++];
                var17_17.y = var6_6;
                var6_6 += var17_17.height;
                var1_1[var7_7++] = var17_17;
            } while (var11_11 < var2_2);
        } else {
            System.arraycopy(var1_1, var11_11, var1_1, var7_7, var2_2 - var11_11);
        }
        this.lines = var1_1;
        this.nlines = var2_2 += var7_7 - var11_11;
        Globals.registerTimeStamp(this, "END FORMAT SCREEN");
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
    }

    public void scrollWhenDone(Point point) {
        this.scrollWhenDone(point.x, point.y);
    }

    public void scrollWhenDone(int n, int n2) {
        this.xToScroll = n;
        this.yToScroll = n2;
        this.needScrollOnFinish = true;
    }

    /*
     * Unable to fully structure code
     */
    void formatDocument() {
        block25: {
            Globals.registerTimeStamp(this, "BEGIN FORMAT DOCUMENT");
            this.setCompleted(false);
            var1_1 = this.lines;
            var2_2 = this.nlines;
            var3_3 = System.currentTimeMillis() + 200L;
            if (this.newY == 0) {
                this.newY = this.getDocumentY();
            }
            var5_4 = 0;
            while (var5_4 < var2_2 && !var1_1[var5_4].updated) {
                ++var5_4;
            }
            var6_5 = this.doc.nitems << 16;
            var7_6 = var5_4 > 0 ? var1_1[var5_4 - 1].end : 0;
            var8_7 = var5_4 > 0 ? var1_1[var5_4 - 1].y + var1_1[var5_4 - 1].height : 0;
            var9_8 = var5_4;
            var10_9 = false;
            var11_10 = new FormatState();
            var12_11 = new FormatState();
            var11_10.pos = -1;
            while (var7_6 < var6_5) {
                var13_12 = this.formatLine(var8_7, var7_6, var11_10, var12_11);
                if (var13_12 == null) break;
                if (var8_7 + var13_12.height > this.newY && var8_7 < this.height) {
                    this.touch();
                    break;
                }
                var13_12.y = var8_7;
                var7_6 = var13_12.end;
                var8_7 += var13_12.height;
                var14_17 = var13_12.height;
                while (var9_8 < var2_2 && var1_1[var9_8].end <= var7_6) {
                    var14_17 -= var1_1[var9_8].height;
                    ++var9_8;
                }
                if (var8_7 < this.newY) {
                    this.newY += var14_17;
                }
                this.docHeight += var14_17;
                if (this.newY > this.docHeight) {
                    this.newY = this.docHeight;
                } else if (this.newY < 0) {
                    this.newY = 0;
                }
                var15_21 = var13_12.margin >> 16;
                if (var15_21 < 0) {
                    var16_23 = this.doc.getStyle(this.ds.docStyle, var13_12.start);
                    var15_21 = this.getMargin(var16_23, var13_12.start, var13_12.y) >> 16;
                }
                if (this.docWidth < var15_21 + var13_12.width) {
                    this.docWidth = var15_21 + var13_12.width;
                }
                if (var9_8 == var5_4) {
                    var16_24 = 10;
                    if (var2_2 + var16_24 > var1_1.length) {
                        var17_26 = new DocLine[var1_1.length * 2];
                        System.arraycopy(var1_1, 0, var17_26, 0, var2_2);
                        var1_1 = var17_26;
                    }
                    System.arraycopy(var1_1, var9_8, var1_1, var9_8 + var16_24, var2_2 - var9_8);
                    var9_8 += var16_24;
                    var2_2 += var16_24;
                }
                var1_1[var5_4++] = var13_12;
                if (var9_8 < var2_2 && !var1_1[var9_8].updated && var1_1[var9_8].start == var7_6 && var1_1[var9_8].margin == var11_10.margin) {
                    do {
                        var13_12 = var1_1[var9_8++];
                        this.updateFloatersYInRange(var13_12.start, var13_12.end, var8_7 - var13_12.y);
                        var13_12.y = var8_7;
                        var8_7 += var13_12.height;
                        var1_1[var5_4++] = var13_12;
                    } while (var9_8 < var2_2 && !var1_1[var9_8].updated);
                    var7_6 = var1_1[var9_8 - 1].end;
                }
                if (System.currentTimeMillis() < var3_3) continue;
                ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
                var10_9 = true;
                break;
            }
            this.docHeight = this.adjustDocHeightForFloaters(this.docHeight);
            if (var9_8 < var2_2 && var1_1[var9_8].y != var8_7) {
                this.updateFloatersYInRange(var7_6, var6_5, var8_7 - var1_1[var9_8].y);
                do {
                    var13_12 = var1_1[var9_8++];
                    var13_12.y = var8_7;
                    var8_7 += var13_12.height;
                    var1_1[var5_4++] = var13_12;
                } while (var9_8 < var2_2);
            } else {
                System.arraycopy(var1_1, var9_8, var1_1, var5_4, var2_2 - var9_8);
            }
            var2_2 += var5_4 - var9_8;
            if (var10_9) break block25;
            var13_13 = 0;
            var8_7 = 0;
            var15_21 = 0;
            while (var15_21 < var2_2 && var13_13 < this.nItemComponents) {
                block26: {
                    var16_25 = this.itemComponents[var13_13].getIndex();
                    var14_19 = var1_1[var15_21];
                    if (var16_25 <= var14_19.end >> 16) ** GOTO lbl98
                    break block26;
lbl-1000:
                    // 1 sources

                    {
                        var17_26 = this.itemComponents[var13_13].getComponent();
                        var18_27 = var17_26.getBounds();
                        if (!(var18_27.y + var18_27.height >= var14_19.y && var14_19.y + var14_19.height > var18_27.y || var8_7 + var14_19.height > this.newY && var8_7 < this.height)) {
                            var17_26.setLocation(var18_27.x, var14_19.y);
                        }
                        if (++var13_13 >= this.nItemComponents) break;
                        var16_25 = this.itemComponents[var13_13].getIndex();
lbl98:
                        // 2 sources

                        ** while (var16_25 >= var14_19.start >> 16 && var16_25 < var14_19.end >> 16)
                    }
                }
                var8_7 += var14_19.height;
                ++var15_21;
            }
        }
        this.nlines = var2_2;
        this.lines = var1_1;
        if (!var10_9) {
            this.notifyDocSize();
            if (this.needScrollOnFinish) {
                this.scroller.setScrollPosition(this.xToScroll, this.yToScroll);
                this.needScrollOnFinish = false;
            }
            this.setCompleted(true);
        }
        if (this.label != null && (var13_15 = this.doc.findLabel(this.label)) != -1 && var13_15 <= var7_6) {
            var14_20 = this.findYFor(var13_15);
            this.scrollTo(this.docX, var14_20);
            var15_22 = this.scroller.getScrollPosition();
            if (var15_22.y >= var14_20) {
                this.label = null;
            }
        }
        this.bFormatDone = true;
        var13_16 = Globals.localProps.handleGetString("hotjava.done");
        this.dispatchDocumentEvent(1024, var13_16);
        Globals.registerTimeStamp(this, "END FORMAT DOCUMENT");
        Globals.flushTimeStamps();
    }

    private void adjustScrollpaneOrigin() {
        int n = this.getDocumentY();
        int n2 = this.docX;
        this.docX = -this.getXOriginDelta();
        if (this.newY != n || this.docX != n2) {
            Graphics graphics;
            if ((n > this.newY && n < this.newY + this.height || n < this.newY && n + this.height > this.newY) && (graphics = this.getGraphics()) != null) {
                int n3 = 0;
                int n4 = 0;
                if (n < this.newY) {
                    n4 = n + this.height - this.newY;
                    n3 = n;
                    graphics.copyArea(this.docX, n3, this.width, n4, 0, this.newY - n);
                } else {
                    n4 = this.newY + this.height - n;
                    n3 = n + this.height - n4;
                    graphics.copyArea(this.docX, n3, this.width, n4, 0, n - n3);
                }
                graphics.dispose();
            }
            this.scrollTo(this.docX, this.newY);
        }
        this.newY = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateClient(Object object) {
        System.currentTimeMillis();
        if (!this.ds.started) return;
        Object object2 = Globals.getAwtLock();
        synchronized (object2) {
            Document document = this.getTopDocument();
            synchronized (document) {
                Document document2 = this.doc;
                synchronized (document2) {
                    if (object != null) {
                        if (object.equals(REPAINT)) {
                            Graphics graphics = this.getGraphics();
                            if (graphics == null) return;
                            int n = this.parent.getSize().width;
                            if (this.paint(graphics, 0, 0, n, this.height, true, false)) {
                                this.touch();
                            }
                            graphics.dispose();
                            return;
                        }
                        if (object.equals(FORMAT_SCREEN)) {
                            this.repair = false;
                            this.formatScreen();
                        } else {
                            if (!object.equals(FORMAT_DOCUMENT)) return;
                            this.formatDocument();
                        }
                    } else if (this.repair) {
                        this.repair = false;
                        this.formatScreen();
                    } else {
                        this.formatDocument();
                    }
                }
            }
            return;
        }
    }

    private Document getTopDocument() {
        if (this.parent == null) {
            return this.doc;
        }
        Container container = this.parent;
        while (!(container instanceof MasterDocumentPanel)) {
            if ((container = container.getParent()) != null) continue;
            return this.doc;
        }
        MasterDocumentPanel masterDocumentPanel = (MasterDocumentPanel)container;
        Document document = masterDocumentPanel.getDocument();
        if (document != null) {
            return document;
        }
        return this.doc;
    }

    public int updatePriority() {
        if (this.repair) {
            return 5;
        }
        return 4;
    }

    public void touch(boolean bl, int n, DocItem docItem) {
        if (!this.doc.isOkToFormat() || !this.bFormatDone) {
            return;
        }
        int n2 = this.findPos(docItem.getIndex() << 16);
        if (n2 < this.nlines) {
            this.lines[n2].updated = true;
        }
        this.touch(bl, n);
    }

    public void touch(boolean bl, int n) {
        if (this.getParent() == null) {
            return;
        }
        if (!this.doc.isOkToFormat() || !this.bFormatDone) {
            return;
        }
        this.repair = bl | this.repair;
        if (this.ds.started) {
            ScreenUpdater.updater.setPriority(5);
            ScreenUpdater.updater.notify((UpdateClient)this, (long)n);
        }
    }

    protected boolean handleMouseUp(MouseEvent mouseEvent) {
        Object object = this.dragLock;
        synchronized (object) {
            if (this.dragThread != null) {
                this.dragThread.stop();
                this.dragThread = null;
            }
        }
        return super.handleMouseUp(mouseEvent);
    }

    protected boolean handleMouseDrag(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (super.handleMouseDrag(mouseEvent)) {
            int n = point.x;
            int n2 = point.y;
            Point point2 = this.scroller.getScrollPosition();
            Dimension dimension = this.scroller.getViewportSize();
            int n3 = point2.x + dimension.width;
            int n4 = point2.y + dimension.height;
            int n5 = this.scroller.getVAdjustable().getUnitIncrement();
            int n6 = this.scroller.getHAdjustable().getUnitIncrement();
            if (n > n3) {
                this.scrollBy(n6, 0);
                this.notifyDragThread(n6, 0, mouseEvent);
            } else if (n < point2.x) {
                this.scrollBy(-n6, 0);
                this.notifyDragThread(-n6, 0, mouseEvent);
            }
            if (n2 > n4) {
                this.scrollBy(0, n5);
                this.notifyDragThread(0, n5, mouseEvent);
            } else if (n2 < point2.y) {
                this.scrollBy(0, -n5);
                this.notifyDragThread(0, -n5, mouseEvent);
            }
        }
        return true;
    }

    private void notifyDragThread(int n, int n2, MouseEvent mouseEvent) {
        Object object = this.dragLock;
        synchronized (object) {
            if (this.dragThread == null) {
                this.dragThread = new DragThread(n, n2, this.dragDelay, this, mouseEvent);
                this.dragThread.start();
            } else {
                this.dragThread.notifyDragThread(n, n2);
            }
            return;
        }
    }

    public void reformat() {
        if (!this.doc.isOkToFormat()) {
            return;
        }
        super.reformat();
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)FORMAT_SCREEN);
    }

    public void layout() {
        if (!this.doc.isOkToFormat()) {
            return;
        }
        this.docWidth = 0;
        this.reformat();
    }

    public void scrollTo(Point point) {
        this.scrollTo(point.x, point.y);
    }

    public void scrollTo(int n, int n2) {
        int n3 = this.scroller.getViewportSize().height;
        if (this.docHeight > n3 && n2 > this.docHeight - n3) {
            n2 = this.docHeight - n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        try {
            this.scroller.getHAdjustable().setValue(n);
            this.scroller.getVAdjustable().setValue(n2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void scrollBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                this.notifyDocSize();
                Point point = this.scroller.getScrollPosition();
                this.scrollTo(point.x + n, point.y + n2);
            }
            return;
        }
    }

    public void top() {
        this.scrollTo(0, 0);
    }

    public void paint(Graphics graphics, boolean bl) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.ds.started) {
                    boolean bl2 = !bl;
                    Rectangle rectangle = graphics.getClipRect();
                    if (rectangle == null) {
                        if (this.paint(graphics, 0, 0, this.width, this.height, true, bl2)) {
                            this.touch();
                        }
                    } else if (this.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true, bl2)) {
                        this.touch();
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void select(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                int n3;
                if (n > n2) {
                    n3 = n2;
                    n2 = n;
                    n = n3;
                }
                if (n == this.ds.selStart && n2 == this.ds.selEnd) {
                    return;
                }
                if (n == n2 && n == 0 && !this.hasSelection(this.ds)) {
                    return;
                }
                n3 = this.ds.selStart;
                int n4 = this.ds.selEnd;
                this.ds.selStart = n;
                this.ds.selEnd = n2;
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    if (this.ds.selStart > n4 || this.ds.selEnd < n3) {
                        this.paintRange(graphics, n3, n4, true);
                        this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    } else {
                        int n5;
                        int n6 = Math.min(this.ds.selStart, n3);
                        if (n6 < (n5 = Math.max(this.ds.selStart, n3))) {
                            this.paintRange(graphics, n6, n5, true);
                        }
                        if ((n6 = Math.min(this.ds.selEnd, n4)) < (n5 = Math.max(this.ds.selEnd, n4))) {
                            this.paintRange(graphics, n6, n5, true);
                        }
                    }
                    graphics.dispose();
                }
            }
        }
        this.dispatchDocumentEvent(1007, this.doc);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.lostOwnership();
    }

    public void lostOwnership() {
        this.select(-1, -1);
    }

    public void selectAll() {
        this.select(0, this.doc.length());
    }

    public synchronized void scrollTo(int n) {
        int n2 = this.findYFor(n);
        this.scrollTo(0, n2);
    }

    public void showCursor(boolean bl) {
        Document document = this.doc;
        synchronized (document) {
            if (this.ds.showcur != bl) {
                Graphics graphics;
                this.ds.showcur = bl;
                if (this.ds.selStart == this.ds.selEnd && (graphics = this.getGraphics()) != null) {
                    this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    graphics.dispose();
                }
            }
            return;
        }
    }

    public void showSelection(boolean bl) {
        Document document = this.doc;
        synchronized (document) {
            if (this.ds.showsel != bl) {
                Graphics graphics;
                this.ds.showsel = bl;
                if (this.ds.selStart < this.ds.selEnd && (graphics = this.getGraphics()) != null) {
                    this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    graphics.dispose();
                }
            }
            return;
        }
    }

    public int getSelectEnd() {
        return this.ds.selEnd;
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1004: {
                String string;
                if (documentEvent.getSource() != this.doc || !(string = (String)documentEvent.getArgument()).equals("background.img") && !string.equals("text.color") && !string.equals("background.color") && !string.equals("margin.left") && !string.equals("margin.right")) break;
                this.resetDocStyle();
                return;
            }
            case 1005: {
                if (this.doc.getState() != 12) break;
                this.docWidth = 0;
                return;
            }
            case 1009: {
                Object object = Globals.getAwtLock();
                synchronized (object) {
                    Document document = this.doc;
                    synchronized (document) {
                        int n = 0;
                        while (n < this.nItemComponents) {
                            Component component = this.itemComponents[n].getComponent();
                            ((DocPanel)((Object)component)).interruptLoading();
                            ++n;
                        }
                        if (this.itemsNeedingDeactivation != null) {
                            int n2 = 0;
                            while (n2 < this.itemsNeedingDeactivation.size()) {
                                DocItem docItem = (DocItem)this.itemsNeedingDeactivation.elementAt(n2);
                                docItem.deactivate(this);
                                ++n2;
                            }
                        }
                    }
                    return;
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 12: {
                int n = 0;
                while (n < this.nlines) {
                    System.out.println(String.valueOf(n) + " --- " + this.lines[n]);
                    ++n;
                }
                this.doc.print();
                return;
            }
        }
    }

    public String getSelectedText() {
        int n;
        int n2;
        if (!this.hasSelection(this.ds)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        UpdateClient updateClient = this;
        synchronized (updateClient) {
            n2 = this.ds.selStart;
            n = this.ds.selEnd;
        }
        updateClient = this.doc;
        synchronized (updateClient) {
            DocItemEnumeration docItemEnumeration = this.doc.getDocItems(n2, n);
            while (docItemEnumeration.hasMoreElements()) {
                String string;
                DocItem docItem;
                DocItem docItem2 = (DocItem)docItemEnumeration.nextElement();
                if (docItem2.isText()) {
                    docItem = (TextItem)docItem2;
                    stringBuffer.append(((TextItem)docItem).getText(n2, n));
                    continue;
                }
                if (docItem2.isBlock()) {
                    stringBuffer.append("\n");
                    continue;
                }
                if (!docItem2.isEnd() || (string = (docItem = ((EndTagItem)docItem2).getTag(this.doc)).getText()) == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getSelectedSource() {
        int n;
        int n2;
        if (!this.hasSelection(this.ds)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        UpdateClient updateClient = this;
        synchronized (updateClient) {
            n2 = this.ds.selStart;
            n = this.ds.selEnd;
        }
        updateClient = this.doc;
        synchronized (updateClient) {
            DocItemEnumeration docItemEnumeration = this.doc.getDocItems(n2, n);
            while (docItemEnumeration.hasMoreElements()) {
                Object object;
                DocItem docItem = (DocItem)docItemEnumeration.nextElement();
                if (docItem.isText()) {
                    object = (TextItem)docItem;
                    stringBuffer.append(((TextItem)object).getText(n2, n));
                    continue;
                }
                if (!docItem.isStart() && !docItem.isEnd() || (object = docItem.toString()) == null) continue;
                stringBuffer.append((String)object);
            }
        }
        return stringBuffer.toString();
    }

    public void print(PrintJob printJob, MasterDocumentPanel masterDocumentPanel) throws DocBusyException {
        Graphics graphics;
        int n = this.doc.setOwner(14, Thread.currentThread());
        this.ds.docStyle.left = 0;
        this.ds.docStyle.right = 0;
        this.ds.background = Color.white;
        this.ds.docStyle.nonScreenGraphics = graphics = printJob.getGraphics();
        String string = (String)Globals.props.get("hotjava.pageMarkerClass");
        if (string == null) {
            string = "sunw.hotjava.doc.StdPageMarker";
        }
        PageMarker pageMarker = null;
        try {
            Object obj = Class.forName(string).newInstance();
            if (obj instanceof PageMarker) {
                pageMarker = (PageMarker)obj;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate: " + string);
            exception.printStackTrace(System.err);
        }
        try {
            Object object;
            Dimension dimension = printJob.getPageDimension();
            PageMargins pageMargins = new PageMargins();
            int n2 = printJob.getPageResolution();
            pageMargins.setTopMargin(Integer.getInteger("hotjava.print.margin.top", 72) * n2 / 72);
            pageMargins.setBottomMargin(Integer.getInteger("hotjava.print.margin.bottom", 72) * n2 / 72);
            pageMargins.setLeftMargin(Integer.getInteger("hotjava.print.margin.left", 72) * n2 / 72);
            pageMargins.setRightMargin(Integer.getInteger("hotjava.print.margin.right", 72) * n2 / 72);
            if (pageMarker != null) {
                pageMarker.adjustMargins(pageMargins);
            }
            String string2 = Globals.localProps.handleGetString("printjob.format.msg");
            masterDocumentPanel.setMessage(string2);
            Dimension dimension2 = new Dimension(dimension.width - pageMargins.getHorizMargin(), dimension.height - pageMargins.getVertMargin());
            this.setSize(dimension2.width, dimension2.height, 0);
            double d = 1.0;
            boolean bl = false;
            int n3 = this.formatPrintDocument(0);
            Dimension dimension3 = dimension2;
            if (n3 > dimension2.width) {
                d = (double)dimension2.width / (double)n3;
                dimension3 = new Dimension((int)(0.5 + (double)dimension2.width / d), (int)(0.5 + (double)dimension2.height / d));
                this.setSize(dimension3.width, dimension3.height, 0);
                object = new ScalingGraphics(this.ds.docStyle.nonScreenGraphics, d);
                ((ScalingGraphics)object).setTryToScaleFonts(bl);
                this.ds.docStyle.nonScreenGraphics = object;
                n3 = this.reformatForPrinting();
                if (n3 > dimension2.width) {
                    bl = true;
                    ((ScalingGraphics)object).setTryToScaleFonts(bl);
                    ((ScalingGraphics)object).setTryToScaleFonts(true);
                    ((ScalingGraphics)object).setFont(this.ds.docStyle.font);
                    this.reformatForPrinting();
                }
            }
            object = new Vector(20);
            this.paginate((Vector)object, pageMargins, dimension3);
            masterDocumentPanel.setMessage(Globals.localProps.handleGetString("printjob.start.msg"));
            this.printPages(printJob, graphics, masterDocumentPanel, pageMarker, (Vector)object, pageMargins, dimension2, d, bl);
        }
        catch (Throwable throwable) {
            Object var8_21 = null;
            this.doc.setOwner(n, null);
            throw throwable;
        }
        Object var8_20 = null;
        this.doc.setOwner(n, null);
    }

    private int reformatForPrinting() {
        this.lines = new DocLine[100];
        this.nlines = 0;
        this.copyPanelsForPrinting(this, this.ds);
        return this.formatPrintDocument(0);
    }

    private void paginate(Vector vector, PageMargins pageMargins, Dimension dimension) {
        int n = 0;
        int n2 = dimension.height / 3;
        PageInfo pageInfo = new PageInfo(0, n);
        int n3 = 0;
        block0: while (n3 < this.nlines) {
            int n4;
            int n5 = n4 = n + dimension.height;
            int n6 = this.highestSplitFloaterY(this.lines[n3].y + n4);
            if (n6 != -1) {
                int n7 = n6 - this.lines[n3].y - 1;
                if (n7 + n2 >= n4) {
                    n4 = n7;
                    n6 = -1;
                } else {
                    n4 -= (int)(0.05 * (double)dimension.height);
                }
            }
            Dimension dimension2 = dimension;
            if (n4 != dimension.height) {
                dimension2 = new Dimension(dimension.width, n4);
            }
            int n8 = 0;
            while (n3 < this.nlines) {
                DocLine docLine = this.lines[n3];
                if (this.lineOverflows(docLine, n8, dimension2)) {
                    if (n8 < n5 - n2) {
                        this.pageFinished(vector, pageInfo, n3 + 1);
                        pageInfo = new PageInfo(n3, n += (int)((double)dimension.height * 0.95) - n8);
                        continue block0;
                    }
                    this.pageFinished(vector, pageInfo, n3);
                    n = 0;
                    pageInfo = new PageInfo(n3, n);
                    continue block0;
                }
                n8 += docLine.height;
                ++n3;
            }
        }
        this.pageFinished(vector, pageInfo, n3);
    }

    private void printPages(PrintJob printJob, Graphics graphics, MasterDocumentPanel masterDocumentPanel, PageMarker pageMarker, Vector vector, PageMargins pageMargins, Dimension dimension, double d, boolean bl) {
        int n = vector.size();
        int n2 = printJob.lastPageFirst() ? n - 1 : 0;
        String string = Globals.localProps.handleGetString("printjob.page.msg");
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{String.valueOf(n2 + 1)};
        do {
            Object var20_18;
            Graphics graphics2;
            block8: {
                String string2 = messageFormat.format(objectArray);
                masterDocumentPanel.setMessage(string2);
                PrintedLineInfo printedLineInfo = new PrintedLineInfo();
                graphics2 = graphics;
                graphics = null;
                if (graphics2 == null) {
                    graphics2 = printJob.getGraphics();
                }
                try {
                    if (pageMarker != null) {
                        pageMarker.markBefore(this.doc, graphics2.create(), printJob, n2, n);
                    }
                    DocStyle docStyle = null;
                    PageInfo pageInfo = (PageInfo)vector.elementAt(n2);
                    int n3 = dimension.width;
                    Graphics graphics3 = graphics2.create();
                    int n4 = (int)(0.5 + (double)pageInfo.verticalOffset * d);
                    graphics2.translate(pageMargins.getLeftMargin(), pageMargins.getTopMargin() - n4);
                    graphics2.clipRect(0, n4, dimension.width, dimension.height);
                    graphics2.setColor(Color.black);
                    graphics2.setFont(this.ds.docStyle.font);
                    if (d != 1.0) {
                        ScalingGraphics scalingGraphics = new ScalingGraphics(graphics2, d);
                        scalingGraphics.setTryToScaleFonts(bl);
                        n3 = (int)(0.5 + (double)n3 / d);
                        graphics2 = scalingGraphics;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = pageInfo.startLine;
                    while (n7 < pageInfo.endLine) {
                        docStyle = this.printLine(graphics2, this.lines[n7], n6, 0, n3, docStyle, printedLineInfo);
                        if (n7 == pageInfo.startLine) {
                            n5 = printedLineInfo.startDocY;
                        }
                        n6 += printedLineInfo.height;
                        ++n7;
                    }
                    this.printFloatersInYRange(graphics2, n5, n5 + n6);
                    Dimension dimension2 = printJob.getPageDimension();
                    graphics3.setColor(Color.white);
                    graphics3.fillRect(0, dimension2.height - pageMargins.getBottomMargin() + 1, dimension2.width, pageMargins.getBottomMargin());
                    if (pageMarker == null) break block8;
                    pageMarker.markAfter(this.doc, graphics3, printJob, n2, n);
                }
                catch (Throwable throwable) {
                    var20_18 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            var20_18 = null;
            graphics2.dispose();
        } while (!(printJob.lastPageFirst() ? n2-- <= 0 : ++n2 >= n));
    }

    private void pageFinished(Vector vector, PageInfo pageInfo, int n) {
        if (!pageInfo.isFinished()) {
            pageInfo.endLine = n;
            pageInfo.markFinished();
            vector.addElement(pageInfo);
        }
    }

    private void setCompleted(boolean bl) {
        bl &= this.doc.doneParsing();
        if (this.getParent() instanceof DocumentFormatterPanel) {
            DocumentFormatterPanel documentFormatterPanel = (DocumentFormatterPanel)this.getParent();
            documentFormatterPanel.setCompleted(bl);
        }
    }

    private final class DocListener
    implements DocumentListener {
        public DocListener() {
            DocumentFormatter.this = DocumentFormatter.this;
        }

        public void documentChanged(DocumentEvent documentEvent) {
            DocumentFormatter.this.processDocumentEvent(documentEvent);
        }
    }

    private final class 1
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            DocumentFormatter.this.processKeyEvent(keyEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

