/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean.applets;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import sun.awt.VariableGridLayout;
import sun.misc.BASE64Encoder;
import sun.misc.CharacterEncoder;
import sun.net.smtp.SmtpClient;
import sunw.hotjava.bean.applets.HotJavaBeanApplet;
import sunw.hotjava.misc.Base64HeaderEncoder;
import sunw.hotjava.misc.CharacterEncoding;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.misc.QPEncoder;
import sunw.hotjava.misc.QPHeaderEncoder;
import sunw.hotjava.misc.VerbatimHeaderEncoder;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextArea;
import sunw.hotjava.ui.UserTextButton;
import sunw.hotjava.ui.UserTextField;

public class MailDocumentApplet
extends HotJavaBeanApplet {
    static final String propName = "maildoc";
    static final String debugProperty = "maildoc.debug";
    static final String errorURLBase = "maildoc-msg-";
    static final String mimePreamble = System.getProperty("maildoc.mime.preamble");
    static final String mimeEpilogue = System.getProperty("maildoc.mime.epilogue");
    static final String boundaryPrefix = System.getProperty("maildoc.mime.boundary.prefix");
    String userMailAddress;
    String toParam;
    String subjectParam;
    TextField fromAddressField;
    TextField toAddressField;
    TextField subjectField;
    TextArea compositionArea;
    UserTextButton sendButton;
    Checkbox htmlToggle;
    UserLabel statusLabel;
    boolean didInsert;
    boolean didSend;

    public void init() {
        this.toParam = this.getParameter("to");
        this.subjectParam = this.getParameter("subject");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        VariableGridLayout variableGridLayout = new VariableGridLayout(1, 2);
        variableGridLayout.setColFraction(0, 0.15);
        variableGridLayout.setColFraction(1, 0.85);
        panel.setLayout((LayoutManager)variableGridLayout);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1));
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 1));
        panel.add(panel3);
        this.header(panel2, "tolabel");
        this.toAddressField = new UserTextField("maildoc.headfield");
        panel3.add(this.toAddressField);
        this.header(panel2, "fromlabel");
        this.fromAddressField = new UserTextField("maildoc.headfield");
        panel3.add(this.fromAddressField);
        this.header(panel2, "subjectlabel");
        this.subjectField = new UserTextField("maildoc.headfield");
        panel3.add(this.subjectField);
        this.header(panel2, "composearea.title");
        panel3.add(new Label(""));
        this.compositionArea = new UserTextArea("maildoc.composearea");
        this.add("Center", this.compositionArea);
        panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        this.add("South", panel);
        Panel panel4 = new Panel();
        panel.add(panel4);
        panel4.setLayout(new FlowLayout());
        this.sendButton = new UserTextButton("maildoc.send");
        panel4.add(this.sendButton);
        panel4.add(new UserTextButton("maildoc.cancel"));
        panel4.add(new Label(" "));
        this.htmlToggle = new Checkbox(Globals.localProps.handleGetString("maildoc.formatted.text"));
        panel4.add(this.htmlToggle);
        this.statusLabel = new UserLabel("maildoc.status");
        panel.add(this.statusLabel);
        this.resetFields();
    }

    void resetFields() {
        this.didSend = false;
        this.didInsert = false;
        this.resetPreferences();
        ((TextComponent)this.toAddressField).setText(this.toParam == null ? "" : this.toParam);
        this.loadSubject();
        this.compositionArea.setText("");
        this.htmlToggle.setState(false);
    }

    public void showStatus(String string) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(string);
        }
        super.showStatus(string);
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    void resetPreferences() {
        this.userMailAddress = this.getParameter("from", this.getMailAddress());
        ((TextComponent)this.fromAddressField).setText(this.userMailAddress);
    }

    public void start() {
        this.resetPreferences();
        this.loadSubject();
        this.prepare();
    }

    protected String getMailAddress() {
        String string = System.getProperty("user.fromaddr");
        if (string == null) {
            string = System.getProperty("user.name");
            if (string != null) {
                String string2 = System.getProperty("mail.host");
                if (string2 == null) {
                    try {
                        string2 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
                string = String.valueOf(string) + "@" + string2;
            } else {
                string = "";
            }
        }
        return string;
    }

    private void loadSubject() {
        if (this.subjectParam == null) {
            ((TextComponent)this.subjectField).setText("");
            return;
        }
        ((TextComponent)this.subjectField).setText(this.subjectParam);
    }

    void header(Container container, String string) {
        container.add(new UserLabel("maildoc." + string));
    }

    void prepare() {
        this.sendButton.setEnabled(this.canSend());
        this.showStatus("");
    }

    boolean canSend() {
        return !this.didSend;
    }

    boolean canInsert() {
        return !this.didInsert;
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            String string = (String)event.arg;
            if (string.endsWith("send")) {
                this.sendMail();
                return true;
            }
            if (string.endsWith("cancel")) {
                this.subjectParam = "";
                this.resetFields();
                this.prepare();
                return true;
            }
        }
        return false;
    }

    public void sendMail() {
        String string = this.toAddressField.getText().trim();
        if (string.length() == 0) {
            this.showStatus(Globals.localProps.handleGetString("mailto.notoaddr.message"));
            return;
        }
        String string2 = this.fromAddressField.getText().trim();
        String string3 = this.subjectField.getText().trim();
        String string4 = CharacterEncoding.getNetworkName(Globals.localProps.handleGetString("hotjava.charset", "8859_1"));
        if (string4 == null) {
            string4 = "iso-8859-1";
        }
        String string5 = Globals.localProps.handleGetString("maildoc.headers.transfer.encoding", "quoted-printable");
        char c = string5.charAt(0);
        string5 = Globals.localProps.handleGetString("maildoc.body.transfer.encoding", "quoted-printable");
        char c2 = string5.charAt(0);
        try {
            SmtpClient smtpClient = new SmtpClient();
            smtpClient.from(string2);
            smtpClient.to(string);
            PrintStream printStream = smtpClient.startMessage();
            if (string2.length() > 0) {
                printStream.println("From: " + string2);
            }
            printStream.println("To: " + string);
            if (string3.length() > 0) {
                if (Boolean.getBoolean("maildoc.headers.encode")) {
                    String string6 = Globals.localProps.handleGetString("hotjava.charset", "8859_1");
                    this.encodeHeader("Subject", string3, string6, c, printStream);
                } else {
                    printStream.println("Subject: " + string3);
                }
            }
            printStream.println("Mime-version: 1.0");
            this.insertSimpleMessage(printStream, this.htmlToggle.getState(), string4, c2);
            smtpClient.closeServer();
            this.didSend = true;
            this.showStatus(Globals.localProps.handleGetString("mailto.success.message"));
            this.subjectParam = "";
            this.resetFields();
            return;
        }
        catch (IOException iOException) {
            this.didSend = false;
            this.showStatus(Globals.localProps.handleGetSubst("mailto.error.message", iOException.toString()));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.didSend = false;
            this.showStatus(Globals.localProps.handleGetSubst("mailto.error.message", exception.toString()));
            return;
        }
    }

    private String getBoundaryString(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
        String string = dateFormat.format(date);
        string = string.replace(' ', '_');
        string = string.replace(':', '_');
        return String.valueOf(boundaryPrefix) + string;
    }

    private void insertSimpleMessage(PrintStream printStream, boolean bl, String string, char c) throws IOException {
        if (bl) {
            printStream.println("Content-type: text/html; charset=" + string);
        } else {
            printStream.println("Content-type: text/plain; charset=" + string);
        }
        this.transferEncodeContent(this.compositionArea.getText(), printStream, c);
    }

    private void transferEncodeContent(String string, PrintStream printStream, char c) throws IOException {
        Object object;
        String string2 = null;
        if (!string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        switch (c) {
            case 'Q': 
            case 'q': {
                string2 = "quoted-printable";
                object = new QPEncoder(false, false);
                break;
            }
            case 'B': 
            case 'b': {
                string2 = "base64";
                object = new BASE64Encoder();
                break;
            }
            case 'N': 
            case 'n': {
                printStream.println();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(printStream);
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.flush();
                return;
            }
            default: {
                Hax.debugln(debugProperty, "Illegal RFC2047 transfer-encoding: " + c);
                string2 = "base64";
                object = new BASE64Encoder();
            }
        }
        if (string2 != null) {
            printStream.println("Content-transfer-encoding: " + string2);
        }
        printStream.println();
        byte[] byArray = string.getBytes(Globals.localProps.handleGetString("hotjava.charset", "8859_1"));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        object.encodeBuffer((InputStream)byteArrayInputStream, (OutputStream)printStream);
        printStream.flush();
    }

    private void encodeHeader(String string, String string2, String string3, char c, PrintStream printStream) throws IOException {
        CharacterEncoder characterEncoder;
        String string4 = CharacterEncoding.getNetworkName(string3);
        if (string4 == null) {
            string4 = "iso-8859-1";
        }
        switch (c) {
            case 'Q': 
            case 'q': {
                characterEncoder = new QPHeaderEncoder(string, string4);
                break;
            }
            case 'B': 
            case 'b': {
                characterEncoder = new Base64HeaderEncoder(string, string4);
                break;
            }
            case 'N': 
            case 'n': {
                characterEncoder = new VerbatimHeaderEncoder(string);
                break;
            }
            default: {
                Hax.debugln(debugProperty, "Illegal RFC2047 transfer-encoding: " + c);
                characterEncoder = new VerbatimHeaderEncoder(string);
            }
        }
        characterEncoder.encodeBuffer(string2.getBytes(string3), (OutputStream)printStream);
    }
}

