/*************************************************************************
 *                                                                       *
 * pandora.h - header file with file structures.                         *
 *************************************************************************/

#ifndef PAN_PANDORA_H
#define PAN_PANDORA_H

#include <stdlib.h>
#include "../pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif


/* error handling function */
#define pan_error_number 122

char *pan_errors[pan_error_number][2] =
{
 {"1","Server In Use,Semaphore Overflow,TTS Available"},
 {"2","DOS File Not Found"},
 {"3","DOS Path Not Found"},
 {"4","DOS Too Many Open Files"},
 {"5","DOS Access Denied"},
 {"6","DOS Invalid File Handle"},
 {"7","DOS Memory Blocks Destroyed"},
 {"8","DOS Insufficient Memory"},
 {"9","DOS Invalid Memory Block Address"},
 {"10","DOS Invalid Environment"},
 {"11","DOS Invalid Format"},
 {"13","DOS Invalid Access Code"},
 {"14","DOS Invalid Data"},
 {"15","DOS Invalid Drive Specified"},
 {"16","DOS Attempt To Delete Current Dir"},
 {"17","DOS Not Same Device"},
 {"18","DOS No More Files"},
 {"32","DOS Sharing Violation"},
 {"33","DOS Lock Violation"},
 {"128","File In User Error"},
 {"129","No More File Handles"},
 {"130","No Open Privileges"},
 {"131","IO Error Network Disk"},
 {"132","No Create Privileges"},
 {"133","No Delete Privileges"},
 {"134","Create File Exists Read Only"},
 {"135","Wild Cards in Create File Name"},
 {"136","Invalid File Handle"},
 {"137","No Search Privileges"},
 {"138","No Delete Privileges"},
 {"139","No Rename Privileges"},
 {"140","No Modify Privileges"},
 {"141","Some Files Affected In Use"},
 {"142","No Files Affected In Use"},
 {"143","Some Files Affected Read Only"},
 {"144","No Files Affected Read Only"},
 {"145","Some Files Renamed - Name Exists"},
 {"146","No Files Renamed - Name Exists"},
 {"147","No Read Privileges"},
 {"148","No Write Privileges or Read Only"},
 {"149","File Detached"},
 {"150","Server Out Of Memory,Out Of Dynamic Workspace"},
 {"151","No Disk Space for Spool File"},
 {"152","Volume Does Not Exist"},
 {"153","Directory Full"},
 {"154","Renaming Across Volumes"},
 {"155","Bad Directory Handle"},
 {"156","Invalid Path,No more Trustees"},
 {"157","No More Directory Handles"},
 {"158","Invalid Filename"},
 {"159","Directory Active"},
 {"160","Directory Not Empty"},
 {"161","Directory IO Error"},
 {"162","Read File With Record Locked"},
 {"163","No Netware shell loaded"},
 {"192","No Account Privileges"},
 {"193","Login Denied,No Account Balance"},
 {"194","Account Credit limit Exceeded,Login Denied,No credit"},
 {"195","Account,Too many Holds"},
 {"197","Intruder Detection, Account is Locked"},
 {"198","Not Console Operator"},
 {"208","Queue Error"},
 {"209","No Queue"},
 {"210","No Queue Server"},
 {"211","No Queue Rights"},
 {"212","Queue Full"},
 {"213","No Queue Job"},
 {"214","No Job Rights"},
 {"215","Password Not Unique,Queue Servicing"},
 {"216","Password Too Short,Queue Not Active"},
 {"217","Login Denied,No connection,Station Not Server"},
 {"218","Unauthorized login time,Queue Halted"},
 {"219","Unauthorized login station,Max Queue Servers"},
 {"220","Account Disabled"},
 {"222","Password has expired - No Grace"},
 {"223","Password has expired"},
 {"232","Not Item Property,Write Property to Group"},
 {"233","Member Already Exists"},
 {"234","No Such Member"},
 {"235","Not Group Property"},
 {"236","No Such Segment"},
 {"237","Property Already Exists"},
 {"238","Object Already Exists"},
 {"239","Invalid Name"},
 {"240","Wild Card Not Allowed"},
 {"241","Invalid Bindery Security"},
 {"242","No Object Read Privilege"},
 {"243","No Object Rename Privilege"},
 {"244","No Object Delete Privilege"},
 {"245","No Object Create Privilege"},
 {"246","No Property Delete Privilege,Not Same Local Drive"},
 {"247","No Property Create Privilege,Target Drive Not Local"},
 {"248","Already or Not Attached To Server,No Property Write Privilege"},
 {"249","No Free Connection Slots,No Property Read Privilege"},
 {"250","No More Server Slots,Temporary Remap Error"},
 {"251","Invalid Parameters,No Such Property,Unknown Request"},
 {"252","Unknown File Server,Message Queue Full,No Such Object"},
 {"253","Bad Station Number,Unknown Request,Field Already Locked,TTS Disabled"},
 {"254","Bind/NDS Locked/Err,Bad Sem Name Len,Login disable,Timeout,Trans err"},
 {"255","Bad Printer/Offset/FCB/Name/Ext/Hrdwre/Drive/Sem/File/Passwd/Req/IO"},
 {"-1","unknown error"},
 {"-100","Password lengh exeed maximum (16 chars for Brute_Force & Dict (128 chars for Hash_Gen))"},
 {"-101","pw_first/pw_last mismatch"},
 {"-102","pw_current/pw_last mismatch"},
 {"-103","pw_first contains unauthorized chars OR pw_first/pwlen mismatch"},
 {"-104","pw_current contains unauthorized chs OR pw_curr./pwlen mismatch"},
 {"-105","Password not found with given words"},
 {"-106","Maximum tries reached"},
 {"-107","Hash is unknown"},
 {"-108","Invalid hash"},
 {"-110","Password is NULL"},
 {"-199","File MUST be named, BACKUP.DS or BACKUP.NDS or DSREPAIR.DIB"},
 {"-200","Error opening .NDS/.DS/.DIB files"},
 {"-201","Out of memory"},
 {"-202","Out of DOS memory"},
 {"-203","NDS needs repair, cross reference encountered"},
 {"-204","Value not found for this object/attribute pair"},
 {"-205","Attribute not defined"},
 {"-206","Unable to open Adapter"},
 {"-300","Error opening file (Pandora/.NDS)"},
 {"-301","File read/write failure OR invalid file"},
 {"-400","Unable to connect to server"}
};

char Pan_Key_Space[PAN_KEYSPACE+1]=
{"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,./<>?;':\"[]{}`~!@#$%^&*()_-+=|"};

char *Pan_error(int number)
{
 int i;

 for(i=0;i<pan_error_number;i++)
  if (atoi(pan_errors[i][0])==number)
   return(pan_errors[i][1]);
 return("Unknown error");
}

/** API level functions **/

/* ok the following alloc/free stuff looks redundant, YES i know about */
/* C prototyping. But really if i wanted to bother with that kind of   */
/* overhead, this would be C++ not C code ;-) */

Pan_PassList Pan_PassList_alloc(void)
{
 return (Pan_PassList)calloc(1,sizeof(struct pan_passlist));
}

Pan_NDSBrowse Pan_NDSBrowse_alloc(void)
{
 return (Pan_NDSBrowse)calloc(1,sizeof(struct pan_ndsbrowse));
}

Pan_Connections Pan_Connections_alloc(void)
{
 return (Pan_Connections)calloc(1,sizeof(struct pan_connections));
}

void Pan_PassList_free(Pan_PassList pPassList)
{
 Pan_PassList p,q;
 for (p=pPassList;p!=NULL;p=q)
  {q=(p->next);
   free(p);
  }
}

void Pan_NDSBrowse_free(Pan_NDSBrowse pNDSBrowse)
{
 Pan_NDSBrowse p,q;
 for (p=pNDSBrowse;p!=NULL;p=q)
  {q=(p->next);
   free(p);
  }
}

void Pan_Connections_free(Pan_Connections pConnections)
{
 Pan_Connections p,q;
 for (p=pConnections;p!=NULL;p=q)
  {q=(p->next);
   free(p);
  }
}

void Pan_PassList_to_PassHack(Pan_PassList pPassList,Pan_PassHack *pPassHack)
{ int i;

  pPassHack->bind=pPassList->bind;
  pPassHack->id=pPassList->id;
  pPassHack->parentID=pPassList->parentID;
  pPassHack->objectID=pPassList->objectID;
  pPassHack->pwlen=pPassList->pwlen;
  for(i=0;i<16;i++) pPassHack->hash[i]=pPassList->hash[i];
  for(i=0;i<40;i++) pPassHack->userOU[i]=pPassList->userOU[i];
  for(i=0;i<258;i++) pPassHack->userCN[i]=pPassList->userCN[i];
}

void PassHack_in_Pan_PassList(Pan_PassHack *pPassHack,Pan_PassList pPassList)
{ int i;

  pPassList->bind=pPassHack->bind;
  pPassList->id=pPassHack->id;
  pPassList->parentID=pPassHack->parentID;
  pPassList->objectID=pPassHack->objectID;
  pPassList->pwlen=pPassHack->pwlen;
  for(i=0;i<16;i++) pPassList->hash[i]=pPassHack->hash[i];
  for(i=0;i<40;i++) pPassList->userOU[i]=pPassHack->userOU[i];
  for(i=0;i<258;i++) pPassList->userCN[i]=pPassHack->userCN[i];
  pPassList->pwlen_known=TRUE;
  pPassList->pwhash_known=TRUE;
}

void PassHack_to_PassHack(Pan_PassHack *aPassHack,Pan_PassHack *bPassHack)
{
 int i;

 aPassHack->bind=bPassHack->bind;
 aPassHack->id=bPassHack->id;
 aPassHack->parentID=bPassHack->parentID;
 aPassHack->objectID=bPassHack->objectID;
 aPassHack->pwlen=bPassHack->pwlen;
 for(i=0;i<16;i++) aPassHack->hash[i]=bPassHack->hash[i];
 for(i=0;i<40;i++) aPassHack->userOU[i]=bPassHack->userOU[i];
 for(i=0;i<258;i++) aPassHack->userCN[i]=bPassHack->userCN[i];
 for(i=0;i<68;i++) aPassHack->key_space[i]=bPassHack->key_space[i];
 for(i=0;i<aPassHack->pwlen+1;i++) aPassHack->pw_first[i]=bPassHack->pw_first[i];
 for(i=0;i<aPassHack->pwlen+1;i++) aPassHack->pw_current[i]=bPassHack->pw_current[i];
 for(i=0;i<aPassHack->pwlen+1;i++) aPassHack->pw_last[i]=bPassHack->pw_last[i];
}

#ifdef __cplusplus
}
#endif

#endif /* PAN_PANDORA_H */
