#ifndef PAN_GUI_H

 #define PAN_GUI_H

 #include <stdio.h>       /* standard stuff */
 #include <string.h>
 #include <stdlib.h>
 #include <time.h>          /* for timming routines */
 #include "include/mgui.h"  /* Graphical User Interface API */
                            /* defines UNIX if detected */
#if !defined UNIX
 #include <sys/builtin.h> /* for simple semaphore stuff for WIN */
 #include <sys/smutex.h>  /* for simple semaphore stuff for WIN */
#else
 #include <pthread.h>     /* semaphore & threading for Unix */
 #define _smutex_release(a) pthread_mutex_unlock(a)
 #define _smutex_available(a) pthread_mutex_trylock(a)!=EBUSY
 #define _smutex_request(a)
#endif

 #include "../pandora/pan_file.h" /* Pandora API */
 #include "../pandora/pan_hash.h" /* Pandora API */

 #include "off_func.h" /* Offline password attack functions prototypes */
/*
 * Global Variables, declared in the Main Shell
 */

/* Main Form variables */
extern MOBJECT main_shell; /* the main shell */
extern MOBJECT form0;      /* password shell form */
extern MOBJECT form1;      /* result shell form */
extern MOBJECT edit_00;    /* selected target edit field */

 /* Menu forms */
extern MOBJECT slist;          /* list in the password shell form */
extern MOBJECT rlist;          /* list in the result shell form */
extern MOBJECT mouse_menu;
#if !defined UNIX
 extern _smutex attacking;        /* Crack action */
#else
 extern pthread_mutex_t attacking;
#endif

 /* default colors */
extern MTColor black, white, darkblue, cadetblue, seagreen;
extern MTColor vmbg, green, red, orange, yellow;
extern MTColor darkvmbg, darkorange, darkred, darkgreen;
extern long    NColors;

 /* Pandora file variables */
extern Pan_PassList  pPassList; /* Memory dump of the password list */
extern Pan_PassList  *Index; /* Index of the above list for sorting facility */
extern Pan_PassHack  pPassHack; /* Current password record being hacked */
extern Pan_NDSBrowse pNDSBrowse;
extern Pan_NDSBrowse *Index2;
extern long int nIndex; /* Number of items in the list */

extern struct
  {
   uint32 try_before_save;
   short dict_attack_type; /* 1 is selected object, 2 range of objects */
   short speed; /*TRUE for fast display, FALSE for detailed display (slow)*/
   char key_space[PAN_KEYSPACE+1]; /* self defined key space */
   char ini_path[MAXPATHLEN];
   char save_path[MAXPATHLEN];
   char save_file[MAXPATHLEN+MAXFNAMELEN];
  }preference;

typedef struct hackit
{
 uint32 tries; /* copied from try_before_save */
 char save_file[MAXPATHLEN+MAXFNAMELEN];
 Pan_PassHack pPassHack; /* copied from selected pPasshack */
 char str[512]; /* used form MGUI output */
 long pos; /* soft process abort */
 /* later use for clusterfuk : computer_ID, computer_Status */
}HackIt;

#endif /* PAN_GUI_H */
