#ifndef PAN_HASH_LIB
#define PAN_HASH_LIB

#include "hash_med.h"

#ifdef __cplusplus
extern "C" {
#endif

/** API level functions **/

int Pan_Brute_Force(Pan_PassHack *pPassHack, int maxtry,
                    char **retpw, uint32 limit)
{
 int i,j,first,TEST=FALSE;

 if (pPassHack->pwlen>16) return(-100); /* Can't brute force pass >16char */
 if (pPassHack->pwlen==0) {*retpw=NULL; return(0);} /* If NULL no passwd ! */

 /** Test No_1 : if pw_last is no set do set it for full loop **/
 if (pPassHack->pw_last==NULL) pPassHack->pw_last=pPassHack->pw_first[0];

 /** Test No_2 : is the first word before the last authorized word ? **/
 TEST=FALSE;
 for (i=0; i<maxtry+1; i++)
  if (pPassHack->pw_first[0]==key_space[i])
   {for (j=i; j<maxtry+1; j++)
     if (pPassHack->pw_last==key_space[j]) TEST=TRUE;
    break;
   }
 if (TEST==FALSE) return(-101);
 first=i;

 /** Test No_3 : is the current word set ? if not set it equal to first **/
 if (pPassHack->pw_current[0]==NULL)
  for (i=0;i<pPassHack->pwlen;i++)
   pPassHack->pw_current[i]=pPassHack->pw_first[i];

 /** Test No_4 : is the current word in a valid range ? **/
 TEST=FALSE;
 for (i=0; i<maxtry+1; i++)
  if (pPassHack->pw_last==key_space[i])
   {for (j=first; j<i+1; j++)
     if (pPassHack->pw_last==key_space[j]) TEST=TRUE;
    break;
   }
 if (TEST==FALSE) return(-102);

 /** Test No_5 : is the first word in the limit defined ? **/
 for (i=0;i<pPassHack->pwlen;i++)
  {
   TEST=FALSE;
   for (j=0;j<maxtry+1;j++)
    if (pPassHack->pw_first[i]==key_space[j]) TEST=TRUE;
   if (TEST==FALSE) return(-103);
  }
    
 /** Test No_6 : is the current word in the limit defined ? **/
 for (i=0;i<pPassHack->pwlen;i++)
  {
   TEST=FALSE;
   for (j=0;j<maxtry+1;j++)
    if (pPassHack->pw_current[i]==key_space[j]) TEST=TRUE;
   if (TEST==FALSE) return(-104);
  }

 return(Brute_Force(pPassHack,maxtry,retpw,limit));
}

int Pan_Hash_Gen(Pan_PassHack *pPassHack)
{
 if (pPassHack->pwlen>128) return(-100); /* Netware max passwd lengh=128 */
 if (strlen(pPassHack->pw_first)!=pPassHack->pwlen) return(-103);
 hash_gen(pPassHack->objectID,pPassHack->pw_first,
          pPassHack->pwlen,pPassHack->hash);
 return(NULL);
}

int Pan_Challenge_Response
 (Pan_PassHack *Info,int hash_known,uint8 *logkey, uint8 *dst)
{
 return(getpassk(Info,hash_known,logkey,dst));
}

int Pan_Dict_Attack(Pan_PassHack *pPassHack,char **retpw,char *readfile)
{
 if (pPassHack->pwlen>16) return(-100);
 return(Dict_Attack(pPassHack,retpw,readfile));
}

int Pan_3hash_cipher(uint8 *oldcrpw,uint8 *newcrpw,uint8 *cipherpw)
{
 return(three_hash_cipher(oldcrpw,newcrpw,cipherpw));
}

/** End of API Level function **/

#ifdef __cplusplus
}
#endif

#endif /* PAN_HASH_LIB */
