/*************************************************************************
 *                                                                       *
 * Project Pandora Password Hash and Hack Functions                      *
 *************************************************************************/

#ifndef PAN_FILE_H
#define PAN_FILE_H

#include "pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/** API functions **/

 /* Read/Write the NDS related information */

  /*Usage : err=Pan_Convert("f:\system\")*/
   /* convert Backup.DS */
   /* return an error if a problem occured, NDS files in specified dir */
 int Pan_Convert_DS(char *path);

  /*Usage : err=Pan_Extract(&pPassList,"f:\nds\")*/
   /* return an error if a problem occured, NDS files in current dir */
   /* chained records in pPassList,last record if : last->next=NULL */
 int Pan_Extract_NDS(Pan_PassList *pPassList, char *path);

  /*Usage : err=Pan_Extract(&pPassList,"f:\nds\")*/
   /* return an error if a problem occured, NDS files in current dir */
   /* chained records in pPassList,last record if : last->next=NULL */
 int Pan_Extract_Bindery(Pan_PassList *pPassList, char *path);

  /*Usage : err=Pan_PassList_read("PASSNAME.NDS",&pPassList)*/
   /* return an error if a problem occured */
   /* chained list of records in pPassList */
 int Pan_PassList_read(char *readfile,Pan_PassList *pPassList);

  /*Usage : err=Pan_PassList_write("PASSNAME.NDS",pPassList)*/
   /* return an error if a problem occured */
   /* The last Password record in the list MUST have last->next=NULL */
 int Pan_PassList_write(char *writefile,Pan_PassList pPassList);

  /*Usage : err=Pan_PassHack_read("WHATEVER.EXT",&pPassHack)*/
   /* return an error if a problem occured */
 int Pan_PassHack_read(char *readfile,Pan_PassHack *pPassHack);

  /*Usage : err=Pan_PassHack_write("WHATEVER.EXT",&pPassHack)*/
   /* return an error if a problem occured */
 int Pan_PassHack_write(char *writefile,Pan_PassHack *pPassHack);

#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_H */
