/*
 * gemlib bindings   library visible commons only
 *
 *	++jrb	bammi@cadence.com
 *
 *	modified:  mj --  ntomczak@vm.ucs.ualberta.ca
 */
#ifndef _COMMON_H
#define _COMMON_H

/* Array sizes in vdi control block */

#define CNTRLMAX    12   /* It seems that 11 is enough - max reached
			   for vex_* functions */
#define INTINMAX   255	/* This library will allow strings up to this
			   size in v_gtext and vr[qm]_string */
#define INTOUTMAX   45	/* A limit for number of elements in _intout
			   for usual functions - reached for v_opnwk */
#define PTSINMAX  1024	/* Max number of points in _ptsin - 2 shorts
			   for a point.  Value raised to accomodate
			   TT and fsmgdos printer drivers */
#define PTSOUTMAX    6	/* Max number of points in _ptsout - 2 shorts
			   for a point.  Max reached in v_opnwk	*/

/* Size for _global in aes control block - most other stuff overlapped
   with arrays for vdi - sizes needed for _control, _int_in, _int_out,
   respectively are 5, 16 and 7 shorts and 2 and 1 longs for
   _addrin and addrout */

#define GLOBMAX     15

#define _control	(&_contrl[0])
#define _int_in		(&_intin[0])
#define _int_out	((int *)(&_intout[0]))
#define _addrin		((void **)(&_ptsin[0]))
#define _addrout	((void **)(&_ptsout[0]))


/* code up _control[] elements for __aes__() calls
 * (evaluated at compile time,  no runtime overhead)
 * see common.c for encoding semantics.
 */
#define AES_CONTROL_ENCODE(A, B, C, D) (unsigned long)  \
    		( 				    \
       		     (((unsigned long)A) << 24) |   \
       		     (((unsigned long)B) << 16) |   \
       		     (((unsigned long)C) <<  8) |   \
       		     (((unsigned long)D)      )     \
		)

/*
 * code up _contrl[] elements for __vdi__() calls
 * (note with gcc hardly any runtime overhead, most of the uses
 *  end up getting evaluated at compile time)
 * see common.c for encoding semantics.
 */
/*
 * WARNING!! - this coding will accomodate vdi calls with
 *   opcodes      (A) in range 0 - 255
 *   _ptsin size  (B) up to 2047 = 0x7ff nodes (up to 1024 currently used)
 *   _intin size  (C) up to 255  = 0xff  shorts
 *   and subcodes (D) in range 0 - 31
 * Any function for which parameters "stick out" has to be coded
 * without using this macro.  Failure to comply may cause very
 * funny results.
 */
#define VDI_CONTRL_ENCODE(A, B, C, D) (unsigned long)	    \
    		( 				    \
       		     (((unsigned long)D) << 27) |   \
       		     (((unsigned long)B) << 16) |   \
       		     (((unsigned long)C) <<  8) |   \
       		     (((unsigned long)A)      )     \
		)


/* binding arrays */
/* takes care of ptsin containing upto PTSINMAX vertices
 * (tt and fsmgdos require this value to be not smaller than 1024)
 */
#ifndef __IN_COMMON_C__
extern short 		_intin[INTINMAX], _intout[INTOUTMAX];
extern short		_ptsin[2 * PTSINMAX], _ptsout[2 * PTSOUTMAX];
extern unsigned short	_contrl[CNTRLMAX], _global[GLOBMAX];
extern int		gl_apid, gl_ap_version;
extern void		*_vdiparams[];
#endif

/* aes trap interface func */
int __aes__(unsigned long coded_control);

/* vdi trap interface func */
void __vdi__(unsigned long coded_contrl, int handle);
void vdi(void);

#endif /* _COMMON_H */
