/*
 *	Aes menu library interface
 *
 *	    menu_bar      Show/Hide menu bar
 *	    menu_icheck   Check/Uncheck a menu item
 *	    menu_ienable  Enable/Disable a menu item
 *	    menu_tnormal  Display a menu item in normal/rev video
 *	    menu_text     Change the text of a menu item
 *	    menu_register Put desk accessory menu item in Desk menu
 *     menu_popup    Display a popup menu
 *     menu_attach   Attach, change, remove or inq about a submenu
 *     menu_istart   Set / inq about starting menu item of a submenu
 *     menu_settings Set / inq submenu delay/scroll values
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */

#include <gemfast.h> /* for MENU, OBJECT etc */

#include "common.h"

#ifdef __DEF_ALL__

#define L_menu_bar
#define L_menu_ich
#define L_menu_ien
#define L_menu_tno
#define L_menu_tex
#define L_menu_reg
#define L_menu_pop
#define L_menu_att
#define L_menu_ist
#define L_menu_set

#endif /* __DEF_ALL__ */


#ifdef L_menu_bar

/* Show/hide a menu bar
 *	returns 0 on error	>0 no error
 */
int menu_bar(void *Tree, int ShowFlag)
{
    _int_in[0] = ShowFlag;
    _addrin[0] = Tree;
    
    return __aes__(AES_CONTROL_ENCODE(30, 1, 1, 1));
}
#endif /* L_menu_bar */


#ifdef L_menu_ich

/* Check/Uncheck a menu item
 *	returns 0 on error	>0 no error
 */
int menu_icheck(void *Tree, int Item, int CheckFlag)
{
    _addrin[0] = Tree;
    _int_in[0] = Item;
    _int_in[1] = CheckFlag;
    
    return __aes__(AES_CONTROL_ENCODE(31, 2, 1, 1));
}
#endif /* L_menu_ich */

#ifdef L_menu_ien

/* Enable/Disable a menu item
 *	returns 0 on error	>0 no error
 */
int menu_ienable(void *Tree, int Item, int EnableFlag)
{
    _addrin[0] = Tree;
    _int_in[0] = Item;
    _int_in[1] = EnableFlag;

    return __aes__(AES_CONTROL_ENCODE(32, 2, 1, 1));
}
#endif /* L_menu_ien */

#ifdef L_menu_tno

/* Show menu item in Norm/Rev video
 *	returns 0 on error	>0 no error
 */
int menu_tnormal(void *Tree, int Item, int NormalFlag)
{
    _addrin[0] = Tree;
    _int_in[0] = Item;
    _int_in[1] = NormalFlag;

    return __aes__(AES_CONTROL_ENCODE(33, 2, 1, 1));
}
#endif /* L_menu_tno */

#ifdef L_menu_tex

/* Change the text of a menu item
 *	returns 0 on error	>0 no error
 */
int menu_text(void *Tree, int Item, char *Text)
{
    _addrin[0] = Tree;
    _addrin[1] = Text;
    _int_in[0]  = Item;
    
    return __aes__(AES_CONTROL_ENCODE(34, 1, 1, 2));
}
#endif /* L_menu_tex */

#ifdef L_menu_reg

/* Register an accessory with the Desk Menu
 *	returns menuid	-1 == no more room in desk menu
 */
int menu_register(int ApId, char *MenuText)
{
    _int_in[0] = ApId;
    _addrin[0] = MenuText;
    
    return __aes__(AES_CONTROL_ENCODE(35, 1, 1, 1));
}
#endif /* L_menu_reg */


#ifdef L_menu_pop

/* Allows an application to display a popup menu anywhere on the screen.  The
 * popup menu may also have submenus.  If the number of menu items exceed the
 * menu scroll height, the menu may also be set to scroll.  menu_settings can
 * be used to set the height at which all menus will start to scroll.
 *
 * returns 0 on failure, and data in me_data is invalid
 * returns 1 on success, data in me_data is valid
 */
int menu_popup(MENU_T *me_menu, int me_xpos, int me_ypos, MENU_T *me_mdata)
{
    _int_in[0]   =  me_xpos;
    _int_in[1]   =  me_ypos;

    _addrin[0]  =  me_menu;
    _addrin[1]  =  me_mdata;
    
    return __aes__(AES_CONTROL_ENCODE(36, 2, 1, 2));
}
#endif /* L_menu_pop */

#ifdef L_menu_att

/* Allows an application to attach, change, remove or inquire about a submenu
 * associated with a menu item.
 *
 * returns:0 failure: the submenu was not attached for whatever reasons
 *         1 success: the submenu was attached, changed or removed successfully
 */
int menu_attach(int me_flag, OBJECT *me_tree, int me_item, MENU_T *me_mdata)
{
    _int_in[0] = me_flag;
    _int_in[1] = me_item;

    _addrin[0] = me_tree;
    _addrin[1] = me_mdata;
    return __aes__(AES_CONTROL_ENCODE(37, 2, 1, 2));
}
#endif /*  L_menu_att */

#ifdef L_menu_ist

/* Allows an application to set or inquire the starting menu item of a submenu
 * that is associated with a menu item.  The submenu is shifted vertically so
 * that the starting menu item is aligned with the menu item that is associated
 * with this submenu.  
 *
 * returns: 0 failure: the submenu is not associated with a menu item.  The
 *                     submenu must be attached via menu_attach before this
 *                     call can be made. 
 *         >0 success: the starting menu item is currently set to this value.
 */
int menu_istart(int me_flag, OBJECT *me_tree, int me_imenu, int me_item)
{
    _int_in[0] = me_flag;
    _int_in[1] = me_imenu;
    _int_in[2] = me_item;

    _addrin[0] =  me_tree;

    return __aes__(AES_CONTROL_ENCODE(38, 3, 1, 1));
}
#endif /* L_menu_ist */

#ifdef L_menu_set

/* Allows an application to set or inquire the submenu delay values and the
 * menu scroll height value. 
 *
 * returns 1 always
 */
int menu_settings(int me_flag, MN_SET *me_values)
{
    _int_in[0] = me_flag;
    
    _addrin[0] = me_values;
    return __aes__(AES_CONTROL_ENCODE(39, 1, 1, 1));
}    
#endif /* L_menu_set */

/* - eof - */
