/*
 *	Aes graphics library interface
 *
 *	    graf_rubberbox  Draw a rubber box
 *	    graf_dragbox    Drag a box within a boundary
 *	    graf_movebox    Move a box
 *	    graf_growbox    Draw an expanding box outline
 *	    graf_shrinkbox  Draw a shrinking box outline
 *	    graf_watchbox   Track mouse in/out of a box
 *	    graf_slidebox   Track sliding box in a parent box
 *	    graf_handle     Get VDI handle
 *	    graf_mouse      Change Mouse Form
 *	    graf_mkstate    Get mouse and keyboard state
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_graf_rub
#define L_graf_dra
#define L_graf_mov
#define L_graf_gro
#define L_graf_shr
#define L_graf_wat
#define L_graf_sli
#define L_graf_han
#define L_graf_mou
#define L_graf_mks

#endif /* __DEF_ALL__ */


#ifdef L_graf_rub

/* Draw a rubber box
 *  input initial position and size of the rubber-box [Ix,Iy, Iw,Ih].
 * output Final Size (Fw,Fh).
 * control returns when left mouse button is released.
 *
 *	return == 0 error	>0 no error
 */
int graf_rubberbox(int Ix,  int Iy, int Iw, int Ih,
		   int *Fw, int *Fh)
{
    int retval;
    
    _int_in[0] = Ix;
    _int_in[1] = Iy;
    _int_in[2] = Iw;
    _int_in[3] = Ih;
    
    retval = __aes__(AES_CONTROL_ENCODE(70, 4, 3, 0));
    
    *Fw = _int_out[1];
    *Fh = _int_out[2];
    
    return retval;
}
#endif /* L_graf_rub */


#ifdef L_graf_dra

/* Drag a box in boundary
 * 	Sw = Width of box being dragged
 * 	Sh = Height of box being dragged
 * 	Sx = Starting X pos of box being dragged
 * 	Sy = Starting Y pos of box being dragged
 * 	Bx = X position of boundary
 * 	By = Y position of boundary
 * 	Bw = Width of bounday
 * 	Bh = Height of boundary
 * 	Fw = Final X position of box in boundary
 * 	Fh = Final Y position of box in boundary
 * 	control returns on mouse button release
 *
 *	return == 0 error	>0 no error
 */
int graf_dragbox(int Sw, int Sh, int Sx, int Sy,	/* inputs  */
		 int Bx, int By, int Bw, int Bh,
		 int *Fw, int *Fh) 			/* outputs */
{
    int retval;
    
    _int_in[0] = Sw;
    _int_in[1] = Sh;
    _int_in[2] = Sx;
    _int_in[3] = Sy;
    _int_in[4] = Bx;
    _int_in[5] = By;
    _int_in[6] = Bw;
    _int_in[7] = Bh;
    
    retval = __aes__(AES_CONTROL_ENCODE(71, 8, 3, 0));

    *Fw = _int_out[1];
    *Fh = _int_out[2];

    return retval;
}
#endif /* L_graf_dra */


#ifdef L_graf_mov

/* Move a box
 *	from Sx,Sy to Dx,Dy
 * 	Sw = Width of Box
 * 	Sh = Height of Box
 *
 *	return == 0 error	>0 no error
 */
int graf_movebox(int Sw, int Sh, int Sx, int Sy, int Dx, int Dy)
{
    _int_in[0] = Sw;
    _int_in[1] = Sh;
    _int_in[2] = Sx;
    _int_in[3] = Sy;
    _int_in[4] = Dx;
    _int_in[5] = Dy;

    return __aes__(AES_CONTROL_ENCODE(72, 6, 1, 0));
}
#endif /* L_graf_mov */


#ifdef L_graf_gro

/* Draw an expanding outline
 * 	Sx = Start X
 * 	Sy = Start Y
 * 	Sw = Start Width
 * 	Sh = Start Height
 * 	Fx = Final X
 * 	Fy = Final Y
 *	Fw = Final Width
 * 	Fh = Final Height
 *
 *	return == 0 error	>0 no error
 */
int graf_growbox(int Sx, int Sy, int Sw, int Sh,
		 int Fx, int Fy, int Fw, int Fh)
{
    _int_in[0] = Sx;
    _int_in[1] = Sy;
    _int_in[2] = Sw;
    _int_in[3] = Sh;

    _int_in[4] = Fx;
    _int_in[5] = Fy;
    _int_in[6] = Fw;
    _int_in[7] = Fh;
    
    return __aes__(AES_CONTROL_ENCODE(73, 8, 1, 0));
}
#endif /* L_graf_gro */


#ifdef L_graf_shr

/* Draw a shrinking outline
 * 	Fx = Final X
 * 	Fy = Final Y
 * 	Fw = Final Width
 * 	Fh = Final Height
 * 	Sx = Start X
 * 	Sy = Start Y
 * 	Sw = Start Width
 * 	Sh = Start Height
 *
 *	return == 0 error	>0 no error
 */
int graf_shrinkbox(int Fx, int Fy, int Fw, int Fh,
		   int Sx, int Sy, int Sw, int Sh)
{
    _int_in[0] = Fx;
    _int_in[1] = Fy;
    _int_in[2] = Fw;
    _int_in[3] = Fh;

    _int_in[4] = Sx;
    _int_in[5] = Sy;
    _int_in[6] = Sw;
    _int_in[7] = Sh;

    return __aes__(AES_CONTROL_ENCODE(74, 8, 1, 0));
}
#endif /* L_graf_shr */


#ifdef L_graf_wat

/* Track mouse
 *	Tree = Addr of object tree containing the box
 * 	Object = Index of Object in tree
 * 	InState = Box state when mouse is inside
 * 	OutState = Box state when mouse is outside
 *
 * 	Returns on mouse button release
 * 	Return = 0 if release outside box
 *	Return = 1 if release inside box.
 *
 * Values for state: (combinations possible)
 *	 0	Normal
 *	 1	Selected
 *	 2	Crossed
 *	 4	Checked
 *	 8	Disabled
 *	16	Outlined
 *	32	Shadowed
 *
 */
int graf_watchbox(void *Tree,
		  int Object, int InState, int OutState)
{
    _addrin[0] = Tree;
    _int_in[0]  = 0;		/* reserved */
    _int_in[1]  = Object;	
    _int_in[2]  = InState;
    _int_in[3]  = OutState;

    return __aes__(AES_CONTROL_ENCODE(75, 4, 1, 1));
}
#endif /* L_graf_wat */


#ifdef L_graf_sli

/* Track slider in box
 * 	Tree = Addr of tree containing Box & Slider
 * 	Parent = Index of Parent Box
 * 	Object = Index of Slider
 * 	Direction = Direction of Slider 0 = Horz, 1=Vert
 *
 * 	Return = Final position of slider [0,1000].
 */
int graf_slidebox(void *Tree,
		  int Parent, int Object, int Direction)
{
    _addrin[0] = Tree;
    _int_in[0]  = Parent;
    _int_in[1]  = Object;
    _int_in[2]  = Direction;

    return __aes__(AES_CONTROL_ENCODE(76, 3, 1, 1));
}
#endif /* L_graf_sli */

#ifdef L_graf_han

/* get VDI handle for workstation
 * Wchar,Hchar	size of system font char cell
 * Wbox, Hbox   size of box to contain char
 *
 * returns VDI handle
 */
int graf_handle(int *Wchar, int *Hchar, int *Wbox, int *Hbox)
{
    int handle = __aes__(AES_CONTROL_ENCODE(77, 0, 5, 0));

    *Wchar = _int_out[1];
    *Hchar = _int_out[2];
    *Wbox  = _int_out[3];
    *Hbox  = _int_out[4];
    
    return handle;
}
#endif /* L_graf_han */


#ifdef L_graf_mou

/*
 * Mouse Forms
 *	0	arrow
 *	1	text cursor (vert bar)
 *	2	Hour Glass
 *	3	Pointed finger
 *	4	Flat Hand
 *	5	Thin crosshair
 *	6	Thick crosshair
 *	7	outline crosshair
 *	255	Mouse form in FormAddress
 *	256	Hide Mouse
 *	257	Show Mouse
 *
 *	return ==0 error	>0 no error
 */
int graf_mouse(int Form, void *FormAddress)
{
    _int_in[0]  = Form;
    _addrin[0] = FormAddress;
    
    return __aes__(AES_CONTROL_ENCODE(78, 1, 1, 1));
}
#endif /* L_graf_mou */

#ifdef L_graf_mks

/* Get mouse/kbd info
 *	Mx		Current X pos of mouse
 *	My		Current Y pos of mouse
 *	ButtonState 	State of mouse buttons lsb==leftmost button & so on...
 *	KeyState	State of kbd Shift and Alt keys
 *				 1- right shift  2-left shift
 *				 4- Ctrl         8-Alt
 *				 Bit = 0 key up  = 1 key down
 *
 *	returns a reserved value
 */
int graf_mkstate(int *Mx, int *My, int *ButtonState, int *KeyState)
{
    int retval;
    
    retval = __aes__(AES_CONTROL_ENCODE(79, 0, 5, 0));
    
    *Mx		 = _int_out[1];
    *My		 = _int_out[2];
    *ButtonState = _int_out[3];
    *KeyState    = _int_out[4];
    
    return retval;
}
#endif /* L_graf_mks */

/* - eof - */	
