 MODULE Real;
 (*$E MOS *)
 IMPORT GEMDOSIO;
 FROM InOut      IMPORT  WriteLn,        WriteReal,      ReadReal,
8WriteString,    Read,           WriteLHex,
8WriteLNum,      WritePg,        WriteCard,
8WriteInt;
8
 FROM GrafBase   IMPORT  Pnt, Point;
 
 FROM LineA      IMPORT  PutPixel;
 
 FROM ErrBase    IMPORT  RaiseError,     ErrResp,        RtnCond;
 
 FROM MOSGlobals IMPORT  DivByZero,      OutOfRange,     Overflow,
8StringOverflow;
 
 FROM Convert    IMPORT  GetProc,        GetInfo,        ConvInt;
 
 FROM MOSConfig  IMPORT  RadixChar;
 
 FROM Strings    IMPORT  Length;
 
 FROM Convert IMPORT ConvToReal, ConvFloat, ConvFix, ConvEng;
 FROM MathLib0 IMPORT sin, cos, tan, sqrt, fraction, rad, exp, pwrOfTen,
(entier,real,pwrOfTwo, ln, ld, log, power, logar;
 
 TYPE
 
"calcProc      =       PROCEDURE(LONGREAL) : LONGREAL;
"
 
 VAR
 
"c1, c2        :       LONGCARD;
"i1, i2        :       LONGINT;
"r, s          :       LONGREAL;
"c             :       CARDINAL;
"i             :       INTEGER;
"ch            :       CHAR;
"StartTime,
"EndTime       :       LONGCARD;
"prec          :       CARDINAL;
"mpos, epos    :       BOOLEAN;
"exponent      :       INTEGER;
"st            :       ARRAY[0..79] OF CHAR;
"stind         :       CARDINAL;
"info          :       GetInfo;
"valid         :       BOOLEAN;
"
 
 PROCEDURE TestPlot(xR, yR : LONGREAL; yaxis : LONGINT; calc : calcProc);
 
"VAR
"
$i, yk  : LONGINT;
$
"BEGIN
$WritePg;
$FOR i := 0 TO 639 DO
&PutPixel(Pnt(SHORT(i), 200), 1);
$END;
$IF (yaxis >= 0L) AND (yaxis <= 639L) THEN
&FOR i := 0 TO 399 DO
(PutPixel(Pnt(SHORT(yaxis), SHORT(i)), 1);
&END
$END;
$FOR i := 0 TO 639 DO
&yk := 200L + entier(yR * calc(real(i - yaxis) / xR));
&IF (yk >= 0L) AND (yk <= 639L) THEN
(PutPixel(Pnt(SHORT(i), SHORT(yk)), 1)
&END
$END;
$Read(ch);
"END TestPlot;
 
 
 PROCEDURE get(VAR Info : GetInfo);
"BEGIN
$IF stind >= Length(st) THEN
&Info.ch := 0C
$ELSE
&Info.ch := st[stind];
&INC(stind)
$END
"END get;
 
 
 BEGIN
"TestPlot(80.0, -80.0, 320L, sin);
"TestPlot(80.0, -80.0, 320L, cos);
"TestPlot(80.0, -80.0, 320L, tan);
"TestPlot(80.0, -80.0,   0L, sqrt);
"TestPlot(80.0, -80.0, 320L, fraction);
"TestPlot( 1.0, -20.0, 320L, rad);
"TestPlot(80.0, -80.0, 320L, exp);
"TestPlot(80.0, -80.0, 320L, pwrOfTen);
"TestPlot(80.0, -80.0, 320L, pwrOfTwo);
"TestPlot(80.0, -80.0,  -1L, ln);
"TestPlot(80.0, -80.0,  -1L, log);
"TestPlot(80.0, -80.0,  -1L, ld);
"WriteReal(power(3.0, 3.0), 24, 17);
"WriteLn;
"WriteReal(3.0 * 3.0 / 7.0, 24, 17);
"WriteLn;
"WriteReal(ln(3.0), 24, 17);
"WriteLn;
"WriteString('Overflow RMUL');
"WriteLn;
"r := 2.0;
"s := 1.0;
"FOR i := 1 TO 5000 DO
$s := s * r
"END;
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Divide by 0 RDIV');
"WriteLn;
"s := 10.0;
"s := s / 0.0;
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow RDIV');
"WriteLn;
"s := 15.0E+307;
"s := s / 0.00001;
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow RADD');
"WriteLn;
"r := 15.0E+307;
"s := r + r;
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow RSUB');
"WriteLn;
"r := 15.0E+307;
"s := - 1.0 * r;
"s := r - s;
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Out of range ln');
"WriteLn;
"s := ln(-1.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Out of range log');
"WriteLn;
"s := log(-1.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Out of range ld');
"WriteLn;
"s := ld(-1.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow exp');
"WriteLn;
"s := exp(1000.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow pwrOfTen');
"WriteLn;
"s := pwrOfTen(1000.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('Overflow pwrOfTwo');
"WriteLn;
"s := pwrOfTwo(5000.0);
"WriteReal(s, 24, 17);
"WriteLn;
"WriteString('----------------------------');
"WriteLn;
"st := '-123.0412E-5';
"WriteString(st);
"stind := 0;
"r := ConvToReal(get, info, valid);
"IF ~valid THEN
$WriteString('not valid')
"ELSE
$ConvFloat(r, 22, 15, st);
$WriteString(st);
$WriteLn;
$ConvFix(r, 0, 15, st);
$WriteString(st)
"END;
"WriteLn;
"Read(ch)
 END Real.
  
(* $FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$00000AC3$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$FFF75CB2$00000812T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000812$FFEDB240$00000812$FFEDB240$00000F53$00001000$00000F7E$00000791$000006C4$00000F6B$000002F6$0000002F$000002F6$0000002F$00000812$000009D0*)
