 MODULE MultiTask; (*$E MOS *)
 (*$R-*)
 
 (*
 >>> Das Ganze geht aus einem Grunde nicht:
"Wenn z.b. der Timer-IR auftritt, whrend gerade der VBL-IR luft,
"wrde durch den IOTRANSFER der VBL unterbrochen werden. Das darf
"aber nicht sein, stattdessen mte erst der VBL beendet und erst
"dann der timer-IR zugelassen werden. Dies wird bei Multitask-Systemen
"i.a. so gelst, da der scheduler-IR eine niedrigere Prioritt als
"alle System-IRs bekommt. Oder eben so, da durch Semaphore o..
"dafr gesorgt wird, da der Timer-IR bis zum Ende der System-IRs
"wartet.
"Hier knnte man es entweder so lsen, da als timer-IR der VBL-
"Hardware-Vektor verwendet wird oder da man sich in alle Sytem-IRs
"hngt und semaphore setzt.
 *)
 
 (*
!* Demo fr Modula-Coroutinen, die per Interrupt umgeschaltet werden
!* ("Time Slice").
!*
!* Das Demo-Programm geht nur von zwei Coroutinen aus, die abwechselnd
!* aktiviert werden sollen. Ein richtiger Scheduler (Proze-Verwalter/
!* Umschalter) wrde stattdessen eine erweiterbare Liste fr beliebig
!* viele Coroutinen verwalten und sie alle abwechselnd aktivieren.
!*
!* Die Coroutinen werden folgendermaen abwechselnd aktiviert: Zuerst
!* einmal luft das Hauptprogramm (Prozedur 'mainProgram'). Jede zwanzigstel
!* Sekunde wird die erste Coroutine fr eine fnfzigstel Sekunde aktiviert.
!* Nach Ablauf einer Sekunde wird dann stattdessen die zweite Coroutine
!* alle 1/20s fr jeweils 1/50s aktiviert. Nach einer weiteren Sekunde
!* wieder die erste, usw.
!*
!* Das bedeutet:
!
!* Die scheduler-Funktion (s.u.) benutzt den 200Hz-Interrupt-Vektor,
!* sie wird also 200 mal pro Sekunde aufgerufen. Die Funktion installiert
!* sich auf den Vektor mit IOTRANSFER. Jedesmal, wenn der Vektor ange-
!* sprungen wird, wird die unterbrochene Coroutine (bzw. das unterbrochene
!* Programm) im ersten Parameter zu IOTRANSFER ('suspendedCor') gespeichert.
!* Der Scheduler zhlt nun einen Zhler herunter. Ist er nicht abgelaufen,
!* wird gleich wieder mit IOTRANSFER zur unterbrochenen Routine zurckgekehrt.
!* Andernfalls wird eine der zwei wartenden Coroutinen
!*
!Ist der Zhler abgelaufen, wird jeweils
!* eine der wartenden Coroutinen aktiviert. Der Zhler zhlt 400 Werte,
!* die Coroutinen werden demnach alle 2 Sekunden umgeschaltet.
!*
!* Zur Sichtbarmachung der Aktionen der beiden Coroutinen
!* sie beide an verschiedenen Stellen auf dem Bildschirm herum. Dies
!* geschieht durch Direktzugriff auf den Bildschirmspeicher, weil
!* ein Aufruf von Ein-/Ausgabe-Funktionen (GEM, GEMDOS, BIOS) in
!* Interrupts so einfach nicht erlaubt ist.
!!Info-Line raus!
!*)
 
 FROM SYSTEM IMPORT ADDRESS, ADR, IOTRANSFER, TRANSFER, NEWPROCESS, IOCALL;
 FROM SYSTEM IMPORT ASSEMBLER;
 (*
 FROM SysVars IMPORT etv_timer;
 *)
 FROM XBIOS IMPORT ScreenLogicalBase;
 FROM Terminal IMPORT WriteString, WriteLn, Write;
 
 CONST etv_timer =$114;
 
 VAR  mainCor: ADDRESS;                     (* Hauptprogramm *)
%schedCor: ADDRESS;                    (* Scheduler-Coroutine *)
%cor1, cor2: ADDRESS;                  (* die Hintergrund-Coroutinen *)
 
%screen: POINTER TO ARRAY [0..399] OF ARRAY [0..39] OF BITSET;
%seconds: CARDINAL;
%terminate: BOOLEAN;
 
 PROCEDURE lauflicht (offset: CARDINAL; VAR pos: CARDINAL);
"VAR b: BITSET;
"BEGIN
$b:= {};
$INCL (b, pos);
$IF pos=0 THEN pos:= 15; ELSE DEC (pos) END;
$screen^[1,offset]:= b;
$screen^[2,offset]:= b;
$screen^[3,offset]:= b;
$screen^[4,offset]:= b;
"END lauflicht;
 
 PROCEDURE funktion1;
"VAR pos: CARDINAL;
"BEGIN
$pos:= 0;
$LOOP
&lauflicht (4, pos);
$END
"END funktion1;
 
 PROCEDURE funktion2;
"VAR pos: CARDINAL;
"BEGIN
$pos:= 0;
$LOOP
&lauflicht (8, pos);
$END
"END funktion2;
 
 PROCEDURE mainProgram;
"(*
#* Diese Prozedur luft als Hauptprogramm, also nicht im Interrupt.
#*)
"VAR last: CARDINAL; l: LONGCARD;
"BEGIN
$seconds:= 0;              (* Sekundenzhler, wird vom Scheduler erhht *)
$last:= seconds;
$REPEAT
&(* Gibt jede Sekunde ein Zeichen aus: *)
&IF last # seconds THEN
(last:= seconds;
(Write ('#');
&END
$UNTIL FALSE (*seconds = 6;  (* Ende nach 6 Sekunden *)*)
"END mainProgram;
 
(* $FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$00000D26$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$FFEE50DC$00000027T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000027$000000EA$FFEE50DC$00000EA4$00000B77$00001031$0000105B$FFEE50DC$FFEE50DC$000002F0$00000091$0000006B$000002F0$000002E1$00000031$000002F0*)
