 MODULE MM2Serialize;
 
 (*    =======================================
'Vertraulich! Keinesfalls weitergeben!
&=======================================
 
&Seriennummern im Compiler eintragen
(
&17.11.87  jm   /0.0/  Suchen der Seriennummern
&15.12.87  jm   /1.0/  lauffhige Version
&29.02.88  jm   /1.1/  neues Schlsselverfahren mit Offset
&??.??.89  TT   /1.2/  whlt beliebig viele Dateien mit Selektor aus
&08.03.90  TT   /1.3/  ForceMediaChange-Aufruf
=>>> Bringt aber nichts bei Cache-Prg, weil
Adas offenbar nichts davon mitbekommt
 *)
 
 IMPORT GEMDOSIO; (*$E MOS*)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 
 FROM Files   IMPORT File, Open, Create, Close, Remove, State,
4Access, ReplaceMode;
 FROM MOSGlobals IMPORT Drive;
 FROM FileNames IMPORT StrToDrive;
 FROM Directory IMPORT ForceMediaChange;
 FROM Binary  IMPORT SeekMode, Seek, ReadBytes, ReadWord, WriteWord, FileSize;
 FROM PathCtrl IMPORT PathList;
 FROM ShellMsg IMPORT StdPaths;
 FROM Paths   IMPORT SearchFile, ListPos;
 FROM InOut   IMPORT WriteString, WriteLn, Read, WriteCard, ReadCard, WriteHex,
4WritePg;
 FROM Storage IMPORT ALLOCATE, DEALLOCATE;
 FROM Strings IMPORT Concat;
 FROM StrConv IMPORT CardToStr;
 FROM SYSTEM  IMPORT ADDRESS;
 FROM PrgCtrl IMPORT TermProcess;
 
 FROM GEMEnv   IMPORT RC, DeviceHandle, InitGem;
 FROM EasyGEM0 IMPORT HideMouse;
 FROM EasyGEM1 IMPORT SelectMask, SelectFile;
 
 
 
 CONST     NrKeys = 2;                 (* Anzahl verschiedener Schlssel *)
*NrMods = 2;                 (* Anzahl der Module mit Schlsseln *)
(maxCount = 10;                (* max. Anzahl Referenzen pro Nummer *)
 
 TYPE     PosList = ARRAY [1..maxCount] OF LONGCARD;
 
 VAR
,value,                    (* Werte der Default-Seriennummern *)
-lead,                    (* LeadIn-Worte   -"-              *)
)expCount,                    (* erwartete Anzahl der Vorkommen  *)
,patch: ARRAY [0..NrKeys] OF CARDINAL;
*offsets: ARRAY [1..NrMods] OF ARRAY [0..NrKeys] OF PosList;
 
-Offs,
+RegLen,
)FeedBack,
*Iterate: ARRAY [1..NrKeys] OF CARDINAL;
 
)compname: ARRAY [1..NrMods] OF ARRAY [0..141] OF CHAR;
/ok: BOOLEAN;
 
 
 PROCEDURE err (s: ARRAY OF CHAR; fatal: BOOLEAN);
"VAR c: CHAR;
"BEGIN
$WriteLn; WriteString ('>> '); WriteString (s); WriteLn;
$IF fatal THEN
&Read (c); TermProcess (1);
$END
"END err;
"
 
 PROCEDURE ReadCompiler (VAR a: ADDRESS; VAR size: LONGCARD;
9name: ARRAY OF CHAR): BOOLEAN;
"
"(* Sucht Datei <name> auf DefaultPath,
%reserviert Speicher und liest Datei ein.
%<a>    := Anfangsadresse der Datei im Speicher;
%<size> := Lnge  -"- .
%Ergebnis := 'Datei gefunden, genug Platz zum Einlesen gehabt'
"*)
"
"VAR         f: File;
+read: LONGCARD;
 
"BEGIN
$Open (f, name, readOnly);
$size := FileSize (f);
$ALLOCATE (a, size);
$IF a = NIL THEN RETURN FALSE END;
$ReadBytes (f, a, size, read);
$IF size # read THEN RETURN FALSE END;
$Close (f);
$RETURN TRUE
"END ReadCompiler;
 
 
 PROCEDURE Search (        a: ADDRESS; len: LONGCARD; targ1, targ2: CARDINAL;
2VAR count: CARDINAL;
4VAR pos: PosList);
"BEGIN
$ASSEMBLER
&MOVE.L   pos(A6),A1
&CLR.W    D3
&MOVE.L   a(A6),A0
&MOVE.L   len(A6),D1
&MOVE.W   targ1(A6),D0
&MOVE.W   targ2(A6),D4
#
#lp CMP.W    (A0)+,D0         ;Suchschleife
&BNE      nix
&CMP.W    (A0),D4
&BNE      nix
&MOVE.L   A0,D2
&SUB.L    a(A6),D2
&MOVE.L   D2,(A1)+
&ADDQ.L   #1,D3
"nix SUBQ.L   #2,D1
&BHI      lp
&
&MOVE.L   count(A6),A0
&MOVE.W   D3,(A0)          ;setze Count
$END
"END Search;
 
 
 PROCEDURE FindOffsets;
"
"(*  Liest alle Dateien <compname>.
&Durchsucht sie nach Auftreten von <lead>, <value> und prft
&jeweils, ob <expcount> Vorkommen gefunden. Wenn gefunden, wird
&der jew. Offset im entspr. File in 'offsets' vermerkt.
&Bricht im Fehlerfall mit Meldung ab.
"*)
&
"VAR          a: ARRAY [1..NrMods] OF ADDRESS;
/l: ARRAY [1..NrMods] OF LONGCARD;
.wl: LONGCARD;
-ofs: PosList;
"count, n, i, k: CARDINAL;
*errmsg: ARRAY [0..127] OF CHAR;
+dummy: BOOLEAN;
"
"BEGIN
$wl:= 0;
$FOR n:= 1 TO NrMods DO
&IF NOT ReadCompiler (a [n], l [n], compname [n]) THEN
(err ('Compiler kann nicht gelesen werden!', TRUE)
&END;
&INC (wl, l [n]);
&FOR k:= 0 TO NrKeys DO
(FOR i:= 1 TO expCount [k] DO offsets [n, k, i]:= 0 END
&END;
$END;
$FOR k:= 0 TO NrKeys DO
&Search (a [1], wl, lead [k], value [k], count, ofs);
&IF count # expCount [k] THEN
(Concat ('Falsche Anzahl Schlsseleintrge: ',
1CardToStr (count, 0), errmsg, dummy);
(err (errmsg, TRUE)
&END;
&FOR i:= 1 TO expCount [k] DO
(FOR n:= 1 TO NrMods DO
*IF (ofs[i] >= a[n] - a[1]) & (ofs[i] < a[n] - a[1] + l[n]) THEN
,offsets [n, k, i]:= ofs[i] - (a[n] - a[1])
*END
(END
&END
$END;
$count:= 0;
$FOR n:= 1 TO NrMods DO
&FOR k:= 0 TO NrKeys DO
(FOR i:= 1 TO expCount [k] DO
*IF offsets [n, k, i] = 0L THEN INC (count) END;
(END
&END;
&DEALLOCATE (a [n], l [n]);
$END;
$n:= 0;
$FOR k:= 0 TO NrKeys DO
&INC (n, expCount [k])
$END;
$IF count # n THEN
&err ('Interner Fehler: Schlsselanzahl falsch.', TRUE)
$END
"END FindOffsets;
"
"
 PROCEDURE encode (start, len, feedback, iter, off: CARDINAL): CARDINAL; (*$L-*)
$
"(* Schieberegister rechtsrum, Bits 0..<len>,
%Rckkopplung aus Bit <feedback>, auf <start>-Wert loslassen.
%<iter> Iterationen durchfhren; <Off> addieren;
%Ergebnis auf Cardinal krzen
"*)
"
"BEGIN
$ASSEMBLER
&MOVE.W  -(A3),D3        ;Offset
&MOVE.W  -(A3),D2        ;Iterationen
&MOVE.W  -(A3),D0        ;rckgefhrtes Bit
&MOVE.W  -(A3),D4        ;Registerlnge -1
&CLR.L   D1
&MOVE.W  -(A3),D1        ;Startwert
&BRA     l1
#l2 BTST    D0,D1           ;Bit0 := Bit0 EOR Bit(D0)
&BEQ     nochg           ; "
&BCHG    #0,D1           ; "
 nochg LSR.L   #1,D1           ;einmal rechts schieben
&BCC     l1              ;und Bit0 in Bit(D4) rotieren
&BSET    D4,D1
#l1 DBF     D2,l2
&ADD.W   D3,D1           ;Offset dazu
&MOVE.W  D1,(A3)+        ;Ergebnis zurck
$END
"END encode;         (*$L+*)
"
"
 PROCEDURE CheckSer;
!
#(* prft, ob die angegebenen Schlsselverfahren konsistent
&sind mit den angegebenen Default-Eintrgen.
&Im Fehlerfall Abbruch mit Meldung.
#*)
#
#VAR  k: CARDINAL;
#
#BEGIN
%FOR k := 1 TO NrKeys DO
'IF encode (value[0], RegLen[k], FeedBack[k], Iterate[k], Offs[k])
*# value [k]
)THEN err ('Schlsselverfahren pat nicht zu Default-Eintrgen', TRUE)
'END
%END
#END CheckSer;
#
 
 PROCEDURE CalcSer (mySer: CARDINAL);
"
"(* bergabe der Seriennummer in <mySer>.
%Setzt ARRAY <patch> auf verschlsselte Seriennummern.
%Verwendet Beschreibung der Schlsselverfahren in
%<RegLen>, <FeedBack>, <Iterate>.           *)
"
"VAR  k: CARDINAL;
"
"BEGIN
$patch [0] := mySer;
$WriteString ('   Schlssel'); WriteHex (patch [0], 7);
$FOR k := 1 TO NrKeys DO
&patch [k] :=
-encode (mySer, RegLen[k], FeedBack[k], Iterate[k], Offs [k]);
&WriteHex (patch[k], 7);
$END;
$WriteLn;
"END CalcSer;
"
"
 PROCEDURE OpenFile (VAR f: File; name: ARRAY OF CHAR): BOOLEAN;
"
"(* reserviert Speicher und liest Datei ein.
%<a>    := Anfangsadresse der Datei im Speicher;
%<size> := Lnge  -"- .
%Ergebnis := 'Datei gefunden, genug Platz zum Einlesen gehabt'
"*)
 
"BEGIN
$Open (f, name, readWrite);
$IF State (f) < 0 THEN
&err ('Datei nicht gefunden', FALSE); RETURN FALSE
$END;
$RETURN TRUE
"END OpenFile;
 
 
 PROCEDURE PatchSerial (mySer: CARDINAL): BOOLEAN;
"
"VAR  j, k, n: CARDINAL;
*f: File;
*w: CARDINAL;
*
"BEGIN
$CalcSer (mySer);
$FOR n:= 1 TO NrMods DO
&IF NOT OpenFile (f, compname [n]) THEN
(RETURN FALSE
&END;
&FOR j:= 0 TO NrKeys DO
(FOR k:= 1 TO expCount [j] DO
*IF offsets [n, j, k] # 0L THEN
,Seek (f, offsets [n, j, k], fromBegin);
,ReadWord (f, w);
,IF w # value [j] THEN
.IF (j=0) & (k=1) THEN
0err ('Falsche Seriennummern gefunden: Datei unverndert', FALSE);
0Close (f);
.ELSE
0err ('Falsche Seriennummern gefunden: Datei gelscht', FALSE);
0Remove (f);
.END;
.RETURN FALSE
,END;
,Seek (f, -2L, fromPos);
,WriteWord (f, patch [j])
*END
(END
&END;
&Close (f);
$END;
$RETURN TRUE
"END PatchSerial;
"
"
 VAR   n, mySer: CARDINAL;
-c: CHAR;
,dh: DeviceHandle;
 
 BEGIN
"
"InitGem (RC, dh, ok);
"
"HideMouse;
"WritePg;
"
"(* Konstanten fr Schlssel *)
"
"RegLen [1] := 17; FeedBack [1] := 7; Iterate [1] :=  39; Offs [1] := $2302;
"RegLen [2] := 16; FeedBack [2] := 3; Iterate [2] := 367; Offs [2] := $3C78;
#
"(* Default-Seriennummern im Compiler *)
"
"value [0] := $4711;  expCount [0] := 3;  lead [0] := $0641;
"value [1] := $1ADE;  expCount [1] := 1;  lead [1] := $343C;
"value [2] := $312F;  expCount [2] := 1;  lead [2] := $0240;
"
"(* Seriennummern im Compiler suchen *)
"
"WriteString ('Serialize /1.3/:  Seriennummern in Compiler eintragen ');
"WriteLn; WriteLn;
"
"(*
"WriteString ('Achtung: Bei TOS 1.4ff kein Cache-Prg verwenden!');
"WriteLn; WriteLn;
"*)
"
"WriteString ('Konsistenzprfung der angegebenen Schlssel:'); WriteLn;
"CheckSer;
"WriteString ('   ok.'); WriteLn; WriteLn;
"
"FOR n:= 1 TO NrMods DO
$SelectFile ('Wo isser?', compname [n], ok);
$IF NOT ok THEN RETURN END;
$WritePg;
"END;
"
"WriteString ('Suchen der Seriennummern:'); WriteLn;
"
"FindOffsets;
"WriteString ('   ok.'); WriteLn; WriteLn;
"
"(* neue Seriennummern eintragen *)
"
"LOOP
$WriteString ('Neue Seriennummer eintragen:'); WriteLn;
$WriteString ('   Nummer eingeben (0 stoppt): ');
$ReadCard (mySer);
$IF mySer = 0 THEN EXIT END;
$
$ForceMediaChange (StrToDrive (compname[1]));
$IF PatchSerial (mySer) THEN
&WriteString ('   ok.'); WriteLn;
$END;
$WriteLn;
"END;
"
 END MM2Serialize.
 
(* $FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$000022E2$FFEDDD92$000025CB$FFEDDD92$00000C2C$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$FFEDDD92$000022E2T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000275$00000268$00000272$0000024F$0000023D$00002285$000022E2$00000396$FFD6B137$FFD6B137$000003AA$000003CF$000003B9$000003CB$000003E3$00000C2C*)
