 MODULE GetMPB;
 (*$E MOS *)
 
 FROM MOSCtrl IMPORT ProcessID;
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, LONGWORD;
 FROM Console IMPORT WriteString, WriteLn, Read;
 FROM StrConv IMPORT LHexToStr;
 
 TYPE P_MD = POINTER TO MD;
%
%MD = RECORD
,next: P_MD;
,start: ADDRESS;
,length: LONGCARD;
,owner: LONGWORD
*END;
 
%P_MPB = POINTER TO MPB;
%
%MPB = RECORD
-free: P_MD;
-used: P_MD;
-boomer: P_MD
+END;
 
 
 VAR MPBPtr: P_MPB;
 
$ch: CHAR;
 
 CONST   end_os = $4FA;
 
 BEGIN
"ASSEMBLER
(; Malloc (2)
(MOVEQ   #2,D0
(MOVE.L  D0,-(A7)
(MOVE    #$48,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  D0,-(A7)
(
(CLR.L   -(A7)
(MOVE    #$20,-(A7)      ; Super (0)
(TRAP    #1
(MOVE.L  D0,2(A7)
(
(MOVE.L  $4F2,A0         ; ^TOS-Header
(MOVE.L  8(A0),A0        ; wg. altem AHDI
(CMPI.B  #$03,2(A0)
(BEQ.W   error           ; erstmal nicht bei TT wg. Fast-RAM
(
(LEA     $800,A0
(MOVE.L  end_os,D1
(SUB.L   A0,D1
(LSR     #1,D1           ; D1: Anzahl zu suchender Words
(
(; *** nach dem MD suchen ***
(
(MOVE.L  6(A7),D0        ; zu suchender 'start'
(MOVE.L  ProcessID,A2
(MOVE.L  (A2),D2         ; zu suchender 'owner'
(
(CLR.L   -(A7)           ; Flag: bisher nix gefunden
(
$l1: CMP.W   (A0)+,D0
(DBEQ    D1,l1
(BNE     e1
(CMP.L   -4(A0),D0       ; stimmt 'start'?
(DBEQ    D1,l1
(BNE     e1
(CMPI.L  #2,(A0)         ; stimmt 'length'?
(DBEQ    D1,l1
(BNE     e1
(CMP.L   4(A0),D2        ; stimmt 'owner'?
(DBEQ    D1,l1
(BNE     e1
(
(; *** MD gefunden ***
(
(TST.L   (A7)+
(BNE     error           ; mehrfach gefunden -> Abbruch
(
(LEA     -8(A0),A1
(MOVE.L  A1,-(A7)        ; Adr. des MD merken
(
(DBRA    D1,l1           ; weitersuchen
 
$e1: MOVE.L  (A7)+,A1
(MOVE.L  A1,D2
(BEQ     error           ; nicht gefunden
(
(; *** nach mglichen MPBs suchen ***
(
(LEA     $800,A0
(MOVE.L  end_os,D1
(SUB.L   A0,D1
(LSR     #1,D1           ; D1: Anzahl zu suchender Words
(
(CLR.L   -(A7)           ; Endmarke f. gefundene Adressen
(
$l2: CMP.W   (A0)+,D2
(DBEQ    D1,l2
(BNE     e2
(CMP.L   -4(A0),D2       ; steht ^MD in MPB.used?
(DBEQ    D1,l2
(BNE     e2
(; einen haben wir...
(PEA     -8(A0)
(DBRA    D1,l2           ; weitersuchen
(
$e2: 
(; *** Bereich wieder freigeben. Dann ***
(; *** steht in MPB.used der ^MD.next ***
(
(MOVE.L  (A1),-(A7)      ; MD.next merken
(MOVE.L  D0,-(A7)
(MOVE    #$49,-(A7)      ; Mfree()
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  (A7)+,D2        ; MD.next
(
(; *** nochmal die mgl. MPBs prfen ***
(
$l3: MOVE.L  (A7)+,D0        ; ^MD
(BEQ     e3
(MOVE.L  D0,A0
(CMP.L   4(A0),D2        ; MBP.used = MD.next?
(BNE     l3
(TST.L   MPBPtr
(BNE     err2            ; mehrfach gefunden -> Abbruch
(; *** MPB gefunden ***
(MOVE.L  A0,MPBPtr
(BRA     l3              ; weitersuchen
(
"err2: TST.L   (A7)+
(BNE     err2
(CLR.L   MPBPtr
 
$e3: TRAP    #1              ; Super (SSP)
(ADDQ.L  #6,A7
(BRA     ende
(
!error: TRAP    #1              ; Super (SSP)
(ADDQ.L  #6,A7
(MOVE    #$49,-(A7)      ; Mfree()
(TRAP    #1
(ADDQ.L  #2,A7
(CLR.L   MPBPtr
 
"ende: ADDQ.L  #4,A7           ; Adr. vom angeforderten Block vom Stack
"END;
"WriteString ('MPBPtr: ');
"WriteString (LHexToStr (MPBPtr, 7));
"WriteLn;
"Read (ch)
 END GetMPB.
  
(* $FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$FFED5C54$000001ADT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$0000089F$0000075B$0000076B$0000077B$0000078A$0000080A$0000085A$0000089F$000006DD$000007FD$0000082E$00000884$00000A86$000001AD$000001F0$00000380*)
