 MODULE CmpMods2; (*$Z+,M+,C-,Q+,P+,V+,R-*)
 
 FROM InOut IMPORT Write, WriteLn, WriteString, WriteInt, WriteCard,
"OpenOutput, CloseOutput;
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, WORD, BYTE, ADR, TSIZE, LONGWORD, CAST;
 FROM SysTypes IMPORT PtrAnyLongType;
 FROM ArgCV     IMPORT PtrArgStr, InitArgCV;
 FROM Storage   IMPORT ALLOCATE, DEALLOCATE, MemAvail;
 FROM Strings   IMPORT Upper, Concat, Compare, Relation, Pos, Empty,
7StrEqual, Split, Assign, Copy, PosLen, String, Append;
 IMPORT FastStrings;
 FROM Files IMPORT Open, Create, Access, Close, Remove, FILE, ReplaceMode,
(State, ResetState;
 FROM Paths IMPORT SearchFile, ListPos;
 FROM PathEnv IMPORT ReplaceHome, HomePath;
 FROM PathCtrl IMPORT PathList;
 FROM Directory IMPORT MakeFullPath;
 FROM FileNames IMPORT SplitPath, SplitName, ConcatName, ConcatPath,
(FileSuffix;
 FROM Binary IMPORT ReadBytes, WriteBytes, Seek, SeekMode, FileSize, WriteBlock;
 FROM ShellMsg IMPORT ModPaths, ImpPaths, LLRange, ShellPath, LinkerParm;
 FROM MOSCtrl IMPORT PDB;
 FROM PrgCtrl IMPORT TermProcess;
 FROM MOSConfig IMPORT DftSfx, ImpSfx, MaxBlSize;
 IMPORT MOSGlobals, StrConv, Block;
 FROM MM2LnkIO IMPORT ClearEOP, Report, Prompt, InitOutput, VerboseOutput,
(Read, ReadString, WriteString, WriteMod,
(ClearMod, DiscardMods, ReportRealFormat, BeginWriting, ReportCodeLen,
(ReportLinkError, ReportIOError, ReportError, WritingOut, EndWriting;

 CONST PDBlayout = 4;
&version = '2.17';    (* Linker-Version *)
&CodeID = "Megamax Modula-2 V2";
 
 VAR ok: BOOLEAN;
 
 
 PROCEDURE conc (a,b:ARRAY OF CHAR):String;
"VAR c:String;
"BEGIN
$concat (a,b,c,ok);
$RETURN c
"END conc;
 
 
 CONST
 
"SysVarSpace = 52;        (* layout,
>^basePage (f. ArgV),
>^modList (f. Loader),
>Anzahl der Eintrge in modLst,
>processState,
>BottomOfStack,
>TopOfStack,
>termState,
>resident,
>flags,
>TermProcs,
>^prev,
>16 reserved bytes *)
 
"ShModLstSpace = 14;      (* head0: ADDRESS;
>var0: ADDRESS;
>varlen0: LONGCARD;
>flags: BITSET; *)
 
(ESC = 33C;
 
%BadIndex = 1000;
'anykey = 0L;        (* Joker fuer Modul-Key *)
$DefOutSuf = '.PRG';    (* Suffix f. Output, wenn keiner angegeben *)
 
 VAR DefImpInSuf: ARRAY [0..2] OF CHAR; (* Suffix fuer Input Impl. Files *)
$DefPrgInSuf: ARRAY [0..2] OF CHAR; (* Suffix fuer Input Main Files *)
 
&ListMax: CARDINAL;   (* ehemals konstant 1000 *)
 
 TYPE
'tIndex = [0..BadIndex];  (* Index auf die Modul-Liste; BadIndex
Ckodiert Sonderfaelle: kein gueltiger
CIndex bzw. residentes Modul *)
%tModName = string;
 
%ptrModDesc = POINTER TO tModDesc;
 
%tModDesc = RECORD
2image: address;    (* ^Buffer beim Relozieren *)
1codeAd: address;    (* StartAdr im ROM *)
0codeEnd: LONGCARD;
2varAd: address;    (* StartAdr der Variablen *)
1varLen: LONGCARD;   (* Lnge der Variablen *)
3diff: longcard;   (* Laenge der entfernten Imp.Liste *)
4key: longcard;   (* Key dieses Moduls *)
1modlen: longcard;   (* Code-Lnge dieses Moduls *)
-sourcename: ARRAY [0..11] OF CHAR;
-symbolname: ARRAY [0..11] OF CHAR;
3name: ARRAY [0..39] OF CHAR;  (* ModulName *)
0procSym: BOOLEAN;
/compopts: LONGWORD;
.mayRemove: BOOLEAN;    (* FALSE: Body keinesfalls wegoptimieren!*)
0mainMod: BOOLEAN;    (* FALSE: ist'n importiertes Modul *)
.mayCrunch: BOOLEAN;    (* TRUE: Proc-Length-Liste vorhanden *)
/crunched: BOOLEAN;
+varsExported: BOOLEAN;    (* TRUE: Vars werden v. anderen Mods importiert *)
0useCode: BOOLEAN;    (* FALSE: Modulcode wird nicht gebraucht *)
-bodyMarked: BOOLEAN;
1ImpLst: POINTER TO ARRAY tIndex OF tIndex; (* Liste der imp. Module *)
/ImpIndex: tIndex;                 (* Anzahl imp. Module *)
/finalIdx: tIndex;  (* Index fr ModBase *)
0END;
 
$ErrType   = (NotFound, BadFormat, BadVersion, NoSpace, TooManyMods,
1mustnotbeimpl, badlayout, readerr, relocerr, nooptimize,
1badReal);
0
(pLONG = POINTER TO LONGCARD;
 
 VAR
'ModLst: POINTER TO ARRAY tIndex OF tModDesc;  (* Liste der geladenen Module *)
%ModIndex: tIndex;                    (* ^ letzten Eintrag in ModLst *)
$UsedCodes: tIndex;                    (* Anzahl der verw. Modulcodes *)
&InitLst: POINTER TO ARRAY tIndex OF tIndex;    (* Liste der Init-Reihenfolge *)
$InitIndex: tIndex;                    (* ^ letzten Eintrag in InitLst *)
%InitIdx2: tIndex;                    (* ^ auf Second-Mod - InitLst *)
$UsedInits: tIndex;                    (* Anzahl der zu init. Bodies *)
 
#CodeSuffix: boolean;
"LoadingMain: BOOLEAN;
%IOResult,
*ior: INTEGER;                   (* ZW fuer IOResults *)
 
%LoadFile,                            (* geladene Module *)
&OutFile: file;                      (* zu schreibendes Codefile *)
 
%BSSstart: address;                   (* Start-Adr fuer reloz. Vars *)
&CodeNow,                            (* ^ zu vergebenden Codeplatz *)
'VarNow: address;                   (* ^ zu vergebenden Varplatz *)
"ShModLstLen: Longcard;                  (* Ges.lnge der ModLst f.d. Loader *)
$stacksize: LONGCARD;
 
&BodyLen: LONGCARD;                  (* testweise f. Lnge aller Bodies *)
"
&pRelTab,
&eRelTab,
%RelocTab: ADDRESS;
!firstRelVal : longcard;
"lastRelVal : longcard;
!
&dt_buf : RECORD   (* disk transfer buffer *)
1dum0 : ARRAY [1..13] OF word;
1flen : LONGCARD;
1dum1 : ARRAY [16..22] OF word
/END;
&
%singleMod: BOOLEAN;
%
)paths: PathList;
 
&optProcs: BOOLEAN;  (* TRUE: Procs optimieren *)
&noHeader: BOOLEAN;  (* TRUE: Header aus Moduln entfernen *)
$noShModLst: BOOLEAN;  (* TRUE: ShortModList aus Moduln entfernen *)
$noProcSyms: BOOLEAN;  (* TRUE: ProcSymbols vor Prozeduren entfernen *)
 
"extendedCode: BOOLEAN;
&realForm: CARDINAL;
 
#HeaderFlags: BITSET;
 
 
 PROCEDURE fputm ( f:file; VAR p:ARRAY OF word; c:LONGCARD );
"BEGIN
$WriteBytes (f, ADR (p), c);
"END fputm;
 
 
 PROCEDURE fput ( f:file; REF p: ARRAY OF BYTE );
"BEGIN
$IF NOT ODD (HIGH (p)) THEN HALT END;
$WriteBlock (f, p);
"END fput;
 
 
 PROCEDURE hasSuffix (s: string): boolean;
"VAR p: cardinal;
"BEGIN
$RETURN length (FileSuffix (s)) > 0;
$(* in den letzten 4 Zeichen von s muss ein Punkt stehen! *)
"END hasSuffix;
 
 
 PROCEDURE entry (Index: address; Displacement: LONGCARD): LongCard;
"(*** Long-Peek mit Displacement ***)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(MOVE.L  (A0),D0
$END
"END entry;
"(*$L=*)
 
 
 PROCEDURE enter (Index: address; Displacement: cardinal; value: LongCard);
"(*** Long-Poke mit Displacement ***)
"VAR p: POINTER TO LongCard;
"BEGIN
$p:= Index + address (long (Displacement));
$p^:= value;
"END enter;
 
 
 PROCEDURE error (client, impmod: ARRAY OF CHAR; t: ErrType);
 
"(*** Fehleranzeige auf dem Bildschirm; danach zurueck zum Aufrufer ***)
"
"VAR msg: String;
"
"BEGIN
$CASE t OF
+badReal: msg:= 'Different real-formats specified'; client[0]:= 0C |
(badversion: msg:= 'Wrong module version' |
)badformat: msg:= 'Wrong module format'; client[0]:= 0C |
*notfound: msg:= 'Module not found'; client[0]:= 0C |
+readerr: msg:= 'File is damaged'; client[0]:= 0C |
+nospace: msg:= 'Out of memory'; client[0]:= 0C |
'toomanymods: msg:= 'Too many modules (enlarge "max. Module")'; client[0]:= 0C|
%mustnotbeimpl: msg:= 'Init-module must be program module'; client[0]:= 0C|
)badlayout: msg:= 'Bad module layout'; client[0]:= 0C|
*relocerr: msg:= 'Error in relocation list'; client[0]:= 0C|
(nooptimize: msg:= 'Old module layout - may not be optimized'; client[0]:= 0C|
$END; (* of case *)
$ReportLinkError (impmod, client, msg)
"END error;
 
 
 PROCEDURE MyError (ior: integer);
"BEGIN
$ReportIOError (ior)
"END MyError;
 
 PROCEDURE RelError0 (REF s: ARRAY OF CHAR);
"BEGIN
$ReportError (s);
$Remove (outfile);
$TermProcess (MOSGlobals.OutOfMemory)
"END RelError0;
 
 PROCEDURE RelError (internalErr: BOOLEAN);
"VAR s: String;
"BEGIN
$s:= 'Out of memory!';
$IF internalErr THEN Append (' (internal error!)', s, ok) END;
$RelError0 (s);
"END RelError;
 
 PROCEDURE RelError2;
"BEGIN
$RelError0 ('Relocation table overflow! Use "-R" option.');
"END RelError2;
 
 
 PROCEDURE GetStr (VAR p: address): tModName;
"(* String aus der Importliste holen *)
"VAR s: tModName;
"BEGIN
$ASSEMBLER
,MOVE.L  p(A6),A1       ;Adresse von p
,MOVE.L  (A1),A2        ;Wert von p
,LEA     s(A6),A0
%!RE13  MOVE.B  (A2)+,D2       ;Zeichen holen
,CMPI.B  #$FE,D2
,BCC     RE12           ; -> Endmarke
,MOVE.B  D2,(A0)+
,BRA     RE13
%!RE12  BNE     RE14
,ADDQ.L  #1,A2
%!RE14  CLR.B   (A0)+
,MOVE.L  A2,(A1)        ;p hochsetzen
$END;
$RETURN s
"END GetStr;
 
 PROCEDURE SkipStr (VAR p: address);
"(* String aus der Importliste berspringen *)
"(*$L-*)
"BEGIN
$ASSEMBLER
,MOVE.L  -(A3),A1       ;Adresse von p
,MOVE.L  (A1),A2        ;Wert von p
%!RE13  CMPI.B  #$FF,(A2)+
,BNE     RE13
,MOVE.L  A2,(A1)        ;p hochsetzen
$END;
"END SkipStr;
"(*$L=*)
 
 PROCEDURE SkipImpList (VAR p: address);
"(* Importliste berspringen *)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0),A1
%R6 MOVE.W  (A1)+,D0      ;imp. ItemNr
(BEQ     R5            ;fertig mit diesem Import
(MOVE.L  (A1)+,D1      ;importiertes Item
(BRA     R6
%R5 MOVE.L  A1,(A0)
$END;
"END SkipImpList;
"(*$L=*)
 
 
 PROCEDURE SplitFileName ( REF Source: ARRAY OF CHAR; VAR Name,sfx: ARRAY OF Char );
"VAR dummy: MOSGlobals.PathStr;
"BEGIN
$SplitPath (source, dummy, name);
$SplitName (name, name, sfx)
"END SplitFileName;
 
 
 
 PROCEDURE moveMem (olo, ohi, nlo: LONGCARD);
"BEGIN
$ASSEMBLER
(MOVE.L  olo(A6),A0
(MOVE.L  ohi(A6),A1
(MOVE.L  nlo(A6),A2
&L MOVE.W  (A0)+,(A2)+
(CMPA.L  A1,A0
(BCS     L
$END
"END moveMem;
 
 
 PROCEDURE isCLinkMod (modidx: CARDINAL): BOOLEAN;
 (*
!* Wert: TRUE, wenn Modul von 'MM2CLink' erzeugt wurde.
!*)
"BEGIN
$RETURN entry (ModLst^ [modidx].image, 50) # 0;
"END isCLinkMod;
 
 
 PROCEDURE Vergleiche;
 
"TYPE RelocList = POINTER TO RECORD link: LONGCARD; procAddr: LONGCARD END;
'ProcLenList = POINTER TO RECORD start: LONGCARD; len: LONGCARD END;
'ImportTable = POINTER TO RECORD item: CARDINAL; procAddr: LONGCARD END;
$
"PROCEDURE pStart (p: ProcLenList): LONGCARD;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0),D0         ; p^.start
(ANDI.L  #$00FFFFFF,D0
&END;
$END pStart;
$(*$L=*)
 
"PROCEDURE pEnd (p: ProcLenList): LONGCARD;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0)+,D0        ; p^.start
(ANDI.L  #$00FFFFFF,D0
(ADD.L   (A0),D0         ; p^.len
&END;
$END pEnd;
$(*$L=*)
 
"PROCEDURE mark (p: ProcLenList; n: CARDINAL);
$(* n: 1='lokal verwendet', 2='von anderem Modul importiert' *)
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.B  D0,(A0)         ; p^.start
&END;
$END mark;
$(*$L=*)
 
"PROCEDURE marked (p: ProcLenList): BOOLEAN;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(TST.B   (A0)            ; p^.start
(SNE     D0
(ANDI    #1,D0
&END;
$END marked;
$(*$L=*)
 
"PROCEDURE markedValue (p: ProcLenList): CARDINAL;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(CLR     D0
(MOVE.B  (A0),D0         ; p^.start
&END;
$END markedValue;
$(*$L=*)
 
"PROCEDURE between (v, lo, hi: LONGCARD): BOOLEAN;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),D0  ; hi
(MOVE.L  -(A3),D1  ; lo
(MOVE.L  -(A3),D2  ; v
(CMP.L   D1,D2
(BCS     fals
(CMP.L   D0,D2
(BCC     fals
(MOVEQ   #1,D0
(RTS
&fals
(CLR     D0
&END;
$END between;
$(*$L=*)
 
"PROCEDURE advance (p: LONGCARD; VAR prl: ProcLenList);
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A2        ; ADR (prl)
(MOVE.L  -(A3),-(A7)     ; p
(MOVE.L  (A2),A1
&lupo
(MOVE.L  (A7),(A3)+
(MOVE.L  A1,(A3)+
(BSR     pStart/
(MOVE.L  D0,(A3)+
(MOVE.L  A1,(A3)+
(BSR     pEnd/
(MOVE.L  D0,(A3)+
(BSR     between/
(BNE     ende
(ADDQ.L  #8,A1
(BRA     lupo
&ende
(MOVE.L  A1,(A2)
(ADDQ.L  #4,A7
&END
&(*
&WHILE NOT between (p, pStart (prl), pEnd (prl)) DO
(INC (prl, SHORT (SIZE (prl^)))
&END;
&*)
$END advance;
$(*$L=*)
 
"PROCEDURE findListEntry (idx: tIndex; ad: LONGCARD; VAR prl: ProcLenList);
$BEGIN
&WITH ModLst^ [idx] DO
(prl:= image + entry (image, 38)
&END;
&advance (ad, prl)
$END findListEntry;
 
 
$VAR
&image1, image2: ADDRESS;
&pra1, pra2: RelocList;
&prl1, prl2: ProcLenList;
&link1, link2: LONGCARD;
 
"BEGIN (* Vergleiche *)
$image1:= ModLst^ [1].image;
$image2:= ModLst^ [2].image;
$
$pra1:= image1 + entry (image1, 22);
$prl1:= image1 + entry (image1, 38);
$
$pra2:= image2 + entry (image2, 22);
$prl2:= image2 + entry (image2, 38);
$
$OpenOutput ('TXT');
$
$WHILE pra1^.link # NIL DO
&IF pra1^.procAddr < entry (image1, 22) THEN (* Proc, nicht Var *)
(advance (pra1^.procAddr, prl1);
(link1:= pra^.link1;
(LOOP
*IF link = 0L THEN
,EXIT
*ELSIF between (link, start, ende) THEN
,IF ~marked (prl) THEN
.mark (prl,1);
.markCalls (modidx, pStart (prl), pEnd (prl))
,END;
,EXIT
*END;
*link:= entry (image, link)
(END
&END;
&INC (pra, 8)
$END;
 
$CloseOutput;
 
"END Vergleiche;
 
 
 PROCEDURE bit (n: CARDINAL; l: ARRAY OF WORD): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D2
(MOVE.L  -(A3),A0
(MOVE.W  -(A3),D1
(TST     D2
(BEQ     wd
(MOVE.L  (A0),D0
(BRA     lg
%wd MOVE.W  (A0),D0
%lg BTST    D1,D0
(SNE     D0
(ANDI    #1,D0
$END
"END bit;
"(*$L=*)
 
 
 PROCEDURE ExecMod (mname: tModName;       (* Name des gewuenschten Moduls *)
2reqkey: LONGCARD;       (* gewuenschter Key *)
2client: tIndex)         (* Index des Klienten *)
8: tIndex;         (* vergebener Index *)
 
"(* Laedt das Modul "mname" und liefert dessen Index in der "ModLst"
#* als Ergebnis.
#* Der Modulkey "reqkey" wird erwartet und ueberprueft.
#* Falls ein Fehler beim Relozieren oder Laden auftritt,
#* wird der benoetigte Speicher freigegeben und als Ergebnis
#* "BadIndex" geliefert
#*)
$
"VAR
.i: tIndex;
%clientname,
*fname: tModName;
-ad: address;
"
$
"PROCEDURE LoadMod (mname, fname: tModName): tIndex;
 
$(* Laedt ein Modul in den Speicher, ueberprueft das Format
%* und traegt in die Modul-Liste ein. Reloziert nicht!
%* Wenn ein Fehler auftritt, wird der benutzte Speicher
%* freigegeben und als Modul-Index BadIndex geliefert
%*)
 
$PROCEDURE ImportLen (image: address): LongCard;
&
&(* Laenge der Importliste des Moduls, das bei image steht,
)in Bytes ermitteln
&*)
&
&VAR s: address; n: LONGCARD;
&
&BEGIN
(s:= entry (image, 14);
(IF s = NIL THEN
*RETURN 0L
(ELSE
*n:= 4;  (* Platz fr Import-Liste (s. PutMod) *)
*s:= s+image;
*WHILE entry (s, 0) # 0L DO
,inc (s, 4);
,WHILE cardinal (s^) MOD 256 # 255 DO inc (s, 2) END;
,inc (s, 2);
,WHILE cardinal (s^) # 0 DO inc (s, 6) END;
,inc (s, 2);
,INC (n, 4);
*END;
*RETURN s+4L-image-entry (image, 14) - n
(END
&END ImportLen;
$
$VAR    foundkey: LongCard;      (* Key des geladenen Moduls    *)
-ModAdr: Address;       (* Anfang des geladenen Moduls *)
.found: Boolean;       (* fuer FileSearch             *)
,DriveNr: Cardinal;      (*  "                          *)
.VolNr: Cardinal;      (*  "                          *)
0ad1: address;       (* fuer Storage-Anforderungen  *)
0len: longcard;      (*  -"-                        *)
-layout: CARDINAL;
+realCode: CARDINAL;
-mname0: POINTER TO tModName;
,badFile: BOOLEAN;
-dummys: ARRAY [0..127] OF CHAR;
$
$BEGIN (* LoadMod *)
&IF ModIndex < LinkerParm.maxLinkMod THEN
(inc (ModIndex);
&ELSE
((*** Leider ist die Liste bergelaufen: ***)
(error (clientname, mname, TooManyMods);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
&
&SearchFile (fname,paths,fromStart,found,fname);
&Open (loadFile,fname,readonly);
&IF state (loadfile) < 0 THEN
(error (clientname,mname,notfound);
(RETURN BadIndex
&END;
 
&len:= FileSize (loadFile);
&Allocate (ad1, len);
&IF ad1 = NIL THEN
(Close (loadFile);
(error (clientname,mname,nospace);
(RETURN BadIndex
&END;
 
&ReadBytes (loadFile, ad1, len, len);
&ior:= State (loadFile);
&ResetState (loadFile);
&Close (loadFile);
&IF IOR<0 THEN
(error (clientname,mname,readerr);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
 
&ASSEMBLER
(MOVE.L  ad1(A6),A0
(CMPI.L  #$4D4D3243,(A0)+        ; "MM2C"
(BNE     nocode
(CMPI.L  #$6F646500,(A0)+        ; "ode"
&nocode
(SNE     D0
(ANDI    #1,D0
(MOVE    D0,badFile(A6)
&END;
&IF badFile THEN
(error (clientname,mname,badlayout);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
 
&ModAdr:= ad1+8L;
 
&layout:= Short (entry (ModAdr, 0) DIV 65536L);
&ASSEMBLER
(MOVE.W  layout(A6),D0
(LSR.B   #5,D0
(ANDI    #3,D0
(MOVE.W  D0,realCode(A6)
&END;
&(*
(IF (layout DIV 256) < 1 THEN
*error (clientname,mname,badlayout);
*DeAllocate (ad1,0L);
*RETURN BadIndex
(END;
&*)
&
&IF singleMod THEN
(singleMod:= FALSE;
&END;
&
&IF realCode # 0 THEN (* real im Code *)
(IF realForm # 0 THEN (* schon Real benutzt *)
*IF realCode # realForm THEN
,error (clientname,mname,badreal);
,DeAllocate (ad1,0L);
,RETURN BadIndex
*END
(ELSE
*ReportRealFormat (realCode-1);
*realForm:= realCode
(END
&END;
&
&foundkey:= entry (ModAdr, 2);
&IF (reqkey#anykey) & (reqkey#foundkey) THEN
(error (clientname,mname,badversion);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
&
&(*** Modul in ModLst eintragen ***)
*
&WITH ModLst^ [ModIndex] DO
(mainMod:= LoadingMain;
(useCode:= TRUE;
(varsExported:= FALSE;
(image := ModAdr;
(mayCrunch:= (layout DIV 256) >= 2;
(IF optProcs AND NOT mayCrunch THEN
*error (clientname,mname,nooptimize);
*RETURN BadIndex
(END;
(IF noHeader AND mayCrunch THEN
*diff:= entry (image, 42) (* ganzen Header weglassen *)
(ELSE
*diff:= ImportLen (image)
(END;
(codeEnd:= entry (ModAdr, 22);
(BodyLen:= BodyLen + (codeEnd - entry (ModAdr, 6));
(varAd := VarNow;
(varLen:= entry (ModAdr, 10) - entry (ModAdr, 22);
(key   := foundkey;
(mname0:= ADDRESS (entry (ModAdr, 26)) + ModAdr;
(SplitPath (mname0^,dummys,sourcename);
(mname0:= ADDRESS (entry (ModAdr, 30)) + ModAdr;
(Assign (mname0^,name,ok);
(mname0:= ADDRESS (entry (ModAdr, 34)) + ModAdr;
(SplitPath (mname0^,dummys,symbolname);
(compopts:= LONGWORD (entry (ModAdr, 46));
(mayRemove:= NOT bit (2, compopts);
(procSym:= bit (4, layout);
(bodyMarked:= FALSE;
(useCode:= TRUE;
(crunched:= FALSE;
(ImpIndex:= 0;
(ImpLst:= NIL;
(varNow:= varNow + varlen;
(IF isCLinkMod (ModIndex) THEN
*WriteMod (ModIndex, conc ('', name), fname);
(ELSE
*WriteMod (ModIndex, name, fname);
(END;
&END;
&LoadingMain:= FALSE;
&RETURN ModIndex;
$END LoadMod;
 
 
"PROCEDURE ImportMods (myIndex: tIndex): Boolean;
"
$VAR ReqKey: LongCard;
)ImPtr: address;
'ImIndex: tIndex;
,ok: boolean;
-i: cardinal;
 
$BEGIN
&WITH ModLst^ [myIndex] DO
((* Anzahl der importierten Module bestimmen *)
((* und entspr. Speicher allozieren          *)
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(ReqKey:= entry (ImPtr, 0);         (* importiertes Modul *)
(i:= 2;
(WHILE ReqKey # 0L DO
*inc (ImPtr, 4);
*SkipStr (ImPtr);
*SkipImpList (ImPtr);
*inc(i);
*ReqKey:= entry (ImPtr, 0)
(END; (* alle Importe abgearbeitet *)
(ALLOCATE (ImpLst, LONG (i) * TSIZE (tIndex));
(IF ImpLst = NIL THEN
*error (clientname,name,nospace)
(END;
 
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(ReqKey:= entry (ImPtr, 0);         (* importiertes Modul *)
(ok:= true;
(WHILE (ReqKey # 0L) & ok DO
*inc (ImPtr, 4);
*ImIndex:= ExecMod (getstr (ImPtr), ReqKey, myIndex);
*IF ImIndex # BadIndex THEN
,SkipImpList (ImPtr);
,inc(ImpIndex);
,ImpLst^[ImpIndex]:= ImIndex
*ELSE
,ok:= false
*END;
*ReqKey:= entry (ImPtr, 0)
(END; (* alle Importe abgearbeitet *)
&END;
&RETURN ok
$END ImportMods;
"
"VAR s1,s2: tModName;
"
"BEGIN (* of ExecMod *)
$IF codesuffix THEN
&paths:= ImpPaths;
&ConcatName (mname, DefImpInSuf, fname)
$ELSE
&fname:= mname;
&SplitFileName (fname, mname, s1);
&Upper (s1);
&IF StrEqual (s1,DefImpInSuf) THEN
(paths:= ImpPaths
&ELSE
(paths:= ModPaths
&END
$END;
$codesuffix:= true;
$
$i:= LoadMod (mname, fname);
$IF i # BadIndex THEN (* Load war erfolgreich *)
&RETURN i
$ELSE (* Load ist schiefgegangen *)
&RETURN BadIndex
$END
"END ExecMod;
 
 
 
 (*$L-,R-*)
 PROCEDURE PutIntoRelTab ( v: longcard );
"(* VAR d:longcard; *)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(TST.L   firstRelVal
(BNE     c0
(MOVE.L  D0,firstRelVal
(BRA     e0
 c0      CMP.L   lastRelVal,D0
(BHI     c1
 jErr    CLR     (A3)+
(JMP     RelError                ; Programmende
 c1      MOVE.L  D0,D1
(SUB.L   lastRelVal,D1
(
(MOVE.L  pRelTab,A0
 l1      CMPA.L  eRelTab,A0
(BCC     jErr                    ; Listenberlauf
(CMPI.L  #256,D1
(BCS     c2
(MOVE.B  #1,(A0)+
(SUBI.L  #254,D1
(BRA     l1
 c2      MOVE.B  D1,(A0)+
(MOVE.L  A0,pRelTab
 
 e0      MOVE.L  D0,lastRelVal
$END
"END PutIntoRelTab;
 (*$L+,R+*)
 
 
 (*
!* Globale Vars:
!*)
 VAR    ListTop: POINTER TO ARRAY [1..100000] OF pLONG;
'ListBeg: POINTER TO ARRAY [1..100000] OF pLONG;
%ListIndex: cardinal;
&LastDrop: pLONG;
)eoLists, Lists: pLONG;
 
 
 PROCEDURE dialog(): Boolean;
 
"(*$R-*)
"PROCEDURE ClrList;
$VAR i : cardinal;
$BEGIN
&FOR i:= 1 TO ListIndex DO
(ListTop^[i]:= NIL
&END;
&ListIndex:= 0;
&LastDrop:= Lists
$END ClrList;
 
"(*$R-,L-*)
"PROCEDURE SmallestInList() : LONGCARD;
$BEGIN
&ASSEMBLER
(MOVEQ   #-1,D0
(CLR.W   D1
(MOVEQ   #1,D2
&forloop0
(CMP     listIndex,D2
(BHI     forend0
(MOVE    D2,D3
(SUBQ    #1,D3
(ASL     #2,D3
(MOVE.L  ListTop,A0
(MOVE.L  0(A0,D3.W),A1
(CMPA.L  #NIL,A1
(BEQ     cont0
(MOVE.L  (A1),D4
(CMP.L   D4,D0
(BLS     cont0
(MOVE.L  D4,D0
(MOVE    D2,D1
&cont0
(ADDQ    #1,D2
(BRA     forloop0
&forend0
(TST     D1
(BEQ     ende
(SUBQ    #1,D1
(ASL     #2,D1
(MOVE.L  ListTop,A0
(MOVE.L  0(A0,D1.W),D2
(MOVE.L  ListBeg,A1
(CMP.L   0(A1,D1.W),D2
(BNE     cont1
(CLR.L   0(A0,D1.W)
(BRA     cont2
&cont1
(SUBQ.L  #4,0(A0,D1.W)
&cont2
(RTS
&ende
(CLR.L   D0
&END
$END SmallestInList;
"
"(*$R-,L+*)
"PROCEDURE reloc (myMod, imMod: ptrModDesc; VAR ImPtr: ADDRESS; VAR ok: BOOLEAN);
$BEGIN
&ASSEMBLER
(MOVEM.L D3/D4/D6/A4/A5,-(A7)
 
(MOVE.L  myMod(A6),A4
(MOVE.L  tModDesc.image(A4),A4   ;^ zu relozierendes Modul
(
(MOVE.L  ImPtr(A6),A1
(MOVE.L  (A1),A1
(MOVEQ   #1,D6         ;noch ist alles 'ok'
(
(MOVE.L  A6,-(A7)
(MOVE.L  imMod(A6),A6            ;A6 ist ^ModLst^ [ImIndex]
(MOVE.L  tModDesc.image(A6),A2   ;A2 zeigt auf imp. Modul
!
!!RE6   MOVE.W  (A1)+,D0      ;imp. ItemNr
(BEQ.L   RE5           ;fertig mit diesem Import
(MOVE.L  18(A2),D3     ;Offset zur Exp.liste
(BEQ.L   BAD           ;keine da
(ADD.L   A2,D3
(MOVE.L  (A1)+,D1      ;importiertes Item
(BEQ     RE6           ; wird gar nicht benutzt
 
(MOVE    ListIndex,D4
(CMP.W   ListMax,D4
(BCC.W   relerr2
(ADDQ    #1,ListIndex
(MOVE.L  ListBeg,A5
(MOVE    ListIndex,D4
(SUBQ    #1,D4
(LSL     #2,D4
(CLR.L   0(A5,D4.W)
 
(MOVE.L  D3,A0
!!RE9   MOVE.W  (A0)+,D2      ;Item in Exportliste suchen
(BEQ.W   BAD           ; schade - Liste zuende
(CMP.W   D2,D0
(BEQ     RE10          ;gefunden
(ADDQ.L  #4,A0
(BRA     RE9
!!RE10  MOVE.L  (A0)+,D2      ;abs. ItemAdr ausrechnen
(BEQ     re6           ;wurde wegoptimiert
(CMP.L   22(A2),D2
(BCC     isVa2         ;das ist eine Var-Referenz
(ADD.L   tModDesc.codeAd(A6),D2 ;Prozeduren: + Modulanfang
(SUB.L   tModDesc.diff(A6),D2   ;            - Importlisten-Laenge
(BRA     RE11
!!isVa2 ADD.L   tModDesc.varAd(A6),D2  ;Variablen: + VarAnfang
(ADD.L   BSSstart,D2   ;Codelnge addieren
(SUB.L   22(A2),D2
!!RE11  CMP.L   22(A4),D1     ;liegt Ref innerhalb des Codes ?
(BCC.W   bad
(MOVE.L  0(A4,D1.L),D0 ;ItemAdr im Modul nachtragen
(MOVE.L  D2,0(A4,D1.L)
 
(MOVE.L  (A7),A6
(MOVE.L  A1,-(A7)
(MOVE.L  myMod(A6),A5
(MOVE.L  D1,D4
(ADD.L   tModDesc.codead(A5),D4
(SUB.L   tModDesc.diff(A5),D4
 
(MOVE.L  lastDrop,A5
(CMPA.L  eoLists,A5
(BCC     relerr1
(MOVE.L  D4,(A5)
(MOVE    listIndex,D4
(SUBQ    #1,D4
(ASL     #2,D4
(MOVE.L  ListTop,A1
(MOVE.L  A5,0(A1,D4.W)
(MOVE.L  ListBeg,A1
(TST.L   0(A1,D4.W)
(BNE.S   cont2
(MOVE.L  A5,0(A1,D4.W)
&cont2
(ADDQ.L  #4,lastDrop
 
(MOVE.L  (A7)+,A1
(MOVE.L  imMod(A6),A6            ;A6 ist ^ModLst^ [ImIndex]
 
(MOVE.L  D0,D1
(BNE     RE11
(BRA     RE6
 
&relerr2
(JMP     RelError2
&relerr1
(CLR     (A3)+
(JMP     RelError
 
!!bad   CLR.W   D6            ;FehlerFlag
!!RE5   MOVE.L  (A7)+,A6      ;A6 wieder reparieren
(MOVE.L  ImPtr(A6),A0
(MOVE.L  A1,(A0)
(MOVE.L  ok(A6),A0
(MOVE.W  D6,(A0)
 
(MOVEM.L (A7)+,D3/D4/D6/A4/A5
&END
$END reloc;
 
"(*$R+,L+*)
"PROCEDURE Relocate ( myIndex: tIndex ) : Boolean;
"
$VAR      v: LongCard;
)ImPtr: address;
'ImIndex: tIndex;
,ok: boolean;
-i: cardinal;
!main, importn: tModName;
(ptrMod: ptrModDesc;
(
$BEGIN
&(*** Zuerst die Var/Proc-Liste abarbeiten ***)
&
&ptrMod:= ADR (ModLst^ [myIndex]);
&Assign (ptrMod^.name, main, ok);
&ClrList;
&
&ASSEMBLER
/MOVEM.L D3/D4/D5/D6/A4/A5/A6,-(A7)
/MOVE.L  ListTop,D4
/MOVE.L  ListBeg,D5
/MOVE.W  ListIndex,D6
/MOVE    D6,D3
/SUBQ    #1,D3
/ASL     #2,D3
/MOVE.L  lastDrop,A5
/MOVE.L  ptrMod(A6),A1
 
/MOVE.L  tModDesc.image(A1),A4    ;A4 zeigt auf Modul-Bild im RAM
/MOVE.L  22(A4),A0       ;^Var/ProcListe
/ADDA.L  A4,A0
(!RE3   MOVE.L  (A0)+,D0        ;^letzte Ref
/BEQ.W   RE1             ;Ende der Liste
/
/MOVE.L  (A0)+,D1        ;rel. Adresse
/BEQ     re3             ;wurde wegoptimiert
 
/CMP.W   ListMax,D6      ;ListIndex
/BCC.W   relerr2b
/ADDQ    #1,D6           ;ListIndex
/ADDQ    #4,D3
/MOVE.L  D5,A6
/CLR.L   0(A6,D3.W)
 
/CMP.L   22(A4),D1
/BCC     isVar           ;das ist eine Var-Referenz
/ADD.L   tModDesc.codeAd(A1),D1   ;Prozeduren: + Modulanfang
/SUB.L   tModDesc.diff(A1),D1     ;            - Importlisten-Laenge
/BRA     RE2
(!isVar ADD.L   tModDesc.varAd(A1),D1    ;Variablen: + VarAnfang
/ADD.L   BSSstart,D1     ;Codelnge addieren
/SUB.L   22(A4),D1
(!RE2   CMP.L   22(A4),D0       ;liegt Ref innerhalb des Codes ?
/BCC.S   bad2
/MOVE.L  0(A4,D0.L),D2   ;^naechste Ref
/MOVE.L  D1,0(A4,D0.L)   ;Adresse eintragen
 
/ADD.L   tModDesc.codead(A1),D0
/SUB.L   tModDesc.diff(A1),D0
 
/CMPA.L  eoLists,A5
/BCC.S   relerr
/MOVE.L  D0,(A5)
/MOVE.L  D4,A6
/MOVE.L  A5,0(A6,D3.W)
/MOVE.L  D5,A6
/TST.L   0(A6,D3.W)
/BNE.S   cont
/MOVE.L  A5,0(A6,D3.W)
-cont
/ADDQ.L  #4,A5
 
/MOVE.L  D2,D0
/BNE     RE2             ;weitere Refs auf dieses Objekt
/BRA     RE3             ;pruefe, ob weitere Objekte
 
-relerr
/CLR     (A3)+
/JMP     RelError
-relerr2b
/JMP     RelError2
 
(!bad2
/MOVE.W  D6,ListIndex
/MOVE.L  A5,lastDrop
/MOVEM.L (A7)+,D3/D4/D5/D6/A4/A5/A6
/END; error ('',main,relocerr); ASSEMBLER
/BRA     RE0
 
(!RE1   MOVE.L  A5,lastDrop
/MOVE.W  D6,ListIndex
/MOVEM.L (A7)+,D3/D4/D5/D6/A4/A5/A6
)RE0
&END;
 
((*** Jetzt kmmern wir uns um die Importe ***)
&
&WITH ptrMod^ DO
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(i:= 1;
(ok:= TRUE;
(WHILE ( i <= ImpIndex ) & ok DO
*inc (ImPtr, 4);
*Skipstr (ImPtr); (* ImPtr hinter Namen setzen *)
*ImIndex:= ImpLst^[i];
*Assign (ModLst^ [ImIndex].name, importn, ok);
*reloc (ptrMod, ADR (ModLst^ [ImIndex]), ImPtr, ok);
*IF ~ok THEN error (importn,main,relocerr) END;
*inc(i)
(END; (* alle Importe abgearbeitet *)
&END; (* with ModLst^ [myIndex] *)
 
&(* Alle f. dieses Modul relozierten Adressen in RelTab eintragen *)
&
&v:= SmallestInList();
&WHILE v # 0L DO
(PutIntoRelTab(v);
(v:= SmallestInList()
&END;
&
&RETURN ok
$END Relocate;
 
 
"PROCEDURE setCodeAd;
$VAR i: tIndex;
$BEGIN
&FOR i:= 1 TO ModIndex DO
(WITH ModLst^ [i] DO
*IF useCode THEN
,modlen:= codeEnd - diff;
,codeAd:= CodeNow;
,CodeNow:= CodeNow + modlen
*ELSE
,ClearMod (i);
,DEC (UsedCodes);
,DEC (UsedInits);
,modlen:= 0
*END
(END
&END;
$END setCodeAd;
 
 
"PROCEDURE AnotherMod ():BOOLEAN;
$VAR c:CHAR;
$BEGIN
&Prompt (1, 'Another module (Y/N) ? ');
&REPEAT
(Read (c);
(c:=CAP(c);
&UNTIL (c='Y') OR (c='N') OR (c=33C) OR (c=15C);
&RETURN (c='Y') OR (c=15C)
$END AnotherMod;
"
"VAR    i,j: cardinal;
*ln: INTEGER;
%DriveNr: Cardinal;
'VolNr: Cardinal;
)len: Cardinal;
+f: file;
%ModName: string;
&outsuf: String;
+s: string;
$outFirst: boolean;
%inFirst: boolean;
(argc: CARDINAL;
(argv: ARRAY [0..9] OF PtrArgStr;
%modIdx2: tIndex;
$firstMod: BOOLEAN;
#linkCount: CARDINAL;
%gotLast: BOOLEAN;
%tabSize: LONGCARD;
$l, avail: LONGINT;
%outName: string;                    (* Name des Codefiles *)
 
"BEGIN (* of Dialog *)
$optProcs:= FALSE;
$noHeader:= FALSE;
$noShModLst:= FALSE;
$noProcSyms:= FALSE;
$outname:= '';
$HeaderFlags:= {};
$InitArgCV (argc,argv);
$FOR i:= 1 TO argc-1 DO
&Assign (argv[i]^, s, ok);
&Upper (s);
&IF (s[0] = '-') OR (s[0] = '/') THEN
(CASE s[1] OF
(| '0'..'9':
,j:= 1;
,INCL (HeaderFlags, StrConv.StrToCard (s,j,ok));
(| 'R':
,j:= 2;
,j:= StrConv.StrToCard (s,j,ok);
,IF j >= 100 THEN ListMax:= j END;
(| 'H':
,optProcs:= TRUE;
(| 'F':
,optProcs:= TRUE;
,noHeader:= TRUE;
,noShModLst:= TRUE;
,noProcSyms:= TRUE;
(| 'M':
,noProcSyms:= TRUE;
(| 'V':
,VerboseOutput;
(| 'O':
,IF s[2] # 0C THEN
.(* Output name directly appended *)
.INC (argv[i], 2);
.FastStrings.Assign (argv[i]^, outname);
,ELSIF i < argc-1 THEN
.(* Output name in next word *)
.FastStrings.Assign (argv[i+1]^, outname);
,END
(ELSE
*ReportError (conc ('Illegal option character: ', s[1]));
(END;
(argv[i]^[0]:= 0C
&END
$END;
$ClearEOP;
$
$CodeNow:= 18 + LENGTH (CodeID) + 1 + SysVarSpace;
F(* Platz fuer Start-LEA's/JMP und PDB *)
$VarNow:= 0L;
$BodyLen:= 0;
$
$ModIndex:= 0;
$modIdx2:=0;
$firstMod:= TRUE;
$linkCount:= MIN (LLRange);
$gotLast:= FALSE;
$LOOP
&inFirst:= TRUE;
&REPEAT
(Prompt (1, 'Module name? ');
(ReadString (ModName);
(inFirst:= FALSE;
(IF length (ModName) = 0 THEN
*Remove (outfile);
*RETURN false
(ELSIF NOT hasSuffix (ModName) THEN
*ConcatName (modname, DefPrgInSuf, modname);
(END;
(DiscardMods (modIdx2);
(Report (1, 'Module name: ');
(WriteString (ModName);
(IF firstMod THEN
*singleMod:= TRUE;
*InitIndex:= 0;
*ClearEOP;
(END;
((* Release geladene Moduln: *)
(WHILE ModIndex # modIdx2 DO
*DeAllocate (ModLst^ [ModIndex].ImpLst,0L);
*DeAllocate (ModLst^ [ModIndex].image,0L);
*DEC (ModIndex)
(END;
(LoadingMain:= TRUE;
(CodeSuffix:= false
&UNTIL ExecMod (modname, anykey, BadIndex) # BadIndex;
&IF firstMod THEN
(InitIdx2:= InitIndex
&END;
&IF (argc>=2) & gotLast THEN
(EXIT
&END;
&IF (argc<2) & ~AnotherMod () THEN
(EXIT
&END;
&modIdx2:= ModIndex;
&firstMod:= FALSE
$END;
$
$(* Alles geladen, nun kann alles reloziert werden *)
$
$Vergleiche;
$
$HALT;
$RETURN TRUE
"END dialog;
 
 VAR dummy: PDB;
$ch: CHAR;
 
 BEGIN (* ROMLoad *)
"IF SIZE (dummy.ModLst^[1]) # ShModLstSpace THEN HALT END;
"IF TSIZE (PDB) # SysVarSpace THEN HALT END;
"IF NOT ODD (LENGTH (CodeID)) THEN HALT END;
"
"IF LinkerParm.maxLinkMod >= (MAX (tIndex)-1) THEN
$LinkerParm.maxLinkMod:= MAX (tIndex)-2
"END;
"IF LinkerParm.maxLinkMod = 0 THEN LinkerParm.maxLinkMod:= 100 END;
"ListMax:= 1000;
"
"InitOutput (LinkerParm.maxLinkMod, conc ('Megamax Modula-2 Linker ',version));
"
"HomePath:= ShellPath; 
"
"ALLOCATE (ModLst, TSIZE (tModDesc) * LONG (LinkerParm.maxLinkMod+2));
"ALLOCATE (InitLst, TSIZE (tIndex) * LONG (LinkerParm.maxLinkMod+2));
"IF (ModLst = NIL) OR (ModLst = NIL) THEN
$ReportError ('Out of memory');
$TermProcess (MOSGlobals.OutOfMemory)
"END;
"DefPrgInSuf:= DftSfx;
"DefImpInSuf:= ImpSfx;
"RelocTab:= NIL;
"pRelTab:= NIL;
"firstRelVal:= 0L;
"lastRelVal:= 0L;
"realForm:= 0;
"extendedCode:= FALSE;
"IF dialog() THEN
"END;
 END CmpMods2.
  
(* $FFF20C02$FFF698A3$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFE7FB26$FFFD709E$FFFD709E$FFFD709E$FFFD709E$00006FEC$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFF6AA4D$FFE7FB26$FFFD709E$FFE7FB26$FFFD709E$FFE7FB26$FFFD709E$FFFD709E$00002111$FFFD709E$FFF6AAC9$FFFD709E$FFE7FB26$FFFD709E$FFFD709E$FFFD709E$00003171T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000030BD$0000317E$00003197$000031B1$000031E1$000031F1$000031FB$00003208$00000093$00000078$00003171$00003315$0000316E$000031D4$0000313F$0000314F*)
