 IMPLEMENTATION MODULE Text; (* V#107 *)
 (*$L-,R-,Y+,N+*)
 
 (*
"18.7.87:  Read setzt ch auf 0C bei Fehlern
"22.7.87:  ReadString terminiert bei Ctrl-Zeichen
"15.9.87:  Read/Write auf Units ber Treiberroutinen
"10.12.87: ReadString gibt CR/LF bei Eingabe v. CR o. LF aus
"03.01.88: Assembler-Version
"17.01.88: ReadBin neu, GetLast optimiert
"07.07.89: UndoRead wirkt auch auf ReadString
"04.08.89: Read/ReadBin/ReadString lesen bei 'readSeqTxt' nun viel schneller,
,weil ein interner Puffer verwendet wird.
"18.02.90: ReadBin liest Char nun im Seq-Mode, Read im Direct-Mode richtig
"17.12.90: ReadToken/ReadFromLine und TermCH implementiert
"31.01.91: ReadToken funktioniert nun auch auf Disk-Files
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, LONGWORD, ADDRESS, WORD;
 
 FROM FileBase IMPORT Unit, UDataProc, UCloseProc, UFlushProc, URStrProc,
(UWStrProc, UGChrProc;
 
 FROM Files IMPORT File, @CheckState, EOF, Access;
 
 FROM MOSGlobals IMPORT fInternalErr2, fEndOfFile, fBadAccess, fDoubleUndo,
(fDiskFull, fBadOp;
 
 FROM MOSConfig IMPORT Separators;
 
 (*$I FileDesc.Icl *)
 
 (*$O+*)
 TYPE File = POINTER TO FileDesc;
 (*$O-*)
 
 
 PROCEDURE ErrHandler;
"BEGIN
$ASSEMBLER
(; File in A0
(MOVE.L  A0,(A3)+
(JMP     @CheckState
$END
"END ErrHandler;
 
 PROCEDURE ErrHdl2;
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A3
(MOVE.L  A0,D0
(BEQ     T0
(CLR.W   File.state(A0)
%T0
$END
"END ErrHdl2;
 
 PROCEDURE EOL (f: File): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(BEQ     TR
(MOVE.L  D0,A0
(CMPI    #readSeqTxt,File.accmode(A0)
(BEQ     T0
(MOVE    #fBadOp,File.state(A0)
(JSR     ErrHandler
(JSR     ErrHdl2
%TR MOVE    #1,(A3)+
(RTS
%T0 TST     File.eol(A0)
(BNE     TR
(MOVE.L  A0,(A3)+
(JMP     EOF
$END
"END EOL;
 
 
 PROCEDURE reloadBuffer ();
"BEGIN
$ASSEMBLER
(; IN:  A0:f
(; RET: D0.W:state
 
(MOVEM.L A0/A1,-(A7)
(MOVE.L  File.buffer(A0),-(A7)
(MOVEQ   #0,D0
(MOVE.W  File.bufsize(A0),D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVEM.L (A7)+,A0/A1
(TST.L   D0
(BMI     error
(
(MOVE.W  D0,File.bufsize(A0)
(CLR.W   File.bufpos(A0)
(; !!! was ist, wenn Null Zeichen gelesen wurden - wird solch ein
(;     EOF schon vorher erkannt?
(CLR     D0
 
&error
$END
"END reloadBuffer;
 
 PROCEDURE getBufChar ();
"BEGIN
$ASSEMBLER
(; IN:  A0:f
 
(MOVE.W  File.bufpos(A0),D0
(CMP.W   File.bufsize(A0),D0
(BNE     cont
(JSR     reloadBuffer
(BNE     error                   ; D0.W enthlt neg. Fehlercode
&cont
(MOVE.L  File.buffer(A0),A2
(MOVE.B  0(A2,D0.W),D0
(ADDQ    #1,File.bufpos(A0)
&error
$END
"END getBufChar;
 
 
 PROCEDURE Read0 (VAR c:CHAR;f:File): BOOLEAN;  (* TRUE = Zeichen gltig *)
"(*
#* state # 0  ? -->   Err / FALSE
#* eof        ? -->   Err / FALSE
#* pos = len  ? --> binarymode ? --> ja: Err / FALSE; nein: FALSE
#* readerror  ? -->   FALSE
#* sonst TRUE
#*)
"BEGIN
$ASSEMBLER
(; A0: f, A1: c, D1 liefert BOOLEAN
(
(TST     File.state(A0)
(BMI.L   errerr
(
(TST     File.eof(A0)
(BNE.L   erreof
(
(TST     File.eol(A0)
(BEQ     again
(MOVEM.L A0/A1,-(A7)
(MOVE.L  A0,(A3)+
(JSR     ReadLn
(MOVEM.L (A7)+,A0/A1
(
&again
(TST     File.ondisk(A0)
(BEQ     isunit
 
(; von Disk lesen
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCC.L   eof
 
(MOVE.B  File.lastch(A0),-(A7)
 
(TST.L   File.buffer(A0)
(BNE     bufRead
 
(MOVEM.L A0/A1,-(A7)
(PEA     File.lastch(A0)
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVEM.L (A7)+,A0/A1
(TST.L   D0
(BMI     err2
(MOVE.B  File.lastch(A0),D0
(BRA.W   diskok
 
&bufRead
(JSR     getBufChar      ; Char in D0
(TST.W   D0
(BPL     readok
 
&err2
(MOVE.B  (A7)+,File.lastch(A0)
(MOVE    D0,File.state(A0)
(MOVEQ   #0,D1                   ; non-fatal error, Zeichen ungltig
(CLR.B   (A1)                    ; ch:= 0C
(BRA.L   end
 
&isunit
(MOVE.B  File.lastch(A0),-(A7)
(MOVEM.L A0/A1,-(A7)
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  File.urdchr(A0),A0
(JSR     (A0)
(MOVEM.L (A7)+,A0/A1
(MOVE    -(A3),D0
(BMI     err2
(MOVE.B  D0,File.lastch(A0)
(BRA     ok
$
'erreof
(MOVE    #fEndOfFile,D0
'err
(MOVE    D0,File.state(A0)
'errerr
(; ------------------ fatal error --------------
(MOVE.L  A0,(A3)+
(CLR.B   (A1)                    ; ch:= 0C
(MOVEM.L A0/A1,-(A7)
(JSR     ErrHandler
(JSR     ErrHdl2
(MOVEM.L (A7)+,A0/A1
(CLR     (A3)+                   ; Abbruch
(RTS
 
'errint2
(MOVE    #fInternalErr2,D0
(BRA     err
(
'eof
(BHI     errint2
(CMPI    #2,File.accmode(A0)     ; BINARY MODE ?
(BLS     erreof                  ; Ja, dann schon Error
(MOVE    #1,File.eof(A0)         ; sonst erstmal nur Flag setzen
(MOVE    #2,File.state(A0)
(CLR     D0
(MOVEQ   #0,D1                   ; Zeichen ungltig
(BRA     ok2
(
'readok
(MOVE.B  D0,File.lastch(A0)
'diskok
(ADDQ.L  #1,File.pos(A0)         ; Zeichen gelesen, also pos erhhen
H; (wird bei Units sowieso ignoriert)
(CLR     D1                      ; kommt gleich nach File.state...
 
'ok
(MOVE    D1,File.state(A0)
(ADDQ.L  #2,A7                   ;MOVE.B  (A7)+,File.prevch(A0)
(MOVEQ   #1,D1                   ; Zeichen gltig
(CMPI    #2,File.accmode(A0)     ; Binrmodus ?
(BLS     ok2                     ; ja-> kein EOL- und EOF-Test
(
(CMPI.B  #13,D0
(BEQ     eol
(CMPI.B  #10,D0
(BNE     ok0
(TST     File.skipLF(A0)
(BEQ     eol
(CLR     File.skipLF(A0)
(BRA     again
'eol
(MOVE    #1,File.eol(A0)         ; lastch wird das EOL-Zeichen enthalten
(MOVE    #1,File.state(A0)
(MOVEQ   #0,D1                   ; Zeichen ungltig
(CLR     D0
(
'ok0
(TST     File.chkeof(A0)
(BEQ     ok2                     ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BNE     ok2
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
(MOVEQ   #0,D1                   ; Zeichen ungltig
(CLR     D0
(
'ok2
(MOVE.B  D0,(A1)
(
'end
$END
"END Read0;
 
 
 PROCEDURE Read0Bin (VAR c:CHAR;f:File): BOOLEAN;  (* TRUE = Zeichen gltig *)
"(*
#* state # 0  ? -->   Err / FALSE
#* eof        ? -->   Err / FALSE
#* pos = len  ? --> binarymode ? --> ja: Err / FALSE; nein: FALSE
#* readerror  ? -->   FALSE
#* sonst TRUE
#*)
"BEGIN
$ASSEMBLER
(; A0: f, A1: c, D1 liefert BOOLEAN
(
(TST     File.state(A0)
(BMI.L   errerr
(
(TST     File.eof(A0)
(BNE.L   erreof
(
(TST     File.ondisk(A0)
(BEQ     isunit
(
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCC.L   eof
 
(MOVE.B  File.lastch(A0),-(A7)
 
(TST.L   File.buffer(A0)
(BNE     bufRead
 
(MOVEM.L A0/A1,-(A7)
(PEA     File.lastch(A0)
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVEM.L (A7)+,A0/A1
(TST.L   D0
(BMI     err2
(MOVE.B  File.lastch(A0),D0
(BRA.W   diskok
 
&bufRead
(JSR     getBufChar      ; Char in D0
(TST.W   D0
(BPL     readok
 
&err2
(MOVE.B  (A7)+,File.lastch(A0)
(MOVE    D0,File.state(A0)
(MOVEQ   #0,D1                   ; non-fatal error, Zeichen ungltig
(CLR.B   (A1)                    ; ch:= 0C
(BRA.L   end
$
&isunit
(MOVE.B  File.lastch(A0),-(A7)
(MOVEM.L A0/A1,-(A7)
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  File.urdchr(A0),A0
(JSR     (A0)
(MOVEM.L (A7)+,A0/A1
(MOVE    -(A3),D0
(BMI     err2
(MOVE.B  D0,File.lastch(A0)
(BRA     ok
$
'erreof
(MOVE    #fEndOfFile,D0
'err
(MOVE    D0,File.state(A0)
'errerr
(; ------------------ fatal error --------------
(MOVE.L  A0,(A3)+
(CLR.B   (A1)                    ; ch:= 0C
(MOVEM.L A0/A1,-(A7)
(JSR     ErrHandler
(JSR     ErrHdl2
(MOVEM.L (A7)+,A0/A1
(CLR     (A3)+                   ; Abbruch
(RTS
(
'errint2
(MOVE    #fInternalErr2,D0
(BRA     err
(
'eof
(BHI     errint2
(CMPI    #2,File.accmode(A0)     ; BINARY MODE ?
(BLS     erreof                  ; Ja, dann schon Error
(MOVE    #1,File.eof(A0)         ; sonst erstmal nur Flag setzen
(MOVE    #2,File.state(A0)
(CLR     D0
(MOVEQ   #0,D1                   ; Zeichen ungltig
(BRA     ok2
(
'readok
(MOVE.B  D0,File.lastch(A0)
'diskok
(CLR     D1
(ADDQ.L  #1,File.pos(A0)         ; Zeichen gelesen, also pos erhhen
H; (wird bei Units sowieso ignoriert)
'ok
(MOVE    D1,File.state(A0)
(ADDQ.L  #2,A7                   ;MOVE.B  (A7)+,File.prevch(A0)
(MOVEQ   #1,D1                   ; Zeichen gltig
(
(CMPI    #2,File.accmode(A0)     ; Binrmodus ?
(BLS     ok2                     ; ja-> kein EOF-Test
(
(CLR     File.eol(A0)
(
(TST     File.chkeof(A0)
(BEQ     ok2                     ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BNE     ok2
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
H; Zeichen bleibt gltig
(
'ok2
(MOVE.B  D0,(A1)
(
'end
$END
"END Read0Bin;
 
 
 PROCEDURE GetLast (VAR c:CHAR;f:File);
"BEGIN
$ASSEMBLER
(; A0: f, A1: c
(
(CMPI    #2,File.accmode(A0)
(BLS     noget                   ; Bei Binrmodus nur Flag lschen
(MOVE.B  File.lastch(A0),D0
(CMPI.B  #13,D0
(BEQ     eol
(CMPI.B  #10,D0
(BNE     ok
&eol
(MOVE    #1,File.eol(A0)
(MOVE    #1,File.state(A0)
(CLR     D0
(BRA     ok2
&ok
(TST     File.chkeof(A0)
(BEQ     ok2                     ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BNE     ok2
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
(CLR     D0
&ok2
(MOVE.B  D0,(A1)
&noget
(CLR     File.getlast(A0)
$END
"END GetLast;
 
 
 PROCEDURE GetLastBin (VAR c:CHAR;f:File);
"BEGIN
$ASSEMBLER
(; A0: f, A1: c
(
(CMPI    #2,File.accmode(A0)
(BLS     noget                   ; Bei Binrmodus nur Flag lschen
(MOVE.B  File.lastch(A0),D0
(TST     File.chkeof(A0)
(BEQ     ok2                     ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BNE     ok2
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
&ok2
(MOVE.B  D0,(A1)
&noget
(CLR     File.getlast(A0)
$END
"END GetLastBin;
 
 
 PROCEDURE wr (f:File;c:CHAR);
"BEGIN
$ASSEMBLER
(; c IN D0, f in A0; A1 nicht zerstren
(MOVEM.L A0/A1,-(A7)
(MOVE.B  D0,-(A7)
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  A7,(A3)+
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE.L  A7,(A3)+
(MOVE.L  File.uwrite(A0),A0
(JSR     (A0)
(ADDQ.L  #6,A7
(MOVEM.L (A7)+,A0/A1
(MOVE    -(A3),File.state(A0)
$END
"END wr;
"
 
 PROCEDURE Read (f: File; VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),A1
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(TST     File.getlast(A0)
(BEQ     T0
(JSR     GetLast
(BRA     E0
%T0 JSR     Read0
(BRA     E0
%E1 CLR.B   (A1)
%E0 UNLK    A5
$END;
"END Read;
 
 
 PROCEDURE ReadBin (f: File; VAR ch: CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),A1
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(TST     File.getlast(A0)
(BEQ     T0
(JSR     GetLastBin
(BRA     E0
%T0 JSR     Read0Bin
(BRA     E0
%E1 CLR.B   (A1)
%E0 UNLK    A5
$END;
"END ReadBin;
 
 
 PROCEDURE UndoRead (f: File);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -4(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(MOVE.L  -(A3),A0
(TST     File.getlast(A0)
(BEQ     T0
(MOVE    #fDoubleUndo,File.state(A0)
(JSR     ErrHandler
(JSR     ErrHdl2
(UNLK    A5
(RTS
%T0 CMPI    #3,File.accmode(A0)
(BCC     T1
(
(MOVE.L  A0,-(A7)
(MOVE.W  #1,-(A7)
(MOVE.W  File.handle(A0),-(A7)
(MOVEQ   #-1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$42,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
(MOVE.L  (A7)+,A0
(TST.L   D0
(BPL.L   noErr
(MOVE    D0,File.state(A0)
(UNLK    A5
(RTS
&noErr:
(MOVE.L  D0,File.pos(A0)
(
%T1 CLR     File.eof(A0)
(CLR     File.eol(A0)
(ADDQ.W  #1,File.getlast(A0)
(UNLK    A5
(RTS
%E1 SUBQ.L  #4,A3
(UNLK    A5
$END
"END UndoRead;
 
 
 PROCEDURE diskRead;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren !
(BRA     diskLoop
 
%err2
(MOVE    D0,File.state(A0)       ; non-fatal error
(
%E0 RTS
(
%nfeof
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
(RTS
(
%eof
(BHI     errint2
(CMPI    #2,File.accmode(A0)     ; BINARY MODE ?
(BHI.L   nfeof
%erreof
(MOVE    #fEndOfFile,D0
%err
(MOVE    D0,File.state(A0)
%errerr
(MOVE.L  A0,(A3)+
(JSR     ErrHandler              ; fatal error
(JMP     ErrHdl2
(
%errint2
(MOVE    #fInternalErr2,D0
(BRA     err
(
%diskLoop:
(MOVE    4(A7),D0
(CMP     6(A7),D0        ; index > HIGH (str) ?
(BHI     E0              ; dann ist String voll
(
(TST     File.state(A0)
(BMI     errerr
(
(TST     File.eof(A0)
(BNE     erreof
(
(TST     File.eol(A0)
(BEQ     again
(
(MOVEM.L A0/A1,-(A7)
(MOVE.L  A0,(A3)+
(JSR     ReadLn
(MOVEM.L (A7)+,A0/A1
(
&again
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCC     eof
(
(TST.L   File.buffer(A0)
(BEQ     singleRead
 
(JSR     getBufChar
(TST.W   D0
(BMI     err2
(MOVE.B  D0,(A1)
(BRA     diskok
 
&singleRead
(MOVE.L  A0,-(A7)        ; f retten
(MOVE.L  A1,-(A7)        ; ADR(str) als Read-Adr
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A1
(MOVE.L  (A7)+,A0
(TST.L   D0
(BMI     err2
 
(MOVE.B  (A1),D0
 
&diskok
(CLR     File.state(A0)
(ADDQ.L  #1,File.pos(A0)
(MOVE.B  D0,File.lastch(A0)
(
(CMPI    #2,File.accmode(A0)     ; Binrmodus ?
(BLS     valid                   ; ja-> kein EOL- und EOF-Test
(
(CMPI.B  #13,D0
(BEQ     eol
(CMPI.B  #10,D0
(BNE     ok0
(TST     File.skipLF(A0)
(BEQ     eol
(CLR     File.skipLF(A0)
(BRA     again
'eol
(MOVEQ   #1,D0
(MOVE    D0,File.eol(A0)         ; lastch wird das EOL-Zeichen enthalten
(MOVE    D0,File.state(A0)
(RTS
(
'doBS
(TST     4(A7)
(BEQ     diskLoop
(SUBQ    #1,4(A7)
(SUBQ    #1,A1
(BRA     diskLoop
(
'ok0
(TST     File.chkeof(A0)
(BEQ     valid                   ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BEQ     nfeof
(
&valid
(CMPI.B  #8,D0           ; Backspace ?
(BEQ     doBS
(ADDQ    #1,4(A7)        ; index
(ADDQ.L  #1,A1
(CMPI.B  #' ',D0
(BCC     diskLoop
(; Ende bei Ctrl-Zeichen
$END;
"END diskRead;
 
 PROCEDURE unitRead;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren !
%loop
(MOVE    4(A7),D0
(CMP     6(A7),D0        ; index > HIGH (str) ?
(BHI     E0              ; dann ist String voll
(
(JSR     Read0
(TST     D1
(BEQ     E0
(
(MOVE.B  (A1),D0
(CMPI.B  #8,D0
(BEQ     DOBS
(CMPI.B  #' ',D0
(BCS     E0
&NORM
(ADDQ.L  #1,A1
(ADDQ    #1,4(A7)
(BRA     loop
&DOBS
(TST     4(A7)
(BEQ     loop
(SUBQ.L  #1,A1
(SUBQ    #1,4(A7)
(BRA     loop
%E0
$END
"END unitRead;
 
 PROCEDURE ReadString (f: File; VAR str: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -10(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(
(MOVE.W  -(A3),-(A7)     ; HIGH(str)
(MOVE.L  -(A3),A1        ; str
(MOVE.L  -(A3),A0        ; f
(
(TST     File.eof(A0)
(BEQ     noeof
(
(CLR.B   (A1)
(MOVE    #fEndOfFile,File.state(A0)
(JSR     ErrHandler
(JSR     ErrHdl2
(UNLK    A5
(RTS
(
%E1 SUBQ.L  #2,A3
(MOVE.L  -(A3),A0
(CLR.B   (A0)
(SUBQ.L  #4,A3
(UNLK    A5
(RTS
(
%noeof:
(CLR     -(A7)           ; index
(
(TST     File.getlast(A0)
(BEQ     noLast
(JSR     GetLast
(ADDQ.W  #1,(A7)         ; INC (index)
(ADDQ.L  #1,A1
%noLast:
 
(TST     File.ondisk(A0)
(BEQ     isunit
(
(JSR     diskRead
(BRA     E0
(
%isunit
(JSR     unitRead
(
%E0 ; String mit Null abschlieen
(MOVE    (A7)+,D0        ; index
(MOVE    (A7)+,D1        ; HIGH
(CMP     D1,D0
(BHI     E2
(CLR.B   (A1)
%E2 UNLK    A5
$END
"END ReadString;
 
 
 PROCEDURE diskReadFrom;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren !
(BRA     diskLoop
 
%err2
(MOVE    D0,File.state(A0)       ; non-fatal error
(
%E0 RTS
(
%nfeof
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
(RTS
(
%eof
(BHI     errint2
(CMPI    #2,File.accmode(A0)     ; BINARY MODE ?
(BHI.L   nfeof
%erreof
(MOVE    #fEndOfFile,D0
%err
(MOVE    D0,File.state(A0)
%errerr
(MOVE.L  A0,(A3)+
(JSR     ErrHandler              ; fatal error
(JMP     ErrHdl2
(
%errint2
(MOVE    #fInternalErr2,D0
(BRA     err
(
%diskLoop:
(MOVE    4(A7),D0
(CMP     6(A7),D0        ; index > HIGH (str) ?
(BHI     E0              ; dann ist String voll
(
(TST     File.state(A0)
(BMI     errerr
(
(TST     File.eof(A0)
(BNE     erreof
(
(TST     File.eol(A0)
(BEQ     again
(
(MOVEM.L A0/A1,-(A7)
(MOVE.L  A0,(A3)+
(JSR     ReadLn
(MOVEM.L (A7)+,A0/A1
(
&again
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCC     eof
(
(TST.L   File.buffer(A0)
(BEQ     singleRead
 
(JSR     getBufChar
(TST.W   D0
(BMI     err2
(MOVE.B  D0,(A1)
(BRA     diskok
 
&singleRead
(MOVE.L  A0,-(A7)        ; f retten
(MOVE.L  A1,-(A7)        ; ADR(str) als Read-Adr
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A1
(MOVE.L  (A7)+,A0
(TST.L   D0
(BMI     err2
 
(MOVE.B  (A1),D0
 
&diskok
(CLR     File.state(A0)
(ADDQ.L  #1,File.pos(A0)
(MOVE.B  D0,File.lastch(A0)
(
(CMPI    #2,File.accmode(A0)     ; Binrmodus ?
(BLS     valid                   ; ja-> kein EOL- und EOF-Test
(
(CMPI.B  #13,D0
(BEQ     eol
(CMPI.B  #10,D0
(BNE     ok0
(TST     File.skipLF(A0)
(BEQ     eol
(CLR     File.skipLF(A0)
(BRA     again
'eol
(MOVEQ   #1,D0
(MOVE    D0,File.eol(A0)         ; lastch wird das EOL-Zeichen enthalten
(MOVE    D0,File.state(A0)
(RTS
(
'doBS
(TST     4(A7)
(BEQ     diskLoop
(SUBQ    #1,4(A7)
(SUBQ    #1,A1
(BRA     diskLoop
(
'ok0
(TST     File.chkeof(A0)
(BEQ     valid                   ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BEQ     nfeof
(
&valid
(CMPI.B  #8,D0           ; Backspace ?
(BEQ     doBS
(ADDQ    #1,4(A7)        ; index
(ADDQ.L  #1,A1
(BRA     diskLoop
$END;
"END diskReadFrom;
 
 PROCEDURE unitReadFrom;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren !
%loop
(MOVE    4(A7),D0
(CMP     6(A7),D0        ; index > HIGH (str) ?
(BHI     E0              ; dann ist String voll
(
(JSR     Read0
(TST     D1
(BEQ     E0
(
(MOVE.B  (A1),D0
(CMPI.B  #8,D0
(BEQ     DOBS
(ADDQ.L  #1,A1
(ADDQ    #1,4(A7)
(BRA     loop
&DOBS
(TST     4(A7)
(BEQ     loop
(SUBQ.L  #1,A1
(SUBQ    #1,4(A7)
(BRA     loop
%E0
$END
"END unitReadFrom;
 
 PROCEDURE ReadFromLine (f: File; VAR str: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -10(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(
(MOVE.W  -(A3),-(A7)     ; HIGH(str)
(MOVE.L  -(A3),A1        ; str
(MOVE.L  -(A3),A0        ; f
(
(TST     File.eof(A0)
(BEQ     noeof
(
(CLR.B   (A1)
(MOVE    #fEndOfFile,File.state(A0)
(JSR     ErrHandler
(JSR     ErrHdl2
(UNLK    A5
(RTS
(
%E1 SUBQ.L  #2,A3
(MOVE.L  -(A3),A0
(CLR.B   (A0)
(SUBQ.L  #4,A3
(UNLK    A5
(RTS
(
%noeof:
(CLR     -(A7)           ; index
(
(TST     File.getlast(A0)
(BEQ     noLast
(JSR     GetLast
(ADDQ.W  #1,(A7)         ; INC (index)
(ADDQ.L  #1,A1
%noLast:
 
(TST     File.ondisk(A0)
(BEQ     isunit
(
(JSR     diskReadFrom
(BRA     E0
(
%isunit
(JSR     unitReadFrom
(
%E0 ; String mit Null abschlieen
(MOVE    (A7)+,D0        ; index
(MOVE    (A7)+,D1        ; HIGH
(CMP     D1,D0
(BHI     E2
(CLR.B   (A1)
%E2 UNLK    A5
$END
"END ReadFromLine;
 
 
 PROCEDURE diskReadToken;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren!
(BRA     diskLoop
 
%err2
(MOVE    D0,File.state(A0)       ; non-fatal error
(
%E0 RTS
(
%nfeof
(MOVE    #1,File.eof(A0)
(MOVE    #2,File.state(A0)
(RTS
(
%eof
(BHI     errint2
(CMPI    #2,File.accmode(A0)     ; BINARY MODE ?
(BHI.L   nfeof
%erreof
(MOVE    #fEndOfFile,D0
%err
(MOVE    D0,File.state(A0)
%errerr
(MOVE.L  A0,(A3)+
(JSR     ErrHandler              ; fatal error
(JMP     ErrHdl2
(
%errint2
(MOVE    #fInternalErr2,D0
(BRA     err
(
%diskLoop:
(MOVE    6(A7),D0
(CMP     8(A7),D0        ; index > HIGH (str)?
(BHI     E0              ; dann ist String voll
(
(TST     File.state(A0)
(BMI     errerr
(
(TST     File.eof(A0)
(BNE     erreof
(
(TST     File.eol(A0)
(BEQ     again
(
(MOVEM.L A0/A1,-(A7)
(MOVE.L  A0,(A3)+
(JSR     ReadLn
(MOVEM.L (A7)+,A0/A1
(
&again
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCC     eof
(
(TST.L   File.buffer(A0)
(BEQ     singleRead
 
(JSR     getBufChar
(TST.W   D0
(BMI     err2
(MOVE.B  D0,(A1)
(BRA     diskok
 
&singleRead
(MOVE.L  A0,-(A7)        ; f retten
(MOVE.L  A1,-(A7)        ; ADR(str) als Read-Adr
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  (A7)+,A1
(MOVE.L  (A7)+,A0
(TST.L   D0
(BMI     err2
 
(MOVEQ   #0,D0
(MOVE.B  (A1),D0
 
&diskok
(ADDQ.L  #1,File.pos(A0)
(MOVE.B  D0,File.lastch(A0)
(
(CMPI    #2,File.accmode(A0)     ; Binrmodus ?
(BLS     valid                   ; ja-> kein EOL- und EOF-Test
(
(CMPI.B  #13,D0
(BEQ     eol
(CMPI.B  #10,D0
(BNE     ok0
(TST     File.skipLF(A0)
(BEQ     eol
(CLR     File.skipLF(A0)
(BRA     again
'eol
(MOVEQ   #1,D0
(MOVE    D0,File.eol(A0)         ; lastch wird das EOL-Zeichen enthalten
(MOVE    D0,File.state(A0)
(; CR & LF sind immer Separatoren
(TST.W   4(A7)           ; inWord?
(BNE     ende            ; dann Ende
(BRA     diskLoop        ; sonst ignorieren
(
&(*
'doBS
(TST     6(A7)
(BEQ     diskLoop
(SUBQ    #1,6(A7)
(SUBQ    #1,A1
(BRA     diskLoop
&*)
(
'ok0
(TST     File.chkeof(A0)
(BEQ     valid                   ; Kein EOF-Test
(CMP.B   File.eofchr(A0),D0
(BEQ     nfeof
(
&valid
(LEA     Separators,A2
(MOVE.W  D0,D2
(LSR.W   #3,D0
(BTST    D2,0(A2,D0.W)
(BEQ     isToken
(
(; Es ist ein Separator
(TST.W   4(A7)           ; inWord?
(BNE     endeOK          ; dann Ende
(BRA     diskLoop        ; sonst ignorieren
(
&isToken:
(MOVE    #1,4(A7)        ; inWord:= TRUE
(ADDQ.L  #1,A1           ; INC (destptr)
(ADDQ    #1,6(A7)        ; INC (index)
(BRA     diskLoop
(
&(* alt:
(CMPI.B  #8,D0           ; Backspace ?
(BEQ     doBS
(ADDQ    #1,6(A7)        ; index
(ADDQ.L  #1,A1
(LEA     Separators,A2
(MOVE.W  D0,D2
(LSR.W   #3,D0
(BTST    D2,0(A2,D0.W)
(BEQ     diskLoop
(; Ende bei Ctrl-Zeichen
&*)
&endeOK:
(CLR     File.state(A0)
&ende:
$END;
"END diskReadToken;
 
 PROCEDURE unitReadToken;
"BEGIN
$ASSEMBLER
(; A1 nicht zerstren!
%loop
(MOVE    6(A7),D0
(CMP     8(A7),D0        ; index > HIGH (str)?
(BHI     E0              ; dann ist String voll
(
(JSR     Read0
(TST     D1
(BEQ     E0
(
(MOVEQ   #0,D0
(MOVE.B  (A1),D0
((*
*CMPI.B  #8,D0
*BEQ     DOBS
(*)
(LEA     Separators,A2
(MOVE.W  D0,D2
(LSR.W   #3,D0
(BTST    D2,0(A2,D0.W)
(BEQ     isToken
(
(; Es ist ein Separator
(TST.W   4(A7)           ; inWord?
(BNE     E0              ; dann Ende
(BRA     loop            ; sonst ignorieren
(
&isToken:
(MOVE    #1,4(A7)        ; inWord:= TRUE
(ADDQ.L  #1,A1
(ADDQ    #1,6(A7)
(BRA     loop
((*
(DOBS
*TST     6(A7)
*BEQ     loop
*SUBQ.L  #1,A1
*SUBQ    #1,6(A7)
*BRA     loop
(*)
%E0
$END
"END unitReadToken;
 
 PROCEDURE ReadToken (f: File; VAR str: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -10(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E1
(
(MOVE.W  -(A3),-(A7)     ; HIGH(str)
(MOVE.L  -(A3),A1        ; str
(MOVE.L  -(A3),A0        ; f
(
(TST     File.eof(A0)
(BEQ     noeof
(
(CLR.B   (A1)
(MOVE    #fEndOfFile,File.state(A0)
(JSR     ErrHandler
(JSR     ErrHdl2
(UNLK    A5
(RTS
(
%E1 SUBQ.L  #2,A3
(MOVE.L  -(A3),A0
(CLR.B   (A0)
(SUBQ.L  #4,A3
(UNLK    A5
(RTS
(
%noeof:
(CLR     -(A7)           ; index
(CLR     -(A7)           ; inWord
(
(TST     File.getlast(A0)
(BEQ     noLast
(JSR     GetLast
(CLR     D0
(MOVE.B  (A1),D0
(LEA     Separators,A2
(MOVE.W  D0,D2
(LSR.W   #3,D0
(BTST    D2,0(A2,D0.W)
(BNE     noLast          ; war ein Begrenzer -> berlesen
(MOVE.W  #1,(A7)         ; inWord:= TRUE
(ADDQ.W  #1,2(A7)        ; INC (index)
(ADDQ.L  #1,A1
%noLast:
 
(TST     File.ondisk(A0)
(BEQ     isunit
(
(JSR     diskReadToken
(BRA     E0
(
%isunit
(JSR     unitReadToken
(
%E0 ; String mit Null abschlieen
(ADDQ.L  #2,A7           ; inWord
(MOVE    (A7)+,D0        ; index
(MOVE    (A7)+,D1        ; HIGH
(CMP     D1,D0
(BHI     E2
(CLR.B   (A1)
%E2 UNLK    A5
$END
"END ReadToken;
 
 PROCEDURE TermCH (f: File): CHAR;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -4(A3),(A3)+
(JSR     @CheckState
(CLR     D0
(TST     -(A3)
(BEQ     E1
(MOVE.B  File.lastch(A0),D0
%E1 MOVE.B  D0,(A3)+
(ADDQ.L  #1,A3
(UNLK    A5
$END
"END TermCH;
 
 PROCEDURE ReadLn (f: File);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),D0
(MOVE.L  D0,A0
(BEQ     EE
(CMPI    #readSeqTxt,File.accmode(A0)
(BEQ     T0
(MOVE    #fBadOp,File.state(A0)
%EE JSR     ErrHandler
(JSR     ErrHdl2
(UNLK    A5
(RTS
%T0 MOVE.L  A0,(A3)+
(JSR     EOF
(TST     -(A3)
(BNE     E0
(TST     File.eol(A0)
(BNE     T1
(MOVE.L  A0,-(A7)
(MOVE.L  A0,(A3)+
(CLR     -(A7)
(MOVE.L  A7,(A3)+
(JSR     Read
(ADDQ.L  #2,A7
(MOVE.L  (A7)+,A0
(BRA     T0
%T1 CLR     File.eol(A0)
(CMPI.B  #13,File.lastch(A0)
(SEQ     D0
(ANDI    #1,D0
(MOVE    D0,File.skipLF(A0)
%E0 UNLK    A5
$END
"END ReadLn;
 
 
 PROCEDURE write (f:File; start: ADDRESS; len: CARDINAL);
"BEGIN
$ASSEMBLER
(; A1: start, D1: len, f noch auf Heap
(JSR     @CheckState
(TST     -(A3)
(BEQ.L   end
(
(MOVE    File.accmode(A0),D0     ; CMPI    #readOnly,File.accmode(A0)
(BEQ     badAcc
(CMPI    #readSeqTxt,D0
(BEQ     badAcc
(
(TST     File.ondisk(A0)
(BEQ     isunit
(
(MOVE.L  A0,-(A7)
(MOVE.L  A1,-(A7)        ; adr
(MOVE.L  D1,-(A7)        ; len
(MOVE    File.handle(A0),-(A7)
(MOVE    #$40,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,D1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE    #1,File.modified(A0)
(TST.L   D0
(BPL     ok
(MOVE    D0,File.state(A0)
(BRA     end
(
'badAcc:
(MOVE    #fBadAccess,File.state(A0)
(MOVE.L  A0,(A3)+
(JSR     ErrHandler
(JSR     ErrHdl2
(BRA     end
(
'isunit:
(MOVE.L  A0,-(A7)
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  A1,(A3)+        ; adr
(MOVE.L  D1,-(A7)
(MOVE.L  A7,(A3)+        ; len
(MOVE.L  File.uwrite(A0),A0
(JSR     (A0)
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE    -(A3),File.state(A0)
(BRA     end
(
'ok:
(CMP.L   D0,D1
(BLS     ok2
(MOVE    #fDiskFull,File.state(A0)
(BRA     end
'ok2:
(CLR     File.state(A0)
(ADD.L   D1,File.pos(A0)
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCS     end
(MOVE.L  D0,File.len(A0)
'end:
(UNLK    A5
$END
"END write;
 
 
 PROCEDURE Write (f: File; ch: CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE    -(A3),-(A7)
(MOVE.L  A7,A1
(MOVEQ   #1,D1
(JMP     write
$END
"END Write;
 
 PROCEDURE WriteLn (f: File);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE    #$0D0A,-(A7)
(MOVE.L  A7,A1
(MOVEQ   #2,D1
(JMP     write
$END
"END WriteLn;
 
 PROCEDURE WritePg (f: File);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.B  #$0C,-(A7)
(MOVE.L  A7,A1
(MOVEQ   #1,D1
(JMP     write
$END
"END WritePg;
 
 PROCEDURE WriteString (f: File; REF str: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(
(MOVE   -(A3),D1
(MOVE.L -(A3),A1
(
(; A1: start, D1: len, f noch auf Heap
(JSR     @CheckState
(TST     -(A3)
(BEQ.L   end
(
(MOVE    File.accmode(A0),D0     ; CMPI    #readOnly,File.accmode(A0)
(BEQ     badAcc
(CMPI    #readSeqTxt,D0
(BEQ     badAcc
(
(TST     File.ondisk(A0)
(BEQ     isunit
(
(MOVE.L  A0,-(A7)
(MOVE.L  A1,-(A7)        ; adr
(
(MOVE.L A1,D0
 l       TST.B  (A1)+
(DBEQ   D1,l
(BNE    c
(SUBQ.L #1,A1
 c       MOVE.L A1,D1
(SUB.L  D0,D1
(
(MOVE.L  D1,-(A7)        ; len
(MOVE    File.handle(A0),-(A7)
(MOVE    #$40,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,D1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,A0
(MOVE    #1,File.modified(A0)
(TST.L   D0
(BPL     ok
(MOVE    D0,File.state(A0)
(BRA     end
(
'badAcc:
(MOVE    #fBadAccess,File.state(A0)
(MOVE.L  A0,(A3)+
(JSR     ErrHandler
(JSR     ErrHdl2
(BRA     end
(
'isunit:
(MOVE.L  A0,-(A7)
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  A1,(A3)+        ; adr
(MOVE    D1,(A3)+        ; HIGH
(MOVE.L  File.uwrstr(A0),A0
(JSR     (A0)
(MOVE.L  (A7)+,A0
(MOVE    -(A3),File.state(A0)
(BRA     end
(
'ok:
(CMP.L   D0,D1
(BLS     ok2
(MOVE    #fDiskFull,File.state(A0)
(BRA     end
'ok2:
(CLR     File.state(A0)
(ADD.L   D1,File.pos(A0)
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCS     end
(MOVE.L  D0,File.len(A0)
'end:
(UNLK    A5
$END
"END WriteString;
 
 END Text.
 
(* $00006702$00002DF0$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFEC6A8D$FFFD5FA4$FFFD5FA4$FFF8E766$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFC35A0$FFF8E766$FFFC37CF$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$FFFD5FA4$00000966T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00007029$00000754$00000966$00005718$00005539$00005716$0000538E$00000754$0000070E$00000A74$00000754$00000966$0000001C$FFECF630$00007029$0000001C*)
