 IMPLEMENTATION MODULE SysInfo;
 (*$X+,Y+,L-,N+*)
 
 (*
!* 17.10.90  FPU() verndert FPU-Status nicht mehr -> keine Prot-Violation
!* 30.10.90  FPUModel() liefert korrekten Wert bei 68882 im TT
!* 10.11.90  68030-Erkennung korrigiert, aber nicht getestet
!* 17.12.90  68030-Erkennung nochmals korrigiert, aber nicht getestet
!*           Besser: Bei 68030 gibt's offenbar zustzliche Register TT0/TT1.
!*           Sie sollten abgefragt werden, allerdings habe ich keinen Code
!*           fr sie!
!* 08.02.91  68030-Erkennung nochmals korrigiert und getestet.
!* 14.02.92  CallSuper/ToSuper statt Supexec wg. MinT
!* 28.02.92  GetTOSVersion korrigiert.
!* 11.04.95  68040-Erkennung f. CPU()
!*)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM MOSGlobals IMPORT Date;
 FROM CookieJar IMPORT GetCookie;
 FROM MOSSupport IMPORT CallSuper, ToSuper, ToUser;
 
 PROCEDURE UnpackDate ( d: CARDINAL ): Date;
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(
(MOVE    D0,D1
(ANDI    #$1F,D1
(MOVE    D1,(A3)+
(
(LSR     #5,D0
(MOVE    D0,D1
(ANDI    #$F,D1
(MOVE    D1,(A3)+
(
(LSR     #4,D0
(ADDI    #1980,D0
(MOVE    D0,(A3)+
$END
"END UnpackDate;
 
 PROCEDURE cpuTest;
"BEGIN
$ASSEMBLER
(MOVE.L  A7,D2
(LEA     $10,A1          ; Illegal Instruction Exc-Vektor
(MOVE.L  (A1),D1
(LEA     b(PC),A0
(MOVE.L  A0,(A1)
(MOVE.L  #68000,D0
(DC.W    $51FC           ; TRAPF
(MOVE.L  D1,(A1)
((* dieser 68030-Test klappt nicht:
*LEA     $2C,A1          ; Line F Exc-Vektor
*MOVE.L  (A1),D1
*LEA     b(PC),A0
*MOVE.L  A0,(A1)
*MOVE.L  #68020,D0
*DC.W    $F000,4300      ; PMOVE TC,D0
*MOVE.L  #68030,D0
(*)
(MOVE.L  #68030,D0
(; Erkennung der 68030 durch Aktivieren und Prfen des Data-Cache
(MOVEC   CACR,D1
(MOVE.L  D1,D2
(ORI.W   #100100000000%,D2 ; clear & enable data cache
(MOVE    SR,-(A7)
(ORI     #$0700,SR
(MOVEC   D2,CACR         ; enable data cache
(MOVEC   CACR,D2         ; read cache ctrl reg
(BTST    #8,D2           ; data cache enabled?
(BNE     e
(BSET    #15,D2          ; enable 68040 instr. cache
(MOVEC   D2,CACR         ; write cache reg
(MOVEC   CACR,D2         ; read cache ctrl reg
(MOVE.L  #68020,D0
(BTST    #15,D2
(BEQ     e
(MOVE.L  #68040,D0
&e MOVEC   D1,CACR
(MOVE    (A7)+,SR
(RTS
&b MOVE.L  D2,A7
(MOVE.L  D1,(A1)
$END
"END cpuTest;
 
 PROCEDURE CPU (): LONGCARD;
"BEGIN
$ASSEMBLER
(PEA     cpuTest
(JSR     CallSuper
(ADDQ.L  #4,A7
(MOVE.L  D0,(A3)+
$END
"END CPU;
 
 PROCEDURE Has020 (): BOOLEAN;
"BEGIN
$ASSEMBLER
(JSR     CPU
(CMPI.L  #68020,-(A3)
(SCC     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
$END
"END Has020;
 
 PROCEDURE FPU (): FPUType;
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
 
(JSR     cpuTest
(CMPI.L  #68020,D0
(BCS     noLineF
 
(; bei 68020 Line F-Test machen
(; alle Interrupts sperren, weil LineF-Vektor verbogen wird
(MOVE.L  A7,D2
(MOVE.L  $2C,D1          ; Line F emulator
(LEA     c(PC),A0
(MOVE    SR,D0
(ORI     #$0700,SR       ; TT 16.1.93 (vorher: MOVE #$2700,SR)
(MOVE.L  A0,$2C
(FNOP
(MOVE.L  D1,$2C
(MOVE    D0,SR
(MOVEQ   #internalFPU,D0
(BRA     e               ; wir haben eine FPU zur 68020 erkannt
 
&c MOVE.L  D1,$2C
(MOVE    D0,SR
(MOVE.L  D2,A7
 
&noLineF
(MOVEQ   #noFPU,D0
(MOVE.L  A7,D2
(MOVE.L  $08,D1          ; BusError-Exc-Vektor
(LEA     b(PC),A0
(MOVE.L  A0,$08
(TST.W   $FFFFFA40
(MOVEQ   #externalFPU,D0
&b MOVE.L  D2,A7
(MOVE.L  D1,$08
&e MOVE    D0,(A3)+
(
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END FPU;
 
 PROCEDURE GetTOSVersion (VAR version, revision: CARDINAL;
9VAR date: Date);
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
 
(MOVE.L  $4F2,A0           ; sysbase
(MOVEQ   #0,D0
(MOVE.B  2(A0),D0
(MOVE.L  -12(A3),A2
(MOVE.W  D0,(A2)         ; version
(MOVE.B  3(A0),D0
(MOVE.L  -8(A3),A2
(MOVE.W  D0,(A2)         ; revision
(MOVE.L  -(A3),-(A7)     ; ADR(date)
(MOVE.W  $1E(A0),(A3)+   ; Datum aus TOS-Header
(JSR     UnpackDate
(MOVE.L  (A7)+,A0
(MOVE.W  -(A3),4(A0)     ; date.year
(MOVE.L  -(A3),(A0)      ; date.day/month
(SUBQ.L  #8,A3
(
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END GetTOSVersion;
"
 PROCEDURE UseStackFrame (): BOOLEAN;
"BEGIN
$ASSEMBLER
(PEA     a(PC)
(JSR     CallSuper
(ADDQ.L  #4,A7
(MOVE    D0,(A3)+
(RTS
 
&a MOVE.L  A7,D2
(MOVE.L  $10,D1  ; Illegal Instruction Exc-Vektor
(LEA     b(PC),A0
(MOVE.L  A0,$10
(DC.W    $4AFC   ; ILLEGAL
&b MOVE.L  A7,D0
(MOVE.L  D2,A7
(SUB.L   D0,D2
(SUBQ.L  #6,D2
(SNE     D0
(ANDI    #1,D0
(MOVE.L  D1,$10
$END
"END UseStackFrame;
 
 PROCEDURE Machine (): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE.L  #$5F4D4348,(A3)+        ;"_MCH"
(CLR.L   -(A7)
(MOVE.L  A7,(A3)+
(JSR     GetCookie
(SUBQ.L  #2,A3
(MOVE.W  (A7)+,(A3)+
(ADDQ.L  #2,A7
$END
"END Machine;
 
 PROCEDURE FPUModel (): CARDINAL;
"BEGIN
$ASSEMBLER
(JSR     FPU
(MOVE    -(A3),D0
(CMPI    #2,D0           ; internal?
(BCC     gr              ; nein - dann immer 1 bei externer FPU liefern
(MOVE    D0,(A3)+
(RTS
(
%gr SUBQ.L  #4,A7
(JSR     ToSuper
 
(MOVEQ   #0,D0
(MOVE.L  A7,A0
(FSAVE   -(A7)
(CMPI.B  #$18,1(A7)
(MOVE.L  A0,A7
(SEQ     D0
(ADDQ.B  #2,D0
(MOVE    D0,(A3)+
(
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END FPUModel;
 
 END SysInfo.
 
(* $FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$000002C3$FFEF48E4$00001497$FFEF48E4$000006B9$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$FFEF48E4$000002C3T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000002C3$FFAD49B2$FFAD49B2$FFAD49B2$0000082A$00000833$000007D4$000008A8$0000087E$000008AB$0000087A$000008A8$00000866$000008A8$0000029F$000002A9*)
