DEFINITION MODULE Granule;

(*
 * Dieses Modul ist eine alternative Speicherverwaltung zu Storage.
 * Der Vorteil ist, da sie fr Blcke in 16-Byte-Portionen optimiert
 * ist und fast keinen Verwaltungs-Overhead hat.
 *
 * Sie ist u.U. auch schneller als Storage. Allerdings erkennt sie
 * nicht, welche Blcke zusammengehren - das Anwendungsprogramm mu
 * selbst genau darauf achten, wieviel es alloziert hatte, wenn es einen
 * Bereich wieder freigeben will. DEALLOCATE (x, 0) ist also hier nicht
 * erlaubt - es mu immer exakt die Gre des belegten Bereichs angegeben
 * werden.
 *
 * Granule wurde speziell fr den GME entwickelt. Der GME verwaltet jede
 * einzelne Zeile ber dieses Modul in einem eigens allozierten Block.
 *
 * Ob Granule oder Storage fr Ihre Anwendung besser geeignet ist,
 * probieren Sie am Besten in der Praxis aus.
 * Um die Funktionen 'CreateHeap', 'SetDefaultSize' usw. brauchen Sie sich
 * dabei nicht unbedingt zu kmmern - sie dienen nur Optimierungszwecken.
 *
 * Hinweis:
 * Die aktuelle Implementation dieses Moduls benutzt bei TT- und Falcon-
 * Rechnern nur das langsamere ST-RAM, also kein TT-RAM.
 * Wen das strt, setze sich mit Th. Tempelmann in Verbindung oder siehe
 * die Notizen vom Source des Moduls (die Quelltexte aller Module sind
 * ebenfalls dort zu bekommen). Der Nachteil wre dann allerdings, da ca.
 * 100 KB zustzlich ungenutzt belegt werden mten, falls TT-RAM verfgbar
 * ist.
 *)

FROM SYSTEM IMPORT  ADDRESS;


PROCEDURE ALLOCATE (VAR adr: ADDRESS; bytes: LONGCARD);
(* Belegt Speicher ab adr mit bytes Bytes. Wenn Dynamic = TRUE
 * (siehe Prozedur Dynamic) wird bei einem Heapberlauf ein weiteres
 * Speichersegment angefordert und in den Heap integriert. Wenn FALSE
 * oder kein Speicher mehr zu Verfgung steht, wird adr NIL gesetzt.
 *)

PROCEDURE DEALLOCATE (VAR addr: ADDRESS; bytes: LONGCARD);
(* Gibt den Speicher wieder frei. 'bytes' mu den selben Wert haben,
 * mit dem der Speicher fr 'addr' vorher belegt wurde.
 * (werden NEW und DISPOSE verwendet, wird dafr automatisch Sorge getragen).
 *)

PROCEDURE Shrink (VAR adr: ADDRESS; amount: LONGCARD; VAR size: LONGCARD);
(* Gibt mit allocate belegten Speicher frei.
 * 'amount' ist die Anzahl, um die der Block verkleinert werden soll,
 * 'size' mu beim Aufruf mit der alten Gre besetzt sein und enthlt
 * hinterher die neue Gre.
 * Der freizugebende Teil wird am Ende des Blocks abgezwackt und fr
 * neue ALLOCATEs zur Verfgung gestellt.
 *)

PROCEDURE CreateHeap (bytes: LONGCARD): INTEGER;
(* Installiert den Heap mit bytes Byte. Liefert einen Fehlercode mit
 * folgender Bedeutung:
 *
 *  0   = Kein Fehler, Heap wurde installiert
 * -1   = Kein Speicher in ausreichender Gre zur Verfgung
 * -2   = Heap ist bereits installiert
 *
 * Wird kein Heap installiert, wird beim ersten ALLOCATE-Aufruf
 * automatisch ein Heap v. 64KB erzeugt.
 *)
 
PROCEDURE Dynamic (dyn: BOOLEAN);
(* Schaltet die Dynamic-Option des Heaps.
 * TRUE  = ALLOCATE fordert bei Heapberlauf neues Speichersegment an.
 * FALSE = ALLOCATE liefert bei Heapberlauf immer NIL
 *)

PROCEDURE SetDefaultSize (size: LONGCARD);
(* Setzt die Standard-Heapgre, um die der Heap erweitert wird,
 * wenn er bei "dynamic=TRUE" um ein neues Segment erweitert werden mu.
 * Der Default ist 64 KB
 *)

PROCEDURE Free (): LONGCARD;
(* Liefert Anzahl der Bytes, die auf dem bereits angelegten Heap noch
 * frei sind.
 *)

PROCEDURE MemAvail (): LONGCARD;
(* liefert die Anzahl aller freien Bytes sowohl im Heap, als auch im
 * noch nicht allozierten Speicher - abzglich der GEMDOS-Reserve
 * (Konstante GEMReserve, z.Zt. 64KB)
 *)

END Granule.
