 IMPLEMENTATION MODULE FPUSupport;
 (*$Y+,X+,F-*)
 
 (*
!* 27.11.90  Routinen laufen auch, wenn Aufrufer schon im Supervisormode ist.
!* 29.07.91  keine Privilegsverletzung mehr, wenn im Usermode (hyperCACHE030);
!*           Sprung in Supervisormode nun korrekt (ging bisher gar nicht?!).
!*           FSAVE bei externalFPU rettet nun Frame in umgekehrter Reihenfolge,
!*           so da es nun endlich korrekt funktioniert.
!* 15.02.94  Keine Low-Byte-Zugriffe mehr auf fpstat wg. Mega STE
!*
!* >> Konzept noch nicht perfekt: Wenn Coroutinen ggf.automatisch den
!*   FPU-Context switchen sollen, wrden noch Low-Level-versionen
!*   von Save/RestoreContext bentigt. Ggf. "usedFPU", "MaxContextSize"
!*   und diese Low-Level Routinen in ein Modul "FPUBase" packen.
!*   Die Low-Level-Routinen f. Runtime knnen hier nicht rein, weil
!*   hier Storage importiert wird und das zu zirkul. Importen fhrt.
!*)
 
 FROM SYSTEM IMPORT ASSEMBLER, BYTE;
 
 FROM Storage IMPORT ALLOCATE, DEALLOCATE;
 
 IMPORT MOSGlobals, SFP004;
 
 FROM SysInfo IMPORT FPUType, FPU, FPUModel;
 
 VAR usedFPU: FPUType;  (* zeigt die verwendete FPU an *)
$model: CARDINAL;
 
 CONST movemSize = 8*12 + 3*4;
&contextSize = movemSize + 2 + 2 + 256 + 4;
 
 (* Die Gre errechnet sich aus:
!* 8 * FPn (je 12 Byte)
!* je 4 fr FPCR/SR/IAR
!* 2 fr evtl. nicht-Null-Flag
!* 2 fr Frame-Word von FSAVE
!* interne Daten bei Busy State Frame (256 max. mglich)
!* 4 zur Sicherheit *)
 
 TYPE FPUContext = POINTER TO ARRAY [1..contextSize] OF BYTE;
 
 
 PROCEDURE NewContext     (VAR context: FPUContext);
"BEGIN
$NEW (context);
$IF context = NIL THEN
&ASSEMBLER
(TRAP    #6
(DC.W    MOSGlobals.OutOfMemory
&END;
$ELSE
&ASSEMBLER
(; Illegales State Frame erzeugen
(MOVE.L  context(A6),A1
(MOVE.L  (A1),A0
(MOVE.W  #$FFFF,movemSize(A0)
&END;
$END;
"END NewContext;
 
 PROCEDURE DisposeContext (VAR context: FPUContext);
"BEGIN
$DISPOSE (context)
"END DisposeContext;
 
 (*$L-*)
 
 PROCEDURE FPUInit;
"BEGIN
$ASSEMBLER
(CMPI    #externalFPU,usedFPU
(BNE     intern
(JMP     SFP004.FPUReset
$intern:
(CMPI    #internalFPU,usedFPU
(BNE     none
(FMOVE   #$0000F400,FPCR  ; s. 'Runtime'
$none:
$END
"END FPUInit;
 
 (* wird nicht exportiert, da FPUContext eh nur opaque ist und ein manuelles
!* allozieren damit gar nicht mglich ist.
 PROCEDURE MaxContextSize (): LONGCARD;
!(*
"* Liefert die maximal ntige Gre des Context-Puffers in Byte.
"* Damit kann der Bereich notfalls auf eine andere Weise reserviert
"* werden, statt 'NewContext' zu benutzen.
"* Dann sollte der fr 'FPUContext' angelegte Pu
"*)
 PROCEDURE MaxContextSize (): LONGCARD;
"BEGIN
$ASSEMBLER
(MOVE.L  #contextSize,(A3)+
$END
"END MaxContextSize;
 *)
 
 PROCEDURE AcknowledgeException (context: FPUContext);
"BEGIN
$ASSEMBLER
(; Setze Bit 27 im BIU
(MOVE.L  -(A3),A1
(CMPI    #internalFPU,usedFPU
(BNE     noAckn
(LEA     movemSize(A1),A1
(TST.B   (A1)
(BEQ     noAckn          ; kein Ackn bei Null-State
(CLR     D0
(MOVE.B  1(A1),D0
(BSET    #3,(A1,D0.W)
&noAckn
$END
"END AcknowledgeException;
 
 
 CONST   A2stat  =  0;             (* Response word of MC68881 read *)
(A2ctrl  =  2;             (* Control  word of MC68881 write *)
(A2save  =  4;             (* Save     word of MC68881 read *)
(A2restore= 6;             (* Restore  word of MC68881 r/w *)
(A2cmd   =  10;            (* Command  word of MC68881 write *)
(A2cond  =  14;            (* Condition word of MC68881 write *)
(A2op    =  16;            (* Operand  long of MC68881 read/write *)
(A2regsel=  $14;           (* register select long read *)
 
 PROCEDURE SaveContext    (context: FPUContext);
"BEGIN
$ASSEMBLER
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1              ;Super(1)
(MOVEQ   #-1,D2
(TST     D0              ; sind wir schon im Supervisormode ?
(BNE     supv
(
(MOVE.W  D0,4(A7)
(TRAP    #1              ;Super(0)
(MOVE.L  D0,A7           ; SSP wiederherstellen
(MOVE    #$CFFF,D2
&supv
(MOVE    SR,D1
(AND     D2,D1
(MOVE.W  D1,-(A7)
(
(MOVE.L  -(A3),A1
(MOVE.L  A1,A0
(ADDA.W  #movemSize,A1
(
(CMPI    #externalFPU,usedFPU
(BNE.W   intern
(
(MOVE.L  A3,D1
(MOVEA.W #$FA40,A2
(MOVEA.W #$FA50,A3       ; fpop
(
 wait    MOVE.W  A2save(A2),D0
(CMPI.W  #$300,D0
(BCC     start           ; > $300
(CMPI.W  #$100,D0
(BCS     nullstate       ; < $100
(CMPI.W  #$200,D0
(BCS     wait
(; Format Error
(CLR.W   (A1)            ; IDLE-format word sichern
(MOVE.L  D1,A3
(MOVE.W  (A7)+,SR
(ADDQ.L  #6,A7
(LINK    A5,#0
(JSR     SFP004.FPUError
(UNLK    A5
(RTS
 nullstate:
(MOVE.W  D0,(A1)         ; null-format word sichern
(BRA.W   endextern
 
 start   MOVE.W  D0,(A1)+        ; format word sichern
(; Anzahl der Bytes im Lower Byte -> Anz. der Longs berechnen
(ANDI    #$FF,D0
(ADDA.W  D0,A1
(LSR     #2,D0
(SUBQ    #1,D0
(; whrend der Datenbertragung des FSAVE keine Interrupts zulassen
(MOVE    SR,D2
(MOVE    #$2700,SR
 loop    MOVE.L  (A3),-(A1)
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(DBRA    D0,loop
(MOVE    D2,SR
(
(; FMOVEM FP0-FP7,(A0)+
(TST.W   (A2)
(MOVE.W  #1111000011111111%,A2cmd(A2)
(TST.W   (A2)
(TST.W   (A2)
(TST.W   A2regsel(A2)
(TST.W   (A2)
(MOVEQ   #7,D0
 again   MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(DBRA    D0,again
(
(; FMOVEM FPCR/FPSR/FPIAR,(A0)+
(MOVE.W  #1011110000000000%,A2cmd(A2)    ;$BC00
(TST.W   (A2)
(;TST.W   (A2)
(;TST.W   A2regsel(A2)
(;TST.W   (A2)
(MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
(MOVE.L  (A3),(A0)+
(TST.W   (A2)            ; fpstat wg. Synchr. lesen
$endextern:
(MOVE.L  D1,A3
(BRA     none
 
$intern:
(CMPI    #internalFPU,usedFPU
(BNE     none
(FSAVE   (A1)
(TST.B   (A1)
(BEQ     none
(FMOVEM  FP0-FP7,-(A1)
(FMOVEM  FPCR/FPSR/FPIAR,-(A1)
$none:
(MOVE.W  (A7)+,SR
(ADDQ.L  #6,A7
$END
"END SaveContext;
 
 PROCEDURE RestoreContext (context: FPUContext);
"BEGIN
$ASSEMBLER
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1              ;Super(1)
(MOVEQ   #-1,D2
(TST     D0              ; sind wir schon im Supervisormode ?
(BNE     supv
(
(MOVE.W  D0,4(A7)
(TRAP    #1              ;Super(0)
(MOVE.L  D0,A7           ; SSP wiederherstellen
(MOVE    #$CFFF,D2
&supv
(MOVE    SR,D1
(AND     D2,D1
(MOVE.W  D1,-(A7)
(
(MOVE.L  -(A3),A1
(MOVE.L  A1,A0
(ADDA.W  #movemSize,A1
(
(CMPI    #externalFPU,usedFPU
(BNE.W   intern
(
(TST.B   (A1)
(BEQ.W   nullstate
(
(MOVE.L  A3,D1
(MOVEA.W #$FA40,A2
(MOVEA.W #$FA50,A3
(
(; first reset FPU to be able to transfer the regs
(MOVE.W  #3,A2ctrl(A2)   ; write abort-cmd
(
(; FMOVEM (A0)+,FP0-FP7
(MOVE.W  #1101000011111111%,A2cmd(A2)
(TST.W   (A2)
(TST.W   (A2)
(TST.W   A2regsel(A2)
(TST.W   (A2)
(MOVEQ   #7,D0
 again   MOVE.L  (A0)+,(A3)
(TST.W   (A2)
(MOVE.L  (A0)+,(A3)
(TST.W   (A2)
(MOVE.L  (A0)+,(A3)
(TST.W   (A2)
(DBRA    D0,again
(
(; FMOVEM (A0)+,FPCR/FPSR/FPIAR
(MOVE.W  #1001110000000000%,A2cmd(A2)
(TST.W   (A2)
(;TST.W   (A2)
(;TST.W   A2regsel(A2)
(;TST.W   (A2)
(MOVE.L  (A0)+,(A3)
(TST.W   (A2)
(MOVE.L  (A0)+,(A3)
(TST.W   (A2)
(MOVE.L  (A0)+,(A3)
(TST.W   (A2)
 
(; FRESTORE (A1)
(MOVE.W  (A1)+,D0
(MOVE.W  D0,A2restore(A2)
(CMP.W   A2restore(A2),D0
(BEQ     start
(
(MOVE.L  D1,A3
(
(; Format Error
 error   MOVE.W  (A7)+,SR
(ADDQ.L  #6,A7
(LINK    A5,#0
(JSR     SFP004.FPUError
(UNLK    A5
(RTS
 
 nullstate:
(MOVEA.W #$FA46,A2       ; fprestore
(MOVE.W  (A1),D0
(MOVE.W  D0,(A2)         ; FRESTORE
(CMP.W   (A2),D0
(BEQ     none
(BRA     error
(
 start   ; Anzahl der Bytes im Lower Byte -> Anz. der Longs berechnen
(ANDI    #$FF,D0
(LSR     #2,D0
(SUBQ    #1,D0
(; whrend der Datenbertragung keine Interrupts zulassen
(MOVE    SR,D2
(MOVE    #$2700,SR
 loop    MOVE.L  (A1)+,(A3)
(TST.W   (A2)
(DBRA    D0,loop
(MOVE    D2,SR
(MOVE.L  D1,A3
(BRA     none
(
$intern:
(CMPI    #internalFPU,usedFPU
(BNE     none
(TST.B   (A1)
(BEQ     null_rst
(FMOVEM  (A0)+,FPCR/FPSR/FPIAR
(FMOVEM  (A0)+,FP0-FP7
$null_rst:
(FRESTORE (A1)
$none:
(MOVE.W  (A7)+,SR
(ADDQ.L  #6,A7
$END
"END RestoreContext;
 
 BEGIN
"usedFPU:= FPU ();
$(* egal, ob die vorhandene FPU auch wirklich benutzt wird: wenn hier
%* eine der Funktionen aufgerufen wird, ists auf jeden Fall nicht die
%* falsche. *)
"model:= FPUModel ();
 END FPUSupport.
  
(* $FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$000001F9$FFEE3A76$00002226$FFEE3A76$00000893$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$FFEE3A76$000001F3T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001588$00001625$00001715$00001ACA$00001BC4$00001C48$00001CB5$00001D59$00001FFB$0000165D$00001CED$0000003E$000001F9$000001C0$000001F6$000001D4*)
