 IMPLEMENTATION MODULE FileManagement;
 (*$R-,Y+*)
 (*$H+*)
 
 (*FROM InOut IMPORT WriteString, WriteLn, Read, WriteCard, WriteInt;*)
 
 
 (*  --------------------------------------------------------------------------
!*  System-Version: MOS 1.1
!*  --------------------------------------------------------------------------
!*  Version       : 1.01
!*  --------------------------------------------------------------------------
!*  Text-Version  : V#0262
!*  --------------------------------------------------------------------------
!*  Modul-Holder  : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Copyright August 1988 by Manuel Chakravarty
!*  Vertriebsrechte fr ATARI ST unter MEGAMAX Modula-2
!*                  liegen bei Application Systems Heidelberg
!*  --------------------------------------------------------------------------
!*  MCH : Manuel Chakravarty
!*  DS  : Dirk Steins 
!*  --------------------------------------------------------------------------
!*  Datum    Autor  Version  Bemerkung (Arbeitsbericht)
!*
!*  07.08.88 MCH    V0.01    Erste Definitionen
!*  08.08.88 MCH    V0.01    'fileList' + 'insertFileInList'
!*  09.08.88 MCH    V0.01    Austesten der 'fileList'-Verwaltung + 'DeleteFiles'
!*  09.08.88 MCH    V0.02    Nochmal
!*  10.08.88 MCH    V0.02    'FormatDisk' (norm. SS und DS) + 'DeleteFiles'
!*  11.08.88 MCH    V0.02    'CopyFiles' luft (Tra-Ra!)
!*  24.08.88 MCH    V0.03    'CountFilesAndDirs' extern
!*  25.08.88 MCH    V0.03    Genderte Status-Verwaltung
!*  27.08.88 MCH    V0.03    'minExternalSpace' eingefhrt.
!*  28.08.88 MCH    V0.04    'FileInformation' Def. + Imp.
!*  11.08.88 MCH    V0.04    Datum/Uhrzeit bleibt beim Kopieren erhalten
!*  03.09.89 MCH    V0.04    Fehlerbehandlung verbessert
!*  11.09.89 TT     V0.05    readIntoBuffer: Fehlerabfrage entfernt
!*  30.6.90  DS     V0.06    DestPath von Files wird bei gendertem Ordnername
!*                           jetzt korrekt gendert. nderungen sind gekenn-
!*                           zeichnet mit %%.
!*  24.10.90 TT     V0.07    Doku im Def-Text korrigiert; FormatDrive mit
!*                           mit Directory.Drive-Werten definiert (Def-Text);
!*                           $H+ eingebaut
!*  10.11.90 TT     V0.07    $R-
!*  11.03.91 TT     V1.01    FileInformation bercksichtigt Ordner und kann
!*                           auch Zeit/Datum neu setzen.
!*  09.04.91 TT     V1.02    FormatDisk wertet 'drive' nun richtig aus (bisher
!*                           wurde bei 'drvA' LW B: formatiert.
!*  --------------------------------------------------------------------------
!*  Modul-Beschreibung:
!*
!*  Dieses Modul stellt Routinen fr die Dateiverwaltung zur Verfgung.
!*  --------------------------------------------------------------------------
!*)
 
 (*  -- Wie sieht es mit Datum und Zeit bei Ordnern aus??????
!*  -- Wird beim Namenskonflikt von Ordnern ein neuer Name angegeben, so mu
!*     der DestPath der Ordnerelemente entsprechend gendert werden.
!*     Behoben Dirk Steins
!*  -- Tritt bei 'flushBufferElem' whrend des Schreibens ein Fehler auf, so
!*     ist nicht gewhrleistet, da das File anstndig geschlossen wird.
!*  -- Evtl. 'queryFileList' exportieren (z.B fr Modul-Loading in der Shell).
!*)
 
 
 FROM SYSTEM IMPORT ADDRESS, TSIZE,
3ASSEMBLER, ADR;
 
 FROM Storage IMPORT ALLOCATE, DEALLOCATE, MemAvail;
 
 FROM Strings IMPORT Length, Concat, Append, Empty, Insert, Copy, StrEqual,
4Assign;
 
 IMPORT Strings, FastStrings, FuncStrings;
 
 FROM MOSGlobals IMPORT OutOfMemory, GeneralErr, fOK, fFileNotFound,
7fPathNotFound, fAccessDenied, fFileExists,
7fDiskFull, fIllegalCall, DriveStr, PathStr,
7FileStr;
 
 FROM Clock IMPORT Time, Date;
 
 FROM Directory IMPORT FileAttr, FileAttrSet, DirEntry,
6SetFileAttr, Delete, Rename, GetDirEntry,
6DirQuery, CreateDir, DeleteDir;
 
 FROM FileNames IMPORT SplitPath;
 
 FROM Files IMPORT File, Access, ReplaceMode,
2Create, Open, Close, SetDateTime, GetDateTime, State,
2GetStateMsg, ResetState, Remove;
 
 FROM Binary IMPORT SeekMode,
3ReadBytes, WriteBytes, FileSize, Seek, FilePos;
 
 FROM Lists IMPORT List, CreateList, DeleteList, RemoveEntry, AppendEntry,
2ResetList, NextEntry, PrevEntry, CurrentEntry, NoOfEntries;
 
 FROM SysUtil0 IMPORT VarEqual;
 
 
 CONST   (*  MOS const.s  *)
 
(noErrorTrap     = 6;
 
((*  system call opcodes  *)
 
(flopwr          = 9;
(flopfmt         = 10;
(protobt         = 18;
(
(xbios           = 14;
(
((*  misc  *)
(
(filesAndSubdirs = FileAttrSet {subdirAttr};
(
(
(minCopySpace    = 10L * 1024L;  (*  10k minimal  *)
(minExternalSpace= 30L * 1024L;  (*  30k minimal for other prog.s  *)
((* erweitert auf 30k fr Pfadlisten *)
 
 TYPE    ptrMaxStr       = POINTER TO ARRAY[0..32767] OF CHAR;
(str128          = ARRAY[0..127] OF CHAR;
(fileName        = ARRAY[0..11] OF CHAR;
(ptrCardinal     = POINTER TO CARDINAL;
(
(
 TYPE    statusRecord    = RECORD
<fileErrAlert: FileErrorAlertProc;
<
<showStatus  : FileOpStatusProc;
<noFiles     : CARDINAL;
:END;
(ptrStatusRecord = POINTER TO statusRecord;
(
((*  types for the copy buffer  *)
(
(copyBufferElem  = POINTER TO RECORD
<next    : copyBufferElem;   (*  NIL <=> not used  *)
<newPath : str128;
<isSubdir: BOOLEAN;
<date    : Date;             (*  of creation  *)
<time    : Time;             (*  of creation  *)
<seekPos : LONGCARD;         (*  append if > 0L  *)
<start   : ADDRESS;          (*  start of data  *)
<length  : LONGCARD;         (*  length of data  *)
:END;
(
(copyBuffer      = POINTER TO RECORD
<bottom,                     (*  first buffer elem *)
<next      : copyBufferElem; (*  next elem. to use *)
<length    : LONGCARD;       (*  buffer length  *)
<
<status    : statusRecord;
<
<feAlert   : FileExistsAlertProc;
<oldPathLen: CARDINAL;
<newPath   : str128;
<
<success   : BOOLEAN;        (*  FALSE ~ Error  *)
:END;
'
 
 VAR     voidO : BOOLEAN;
(voidI : INTEGER;
(voidFN: fileName;
(void128: str128;
(
 
 CONST   DebugInfo = FALSE;
 
 (*$? DebugInfo:
 
 PROCEDURE wLn (REF str: ARRAY OF CHAR);
 
"BEGIN
$WriteString (str); WriteLn;
"END wLn;
 
 PROCEDURE w (REF str: ARRAY OF CHAR);
 
"BEGIN
$WriteString (str);
"END w;
 
 PROCEDURE wc (c: LONGCARD);
 
"BEGIN
$WriteCard (c, 6);
"END wc;
 
 PROCEDURE wi (c: INTEGER);
 
"BEGIN
$WriteInt (c, 6);
"END wi;
 
 PROCEDURE wsiLn (REF str: ARRAY OF CHAR; i: INTEGER);
 
"BEGIN
$w (str); wi (i); WriteLn;
"END wsiLn;
 
 PROCEDURE wcsLn (l: LONGCARD; REF str: ARRAY OF CHAR);
 
"BEGIN
$wc (l); wLn (str);
"END wcsLn;
"
 PROCEDURE wscLn (REF str: ARRAY OF CHAR; l: LONGCARD);
 
"BEGIN
$w (str); wc (l); WriteLn;
"END wscLn;
"
 PROCEDURE Wait;
 
"VAR ch: CHAR;
"
"BEGIN
$Read (ch);
"END Wait;
!*)
"
8(*  misc. proc.s  *)
8(*  ============  *)
 
 PROCEDURE reportOutOfMemory;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    OutOfMemory - $4000
$END;
"END reportOutOfMemory;
"(*$L=*)
"
 PROCEDURE reportPathFault;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     'FileManagement: Illegal path!'
(SYNC
$END;
"END reportPathFault;
"(*$L=*)
"
 
 PROCEDURE isSubdir (attrs: FileAttrSet): BOOLEAN;
 
"BEGIN
$RETURN subdirAttr IN attrs
"END isSubdir;
 
 
 PROCEDURE GetFileAttr (REF name  : ARRAY OF CHAR;
7VAR attr  : FileAttrSet;
7VAR result: INTEGER);
"
"VAR   entry: DirEntry;
"
"BEGIN
$GetDirEntry (name, entry, result);
&(* -> Directory.GetFileAttr geht nicht bei Subdirs. *)
$attr := entry.attr;
"END GetFileAttr;
 
 PROCEDURE doShowStatus (    statusRecPtr: ptrStatusRecord;
<ioRes       : INTEGER;
8VAR stop        : BOOLEAN);
 
"VAR   report,
(continue: BOOLEAN;
(
"BEGIN
$WITH statusRecPtr^ DO
$
&report := (ioRes = fFileNotFound) OR (ioRes = fPathNotFound)
0OR (ioRes = fAccessDenied) OR (ioRes = fDiskFull);
&continue := (ioRes = fOK) OR (ioRes = fFileNotFound)
2OR (ioRes = fPathNotFound) OR (ioRes = fAccessDenied)
2OR (ioRes = fFileExists);
$
&IF report THEN fileErrAlert (ioRes) END;
&stop := ~ continue;
$
&IF ~ stop THEN
(IF noFiles > 0 THEN DEC (noFiles) END;
(showStatus (noFiles, stop);
&END;
&
$END;
"END doShowStatus;
 
 
0(*  operations on the 'copyBuffer'  *)
0(*  ==============================  *)
0
 
 (*  createCopyBuffer -- Alloc.s as much memory as possible and creates
!*                      a 'copyBuffer' with it.
!*                      'useAllMem = FALSE' means to use 2/5 of the largest
!*                      avaible mem. block, else the whole block is used.
!*                      'success = FALSE' means, not enough memory.
!*)
!
 PROCEDURE createCopyBuffer (VAR cb       : copyBuffer;
@useAllMem: BOOLEAN;
<VAR success  : BOOLEAN);
 
"PROCEDURE memAvail (): LONGCARD;
"
$VAR res: LONGCARD;
"
$BEGIN
&IF useAllMem THEN
(res := MemAvail ();
(IF res < minExternalSpace THEN res := 0
(ELSE res := res - minExternalSpace END;
&ELSE
(res := MemAvail () * 2L DIV 5L;
(IF res < minExternalSpace THEN res := 0 END;
&END;
&
&res := res - res MOD 2L;          (*  make even  *)
&
&RETURN res
$END memAvail;
$
 
"BEGIN
$success := (memAvail () >= minCopySpace );
$IF ~ success THEN RETURN END;
$
$NEW (cb);
$WITH cb^ DO
&length := memAvail ();       (*  take as much as possible  *)
&ALLOCATE (bottom, length);
&next := bottom;              (*  next elem. to use is the first elem.  *)
&bottom^.next := NIL;         (*  first elem. is not yet in use  *)
$END;
"END createCopyBuffer;
 
 PROCEDURE deleteCopyBuffer (cb: copyBuffer);
 
"BEGIN
$DEALLOCATE (cb^.bottom, 0L);
$DISPOSE (cb);
"END deleteCopyBuffer;
"
 
 (*  bufAvail -- Determines the maximum amount of bytes, that are avaible
!*              in the 'cb'.
!*)
 
 PROCEDURE bufAvail (cb: copyBuffer): LONGCARD;
 
"BEGIN
$RETURN cb^.length - (LONGCARD (cb^.next) - LONGCARD (cb^.bottom))
+- SIZE (cb^.next^)
"END bufAvail;
"
 (*  flushCopyBuffer -- Writes the data in 'cb' to the destination.
!*)
 
((* %% added 27.6.90 DS             *)
((* pc: short for PathChange     *)
 (*   The 'pcList' is the pathChangedList. In this list all path's
!*   which were changed during flushBuffer will be stored. 
!*   This Types and vars are global because the 'pcList' is initialised in
!*   the procedure 'copyFiles'. And it has to be global because otherwise
!*   some entries would be forgotten.
!*)
!
"TYPE    pcEntry         = RECORD
>oldPath,
>newPath     : str128;
<END;
*pcPtr           = POINTER TO pcEntry;
*
"VAR     pcList  : List;
 
 PROCEDURE flushCopyBuffer (cb: copyBuffer);
 
"VAR   elem : copyBufferElem;
(ioRes: INTEGER;
(f    : File;
(mode : ReplaceMode;
(path : str128;
(fn,
(orgFn,                  (* %% added 30.6.90 DS: is needed for the
A* pcList and the original pathname in it.
A*)
(oldFn: fileName;
(stop : BOOLEAN;
(
"PROCEDURE stateErr (): BOOLEAN;
$
$BEGIN
&ioRes := State (f);
&IF ioRes # fOK THEN ResetState (f) END;
&RETURN ioRes # fOK
$END stateErr;
$
((* %% added 27.6.90 DS *)
"PROCEDURE insertChangeEntry (VAR path : ARRAY OF CHAR;
?VAR old, new : ARRAY OF CHAR;
?start : CARDINAL) : BOOLEAN;
$(* inserts the newPath corresponding to oldPath in the 
%* pathList. If no oldPath is found a new entry is created.
%* Creating a new entry is the normal case due to changes in
%* development.
%*)
$VAR sPath : str128;
(pc    : pcPtr;
"BEGIN
$FastStrings.Concat (path, old, sPath);
$ResetList (pcList);
$REPEAT 
&pc := NextEntry (pcList);
$UNTIL (pc = NIL) OR StrEqual (sPath, pc^.oldPath);
$IF pc # NIL
$THEN
&FastStrings.Concat (path, new, sPath);
&FastStrings.Assign (sPath, pc^.newPath);
$ELSE
&ALLOCATE (pc, TSIZE (pcEntry));
&IF pc = NIL THEN reportOutOfMemory; RETURN FALSE END;
&FastStrings.Concat (path, old, pc^.oldPath);
&FastStrings.Concat (path, new, pc^.newPath);
&AppendEntry (pcList, pc, voidO);
&IF voidO THEN reportOutOfMemory; RETURN FALSE END;
$END;
$RETURN TRUE
"END insertChangeEntry;
"
"(* %% added 27.6.90 DS *)
"PROCEDURE TestAndChange (VAR path : ARRAY OF CHAR;
;last : CARDINAL);
"(* If path is in the pcList, path will be replaced by the newPath.
#* this proc call's itself recursively to change previous changed 
#* parts of a path correct.
#* 'last' is a control-parameter to pretend infinite loops. (i don't 
#* know if it's necessary).
#*)
%VAR p : INTEGER;
)l : CARDINAL;
)pc: pcPtr;
)tPath : str128;
)tName : fileName;
"BEGIN
$l := Length (path);
$IF (l > 2) AND ~(l = last)
$THEN
&SplitPath (path, tPath, tName);
&tPath[Length(tPath)-1] := 0c;     (* '\' lschen *)
&TestAndChange (tPath, l);
&Append ('\',tPath, voidO);        (* '\' wieder anfgen *)
&FastStrings.Concat (tPath, tName, path);
&ResetList (pcList);
&REPEAT
(pc := NextEntry (pcList);
&UNTIL (pc = NIL) OR StrEqual (path, pc^.oldPath);
&IF pc # NIL
&THEN
(FastStrings.Assign (pc^.newPath, path);
&END;
$END;
"END TestAndChange;
"
"PROCEDURE flushOneElem;
"
$VAR pathChanged : BOOLEAN;
"
$BEGIN
&WITH elem^ DO IF isSubdir THEN
&
((* %% added by DS 27.6.90: *)
(SplitPath (newPath, path, orgFn);
(TestAndChange (path, 0);
(FastStrings.Concat (path, orgFn, newPath);
*
(pathChanged := FALSE;
(
(LOOP
*CreateDir (newPath, ioRes);
*IF ioRes = fAccessDenied THEN               (*  folder exists  *)
*
,SplitPath (newPath, path, oldFn);
,fn := oldFn;
,IF ~ cb^.feAlert (fn) THEN ioRes := fFileExists; EXIT END;
,
,(* %% added by DS 27.6.90: *)
,IF ~StrEqual (oldFn, fn)
,THEN 
.pathChanged := TRUE
,ELSE
.ioRes := fFileExists;
.EXIT
,END;
,
,FastStrings.Concat (path, fn, newPath);
,
*ELSE EXIT END;                              (*  success  *)
(END;
(
((* %% added by DS 27.6.90: *)
(IF pathChanged THEN
+IF ~insertChangeEntry (path, orgFn, fn, cb^.oldPathLen)
+THEN stop := TRUE
+END;
(END;
(
&ELSE
&
(IF seekPos > 0L THEN                    (*  append  *)
(
*Open (f, newPath, writeOnly);
*IF stateErr () THEN Remove (f); RETURN END;
*Seek (f, seekPos, fromBegin);
*IF stateErr () THEN Remove (f); RETURN END;
*
(ELSE                                    (*  new file  *)
*mode := noReplace;
*
*TestAndChange (newPath, 0);
*
*LOOP
*
,Create (f, newPath, writeOnly, mode);
,IF State (f) = fFileExists THEN             (*  file exists  *)
,
.ResetState (f);
.SplitPath (newPath, path, oldFn);
.fn := oldFn;
.IF ~ cb^.feAlert (fn) THEN ioRes := fFileExists; RETURN END;
.IF StrEqual (fn, oldFn) THEN mode := replaceOld
.ELSE FastStrings.Concat (path, fn, newPath) END;
.
,ELSIF stateErr () THEN RETURN               (*  file error!  *)
,ELSE EXIT END;                              (*  success  *)
,
*END;
*
(END;
(
(WriteBytes (f, start, length);
(IF stateErr () THEN Remove (f); RETURN END;
(Close (f);
(Open (f, newPath, writeOnly);
(SetDateTime (f, date, time);
((* IF stateErr () THEN Remove (f); RETURN END; *)
(Close (f);
(
&END END;
$END flushOneElem;
$
"BEGIN
$elem := cb^.bottom;
$LOOP
&IF elem^.next = NIL THEN EXIT END;
&
&flushOneElem;
&
&doShowStatus (ADR (cb^.status), ioRes, stop);        (*  communicate  *)
&IF stop THEN cb^.success := FALSE; EXIT END;
&
&elem := elem^.next;
$END;
$
$cb^.next := cb^.bottom;             (*  free buffer contens  *)
$cb^.next^.next := NIL;
"END flushCopyBuffer;
"
 
 (*  createCopyBufferElem -- Creates a new elem. in the 'copyBuffer', if
!*                          there is not enough room to do so, the buffer
!*                          is flushed first.
!*                          Call only, if there are no open files.
!*)
 
 PROCEDURE createCopyBufferElem (    cb  : copyBuffer;
@VAR elem: copyBufferElem);
 
"BEGIN
$IF bufAvail (cb) < (minCopySpace DIV 2L) THEN
&flushCopyBuffer (cb); IF ~ cb^.success THEN RETURN END;
$END;
$
$WITH cb^ DO
&elem := next;
&next := copyBufferElem (LONGCARD (bottom) + length - SIZE (cb^.next^));
&elem^.next := next;
&elem^.next^.next := NIL;          (*  mark next elem as free  *)
&elem^.start := ADDRESS (elem) + ADDRESS (SIZE (elem^));
&elem^.length := LONGCARD (elem^.next) - LONGCARD (elem^.start);
$END;
"END createCopyBufferElem;
 
 (* deleteCopyBufferElem -- Deletes a 'copyBufferElem'. The element must
!*                         be the last in the 'copyBuffer'!
!*)
 
 PROCEDURE deleteCopyBufferElem (    cb: copyBuffer;
@VAR elem: copyBufferElem);
 
"BEGIN
$cb^.next := elem;
$elem^.next := NIL;
"END deleteCopyBufferElem;
"
 (*  shrinkBufferElem -- Reduces the length of 'elem' to 'bytes' byte.
!*
!*                      ATTENTION: -- Could only be used for the last
!*                                    used element of a buffer.
!*                                 -- Length of the elem. and start of
!*                                    the next differ, if 'bytes' is odd.
!*)
 
 PROCEDURE shrinkBufferElem (cb   : copyBuffer;
<elem : copyBufferElem;
<bytes: LONGCARD);
 
"BEGIN
$(*  if not last used elem. or trying to enlarge elem. size
%*)
$IF (elem^.next^.next # NIL) OR (elem^.length < bytes) THEN HALT END;
$
$elem^.length := bytes;
$elem^.next := ADDRESS (elem^.start) + ADDRESS (bytes + bytes MOD 2L);
$elem^.next^.next := NIL;
$cb^.next := elem^.next;
"END shrinkBufferElem;
"
"
 PROCEDURE readIntoBuffer (REF path: ARRAY OF CHAR;
:VAR pos : LONGCARD;
>cb  : copyBuffer);
 
"VAR   f        : File;
(bufElem  : copyBufferElem;
(readBytes: LONGCARD;
(success  : BOOLEAN;
"
"PROCEDURE stateErr (): BOOLEAN;
"
$BEGIN
&cb^.success := (State (f) = fOK);
&IF ~ cb^.success THEN
(cb^.status.fileErrAlert (State (f));
(ResetState (f);
(pos := 0L;
(Close (f);
(bufElem^.next := NIL;
&END;
&RETURN ~ cb^.success
$END stateErr;
$
 
"BEGIN
$
$(*  alloc. room in the buffer for the new file (or part of it).
%*)
%
$createCopyBufferElem (cb, bufElem);
$IF ~ cb^.success THEN
$pos := 0L; RETURN END;
$WITH bufElem^ DO
&Copy (path, cb^.oldPathLen, Length (path) - cb^.oldPathLen, newPath,
,voidO);
&Insert (cb^.newPath, 0, newPath, success);
&IF ~ success THEN
(reportPathFault;
(deleteCopyBufferElem (cb, bufElem);
(pos := 0L;
(RETURN
&END;
&isSubdir := FALSE;
&seekPos := pos;
&
&Open (f, path, readOnly); IF stateErr () THEN RETURN END;
&GetDateTime (f, date, time);
&Seek (f, pos, fromBegin); IF stateErr () THEN RETURN END;
&ReadBytes (f, start, length, readBytes); IF stateErr () THEN RETURN END;
&pos := FilePos (f);
&IF pos = FileSize (f) THEN pos := 0L END;         (*  EOF  *)
&Close (f);
&
&shrinkBufferElem (cb, bufElem, readBytes);
&
$END;
"END readIntoBuffer;
 
"
0(*  proc.s for query through file list  *)
0(*  ==================================  *)
0
0
((*  The following proc.s shouldn't directly or indirectly be
)*  recursive. Cause the caller is working with global var.s
)*)
)
 TYPE    fileHandleProc      = PROCEDURE (REF (*file: *) ARRAY OF CHAR,
I(*env : *) ADDRESS): BOOLEAN;
(dirHandleProc       = PROCEDURE (REF (*dir: *) ARRAY OF CHAR,
I(*env: *) ADDRESS): BOOLEAN;
I
(oldPathLenToEnvProc = PROCEDURE ((*oldLen: *) CARDINAL,
I(*env   : *) ADDRESS);
I
(queryEnv        = RECORD
<handleFile: fileHandleProc;
<handleDir : dirHandleProc;
<handleEnv : ADDRESS;
<dirFirst  : BOOLEAN;
<
<stop      : BOOLEAN;
<pathChanged : BOOLEAN;
<newPath   : PathStr;
:END;
 
 VAR     dontKnowANameEnv: queryEnv;
(dontKnowANameStr: str128;
(
(
 
 PROCEDURE dontKnowAName (REF path: ARRAY OF CHAR; entry: DirEntry): BOOLEAN;
 
"VAR   success: BOOLEAN;
(ioRes  : INTEGER;
((* %% added 30.6.90 DS: because dontKnowAName calls itself recursively
)* the following var has to be local. Otherwise some pathes will
)* not be set correct! See remark 34 lines above!!
)*)
(dontKnowANameStr: str128;
 
"BEGIN
$IF entry.name[0] # '.' THEN WITH dontKnowANameEnv DO
$
&Concat (path, entry.name, dontKnowANameStr, success);
&IF ~ success THEN reportPathFault; stop := TRUE; RETURN FALSE END;
&IF isSubdir (entry.attr) THEN
&
(IF dirFirst THEN
*stop := ~ handleDir (dontKnowANameStr, handleEnv);
*IF stop THEN RETURN FALSE END;
(END;
(
(Append ('\*.*', dontKnowANameStr, success);
(IF ~ success THEN reportPathFault; stop := TRUE; RETURN FALSE END;
(DirQuery (dontKnowANameStr, filesAndSubdirs, dontKnowAName, ioRes);
(IF stop OR (ioRes # fOK) THEN stop := TRUE; RETURN FALSE END;
(
(IF ~ dirFirst THEN
*Concat (path, entry.name, dontKnowANameStr, success);
*stop := ~ handleDir (dontKnowANameStr, handleEnv);
*IF stop THEN RETURN FALSE END;
(END;
(
&ELSE stop := ~ handleFile (dontKnowANameStr, handleEnv) END;
&
&IF stop THEN RETURN FALSE END;
&
$END END;
$
$RETURN TRUE
"END dontKnowAName;
 
 PROCEDURE queryFileList (REF path          : ARRAY OF CHAR;
=files         : List;
=workOnFile    : fileHandleProc;
=workOnDir     : dirHandleProc;
=setOldPathLen : oldPathLenToEnvProc;
=workEnv       : ADDRESS;
=workOnDirFirst: BOOLEAN);
 
"VAR   entry  : ptrMaxStr;
(str,
(str2,
(str3   : str128;
(ioRes  : INTEGER;
(attrs  : FileAttrSet;
(success: BOOLEAN;
 
"BEGIN
$WITH dontKnowANameEnv DO
$
&handleFile := workOnFile;
&handleDir  := workOnDir;
&handleEnv  := workEnv;
&dirFirst   := workOnDirFirst;
&stop := FALSE;
&pathChanged := FALSE;
&
&IF path[0]#0C THEN
(IF path [Length (path) - 1] = '\' THEN FastStrings.Assign (path, str3)
(ELSE Concat (path, '\', str3, success) END;
&ELSE str3 := '' END;
&
&ResetList (files);
&entry := NextEntry (files);
&WHILE entry # NIL DO
&
(FastStrings.Assign (entry^, str2); (*  !!! 'entry^' by reference !!!  *)
(
(Concat (str3, str2, str, success);
(IF ~ success THEN reportPathFault; RETURN END;
(
(SplitPath (str, str2, voidFN);
(setOldPathLen (Length (str2), workEnv);
(
(GetFileAttr (str, attrs, ioRes); IF ioRes # fOK THEN RETURN END;
(IF isSubdir (attrs) THEN
(
*IF dirFirst THEN
,IF ~ handleDir (str, handleEnv) THEN RETURN END
*END;
*
*Concat (str, '\*.*', str2, success);
*IF ~ success THEN reportPathFault; RETURN END;
*DirQuery (str2, filesAndSubdirs, dontKnowAName, ioRes);
*IF stop OR (ioRes # fOK) THEN RETURN END;
(
*IF ~ dirFirst THEN
,IF ~ handleDir (str, handleEnv) THEN RETURN END
*END;
*
(ELSE IF ~ handleFile (str, handleEnv) THEN RETURN END END;
(
(entry := NextEntry (files);
&END;
&
$END;
"END queryFileList;
!
!
 PROCEDURE statusDummy (c: CARDINAL; VAR s: BOOLEAN);
 
"BEGIN
$s := FALSE;
"END statusDummy;
 
 PROCEDURE setLenDummy (c: CARDINAL; env: ADDRESS);
 
"END setLenDummy;
 
 
8(*  proc.s for query  *)
8(*  ================  *)
 
 PROCEDURE countEntry (REF path: ARRAY OF CHAR; env: ADDRESS): BOOLEAN;
 
"BEGIN
$INC (env^);         (*  not clean, but saves a cast  *)
$RETURN TRUE
"END countEntry;
"
 PROCEDURE deleteFile (REF path: ARRAY OF CHAR; env: ADDRESS): BOOLEAN;
 
"VAR   ioRes: INTEGER;
(stop : BOOLEAN;
 
"BEGIN
$Delete (path, ioRes);
$doShowStatus (env, ioRes, stop);
$RETURN ~ stop
"END deleteFile;
"
 PROCEDURE deleteDir (REF path: ARRAY OF CHAR; env: ADDRESS): BOOLEAN;
 
"VAR   ioRes: INTEGER;
(stop : BOOLEAN;
"
"BEGIN
$DeleteDir (path, ioRes);
$doShowStatus (env, ioRes, stop);
$RETURN ~ stop
"END deleteDir;
 
 
 PROCEDURE fileInBuffer (REF path: ARRAY OF CHAR; env: ADDRESS): BOOLEAN;
 
"VAR   cb  : copyBuffer;
(pos : LONGCARD;
 
"BEGIN
$cb := copyBuffer (env);
$
$pos := 0L;
$REPEAT
&readIntoBuffer (path, pos, cb);
$UNTIL pos = 0L;
$
$RETURN cb^.success
"END fileInBuffer;
"
 PROCEDURE dirInBuffer (REF path: ARRAY OF CHAR; env: ADDRESS): BOOLEAN;
 
"VAR   cb     : copyBuffer;
(bufElem: copyBufferElem;
(success: BOOLEAN;
(tPath  : str128;
(
 
"BEGIN
$cb := copyBuffer (env);
$
$createCopyBufferElem (cb, bufElem);
$IF ~ cb^.success THEN RETURN FALSE END;
$WITH bufElem^ DO
&Concat (cb^.newPath,
.FuncStrings.DelStr (path, 0, cb^.oldPathLen), tPath, success);
&IF ~ success THEN
(reportPathFault;
(deleteCopyBufferElem (cb, bufElem);
(RETURN FALSE
&END;
&FastStrings.Assign (tPath, newPath);
&
&isSubdir := TRUE;
&
$END;
$
$shrinkBufferElem (cb, bufElem, 0L);
$
$RETURN TRUE
"END dirInBuffer;
 
 PROCEDURE setOldPathLen (len: CARDINAL; env: ADDRESS);
 
"VAR   cb: copyBuffer;
 
"BEGIN
$cb := copyBuffer (env);
$
$cb^.oldPathLen := len;
"END setOldPathLen;
"
"
8(*  Die exportierten Routinen  *)
8(*  =========================  *)
"
 PROCEDURE CountFilesAndDirs (REF path: ARRAY OF CHAR;
Al   : List;
=VAR no  : CARDINAL);
 
"BEGIN
$no := 0;
$queryFileList (path, l, countEntry, countEntry, setLenDummy, ADR (no),
3TRUE);
"END CountFilesAndDirs;
"
 PROCEDURE DeleteFiles (REF path        : ARRAY OF CHAR;
7files       : List;
7noFiles     : CARDINAL;
7showStatus  : FileOpStatusProc;
7fileErrAlert: FileErrorAlertProc);
 
"VAR   status: statusRecord;
(stop  : BOOLEAN;
 
"BEGIN
$showStatus (noFiles, stop); IF stop THEN RETURN END;
&
$status.fileErrAlert := fileErrAlert;
$status.showStatus := showStatus;
$status.noFiles := noFiles;
$
$queryFileList (path, files, deleteFile, deleteDir, setLenDummy,
3ADR (status), FALSE);
"END DeleteFiles;
 
 PROCEDURE CopyFiles (REF path        : ARRAY OF CHAR;
5files       : List;
5noFiles     : CARDINAL;
5REF newPath     : ARRAY OF CHAR;
5deleteOld,
5useAllMem   : BOOLEAN;
5feAlert     : FileExistsAlertProc;
5showStatus  : FileOpStatusProc;
5fileErrAlert: FileErrorAlertProc);
 
"VAR   buffer : copyBuffer;
(len    : CARDINAL;
(success,
(stop   : BOOLEAN;
(entry  : pcPtr;
 
"BEGIN
$showStatus (noFiles, stop); IF stop THEN RETURN END;
&
$(* %% added 27.6.90 DS *)
$CreateList (pcList, success);
$IF success (* TRUE means error, but i don't wanted another var *)
$THEN reportOutOfMemory; RETURN END;
$
$createCopyBuffer (buffer, useAllMem, success);
$IF ~ success THEN reportOutOfMemory; RETURN END;
$buffer^.feAlert := feAlert;
$Assign (newPath, buffer^.newPath, success);
$len := Length (newPath);
$IF ~ success OR (len < 2) THEN
&reportPathFault;
&deleteCopyBuffer (buffer);
&RETURN
$END;
$IF newPath[len - 1] # '\' THEN Append ('\', buffer^.newPath, voidO) END;
$buffer^.status.fileErrAlert := fileErrAlert;
$buffer^.status.showStatus := showStatus;
$buffer^.status.noFiles := noFiles;
$buffer^.success := TRUE;
$
$queryFileList (path, files, fileInBuffer, dirInBuffer, setOldPathLen,
3buffer, TRUE);
$flushCopyBuffer (buffer);
$
$deleteCopyBuffer (buffer);
$
$(* %% added 27.6.90 DS *)
$(* delete pathList *)
$ResetList (pcList);
$entry := PrevEntry (pcList);
$WHILE entry # NIL DO
&RemoveEntry (pcList, voidO);
&DEALLOCATE (entry, 0L);
&entry := CurrentEntry (pcList);
$END;
$DeleteList (pcList, success)
$
"END CopyFiles;
"
 PROCEDURE FileInformation (REF name        : ARRAY OF CHAR;
;showFileInfo: FileInfoProc;
;fileErrorAlt: FileErrorAlertProc);
 
"VAR   entry,
(oldEntry: DirEntry;
(ioRes   : INTEGER;
(path,
(newName : str128;
(f: File;
(success : BOOLEAN;
 
"PROCEDURE error (): BOOLEAN;
$BEGIN
&IF ioRes < fOK THEN fileErrorAlt (ioRes); RETURN TRUE END;
&RETURN FALSE
$END error;
 
"PROCEDURE errorF (): BOOLEAN;
$BEGIN
&ioRes:= State (f);
&RETURN error ()
$END errorF;
 
"BEGIN
$GetDirEntry (name, entry, ioRes);
$IF error () THEN RETURN END;
$oldEntry := entry;
$
$showFileInfo (entry);
$
$SplitPath (name, path, voidFN);
$Concat (path, entry.name, newName, success);
$IF ~ success THEN reportPathFault; RETURN END;
$
$IF ~ StrEqual (entry.name, oldEntry.name) THEN
&Rename (name, newName, ioRes);
&IF error () THEN RETURN END;
$END;
$IF NOT (subdirAttr IN oldEntry.attr) THEN
&IF ~VarEqual (entry.date, oldEntry.date)
&OR ~VarEqual (entry.time, oldEntry.time) THEN
(Open (f, newName, readOnly);
(IF errorF () THEN RETURN END;
(SetDateTime (f, entry.date, entry.time);
(IF errorF () THEN RETURN END;
(Close (f);
(IF errorF () THEN RETURN END;
&END;
&IF (entry.attr # oldEntry.attr) THEN
(SetFileAttr (newName, entry.attr, ioRes);
(IF error () THEN RETURN END;
&END;
$END;
"END FileInformation;
 
 PROCEDURE FormatDisk (    drive          : FormatDrive;
:sides,
:tracks,
:sectorsPerTrack,
:interleave     : CARDINAL;
:REF name           : ARRAY OF CHAR;
:showStatus     : FileOpStatusProc;
6VAR result         : FormatResult);
 
"CONST fmtBufferSize   = 11L * 1024L;
 
"VAR   fmtBuffer       : ADDRESS;
"
"PROCEDURE write(* (noSectors, side, track, sector: CARDINAL) on the A7 *);
3
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  (A7)+,(A3)+             ; save ret. addr.
(
(MOVE.W  drive(A6),-(A7)
(CLR.L   -(A7)                   ; not used
(MOVE.L  fmtBuffer(A6),-(A7)
(MOVE.W  #flopwr,-(A7)           ; write the boot sector
(TRAP    #xbios
(LEA     $14(A7),A7
(
(MOVE.L  -(A3),-(A7)             ; restore ret. addr.
&END;
$END write;
$(*$L=*)
 
"BEGIN
$ASSEMBLER
(MOVEM.L D4-D6,-(A7)
(
(SUBQ.W  #1,drive(A6)            ; 'drvA' ist 1
(
(MOVE.L  result(A6),A0
(MOVE.W  #failedFR,(A0)          ; be pessimistic
#
(;  format media
(;
(;  D6.W ~ counts tracks | D4.W ~ counts sides
(
(LEA     fmtBuffer(A6),A0
(MOVE.L  A0,(A3)+
(MOVE.L  #fmtBufferSize,(A3)+
(JSR     ALLOCATE                ; alloc. 'fmtBuffer'
(TST.L   fmtBuffer(A6)
(BNE     allocOk
(
(TRAP    #noErrorTrap            ; not enough memory avaible
(DC.W    OutOfMemory - $4000
(BRA.W   ende
 allocOk
(
(MOVE.W  tracks(A6),D6
(SUBQ.W  #1,D6
 trackLoop
 
(MOVE.W  sides(A6),D4
(SUBQ.W  #1,D4
 sideLoop
 
(MOVE.W  #$E5E5,-(A7)            ; virgin word
(MOVE.L  #$87654321,-(A7)        ; magic
(MOVE.W  interleave(A6),-(A7)
(MOVE.W  D4,-(A7)
(MOVE.W  D6,-(A7)
(MOVE.W  sectorsPerTrack(A6),-(A7)
(MOVE.W  drive(A6),-(A7)
(CLR.L   -(A7)                   ; not used
(MOVE.L  fmtBuffer(A6),-(A7)
(MOVE.W  #flopfmt,-(A7)
(TRAP    #xbios                  ; format one track
(LEA     $1A(A7),A7
(TST.W   D0
(BNE.W   stop                    ; bad sectors (no marking yet)
 
(DBF     D4,sideLoop
(
(MOVE.W  D6,(A3)+
(SUBQ.W  #2,A7
(MOVE.L  A7,(A3)+
(MOVE.L  showStatus(A6),A0
(JSR     (A0)
(TST.W   (A7)+
(BNE.W   stop                    ; check user break
 
(DBF     D6, trackLoop
(
(;  write boot sector
(
(MOVE.L  fmtBuffer(A6),A0
(MOVE.W  #127,D0
 clr1Loop
(CLR.L   (A0)+
(DBF     D0,clr1Loop
(
(CLR.W   -(A7)                   ; not executable
(MOVEQ   #1,D0
(ADD.W   sides(A6),D0            ; 2 ~ SS, 3 ~ DS
(MOVE.W  D0,-(A7)
(MOVE.L  #$1000000,-(A7)         ; random serial no.
(MOVE.L  fmtBuffer(A6),-(A7)
(MOVE.W  #protobt,-(A7)          ; make a boot sector
(TRAP    #xbios
(LEA     $E(A7),A7
(
(MOVE.W  #1,-(A7)                ; one sector
(CLR.W   -(A7)                   ; side 1
(CLR.W   -(A7)                   ; track 0
(MOVE.W  #1,-(A7)                ; sector 1
(BSR     write                   ; write boot sector
(TST.W   D0
(BNE.W   stop                    ; stop, if write err
(
(;  write FATs
(
(MOVE.L  fmtBuffer(A6),A0
(MOVE.W  #895,D0                 ; clear 7 sectors
 clr2Loop
(CLR.L   (A0)+
(DBF     D0,clr2Loop
(MOVE.L  fmtBuffer(A6),A0
(MOVE.L  #$F7FFFF00,(A0)         ; FAT-start must be $F7 FF FF
(
(MOVE.W  #5,-(A7)                ; 5 sectors
(CLR.W   -(A7)                   ; side 1
(CLR.W   -(A7)                   ; track 0
(MOVE.W  #2,-(A7)                ; sector 2
(BSR     write                   ; write FAT 1
(TST.W   D0
(BNE.W   stop                    ; stop, if write err
(
(MOVEQ   #5,D6                   ; 5 sectors
(MOVE.W  sectorsPerTrack(A6),D4
(SUBQ.W  #6,D4                   ; 'sectorsPerTrack' - alreadyUsed -> D4
(SUB.W   D4,D6                   ; remaining sectors -> D6
(
(MOVE.W  D4,-(A7)                ; x sectors
(CLR.W   -(A7)                   ; side 1
(CLR.W   -(A7)                   ; track 0
(MOVE.W  #7,-(A7)                ; sector 7
(BSR     write                   ; write FAT 2 Part 1
(TST.W   D0
(BNE     stop                    ; stop, if write err
(
(MOVE.W  sides(A6),D0            ; if two sides then
(MOVEQ   #1,D5                   ;   side 2, track 0
(SUB.W   D5,D0                   ; else
(SUB.W   D0,D5                   ;   side 1, track 1
(EXG.L   D0,D4                   ; D4 = side, D5 = track
(
(TST.W   D6
(BEQ     noPart2                 ; jump, if no sectors left
(
(MOVE.W  D6,-(A7)
(MOVE.W  D4,-(A7)
(MOVE.W  D5,-(A7)
(MOVE.W  #1,-(A7)                ; sector 1
(MOVE.W  drive(A6),-(A7)
(CLR.L   -(A7)                   ; not used
(MULU    #512,D0
(ADD.L   fmtBuffer(A6),D0
(MOVE.L  D0,-(A7)                ; alreadyWrittenSecs * 512 + 'fmtBuffer'
(MOVE.W  #flopwr,-(A7)           ; write the boot sector
(TRAP    #xbios
(LEA     $14(A7),A7
(TST.W   D0
(BNE     stop                    ; stop, if write err
(
 noPart2
 
(;  write root directory
(
(MOVE.L  fmtBuffer(A6),A0
(MOVE.L  name(A6),A1             ; ADR (name) -> A1
(MOVE.W  name+4(A6),D1           ; HIGH (name) -> D1
(MOVEQ   #11,D0
(
(BRA     nameStart
 nameLoop
(MOVE.B  D2,(A0)+
(SUBQ.W  #1,D1
(BMI     nameSpaces
 nameStart
(MOVE.B  (A1)+,D2
(DBEQ    D0,nameLoop
(BNE     nameOk
(
 nameSpaces
(BRA     nameSpcStart
 nameSpcLoop
(MOVE.B  #' ',(A0)+
 nameSpcStart
(DBF     D0,nameSpcLoop
(
 nameOk
(MOVE.B  #08,(A0)+               ;  attribute set for volume label
(
(MOVE.W  #7,-(A7)                ; directory length = 7 sectors
(MOVE.W  D4,-(A7)
(MOVE.W  D5,-(A7)
(ADDQ.W  #1,D6
(MOVE.W  D6,-(A7)
(BSR     write                   ; write directory
(TST.W   D0
(BNE     stop                    ; stop, if write err
(
(MOVE.L  result(A6),A0
(MOVE.W  #okFR,(A0)              ; flag success!
(
 stop
(LEA     fmtBuffer(A6),A0
(MOVE.L  A0,(A3)+
(CLR.L   (A3)+
(JSR     DEALLOCATE              ; dealloc. 'fmtBuffer'
 ende
(MOVEM.L (A7)+,D4-D6
$END;
"END FormatDisk;
"
 END FileManagement.
  
(* $FFEA89F2$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$00006B12$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$FFF57E96$00000A48T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000933$0000093E$0000094B$00000168$0000094B$000009B7$00006A40$00007088$000071F9$000071CE$00000933$00000A4B$000009C2$000009D2$00000A48$00006E6D*)
