 IMPLEMENTATION MODULE Binary; (* V#041 *)
 (*$L-,R-*)
 (*$Y+*)
 
 (*
"28.5.88 tt  berflssiges MOVEQ #0,D2 am Ende v. 'write' entfernt
"3.7.88  tt  Bei write mit null Bytes wird A3 korrekt abgerumt;
.bei Seek wird auch richtig expandiert, wenn FilePos beim
.Aufruf nicht am Fileende ist.
"6.5.90  tt  Read/WriteLargeBlock neu
 *)
 
 FROM FileBase IMPORT Unit, UDataProc, UCloseProc, UFlushProc, URStrProc,
(UWStrProc, UGChrProc;
 
 FROM Files IMPORT File, Access, @CheckState;
 
 FROM SYSTEM IMPORT ASSEMBLER, BYTE, WORD, LONGWORD, ADDRESS, ADR;
 
 IMPORT MOSGlobals;
 
 (*$I FileDesc.Icl *)
 
 (*$O+*)
 TYPE File = POINTER TO FileDesc;
 (*$O-*)
 
 
 PROCEDURE ErrHandler;
"BEGIN
$ASSEMBLER
(MOVE.L  A0,(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     e0
(CLR     File.state(A0)
%e0 CLR     D0
$END
"END ErrHandler;
 
 PROCEDURE CheckAccess;
"BEGIN
$ASSEMBLER
(TST     -(A3)
(BEQ     rf
(CMPI    #2,File.accmode(A0)
(BLS     rt
(MOVE    #MOSGlobals.fBadOp,File.state(A0)
(JMP     ErrHandler
%rf RTS
%rt MOVEQ   #1,D0
$END
"END CheckAccess;
 
 
 PROCEDURE FileSize (f: File): LONGCARD;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     @CheckState
(JSR     CheckAccess
(UNLK    A5
(BEQ     r0
(MOVE.L  File.len(A0),(A3)+
(RTS
%r0 CLR.L   (A3)+
$END
"END FileSize;
 
 
 PROCEDURE FilePos (f: File): LONGCARD;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     @CheckState
(JSR     CheckAccess
(UNLK    A5
(BEQ     r0
(MOVE.L  File.pos(A0),(A3)+
(RTS
%r0 CLR.L   (A3)+
$END
"END FilePos;
 
 
 PROCEDURE write (f:File; start: ADDRESS; len: LONGCARD);
"BEGIN
$ASSEMBLER
(MOVE.L  -12(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     err
(MOVE    File.accmode(A0),D0
(BEQ     badAcc
(CMPI    #2,D0
(BHI     badOp
 
(MOVE.L  -(A3),D0                ; LEN
(BEQ     ok0
(MOVE.L  -(A3),-(A7)             ; START
(MOVE.L  D0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$40,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  (A7)+,D1                ; LEN
(ADDQ.L  #4,A7
(MOVE.L  -(A3),A0
(MOVE    #1,File.modified(A0)
(TST.L   D0
(BPL     ok
(MOVE    D0,File.state(A0)
(UNLK    A5
(RTS
'ok0:
(SUBQ.L  #8,A3
(UNLK    A5
(RTS
 
'badOp:
(MOVE    #MOSGlobals.fBadOp,D0
(BRA     errH
'badAcc:
(MOVE    #MOSGlobals.fBadAccess,D0
'errH:
(MOVE    D0,File.state(A0)
(MOVE.L  A0,(A3)+
(JSR     ErrHandler
'err:
(SUBA.W  #12,A3
(UNLK    A5
(RTS
 
'full:
(MOVE    #MOSGlobals.fDiskFull,File.state(A0)
(UNLK    A5
(RTS
 
'ok:
(CMP.L   D0,D1
(BHI     full
(ADD.L   D1,File.pos(A0)
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCS     end
(MOVE.L  D0,File.len(A0)
'end:
(UNLK    A5
$END
"END write;
 
 PROCEDURE seek0;
"BEGIN
$ASSEMBLER
(MOVE.W  D3,-(A7)
(MOVE.W  File.handle(A4),-(A7)
(MOVE.L  D4,-(A7)
(MOVE    #$42,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
$END
"END seek0;
 
 PROCEDURE Seek (f: File; offset : LONGINT; base: SeekMode);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVEM.L D3-D5/A4,-(A7)
(MOVE.W  -(A3),D3        ; base
(MOVE.L  -(A3),D4        ; offset
(JSR     @CheckState
(JSR     CheckAccess
(MOVE.L  A0,A4           ; f
(BEQ.L   end
(
(; r := seek (offset,f^.handle,base);
(JSR     seek0
(TST.L   D0
(BPL.L   noErr
(
(CMPI.W  #-64,D0
(BNE.L   genErr
(TST     File.accmode(A4)
(BEQ.L   genErr
(
(; Seek ans Ende
(MOVE.L  D4,D5
(SWAP    D3
(MOVEQ   #0,D4
(MOVE    #fromEnd,D3
(JSR     seek0
(TST.L   D0
(BMI.L   genErr
(SWAP    D3
(MOVE.L  D5,D4
(
(MOVE.L  File.len(A4),D5         ; len
(CMP.L   D5,D0
(BNE.L   interr          ; -> Fehler: len und seek-Pos nicht gleich
(
(CMPI    #1,D3
(BEQ     frPos
(BCS     frBeg
(ADD.L   D5,D4
&frPos
(ADD.L   File.pos(A4),D4
&frBeg
(
(CMP.L   D5,D4
(BLS     noExp
(
(SUB.L   D4,D5
(NEG.L   D5
(
%l0 MOVE.L  A4,(A3)+
(MOVE.L  #$8000,(A3)+
(CMPI.L  #$4000,D5
(BLS     t2
(MOVE.L  #$4000,D0
(BRA     t3
%t2 MOVE.L  D5,D0
%t3 MOVE.L  D0,(A3)+
(PEA     rtnadr(PC)
(LINK    A5,#0
(JMP     write
%rtnadr:
(TST     File.state(A4)
(BMI     end
(SUB.L   #$4000,D5
(BGT     l0
(
(CLR     D3              ; base:= fromBegin
(JSR     seek0
(
&noExp:
(TST.L   D0
(BPL     noErr
(
&genErr:
(MOVE    D0,File.state(A4)
(BRA     end
(
&interr
(MOVE    #MOSGlobals.fInternalErr1,D0
(BRA     genErr
(
&noErr:
(MOVE.L  D0,File.pos(A4)
(CMP.L   File.len(A4),D0
(BLS     end
(MOVE.L  D0,File.len(A4)
(
&end:
(MOVEM.L (A7)+,D3-D5/A4
(UNLK    A5
$END
"END Seek;
 
 
 PROCEDURE read;
"BEGIN
$ASSEMBLER
(MOVEM.L D1/D2/A0,-(A7)
(MOVE    File.handle(A0),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
(MOVEM.L (A7)+,D1/D2/A0  ; len / * / f
(TST.L   D0
(BPL     ok
(MOVE    D0,File.state(A0)
(UNLK    A5
(RTS
'ok
(ADD.L   D1,File.pos(A0)
'end
(UNLK    A5
$END
"END read;
 
 PROCEDURE rd_prep;
"BEGIN
$ASSEMBLER
(MOVE.L  D1,D0
(ADD.L   File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BHI     t0
(JMP     read
%t0 MOVE    #MOSGlobals.fEndOfFile,File.state(A0)
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BCS     e0
(JSR     ErrHandler
%e0
$END
"END rd_prep;
 
 PROCEDURE ReadByte (f: File; VAR byte: BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; start
(MOVEQ   #1,D1           ; len
(JSR     rd_prep
%e0 UNLK    A5
$END
"END ReadByte;
 
 PROCEDURE ReadWord (f: File; VAR word: WORD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; start
(MOVEQ   #2,D1           ; len
(JSR     rd_prep
%e0 UNLK    A5
$END
"END ReadWord;
 
 PROCEDURE ReadLong (f: File; VAR long: LONGWORD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; start
(MOVEQ   #4,D1           ; len
(JSR     rd_prep
%e0 UNLK    A5
$END
"END ReadLong;
 
 PROCEDURE ReadBlock (f: File; VAR block: ARRAY OF BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.W  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; start
(MOVEQ   #0,D1
(MOVE.W  (A7)+,D1        ; HIGH
(ADDQ.L  #1,D1
(JSR     rd_prep
%e0 UNLK    A5
$END
"END ReadBlock;
 
 PROCEDURE ReadLargeBlock (f: File; VAR block: LONGARRAY OF BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; start
(MOVE.L  (A7)+,D1        ; HIGH
(ADDQ.L  #1,D1
(JSR     rd_prep
%e0 UNLK    A5
$END
"END ReadLargeBlock;
 
 PROCEDURE ReadBytes (    f        : File;
9addr     : ADDRESS;
9bytes    : LONGCARD;
5VAR bytesRead: LONGCARD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)     ; bytesRead
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(JSR     @CheckState
(JSR     CheckAccess
(BEQ     e0
(MOVE.L  (A7)+,D2        ; addr
(MOVE.L  (A7)+,D1        ; bytes
(MOVE.L  (A7)+,A1        ; bytesRead
(MOVE.L  File.len(A0),D0
(SUB.L   File.pos(A0),D0
(CMP.L   D0,D1
(BLS     t0
(MOVE.L  D0,D1
%t0 MOVE.L  D1,(A1)
(JMP     read
%e0 UNLK    A5
$END
"END ReadBytes;
 
 
 PROCEDURE WriteByte (f: File; byte: BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.W  -(A3),-(A7)
(MOVE.L  A7,(A3)+
(MOVEQ   #1,D0
(MOVE.L  D0,(A3)+
(JMP     write
$END
"END WriteByte;
 
 PROCEDURE WriteWord (f: File; word: WORD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.W  -(A3),-(A7)
(MOVE.L  A7,(A3)+
(MOVEQ   #2,D0
(MOVE.L  D0,(A3)+
(JMP     write
$END
"END WriteWord;
 
 PROCEDURE WriteLong (f: File; long: LONGWORD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -(A3),-(A7)
(MOVE.L  A7,(A3)+
(MOVEQ   #4,D0
(MOVE.L  D0,(A3)+
(JMP     write
$END
"END WriteLong;
 
 PROCEDURE WriteBlock (f: File; REF block: ARRAY OF BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVEQ   #0,D0
(MOVE.W  -(A3),D0
(ADDQ.L  #1,D0
(MOVE.L  D0,(A3)+
(JMP     write
$END
"END WriteBlock;
 
 PROCEDURE WriteLargeBlock (f: File; REF block: LONGARRAY OF BYTE);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(ADDQ.L  #1,-4(A3)
(JMP     write
$END
"END WriteLargeBlock;
 
 PROCEDURE WriteBytes (f: File; addr: ADDRESS; bytes: LONGCARD);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JMP     write
$END
"END WriteBytes;
 
 END Binary.
  
(* $00001B3D$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$000002CB$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$FFFD5CDA$00000259T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001FA8$00000A99$000020C8$FFF0C822$FFF0C822$00000838$00000259$FFED095D$00000BB8$0000146B$0000158B$000016AF$000017DA$000018DE$00001A3C$00002052*)
