 IMPLEMENTATION MODULE WindowBase;
 (*$Y+*)
 
 (*
 FROM StrConv IMPORT IntToStr;
 FROM Terminal IMPORT WriteString, WriteLn, Read;        (*  Debugging  *)
 *)
 
 
 (*  Basismodul fr die Fensterverwaltung des MEGAMAX Modula-2 Systems
!*
!*  Autor: Manuel Chakravarty           Copyright (C) 1988
!*
!*  Erstellt: 6.4.88                    System: MEGAMAX Modula-2 V2.2
!*
!*  Interne Modulversion V#0413         Version V1.1
!*
!*  ----------------------------------------------------------------------
!*
!*  06.04.88 | V0.01    | Erste Version des Def.moduls
!*  07.05.88 | V0.01    | Erste Definitionen im Impl.modul
!*  15.05.88 | V0.01    | 'CreateWindow' + 'DeleteWindow' + 'notValid' +
!*                        'WindowState' + 'OpenWindow' + 'CloseWindow'
!*  24.05.88 | V0.01    | 'initGem' + 'FullArea'
!*  25.05.88 | V0.01    | 'SetWindowString'
!*  30.05.88 | V0.02    | 'careOfCorrectParms' begonnen und server-setzen
!*                        in 'CreateWindow' verlagert
!*  31.05.88 | V0.02    | 'careOfCorrectParms' erweitert + watch dogs
!*  02.06.88 | V0.02    | 'watchRedraw' vervollstndigt + Opt. in asm
!*  06.06.88 | V0.02    | 'watchRedraw' (asm) funktioniert jetzt richtig
!*                        + 'WindowSliders' + Setzen der Slider-Werte
!*  25.07.88 | V0.02    | Beginn der Scroll-Mechanismen
!*  13.08.88 | V0.02    | Scrolling weiter
!*  14.08.88 | V0.02    | Scrolling weiter
!*  15.08.88 | V0.02    | Scrolling fertig + 'UpdateWindow'
!*  29.09.88 | V0.03    | 'MouseProtector'
!*  10.11.88 | V0.03    | 'MouseProtector' luft. 'termProc' fhrt 'exitGem'
!*                        nur aus, falls das 'gemHdl' noch init. ist.
!*                        Die Hannes-Idee: 'pixelAmount' wird jetzt richtig
!*                        berechnet, ohne Rundungsfehler.
!*                        Fenster werden beim Schieben aus dem Desktop-Bereich
!*                        nicht mehr autom. verkleinert, solange der Anwender
!*                        nicht 'ctrl' festhlt.
!*  15.11.88 | V0.04    | 'DetectWindow' + 'WindowCoordinates'
!*  16.11.88 | V0.04    | 'WindowCoordiantes' korrigiert. 'ResetWindowState'
!*                        und 'SetTopWindow'
!*  20.11.88 | V0.05    | In 'mouseMoveProc' das Prinzip der min. nderung
!*                        eingefhrt.
!*                        'GetMinimalWindowSize' + 'BorderToWorkSize' +
!*                        'RedrawWindow' + 'ScreenCoordinates' impl.
!*  21.11.88 | V0.06    | 'PixelToFraction' + 'FractionToPixel' +
!*                        'FramesToSliders' impl. und 'GetMinimalWindowSize'
!*                        um minimale Position erweitert und 'scrollSrvr'
!*                        wird nun auch bei Vernderungen der Slider durch
!*                        sizing aufgerufen und bekommt die gesamte
!*                        'SliderState' bergeben bzw. liefert sie zurck.
!*                        'moveSizeSrvr' bekommt 'wdw^.elems' nicht mehr
!*                        geliefert.
!*  22.11.88 | V0.06    | 'FramesToSliders' -> 'CalculateSliders'
!*  23.11.88 | V0.06    | 'wdw^.state' wird vor 'raiseError' zurckgesetzt.
!*                        Slider werden bei jedem 'redraw' korrigiert, falls
!*                        ntig. 'DetectWindow' macht ein 'careInitGem'.
!*  05.12.88 | V0.06    | 'MaxWdw' liefert keine zu groen Fenster mehr.
!*  08.12.88 | V0.07    | 'CalculateSliders' verdaut jetzt auch 'virtualWidth/
!*                        Height = 0'.
!*                        'moveSizeSrvr' erhalt als zustzlichen Parameter
!*                        'maxWork'.
!*                        Bei 'WindowFlags' hat nun auch das 'topWdw'-Flag
!*                        den richtigen Wert.
!*                        'DetectWindow' berprft, ob das gefundene Fenster
!*                        im 'targets'-Array ist.
!*                        '...General' impl.
!*                        'CreateWindow' liefert keinen 'success'-Parm. mehr.
!*  13.02.89 | V0.07    | 'WindowFlags' liefert jetzt auch fr geschlossene
!*                        Fenster den richtigen Wert.
!*  20.02.89 | V0.07    | Jetzt sollte 'WindowFlags' wirklich funktionieren.
!*  02.04.89 | V0.07    | 'DeleteWindow' gibt jetzt auch die title- und
!*                        info-string-pointer frei.
!*  27.06.89 | V0.08    | Uses 'ResCtrl'
!*  29.06.89 | V0.09    | Def.-nderungen von TT: 'GetMinimal.' -> 'Smallest.'
!*                        + 'ScrollWdwProc' -> 'NewSliderWdwProc'
!*                        + 'ActiveWdwProc' -> 'ActivatedWdwProc'
!*  01.08.89 | V0.10    | 'SetWindowSliderPos' def. + impl.
!*  02.08.89 | V0.11    | 'SysCreateWindow' def. + impl.;
!*                        'SetTopWindow' -> 'PutWindowOnTop'
!*  12.08.89 | V0.12    | Neue Sliderverwaltung
!*  13.08.89 | V0.12    |   "        "
!*  14.08.89 | V0.12    |   "        "         ; beim GEM initalisieren
!*                        wird der Mauszeiger auf Pfeil geschaltet.
!*  15.08.89 | V0.12    | Slider-Debugging
!*  16.08.89 | V0.12    | Kein redraw, falls Fenster versteckt
!*  17.08.89 | V0.12    | 'currBorder' wird jetzt immer init.
!*  19.08.89 | V1.0     | Modul abgeschlossen + Dokumentation
!*  15.02.90 | V1.1     | Anpassung an Compilerversion 4.0
!*  10.04.90 | V1.1     | 'modID' ist ein Integer, damit beim removen kein
!*                        Laufzeitfehler auftritt
!*  13.11.90 | V1.2 TT  | UpdateWindow- und GrafMouse-Aufrufe vertauscht
!*  25.11.90 | V1.2 TT  | 'careOfExitGem' sorgt fr rechtzeitige Abmeldung.
!*                        Ist ntig, da sonst bei "ModLoad" nach 1. Modulstart
!*                        "ExitGem" nicht aufgerufen wird und die automatische
!*                        Abmeldung wg. "SysInitGem" nicht den 'cb' freigibt.
!*  08.04.91 |      TT  | Textkorrektur: "Wdw. already close" -> "...closed"
!*  21.05.93 |      TT  | Bei windTopped und windClosed knnen die Msg-
!*                        Events trotzdem weitergeleitet (PassHandledMsg)
!*                        werden. Dies hat aber offenbar keinen Effekt, da
!*                        dieser Watchdog spter als die Anwendung drankommt.
!*  22.05.93 |      TT  | berarbeitung f. MultiTOS: An allen kritischen
!*                        Stellen UpdateWindow-Aufrufe eingefgt.
!*  25.05.93 |      TT  | Beim Setzen der sichtbaren Fenstergre wird sicher-
!*                        gestellt, da die Rahmenelemente nicht auerhalb
!*                        des Desktop-Bereichs verschwinden.
!*
!*  ----------------------------------------------------------------------
!*)
 
 (* ================= ZU TUN: ==========================
!*
!*  ++ In 'WBATest' verschwindet der Mauszeiger manchmal, wenn ber dem 
!*     STDIO-Fenster gesized wird.
!*
!*  ++ new top server? Geht wohl leider nicht.
!*
!*  -- Stellen, die Ausnutzung des Fensterkoor.sys. einschrnken (wegen
!*     evtl.en berlufen) sind mit !longcalc! gekennzeichnet.
!*
!*  -- 'MouseProtector' ist ausgeklammert, er mte abschaltbar sein
!*     und macht wohl auch noch Fehler. Die Einklammerungen sind mit
!*     !protector! markiert.
!*
!*  -- Das 'Cutting' (beim Verschieben mit CTRL) ist ausgeklammert und mit
!*     !cutting! makiert. Der aktuelle Fehler darin ist, das nach dem Cut-
!*     ting der Rahmen unter Umstnden nicht mehr vom 'moveSizeSrvr' ak-
!*     zeptiert werden wrde.
!*
!*  -- Teilweise mssen den Maschinenroutinen noch ihre Modula-quivalente
!*     zur Seite gestellt werden.
!*
!* ================= DOCU: ============================
!*
!*)
 
 
 FROM SYSTEM     IMPORT ASSEMBLER, ADDRESS, BYTE,
7ADR;
 
 (*  MOS  *)
 
 FROM Storage    IMPORT SysAlloc, DEALLOCATE;
 
 FROM MOSGlobals IMPORT IllegalPointer, GeneralErr, OutOfMemory, MemArea;
 
 FROM PrgCtrl    IMPORT TermCarrier, EnvlpCarrier,
7CatchProcessTerm, SetEnvelope;
 
 FROM ResCtrl    IMPORT RemovalCarrier,
7CatchRemoval;
 
 
 (*  Misc.  *)
 
 FROM Strings    IMPORT Assign;
 
 
 (*  GEM  *)
 
 FROM GrafBase           IMPORT Point, Rectangle, LongPnt, LongRect,
?Pnt, Rect, LPnt, LRect, ClipRect;
 
 FROM GEMGlobals         IMPORT PtrMaxStr, MButtonSet, SpecialKey;
 
 FROM GEMEnv             IMPORT RC, DeviceHandle, GemHandle,
?SysInitGem, ExitGem, CurrGemHandle,
?SetCurrGemHandle;
 
 IMPORT VDIInputs;
 
 FROM VDIInquires        IMPORT GetFaceInfo;
 
 IMPORT AESWindows;
 
 FROM AESGraphics        IMPORT MouseForm, GrafMouse;
 
 FROM AESEvents          IMPORT windRedraw, windTopped, windClosed, windFulled,
?windArrowed, windHSlid, windVSlid, windSized,
?windMoved, windNewTop,
?Event;
 IMPORT AESEvents;
 
 
 (*  Beyond GEM  *)
 
 FROM EventHandler       IMPORT WatchDogCarrier, EventProc,
?SysInstallWatchDog, DeInstallWatchDog;
 
 
 CONST   TestVersion     = FALSE; (*  Debugging?  *)
 
 (*$? NOT TestVersion:  (*$R-*)
!*)
 
 CONST   (*  MOS  *)
 
(noErrorTrap     = 6;            (*  MOS-runtime error Trap-Number *)
(
((*  GEM  *)
 
(noGem           = GemHandle (NIL);  (*  means GEM not init.  *)
(
(minWWithScrollElemChars = 14;   (*  min. widths/heights for wdw.s  *)
(minHWithScrollElemChars = 7;    (*  with 'scrollElem' (in chars)   *)
(
(CenterVis       = MinLInt;
(MaxVis          = MinLInt;
(
((*  intern  *)
!
(wdwMagic        = 302210L;      (*  window magic  *)
(
 TYPE    ptrWindow       = POINTER TO window;
(window          = RECORD
(
<(*  changing values  *)
<
<flags        : WdwFlagSet; (*  curr. window flags *)
<currBorder,
<lastBorder   : Rectangle;
<spec         : WindowSpec;
<title,
<info         : PtrMaxStr;
<
<hdl          : CARDINAL;   (*  AES window handle  *)
<
<(*  not changing attributes  *)
<
<elems        : WdwElemSet; (*  window elements  *)
<aesElems     : AESWindows.WElementSet;
<updateSrvr   : UpdateWdwProc; (*  server  *)
<checkSpecSrvr: CheckSpecWdwProc;
<scrollAmtSrvr: ScrollAmtWdwProc;
<activatedSrvr: ActivatedWdwProc;
<closeSrvr    : CloseWdwProc;
<env          : ADDRESS;
<
<(*  managment vars.  *)
<
<horSlidChgd,
<vertSlidChgd,
<moveSizeChgd : BOOLEAN;
<
<state        : WdwState;
<
<next         : Window;
<modID        : INTEGER;   (*  0 = SysCreate  *)
<magic        : LONGCARD;
<
:END;
(Window          = ptrWindow;
:
 VAR     (*  Global Info.  *)
 
(deskFrame               : Rectangle;    (*  Ausmae des Desktop  *)
(minWWithScrollElem,
(minHWithScrollElem      : INTEGER;
(
((*  Global Variables  *)
:
(windowRoot      : Window;       (*  root of the list of all registrated
I*  windows.
I*)
(modID, initID   : INTEGER;    (*  0 = SysLevel; -1 nach 'removalProc' *)
(
(dev             : DeviceHandle;
(gemHdl          : GemHandle;
(
((*  Misc. Variables  *)
(
(VoidO           : BOOLEAN;
(VoidI           : INTEGER;
(VoidC           : CARDINAL;
 
 
 (* $? TestVersion:
 
 PROCEDURE wLn;
 
"BEGIN
$InOut.WriteLn;
"END wLn;
"
 PROCEDURE wFrame (f: Rectangle);
 
"BEGIN
$InOut.WriteInt (f.x, 5); InOut.WriteInt (f.y, 5);
$InOut.WriteInt (f.w, 5); InOut.WriteInt (f.h, 5);
"END wFrame;
 
 PROCEDURE wStr (REF str: ARRAY OF CHAR);
 
"BEGIN
$InOut.WriteString (str);
"END wStr;
 
 PROCEDURE wLInt (i: LONGINT);
 
"BEGIN
$InOut.WriteInt (i, 0);
"END wLInt;
"
 PROCEDURE wLFrame (f: LongRect);
 
"BEGIN
$InOut.WriteInt (f.x, 5); InOut.WriteInt (f.y, 5);
$InOut.WriteInt (f.w, 5); InOut.WriteInt (f.h, 5);
"END wLFrame;
 
!*)
"
 
 (* !protector!
 
 MODULE MouseProtector;
 
 
 FROM VDIInputs IMPORT MsMoveVecCarrier,
6InstallMsMoveProc, RemoveMsMoveProc, GetMouseState;
 
 IMPORT Rectangle, Point, MemArea, MButtonSet,
'dev,
'ADR;
 
 EXPORT setProtectionArea, disableProtection, mouseIsInFrame, termProtector;
 
 
 CONST   mouseSize = 16;
"
 VAR     vectorHdl       : MsMoveVecCarrier;
(installed       : BOOLEAN;
(pFrame          : Rectangle;
(protect         : BOOLEAN;
(
(stack           : ARRAY [0..511] OF CARDINAL;
 
 
 PROCEDURE mouseIsInFrame0 (loc: Point; frame: Rectangle): BOOLEAN;
 
"BEGIN
$RETURN (loc.x + mouseSize >= frame.x) AND
+(loc.x - mouseSize < frame.x + frame.w) AND
+(loc.y + mouseSize >= frame.y) AND
+(loc.y - mouseSize < frame.y + frame.h)
"END mouseIsInFrame0;
"
 PROCEDURE mouseIsInFrame (frame: Rectangle): BOOLEAN;
 
"VAR   buts: MButtonSet;
(loc : Point;
 
"BEGIN
$GetMouseState (dev, loc, buts);
$RETURN mouseIsInFrame0 (loc, frame)
"END mouseIsInFrame;
"
 (*  !!! ATTENTION !!!
!*
!*  If the following and all called proc.s would be written in asm. and
!*  compiled with $L-, then 'stack' could be of smaller contens.
!*)
 
 PROCEDURE mouseMoveProc (VAR loc: Point): BOOLEAN;
 
"VAR   (* horM, vertM: INTEGER; *)
(diffs       : ARRAY[0..3] OF INTEGER;
(vert, hor,
(vSign, hSign: INTEGER;
 
"BEGIN
$IF protect THEN
&diffs[0] := pFrame.x - loc.x - mouseSize;                (*  left  *)
&diffs[1] := loc.x - mouseSize - pFrame.x - pFrame.w + 1; (*  right  *)
&diffs[2] := pFrame.y - loc.y - mouseSize;                (*  top  *)
&diffs[3] := loc.y - mouseSize - pFrame.y - pFrame.h + 1; (*  bottom  *)
&
&(*  Is mouse on left or right side of the frame?
'*)
&IF ABS (diffs[0]) > ABS (diffs[1]) THEN hor := diffs[1]; hSign := -1;
&ELSE hor := diffs[0]; hSign := 1 END;
&
&(*  Is mouse on top or bottom side of the frame?
'*)
&IF ABS (diffs[2]) > ABS (diffs[3]) THEN vert := diffs[3]; vSign := -1;
&ELSE vert := diffs[2]; vSign := 1 END;
&
&(*  If mouse is in frame the correct horizontally or vertically,
'*  depending on which way is shorter. (Prinzip of min. correction)
'*)
&IF (hor < 0) AND (vert < 0) THEN
(IF hor > vert THEN loc.x := loc.x + hor * hSign
(ELSE loc.y := loc.y + vert * vSign END;
&END;
$END;
"
"(*
$IF protect AND mouseIsInFrame0 (loc, pFrame) THEN
&horM := pFrame.x + pFrame.w DIV 2;
&vertM := pFrame.y + pFrame.h DIV 2;
&IF (loc.x + mouseSize > pFrame.x) AND (loc.x < horM)
&THEN loc.x := pFrame.x - mouseSize END;
&IF (loc.x - mouseSize < pFrame.x + pFrame.w) AND (loc.x >= horM)
&THEN loc.x := pFrame.x + pFrame.w + mouseSize END;
&IF (loc.y + mouseSize > pFrame.y) AND (loc.y < vertM)
&THEN loc.y := pFrame.y - mouseSize END;
&IF (loc.y - mouseSize < pFrame.y + pFrame.h) AND (loc.y >= vertM)
&THEN loc.y := pFrame.y + pFrame.h + mouseSize END;
$END;
#*)
$RETURN TRUE
"END mouseMoveProc;
"
 PROCEDURE setProtectionArea (frame: Rectangle);
 
"VAR   wsp: MemArea;
 
"BEGIN
$IF ~ installed THEN
&wsp.bottom := ADR (stack);
&wsp.length := SIZE (stack);
&InstallMsMoveProc (vectorHdl, mouseMoveProc, wsp);
&installed := TRUE;
$END;
$pFrame := frame; protect := TRUE;
"END setProtectionArea;
"
 PROCEDURE disableProtection;
 
"BEGIN
$protect := FALSE;
"END disableProtection;
 
 PROCEDURE termProtector;
 
"BEGIN
$IF installed THEN RemoveMsMoveProc (vectorHdl); installed := FALSE END;
"END termProtector;
"
"
 BEGIN
"installed := FALSE;
"protect := FALSE;
 END MouseProtector;
 
 *)
(
(
((*  Misc. Proc.s  *)
((*  ============  *)
 
 (*  Should be in 'GrafBase'
!*)
 
 PROCEDURE ShortFrame (f: LongRect): Rectangle;
 
"BEGIN
$RETURN Rect (SHORT (f.x), SHORT (f.y), SHORT (f.w), SHORT (f.h))
"END ShortFrame;
"
 (*  Should be in 'GrafBase'
!*)
 
 PROCEDURE LongFrame (f: Rectangle): LongRect;
 
"BEGIN
$RETURN LRect (LONG (f.x), LONG (f.y), LONG (f.w), LONG (f.h))
"END LongFrame;
"
 
 (*  raiseError -- Raises a runtime error, with a error text depending on
!*                the value of 'state'.
!*)
 
 PROCEDURE raiseError (state: WdwState);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D0
(CMP.W   #cantOpenWdw,D0
(BEQ     cantOpen
(CMP.W   #alreadyOpenWdw,D0
(BEQ     alreadyOpen
(CMP.W   #alreadyCloseWdw,D0
(BEQ     alreadyClose
(CMP.W   #invalidElemWdw,D0
(BEQ.W   invalidElem
(BRA.W   ende
 
 cantOpen
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     "Can't open window (WindowBase)"
(SYNC
(BRA.W   ende
(
 alreadyOpen
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     "Wdw. already open (WindowBase)"
(SYNC
(BRA     ende
(
 alreadyClose
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     "Wdw. already closed (WindowBase)"
(SYNC
(BRA     ende
(
 invalidElem
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     "Invalid element (WindowBase)"
(SYNC
(BRA.W   ende
(
 ende
$END;
"END raiseError;
"(*$L+*)
"
(
 (*  notValid -- Test if 'wdw' is a valid window handle. If it is neither
!*              NIL nor valid let a runtime error (Illegal Pointer) occure.
!*              If the handle is valid and 'wdw^.state # okWdw' then cause
!*              a runtime error.
!*              All exported proc.s, that have got an 'Window'-Parm. are
!*              calling this proc. at there beginning except 'WindowState'
!*              and 'ResetWindowState'.
!*)
 
 PROCEDURE notValid (wdw:Window): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.W  #TRUE,(A3)+
(MOVE.L  A0,D1
(BEQ     ende                    ; 'wdw = NIL'
(
(AND.L   #1,D1
(BNE     illegal                 ; odd addr.
(
(MOVE.L  #wdwMagic,D1
(CMP.L   Window.magic(A0),D1
(BNE     illegal                 ; wrong magic number
(
(CLR.W   -2(A3)
(MOVE.W  #okWdw,D1
(CMP.W   Window.state(A0),D1     ; window state ok?
(BEQ     ende                    ; VALID!
(
(MOVE.W  Window.state(A0),(A3)+
(MOVE.W  D0,Window.state(A0)
(JSR     raiseError
(CLR.W   -2(A3)
(BRA     ende
(
 illegal
(TRAP    #noErrorTrap
(DC.W    IllegalPointer-$4000
 
 ende
$END;
"END notValid;
"(*$L=*)
 
 
 (*  reportOutOfMem -- Raises a 'Out of memory' runtime error.
!*                    It is possible to continue from the error.
!*)
!
 PROCEDURE reportOutOfMem;
 
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    OutOfMemory - $4000
$END;
"END reportOutOfMem;
 
 (*  reportServerErr -- Raises a runtime error, with the message:
!*                     "Window server failed (WindowBase)".
!*                     It is possible to continue from the error.
!*)
!
 PROCEDURE reportServerErr;
 
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     "Window server failed (WindowBase)"
(SYNC
$END;
"END reportServerErr;
 
 (*  createNullStr -- Alloc. a string that contains only a 0C. Returns a
!*                   pointer to the string.
!*)
!
 PROCEDURE createNullStr (): PtrMaxStr;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(MOVEQ   #1,D0
(MOVE.L  D0,(A3)+
(JSR     SysAlloc        ; SysAlloc (x, 1L)
(MOVE.L  (A7)+,A0
(MOVE.L  A0,(A3)+
(BNE     cont
(
(JSR     reportOutOfMem
(BRA     ende
(
 cont
(CLR.B   (A0)            ; x^[0]:=0C
 ende
$END;
"END createNullStr;
"(*$L=*)
 
 
8(*  GEM handling proc.s  *)
8(*  ===================  *)
 
 
 FORWARD installWatchDogs;
 FORWARD deinstallWatchDogs;
 
 (*  initGem -- Fhrt die Anmeldung beim GEM und diverse damit zusammen-
!*             hngende Init.en aus.
!*)
 
 PROCEDURE initGem;
 
"VAR   success : BOOLEAN;
(top,
(bottom  : CARDINAL;
(width   : INTEGER;
 
"BEGIN
"
 (*$? TestVersion:
"WriteString ("'WindowBase' connecting to GEM...");
!*)
!
$SysInitGem (RC, dev, success); IF ~ success THEN RETURN END;
$gemHdl := CurrGemHandle ();
$
$AESWindows.UpdateWindow (TRUE);
$
 (*$? TestVersion:
"WriteString ("'WindowBase' connected."); WriteLn;
!*)
!
$(*  init. global info var.s  *)
$
$deskFrame := AESWindows.WindowSize (AESWindows.DeskHandle,
HAESWindows.workSize);
H
$GetFaceInfo(dev, VoidC,VoidC, bottom,VoidC,VoidC,VoidC, top,
0width ,VoidI,VoidI,VoidI);
$minWWithScrollElem := width * minWWithScrollElemChars;
$minHWithScrollElem := (bottom + top + 1) * minHWithScrollElemChars;
$
$installWatchDogs;
$
$GrafMouse (arrow, NIL);
$
$AESWindows.UpdateWindow (FALSE);
$
"END initGem;
 
 (*  exitGem -- Deinstalls all GEM stuff.
!*)
 
 PROCEDURE exitGem;
 
"BEGIN
$IF gemHdl # noGem THEN
 (*$? TestVersion:
"WriteString ("'WindowBase' deinstall watch dogs...");
!*)
&deinstallWatchDogs;
$
 (*$? TestVersion:
"WriteString ("'WindowBase' exit GEM...");
!*)
&ExitGem (gemHdl)
$END;
"END exitGem;
 
 (*  saveCurrHdl -- Rettet das aktuelle GEM-Hdl. in 'saveArea' und setzt
!*                 stattdessen das handle von 'WindowBase' ein. Tritt
!*                 beim Setzen ein Fehler auf, so wird ein Laufzeitfehler
!*                 ausgelt.
!*)
 
 PROCEDURE saveCurrHdl (VAR saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     CurrGemHandle
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
(
(MOVE.L  gemHdl,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "WindowBase:Can't set own GEMHdl"
(SYNC
(
 ende
$END;
"END saveCurrHdl;
"(*$L=*)
 
 (*  restoreCurrHdl -- Setzt 'saveArea' als GEM-Hdl. ein. Falls dabei ein
!*                    Fehlere auftritt, wird ein Laufzeitfehler ausgelt.
!*)
(
 PROCEDURE restoreCurrHdl (saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST.L   -4(A3)
(BEQ     ende            ; jump, if 'saveArea = noGem'
(
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "WindowBase:Can't set old GEMHdl"
(SYNC
(
 ende
$END;
"END restoreCurrHdl;
"(*$L=*)
"
 PROCEDURE careOfInitGem;
 
"VAR   oldHdl  : GemHandle;
 
"BEGIN
$IF gemHdl = noGem THEN
&oldHdl := CurrGemHandle ();
&initGem;
&initID:= modID; (* merken, wann initGem gemacht wurde *)
&restoreCurrHdl (oldHdl);
$END;
"END careOfInitGem;
 
 PROCEDURE careOfExitGem;
 
"BEGIN
$IF (initID = modID) & (windowRoot = NIL) THEN
&exitGem;
$END;
"END careOfExitGem;
 
 
8(*  Window Managment Routines  *)
8(*  =========================  *)
 
 (*  calculating proc.s  *)
 
 (*  windowToScreenFrame -- Berechnet aus einem Rechteck in Fensterkoor. das
!*                         zugehrige Rechteck in Bildschirmkoor.
!*
!*                         VAR-Parm. nur aus Geschw.grnden.
!*)
!
 PROCEDURE windowToScreenFrame (wdw: ptrWindow; VAR frame: LongRect): LongRect;
 
"BEGIN
$RETURN LRect (frame.x + wdw^.spec.virtual.x, frame.y + wdw^.spec.virtual.y,
2frame.w, frame.h)
"END windowToScreenFrame;
 
 (*  screenToWindowFrame -- Berechnet aus einem Rechteck in Bildschirmkoor.
!*                         das zugehrige Rechteck in Fensterkoor. Dabei
!*                         wird auf die Gre des Fensterhintergrundes
!*                         geclippt.
!*)
!
 PROCEDURE screenToWindowFrame (wdw: ptrWindow; frame: Rectangle): LongRect;
"
"BEGIN
$RETURN LRect (LONG (frame.x) - wdw^.spec.virtual.x,
2LONG (frame.y) - wdw^.spec.virtual.y,
2LONG (frame.w), LONG (frame.h))
"END screenToWindowFrame;
 
 PROCEDURE maxWorkArea (wdw: ptrWindow): LongRect;
 
"VAR   spec: WindowSpec;
(max : LongRect;
"
"BEGIN
"
$spec.virtual := wdw^.spec.virtual;
$max := LongFrame (AESWindows.CalcWindow
8(AESWindows.calcWork, wdw^.aesElems, deskFrame));
$spec.virtual.x := max.x;
$spec.virtual.y := max.y;
$spec.visible := LRect (0L, 0L, max.w, max.h);
 (*
 wStr ('  before checkSpec:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
$wdw^.checkSpecSrvr (wdw, wdw^.env, spec,
8LRect (0L, 0L, max.x + max.w, max.y + max.h));
 (*
 wStr ('  after checkSpec:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
$
$spec.virtual.x := (max.w - spec.visible.w) DIV 2L + max.x;
$spec.virtual.y := (max.h - spec.visible.h) DIV 2L + max.y;
$spec.visible.x := 0L;
$spec.visible.y := 0L;
 (*
 wStr ('  before checkSpec2:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
$wdw^.checkSpecSrvr (wdw, wdw^.env, spec, max);
 (*
 wStr ('  after checkSpec2:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
$
$RETURN LRect (spec.virtual.x + spec.visible.x,
2spec.virtual.y + spec.visible.y,
2spec.visible.w, spec.visible.h)
"END maxWorkArea;
"
"
 (*  working proc.s  *)
"
 PROCEDURE tellAESSliderValues (wdw: Window; tellHor, tellVert: BOOLEAN);
 
"PROCEDURE calcAESSliderPos (visiblexy,
>visiblewh,
>virtualwh: LONGINT): INTEGER;
 
$(*  !longcalc!  *)
$BEGIN
&IF visiblewh >= virtualwh THEN RETURN 0
&ELSE RETURN INTEGER (SHORT ((visiblexy * 1000L)
CDIV (virtualwh - visiblewh))) END
$END calcAESSliderPos;
"
"PROCEDURE calcAESSliderSize (visiblewh, virtualwh: LONGINT): INTEGER;
"
$VAR size: LONGINT;
$
$(*  !longcalc!  *)
$BEGIN
&IF virtualwh = 0L THEN RETURN 1000 END;
&
&size := visiblewh * 1000L DIV virtualwh;
&IF size < 0L THEN size := -1L
&ELSIF size > 1000L THEN size := 1000L END;
&RETURN SHORT (size)
$END calcAESSliderSize;
 
"BEGIN
$IF scrollElem IN wdw^.elems THEN WITH wdw^.spec DO
&
&IF tellHor THEN
 
(AESWindows.SetWindowSlider (wdw^.hdl, AESWindows.horPosition,
DcalcAESSliderPos (visible.x, visible.w,
Vvirtual.w));
(AESWindows.SetWindowSlider (wdw^.hdl, AESWindows.horSize,
DcalcAESSliderSize (visible.w, virtual.w));
(wdw^.horSlidChgd := FALSE;
&
&END;
&IF tellVert THEN
&
(AESWindows.SetWindowSlider (wdw^.hdl, AESWindows.vertPosition,
DcalcAESSliderPos (visible.y, visible.h,
Vvirtual.h));
(AESWindows.SetWindowSlider (wdw^.hdl, AESWindows.vertSize,
DcalcAESSliderSize (visible.h, virtual.h));
(wdw^.vertSlidChgd := FALSE;
(
&END;
&
$END END;
"END tellAESSliderValues;
!
 (*  careOfTellingAESChangedValues -- Falls die Slider, Gre oder Position
!*                                   des Fensters gendert wurde und das 
!*                                   Fenster sichtbar ist, so werden die
!*                                   genderten Werte dem AES mitgeteilt
!*                                   und dies vermerkt.
!*)
!
 PROCEDURE careOfTellingAESChangedValues (wdw: Window);
 
"BEGIN
$IF NOT (hiddenWdw IN wdw^.flags) THEN
$
&tellAESSliderValues (wdw, wdw^.horSlidChgd, wdw^.vertSlidChgd);
&IF wdw^.moveSizeChgd THEN
&
(AESWindows.SetWindowSize (wdw^.hdl, wdw^.currBorder);
(wdw^.moveSizeChgd := FALSE;
(
&END;
$
$ELSE
$
&wdw^.horSlidChgd := FALSE;
&wdw^.vertSlidChgd := FALSE;
&wdw^.moveSizeChgd := FALSE;
&
$END;
"END careOfTellingAESChangedValues;
"
 PROCEDURE validateSpec (wdw: Window; VAR spec: WindowSpec);
 
"VAR   deskBorder,
(winBorder: Rectangle;
(border,
(maxWA    : LongRect;
(gotMax,
(centerMax: BOOLEAN;
(minW,
(minH,
(amt      : LONGINT;
"
"PROCEDURE getMax;
"
$BEGIN
&IF NOT gotMax THEN maxWA := maxWorkArea (wdw); gotMax := TRUE END;
$END getMax;
$
"BEGIN
"
$(*  !cutting!
&(*  Should window automaticly be cut at the desktop border?
'*)
&cutWindow := (controlKey IN VDIInputs.KeyboardState (dev))
3AND (sizeElem IN elems);
&
&(*  Fr cutting mu 'border' noch entsprechend eingeschrnkt werden.
'*)
%*)
$
$border := LongFrame (AESWindows.CalcWindow (AESWindows.calcWork,
Pwdw^.aesElems, deskFrame));
$
$(*  calc. special values
%*)
%
$gotMax := FALSE;
$WITH spec DO
&
&centerMax := (virtual.x = CenterVis) AND (visible.w = MaxVis);
&IF virtual.x = CenterVis THEN
(getMax; 
(IF centerMax THEN virtual.x := maxWA.x
(ELSE virtual.x := (maxWA.w - visible.w) DIV 2L + maxWA.x END;
(DEC (virtual.x, visible.x);
&END;
&IF visible.w = MaxVis THEN
(getMax;
(IF centerMax THEN visible.w := maxWA.w
(ELSE visible.w := maxWA.x + maxWA.w - visible.x - virtual.x END;
&ELSE
(border.w := MaxLInt DIV 2L;
&END;
&
&centerMax := (virtual.y = CenterVis) AND (visible.h = MaxVis);
&IF virtual.y = CenterVis THEN
(getMax; 
(IF centerMax THEN virtual.y := maxWA.y
(ELSE virtual.y := (maxWA.h - visible.h) DIV 2L + maxWA.y END;
(DEC (virtual.y, visible.y);
&END;
&IF visible.h = MaxVis THEN
(getMax;
(IF centerMax THEN visible.h := maxWA.h
(ELSE visible.h := maxWA.y + maxWA.h - visible.y - virtual.y END;
&ELSE
(border.h := MaxLInt DIV 2L;
&END;
&
&winBorder := AESWindows.CalcWindow (AESWindows.calcBorder, wdw^.aesElems,
(Rectangle {SHORT (visible.x + virtual.x), SHORT (visible.y + virtual.y),
3SHORT (visible.w), SHORT (visible.h)} );
&
&deskBorder:= deskFrame;
&
&(* Falls Fensterbreite/-hhe grer als Desktop ist, wird sie reduziert *)
&IF winBorder.w > deskBorder.w THEN
(DEC (visible.w, winBorder.w - deskBorder.w)
&END;
&IF winBorder.h > deskBorder.h THEN
(DEC (visible.h, winBorder.h - deskBorder.h)
&END;
&
&INC (deskBorder.w, deskBorder.x); (* w ist nun rechte x-Pos *)
&INC (deskBorder.h, deskBorder.y); (* h ist nun untere y-Pos *)
&
&(* wg. Mag!X wieder ausklammern, damit dort das "ausblenden" klappt.
((* Falls TopLeft auerhalb d. Desktops liegt, kommt sie nach li. oben. *)
(IF (winBorder.x) > (deskBorder.w-16) THEN
*(*DEC (virtual.x, (winBorder.x) - (deskBorder.w-16));*)
*virtual.x:= deskBorder.x
(END;
(IF (winBorder.y) > (deskBorder.h-16) THEN
*(*DEC (virtual.y, (winBorder.y) - (deskBorder.h-16));*)
*virtual.y:= deskBorder.y
(END;
&*)
&
 (*
 wStr ('after special:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
&
&(*  Der sichtbare Bereich wird falls er ber den virtuellen hinaus-
'*  ragt, so weit nach links/oben verschoben, bis er vollstndig
'*  innerhalb liegt oder links/oben anstt.
'*)
&IF visible.x + visible.w > virtual.w THEN
(amt := visible.x + visible.w - virtual.w;
(IF amt > visible.x THEN amt := visible.x END;
(INC (virtual.x, amt); DEC (visible.x, amt);
&END;
&IF visible.y + visible.h > virtual.h THEN
(amt := visible.y + visible.h - virtual.h;
(IF amt > visible.y THEN amt := visible.y END;
(INC (virtual.y, amt); DEC (visible.y, amt);
&END;
&
 (*
 wStr ('  before checkSpec:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
 wStr ('  border     : '); wLFrame (border); wLn;
!*)
&wdw^.checkSpecSrvr (wdw, wdw^.env, spec, border);
 (*
 wStr ('  after checkSpec:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
&
&(*  Adjust wdw., if it is to small.
'*)
&IF scrollElem IN wdw^.elems THEN
(minW := LONG (minWWithScrollElem);
(minH := LONG (minHWithScrollElem);
&ELSE minW := 1L; minH := 1L END;
&IF visible.w < minW THEN visible.w := minW END;
&IF visible.h < minH THEN visible.h := minH END;
&
$END;
$
"END validateSpec;
 
 (*  setSpec -- Sets the new slider values, position and size of the window.
!*             Sets 'horSlidChgd', 'vertSlidChgd' and/or 'moveSizeChgd',
!*             if necessary and validates spec.
!*             No redraw. No tell to AES.
!*)
 
 PROCEDURE setSpec (wdw: Window; spec: WindowSpec);
"
"BEGIN
$validateSpec (wdw, spec);
 (*
 wStr ('  after validate:'); wLn;
 wStr ('  new virtual: '); wLFrame (spec.virtual); wLn;
 wStr ('  new visible: '); wLFrame (spec.visible); wLn;
!*)
$WITH wdw^.spec DO
$
&IF (virtual.x + visible.x # spec.virtual.x + spec.visible.x)
)OR (virtual.y + visible.y # spec.virtual.y + spec.visible.y)
&THEN
(wdw^.moveSizeChgd := TRUE;
&END;
&
&IF visible.w # spec.visible.w THEN 
(wdw^.moveSizeChgd := TRUE;
(wdw^.horSlidChgd := TRUE;
&END;
&
&IF visible.h # spec.visible.h THEN 
(wdw^.moveSizeChgd := TRUE;
(wdw^.vertSlidChgd := TRUE;
&END;
&
&IF (visible.x # spec.visible.x) OR (virtual.w # spec.virtual.w) THEN
(wdw^.horSlidChgd := TRUE;
&END;
&IF (visible.y # spec.visible.y) OR (virtual.h # spec.virtual.h) THEN
(wdw^.vertSlidChgd := TRUE;
&END;
$
$END;
$wdw^.spec := spec;
$IF wdw^.moveSizeChgd THEN
$
&wdw^.currBorder := AESWindows.CalcWindow
;(AESWindows.calcBorder, wdw^.aesElems,
<ShortFrame
>(windowToScreenFrame (wdw, wdw^.spec.visible)));
&wdw^.lastBorder := Rect (0, 0, 0, 0);
&
$END;
"END setSpec;
"
 (*  copyRedraw -- Executes a copy and redraw of 'frame' on the window 'wdw'.
!*)
!
 PROCEDURE copyRedraw (wdw     : Window;
6doRedraw: UpdateWdwProc;
6env     : ADDRESS;
6frame   : Rectangle;
6mode    : WindowCopyMode;
6amount  : LONGINT);
 
"VAR   clip, source, dest,
(new, zws               : Rectangle;
(amt                    : INTEGER;
!
"BEGIN
$IF hiddenWdw IN wdw^.flags THEN RETURN END;
$
$(*  AES den Zugriff auf ein Fenster melden.  *)
$
$AESWindows.UpdateWindow (TRUE);
$GrafMouse (mouseOff, NIL);
$
$clip := AESWindows.WindowRectList (wdw^.hdl, AESWindows.firstElem);
$WHILE clip.w # 0 DO
$
&clip := ClipRect (deskFrame, clip);(* Draw only within the desktop area *)
&clip := ClipRect (frame, clip);
&IF clip.w # 0 THEN
&
(IF (amount = 0L) OR (mode = noCopyWdw)
+OR ((mode = copyHorWdw) AND (ABS (amount) >= LONG (clip.w)))
+OR ((mode = copyVertWdw) AND (ABS (amount) >= LONG (clip.h)))
(THEN
(
*source.w := 0;
*dest.w := 0;
*doRedraw (wdw, env, source, dest, clip);
(
(ELSE
(
*new := clip;
*amt := SHORT (amount);
*source := new;
*IF mode = copyHorWdw THEN
*
,DEC (source.w, ABS (amt));
,dest := source;
,INC (dest.x, ABS (amt));
,DEC (new.w, source.w);
,IF amt < 0 THEN
.zws := source;
.source := dest;
.dest := zws;
.INC (new.x, source.w);
,END;
,doRedraw (wdw, env, source, dest, new);
,
*ELSE
*
,DEC (source.h, ABS (amt));
,dest := source;
,INC (dest.y, ABS (amt));
,DEC (new.h, source.h);
,IF amt < 0 THEN
.zws := source;
.source := dest;
.dest := zws;
.INC (new.y, source.h);
,END;
,doRedraw (wdw, env, source, dest, new);
*
*END;
*
(END;
(
&END;
&
&clip := AESWindows.WindowRectList (wdw^.hdl, AESWindows.nextElem);
4
$END;
$
$(*  AES die Beendigung des Fensterzugriffes melden  *)
$
$GrafMouse (mouseOn, NIL);
$AESWindows.UpdateWindow (FALSE);
"END copyRedraw;
 
 PROCEDURE scrollTo (wdw: ptrWindow; mode: WindowCopyMode; pos: LONGINT);
 
"VAR   spec  : WindowSpec;
(amount: LONGINT;
"
"BEGIN
$IF mode = noCopyWdw THEN RETURN END;
$
$spec := wdw^.spec;
$IF mode = copyHorWdw THEN
$
&amount := spec.visible.x - pos;
&INC (spec.virtual.x, amount);
&spec.visible.x := pos;
&IF amount # 0L THEN
(setSpec (wdw, spec);
(DEC (amount, wdw^.spec.visible.x - pos);
&END;
&
$ELSE
$
&amount := spec.visible.y - pos;
&INC (spec.virtual.y, amount);
&spec.visible.y := pos;
&IF amount # 0L THEN
(setSpec (wdw, spec);
(DEC (amount, wdw^.spec.visible.y - pos);
&END;
&
$END;
$IF amount # 0L THEN
&careOfTellingAESChangedValues (wdw);
&copyRedraw (wdw, wdw^.updateSrvr, wdw^.env,
2ShortFrame (windowToScreenFrame (wdw, wdw^.spec.visible)),
2mode, amount);
$END;
"END scrollTo;
 
 PROCEDURE scroll (wdw: ptrWindow; mode: WindowScrollMode);
 
"VAR   amount, pos: LONGINT;
"
"BEGIN
$amount := ABS (wdw^.scrollAmtSrvr (wdw, wdw^.env, mode));
$WITH wdw^.spec DO
&CASE mode OF
&
(pageLeftWdw,
(columnLeftWdw : IF amount > visible.x THEN pos := 0
8ELSE pos := visible.x - amount END;
8scrollTo (wdw, copyHorWdw, pos)|
(
(pageRightWdw,
(columnRightWdw: IF amount > (virtual.w - visible.x - visible.w) THEN
:pos := virtual.w - visible.w;
:IF pos < 0L THEN pos := 0L END;
8ELSE
:pos := visible.x + amount
7 END;
8scrollTo (wdw, copyHorWdw, pos)|
(
(pageUpWdw,
(rowUpWdw      : IF amount > visible.y THEN pos := 0L 
8ELSE pos := visible.y - amount END;
8scrollTo (wdw, copyVertWdw, pos)|
(
(pageDownWdw,
(rowDownWdw    : IF amount > (virtual.h - visible.y - visible.h) THEN
:pos := virtual.h - visible.h;
:IF pos < 0L THEN pos := 0L END;
8ELSE
:pos := visible.y + amount
8END;
8scrollTo (wdw, copyVertWdw, pos)|
(
&END;
$END;
"END scroll;
"
 (*  setWorkArea -- Sets a new work area and checks for special values.
!*                 No redraw. Tells AES.
!*)
 
 PROCEDURE setWorkArea (VAR wdw: ptrWindow; workArea: Rectangle);
 
"VAR   spec: WindowSpec;
"
"BEGIN
$spec := wdw^.spec;
$WITH spec DO
$
&IF workArea.x = CenterWdw THEN virtual.x := CenterVis
&ELSE virtual.x := LONG (workArea.x) - spec.visible.x END;
$
&IF workArea.y = CenterWdw THEN virtual.y := CenterVis
&ELSE virtual.y := LONG (workArea.y) - spec.visible.y END;
$
&IF workArea.w = MaxWdw THEN visible.w := MaxVis
&ELSE visible.w := LONG (workArea.w) END;
&IF workArea.h = MaxWdw THEN visible.h := MaxVis
&ELSE visible.h := LONG (workArea.h) END;
$
$END;
&
$setSpec (wdw, spec);
$careOfTellingAESChangedValues (wdw);
"END setWorkArea;
"
 (*  setBorderFrame -- Sets 'frame' as new border frame of the window.
!*                    No redraw. Tells AES.
!*)
!
 PROCEDURE setBorderFrame (wdw: ptrWindow; frame: Rectangle);
 
"VAR   workFrame: Rectangle;
"
"BEGIN
$workFrame := AESWindows.CalcWindow (AESWindows.calcWork,
Hwdw^.aesElems, frame);
$IF frame.x = CenterWdw THEN workFrame.x := CenterWdw END;
$IF frame.y = CenterWdw THEN workFrame.y := CenterWdw END;
$IF frame.w = MaxWdw THEN workFrame.w := MaxWdw END;
$IF frame.h = MaxWdw THEN workFrame.h := MaxWdw END;
$
$setWorkArea (wdw, workFrame);
"END setBorderFrame;
"
 (*  findWindow -- Sucht nach einem offenen Fenster, das die AES-Kennung
!*                'hdl' besitzt. Wird es gefunden, so liefert 'wdw' die
!*                zugehrige Fensterkennung und 'success = TRUE', sonst
!*                'success = FALSE'.
!*)
!
 PROCEDURE findWindow (hdl: CARDINAL; VAR wdw: Window; VAR success: BOOLEAN);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -10(A3),D0
(LEA     windowRoot,A0
(SUBA.W  #Window.next,A0
(
 loop
(MOVE.L  Window.next(A0),A0
(CMPA.L  #0,A0
(BEQ     failed
(BTST    #hiddenWdw,Window.flags(A0)
(BNE     loop
(CMP.W   Window.hdl(A0),D0
(BNE     loop
(
(; success
(MOVE.L  -(A3),A1
(MOVE.W  #TRUE,(A1)
(MOVE.L  -(A3),A1
(MOVE.L  A0,(A1)
(SUBQ.L  #2,A3
(BRA     ende
(
 failed
(MOVE.L  -(A3),A1
(CLR.W   (A1)
(SUBQ.L  #6,A3
 ende
$END;
"END findWindow;
"(*$L=*)
 
 
((*  Event Handling Routines  *)
((*  =======================  *)
 
 VAR PassHandledMsg: BOOLEAN;
 
 PROCEDURE watchRedraw (hdl: CARDINAL; frame: Rectangle): BOOLEAN;
 
"VAR   success : BOOLEAN;
(wdw     : Window;
(
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$copyRedraw (wdw, wdw^.updateSrvr, wdw^.env, frame, noCopyWdw, 0L);
$
$RETURN FALSE
"END watchRedraw;
 
 PROCEDURE watchTopped (hdl: CARDINAL): BOOLEAN;
 
 (*
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$AESWindows.SetTopWindow (hdl);
$
$RETURN PassHandledMsg
"END watchTopped;
 
!*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -2(A3),-(A7)
(
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     findWindow
(TST.W   (A7)+
(BNE     foundHdl
(
(ADDQ.L  #6,A7
(MOVE.W  #TRUE,D0
(BRA     ende
(
 foundHdl
(MOVE.W  4(A7),(A3)+
(JSR     AESWindows.SetTopWindow
(MOVE.L  (A7)+, A0               ;  call activated server
(MOVE.L  A0, (A3)+
(MOVE.L  window.env(A0), (A3)+
(MOVE.L  window.activatedSrvr(A0), A1
(JSR     (A1)
(ADDQ.L  #2,A7
(MOVE.W  PassHandledMsg,D0
 ende
(MOVE.W  D0, (A3)+
$END;
"END watchTopped;
"(*$L=*)
 
 PROCEDURE watchClosed (hdl: CARDINAL): BOOLEAN;
 
 (*
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$wdw^.closeSrvr (wdw, env);
%
$RETURN PassHandledMsg
"END watchClosed;
 
!*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     findWindow
(TST.W   (A7)+
(BNE     foundHdl
(
(ADDQ.L  #4,A7
(MOVE.W  #TRUE,D0
(BRA     ende
(
 foundHdl
(MOVE.L  (A7)+,A0
(MOVE.L  A0,(A3)+
(MOVE.L  Window.env(A0),(A3)+
(MOVE.L  Window.closeSrvr(A0),A0
(JSR     (A0)
(MOVE.W  PassHandledMsg,D0
 ende
(MOVE.W  D0, (A3)+
$END;
"END watchClosed;
"(*$L=*)
 
 PROCEDURE watchFulled (hdl: CARDINAL): BOOLEAN;
 
 (*
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
(frame   : Rectangle;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$WITH wdw^ DO
&IF lastBorder.w = 0 THEN
&
(frame := currBorder;
(setBorderFrame (wdw, Rect (CenterWdw, CenterWdw, MaxWdw, MaxWdw));
(lastBorder := frame;
(
&ELSE
&
(setBorderFrame (wdw, lastBorder)
(
&END;
$END;
$
$RETURN FALSE
"END watchFulled;
 
!*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     findWindow
(TST.W   (A7)+
(BNE     foundHdl
(
(ADDQ.L  #4,A7
(MOVE.W  #TRUE,D0
(BRA     ende
(
 foundHdl
(MOVE.L  (A7)+,(A3)+
(TST.W   Window.lastBorder.w(A0)
(BNE     wasFull
(
(MOVE.L  Window.currBorder(A0),-(A7)
(MOVE.L  Window.currBorder+4(A0),-(A7)
(MOVE.L  A0,-(A7)
(MOVE.W  #CenterWdw, (A3)+
(MOVE.W  #CenterWdw, (A3)+
(MOVE.W  #MaxWdw, (A3)+
(MOVE.W  #MaxWdw, (A3)+
(JSR     setBorderFrame
(MOVE.L  (A7)+,A0
(MOVE.L  (A7)+,Window.lastBorder+4(A0)
(MOVE.L  (A7)+,Window.lastBorder(A0)
(BRA     cont
(
 wasFull
(MOVE.L  Window.lastBorder(A0),(A3)+
(MOVE.L  Window.lastBorder+4(A0),(A3)+
(JSR     setBorderFrame
(
 cont
(CLR.W   D0
 ende
(MOVE.W  D0, (A3)+
$END;
"END watchFulled;
"(*$L=*)
 
 PROCEDURE watchArrowed (hdl: CARDINAL; mode: AESEvents.ArrowedMode): BOOLEAN;
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$CASE mode OF
&AESEvents.pageUp     : scroll (wdw, pageUpWdw)|
&AESEvents.pageDown   : scroll (wdw, pageDownWdw)|
&AESEvents.pageLeft   : scroll (wdw, pageLeftWdw)|
&AESEvents.pageRight  : scroll (wdw, pageRightWdw)|
&AESEvents.rowUp      : scroll (wdw, rowUpWdw)|
&AESEvents.rowDown    : scroll (wdw, rowDownWdw)|
&AESEvents.columnLeft : scroll (wdw, columnLeftWdw)|
&AESEvents.columnRight: scroll (wdw, columnRightWdw)|
$END;
$
$RETURN FALSE
"END watchArrowed;
 
 PROCEDURE watchHSlid (hdl: CARDINAL; pos: CARDINAL): BOOLEAN;
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$scrollTo (wdw, copyHorWdw,
.LONG (INTEGER (pos)) * (wdw^.spec.virtual.w - wdw^.spec.visible.w)
.DIV 1000L);
$
$RETURN FALSE
"END watchHSlid;
 
 PROCEDURE watchVSlid (hdl: CARDINAL; pos: CARDINAL): BOOLEAN;
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$(*  !longcalc!  *)
$
$scrollTo (wdw, copyVertWdw,
.LONG (INTEGER (pos)) * (wdw^.spec.virtual.h - wdw^.spec.visible.h)
.DIV 1000L);
$
$RETURN FALSE
"END watchVSlid;
!
 PROCEDURE watchSized (hdl: CARDINAL; frame: Rectangle): BOOLEAN;
 
 (*
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$setBorderFrame (wdw, frame);
%
$RETURN FALSE
"END watchSized;
!
!*)
!
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     findWindow
(TST.W   (A7)+
(BNE     foundHdl
(
(ADDA.W  #12,A7
(MOVE.W  #TRUE,D0
(BRA     ende
(
 foundHdl
(MOVE.L  (A7)+,(A3)+
(MOVE.L  (A7)+,(A3)+
(MOVE.L  (A7)+,(A3)+
(JSR     setBorderFrame
(CLR.W   D0
(
 ende
(MOVE.W  D0, (A3)+
$END;
"END watchSized;
"(*$L=*)
 
 PROCEDURE watchMoved (hdl: CARDINAL; frame: Rectangle): BOOLEAN;
 
 (*
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$setBorderFrame (wdw, frame);
%
$RETURN FALSE
"END watchMoved;
!
!*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     findWindow
(TST.W   (A7)+
(BNE     foundHdl
(
(ADDA.W  #12,A7
(MOVE.W  #TRUE,D0
(BRA     ende
(
 foundHdl
(MOVE.L  (A7)+,(A3)+
(MOVE.L  (A7)+,(A3)+
(MOVE.L  (A7)+,(A3)+
(JSR     setBorderFrame
(CLR.W   D0
(
 ende
(MOVE.W  D0, (A3)+
$END;
"END watchMoved;
"(*$L=*)
 
 PROCEDURE watchNewTop (hdl: CARDINAL): BOOLEAN;
 
"VAR   success : BOOLEAN;
(wdw     : Window;
!
"BEGIN
$findWindow (hdl, wdw, success);
$IF ~ success THEN RETURN TRUE END;
$
$(*  Hier kommt er wohl vom GEM aus nie hin.
%*  (Vielleicht bei 'SetTopWindow')
%*
$wdw^.activatedSrvr (wdw, wdw^.env);
%*)
%
$RETURN PassHandledMsg
"END watchNewTop;
 
 
 VAR     redrawCrr, toppedCrr, closedCrr, fulledCrr,
(arrowedCrr, hSlidCrr, vSlidCrr, sizedCrr,
(movedCrr, newTopCrr                             : WatchDogCarrier;
 
 PROCEDURE installWatchDogs;
 
 (*
 
"VAR   eventProc       : EventProc;
"
"BEGIN
$eventProc.event:=message;
$
$eventProc.msgType:=windRedraw;
$eventProc.drawHdler:=watchRedraw;
$SysInstallWatchDog (redrawCrr, eventProc);
$eventProc.msgType:=windTopped;
$eventProc.topHdler:=watchTopped;
$SysInstallWatchDog (toppedCrr, eventProc);
$eventProc.msgType:=windClosed;
$eventProc.clsHdler:=watchClosed;
$SysInstallWatchDog (closedCrr, eventProc);
$eventProc.msgType:=windFulled;
$eventProc.fullHdler:=watchFulled;
$SysInstallWatchDog (fulledCrr, eventProc);
$eventProc.msgType:=windArrowed;
$eventProc.arrwHdler:=watchArrowed;
$SysInstallWatchDog (arrowedCrr, eventProc);
$eventProc.msgType:=windHSlid;
$eventProc.hSldHdler:=watchHSlid;
$SysInstallWatchDog (hSlidCrr, eventProc);
$eventProc.msgType:=windVSlid;
$eventProc.hSldHdler:=watchVSlid;
$SysInstallWatchDog (vSlidCrr, eventProc);
$eventProc.msgType:=windSized;
$eventProc.sizeHdler:=watchSized;
$SysInstallWatchDog (sizedCrr, eventProc);
$eventProc.msgType:=windMoved;
$eventProc.moveHdler:=watchMoved;
$SysInstallWatchDog (movedCrr, eventProc);
$eventProc.msgType:=windNewTop;
$eventProc.newTHdler:=watchNewTop;
$SysInstallWatchDog (newTopCrr, eventProc);
"END installWatchDogs;
"
!*)
!
"(*$L-*)
!
"PROCEDURE install (crr : WatchDogCarrier; msgType : CARDINAL; hdler : PROC);
$
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.W  #message,(A3)+
(MOVE.W  D1,(A3)+
(MOVE.L  D0,(A3)+
(JSR     SysInstallWatchDog
&END;
$END install;
"
"BEGIN
$ASSEMBLER
(LEA     redrawCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windRedraw,(A3)+
(LEA     watchRedraw,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     toppedCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windTopped,(A3)+
(LEA     watchTopped,A0
(MOVE.L  A0,(A3)+
(BSR     install
(
(LEA     closedCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windClosed,(A3)+
(LEA     watchClosed,A0
(MOVE.L  A0,(A3)+
(BSR     install
(
(LEA     fulledCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windFulled,(A3)+
(LEA     watchFulled,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     arrowedCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windArrowed,(A3)+
(LEA     watchArrowed,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     hSlidCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windHSlid,(A3)+
(LEA     watchHSlid,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     vSlidCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windVSlid,(A3)+
(LEA     watchVSlid,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     sizedCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windSized,(A3)+
(LEA     watchSized,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     movedCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windMoved,(A3)+
(LEA     watchMoved,A0
(MOVE.L  A0,(A3)+
(BSR     install
$
(LEA     newTopCrr,A0
(MOVE.L  A0,(A3)+
(MOVE.W  #windNewTop,(A3)+
(LEA     watchNewTop,A0
(MOVE.L  A0,(A3)+
(BSR     install
$END;
"END installWatchDogs;
"(*$L=*)
$
 PROCEDURE deinstallWatchDogs;
 
 (*
 
"BEGIN
$DeInstallWatchDog (redrawCrr);
$DeInstallWatchDog (toppedCrr);
$DeInstallWatchDog (closedCrr);
$DeInstallWatchDog (fulledCrr);
$DeInstallWatchDog (arrowedCrr);
$DeInstallWatchDog (hSlidCrr);
$DeInstallWatchDog (vSlidCrr);
$DeInstallWatchDog (sizedCrr);
$DeInstallWatchDog (movedCrr);
$DeInstallWatchDog (newTopCrr);
"END deinstallWatchDogs;
 
!*)
!
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     redrawCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     toppedCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     closedCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     fulledCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     arrowedCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     hSlidCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     vSlidCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     sizedCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     movedCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
(
(LEA     newTopCrr,A0
(MOVE.L  A0,(A3)+
(JSR     DeInstallWatchDog
$END;
"END deinstallWatchDogs;
"(*$L=*)
 
 
8(*  The Exported Routines  *)
8(*  =====================  *)
:
 PROCEDURE CreateWindow (VAR wdw            : Window;
 
<elems          : WdwElemSet;
<updateServer   : UpdateWdwProc;
<checkSpecServer: CheckSpecWdwProc;
<scrollAmtServer: ScrollAmtWdwProc;
<activatedServer: ActivatedWdwProc;
<closeServer    : CloseWdwProc;
<serverEnv      : ADDRESS);
8
"PROCEDURE calcAESElems;
"
$BEGIN
&WITH wdw^ DO
&
(aesElems := AESWindows.WElementSet{};
(IF closeElem IN elems THEN INCL (aesElems, AESWindows.closer) END;
(IF sizeElem IN elems THEN
*INCL (aesElems, AESWindows.sizer);
*INCL (aesElems, AESWindows.fuller);
(END;
(IF moveElem IN elems THEN INCL (aesElems, AESWindows.mover) END;
(IF scrollElem IN elems THEN
*aesElems:=aesElems + AESWindows.WElementSet{AESWindows.upArrow,
VAESWindows.downArrow,
VAESWindows.rightArrow,
VAESWindows.leftArrow,
VAESWindows.horSlider,
VAESWindows.vertSlider}
(END;
(IF titleElem IN elems THEN
*aesElems:=aesElems + AESWindows.WElementSet{AESWindows.mover,
VAESWindows.nameBar}
(END;
(IF infoElem IN elems THEN INCL (aesElems, AESWindows.infoBar) END;
(
&END;
$END calcAESElems;
 
"BEGIN
$careOfInitGem;
$
$SysAlloc (wdw, SIZE (wdw^));        (*  Create  *)
$IF wdw = NoWindow THEN
&RETURN
$END;
$
$WITH wdw^ DO
&flags := WdwFlagSet {hiddenWdw}; (*  Init.  *)
&title := createNullStr ();
&info := createNullStr ();
&hdl := AESWindows.NoWindow;
$END;
$
$wdw^.elems := elems;
$calcAESElems;
$WITH wdw^ DO
&updateSrvr := updateServer;
&checkSpecSrvr := checkSpecServer;
&scrollAmtSrvr := scrollAmtServer;
&activatedSrvr := activatedServer;
&closeSrvr := closeServer;
&env := serverEnv;
$END;
$
$WITH wdw^.spec DO
&virtual := LRect (0, 0, 0, 0);
&visible := maxWorkArea (wdw);
&virtual.x := visible.x;
&virtual.y := visible.y;
&visible.x := 0L;
&visible.y := 0L;
$END;
$WITH wdw^ DO
&setSpec (wdw, spec);
&currBorder := AESWindows.CalcWindow
;(AESWindows.calcBorder, aesElems,
<ShortFrame
>(windowToScreenFrame (wdw, spec.visible)));
&lastBorder := Rect (0, 0, 0, 0);
&
&horSlidChgd := FALSE;
&vertSlidChgd := FALSE;
&moveSizeChgd := FALSE;
&
&state := okWdw;
&magic := wdwMagic;
&
&next := windowRoot;             (*  insert in list  *)
$END;
$windowRoot := wdw;
$
$wdw^.modID := modID;
$
"END CreateWindow;
 
 PROCEDURE SysCreateWindow (VAR wdw            : Window;
 
?elems          : WdwElemSet;
?updateServer   : UpdateWdwProc;
?checkSpecServer: CheckSpecWdwProc;
?scrollAmtServer: ScrollAmtWdwProc;
?activatedServer: ActivatedWdwProc;
?closeServer    : CloseWdwProc;
?serverEnv      : ADDRESS);
8
8
"BEGIN
$CreateWindow (wdw, elems, updateServer, checkSpecServer, scrollAmtServer,
2activatedServer, closeServer, serverEnv);
$IF wdw # NoWindow THEN wdw^.modID := 0 END;
"END SysCreateWindow;
"
 PROCEDURE DeleteWindow (VAR wdw: Window);
 
"PROCEDURE del (VAR w: Window);
"
$BEGIN
&IF w = NoWindow THEN HALT         (*  ! VALID, but not in the list !  *)
&ELSIF w = wdw THEN                (*  match, kill it  *)
(w := wdw^.next;
(DEALLOCATE (wdw^.title, 0L);
(DEALLOCATE (wdw^.info, 0L);
(wdw^.magic := 0L;
(DISPOSE (wdw);
&ELSE del (w^.next) END;           (*  search in the tail  *)
$END del;
 
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$
$IF ~ (hiddenWdw IN wdw^.flags) THEN (*  be sure, window is closed  *)
&CloseWindow (wdw)
$END;
$del (windowRoot);
$careOfExitGem;
"END DeleteWindow;
 
 PROCEDURE OpenWindow (wdw: Window);
 
"VAR   oldHdl          : GemHandle;
(
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$WITH wdw^ DO
&IF hiddenWdw IN flags  THEN
(
(AESWindows.CreateWindow (aesElems, deskFrame, hdl);
(IF hdl # AESWindows.NoWindow THEN
(
*(*  bergib alle aktuellen Fensterparm. an das AES
+*)
(
*tellAESSliderValues (wdw, TRUE, TRUE);
*
*IF titleElem IN elems THEN
,AESWindows.SetWindowString (hdl, AESWindows.nameStr, title)
*END;
*IF infoElem IN elems THEN
,AESWindows.SetWindowString (hdl, AESWindows.infoStr, info)
*END;
*
*(*  Stelle das Fenster dar
+*)
*
*AESWindows.OpenWindow (hdl, currBorder);
*EXCL (flags, hiddenWdw);
*
(ELSE state := cantOpenWdw END;
(
&ELSE state := alreadyOpenWdw END;
$END;
$
$restoreCurrHdl (oldHdl);
"END OpenWindow;
 
 PROCEDURE CloseWindow (wdw:Window);
 
"VAR   oldHdl          : GemHandle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$WITH wdw^ DO
&IF ~ (hiddenWdw IN flags) THEN
&
(AESWindows.CloseWindow (hdl);
(AESWindows.DeleteWindow (hdl);
(INCL (flags, hiddenWdw);
(
&ELSE state := alreadyCloseWdw END;
$END;
$
$restoreCurrHdl (oldHdl);
"END CloseWindow;
 
 PROCEDURE UpdateWindow (wdw   : Window;
8update: UpdateWdwProc;
8env   : ADDRESS;
8frame : LongRect;
8mode  : WindowCopyMode;
8amount: LONGINT);
 
"VAR   oldHdl  : GemHandle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$copyRedraw (wdw, update, env, ShortFrame (windowToScreenFrame (wdw, frame)),
0mode, amount);
$
$restoreCurrHdl (oldHdl);
"END UpdateWindow;
 
 PROCEDURE RedrawWindow (wdw: Window);
 
"VAR   oldHdl  : GemHandle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$copyRedraw (wdw, wdw^.updateSrvr, wdw^.env, wdw^.currBorder (* deskFrame *),
0noCopyWdw, 0L);
$
$restoreCurrHdl (oldHdl);
"END RedrawWindow;
"
 
((*  Set functions  *)
 
 PROCEDURE SetWindowSpec (wdw: Window; spec: WindowSpec);
 
"VAR oldHdl  : GemHandle;
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$setSpec (wdw, spec);
$careOfTellingAESChangedValues (wdw);
$
$restoreCurrHdl (oldHdl);
"END SetWindowSpec;
"
 PROCEDURE SetWindowString (wdw : Window;
;mode: SetWdwStrMode;
;REF str : ARRAY OF CHAR);
"
"PROCEDURE doStrSet (VAR target : PtrMaxStr;
:elem   : WdwElement;
:aesmode: AESWindows.WStringMode);
(
$VAR oldHdl  : GemHandle;
"
$BEGIN
&IF ~ (elem IN wdw^.elems) THEN wdw^.state := invalidElemWdw; RETURN END;
&
&DEALLOCATE (target, 0L);  (* !!! Unkown length !!! *)
&
&SysAlloc (target, HIGH (str) + 2);  (*  string has to be 0C terminated  *)
&IF target = NIL THEN
&
(reportOutOfMem;
(target := createNullStr ();
(
&ELSE Assign (str, target^, VoidO) END;
&
&IF ~ (hiddenWdw IN wdw^.flags) THEN
(saveCurrHdl (oldHdl);
(
(AESWindows.SetWindowString (wdw^.hdl, aesmode, target);
(
(restoreCurrHdl (oldHdl);
&END;
&
&RETURN
$END doStrSet;
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$
$IF mode = infoWdwStr THEN
&doStrSet (wdw^.info, infoElem, AESWindows.infoStr);
$ELSE
&doStrSet (wdw^.title, titleElem, AESWindows.nameStr);
$END;
"END SetWindowString;
;
 PROCEDURE SetWindowWorkArea (wdw     : Window;
=workArea: Rectangle);
"
"VAR   oldHdl: GemHandle;
(spec  : WindowSpec;
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
"
$setWorkArea (wdw, workArea);
$copyRedraw (wdw, wdw^.updateSrvr, wdw^.env, wdw^.currBorder (* deskFrame *),
0noCopyWdw, 0L);
"
$restoreCurrHdl (oldHdl);
"END SetWindowWorkArea;
"
 PROCEDURE SetWindowSliderPos (wdw: Window; horPos, vertPos: LONGINT);
 
"VAR   oldHdl  : GemHandle;
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$IF horPos # OldWindowSlider THEN scrollTo (wdw, copyHorWdw, horPos) END;
$IF vertPos # OldWindowSlider THEN scrollTo (wdw, copyVertWdw, vertPos) END;
$
$restoreCurrHdl (oldHdl);
"END SetWindowSliderPos;
"
 PROCEDURE PutWindowOnTop (wdw: Window);
 
"VAR   oldHdl  : GemHandle;
"
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$saveCurrHdl (oldHdl);
$
$IF NOT (hiddenWdw IN wdw^.flags) THEN
&AESWindows.SetTopWindow (wdw^.hdl)
$END;
$
$restoreCurrHdl (oldHdl);
"END PutWindowOnTop;
"
 PROCEDURE ResetWindowState (wdw: Window);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  A0,D0
(BEQ     ende                    ; 'wdw = NIL'
(
(AND.L   #1,D0
(BNE     illegal                 ; odd addr.
(
(MOVE.L  #wdwMagic,D0
(CMP.L   Window.magic(A0),D0
(BNE     illegal                 ; wrong magic number
(
(MOVE.W  #okWdw,Window.state(A0) ; reset wdw.state
(BRA     ende                    ; VALID!
(
 illegal
(TRAP    #noErrorTrap
(DC.W    IllegalPointer-$4000
 
 ende
$END;
"END ResetWindowState;
"(*$L=*)
"
(
((*  Inquire functions  *)
"
 PROCEDURE GetWindowSpec (wdw: Window; VAR spec: WindowSpec);
 
"BEGIN
$IF notValid (wdw) THEN RETURN END;
$
$spec := wdw^.spec;
"END GetWindowSpec;
"
 PROCEDURE WindowWorkArea (wdw: Window): Rectangle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN Rect (0, 0, 0, 0) END;
$
$RETURN ShortFrame (windowToScreenFrame (wdw, wdw^.spec.visible))
"END WindowWorkArea;
"
 PROCEDURE GetWindowSliderPos (wdw: Window; VAR horPos, vertPos: LONGINT);
 
"BEGIN
$horPos := 0L;
$vertPos := 0L;
$IF notValid (wdw) THEN RETURN END;
$
$horPos := wdw^.spec.visible.x;
$vertPos := wdw^.spec.visible.y;
"END GetWindowSliderPos;
"
 PROCEDURE WindowFlags (wdw: Window): WdwFlagSet;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -4(A3),(A3)+
(JSR     notValid
(TST.W   -(A3)
(BNE     err
(
(;  Setze das 'topWdw'-Flag auf den richtigen Wert
(;
(JSR     AESWindows.TopWindow
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(MOVE.B  Window.flags(A0),D0
(BCLR    #topWdw,D0
(BTST    #hiddenWdw,D0           ; no test for hidden wdw.s
(BNE     isNotTop
(
(CMP.W   Window.hdl(A0),D1
(BNE     isNotTop
(BSET    #topWdw,D0
(
 isNotTop
(BRA     ende
(
 err
(SUBQ.L  #4,A3
(CLR.B   D0
 ende
(MOVE.B  D0, (A3)+
(ADDQ.L  #1, A3
$END;
"END WindowFlags;
"(*$L=*)
 
 PROCEDURE WindowState (wdw: Window): WdwState;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.W  #invalidWdw,(A3)+
(MOVE.L  A0,D1
(BEQ     ende                    ; 'wdw = NIL'
(
(LSR.L   #1,D1
(BCS     ende                    ; odd addr.
(
(MOVE.L  #wdwMagic,D1
(CMP.L   Window.magic(A0),D1
(BNE     ende                    ; wrong magic number
(
(; VALID!
(
(MOVE.W  Window.state(A0),-2(A3) ; RETURN wdw.state
 ende
$END;
"END WindowState;
"(*$L=*)
"
 PROCEDURE MinWindowWorkArea (wdw: Window): Rectangle;
 
"VAR   frame : Rectangle;
"
(oldHdl: GemHandle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN Rect (0, 0, 0, 0) END;
$saveCurrHdl (oldHdl);
$
$frame := ShortFrame (maxWorkArea (wdw));
$WITH frame DO
&IF scrollElem IN wdw^.elems
&THEN w := minWWithScrollElem; h := minHWithScrollElem;
&ELSE w := 1; h := 1 END
$END;
$
$restoreCurrHdl (oldHdl);
$RETURN frame
"END MinWindowWorkArea;
"
 PROCEDURE MaxWindowWorkArea (wdw: Window): Rectangle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN Rect (0, 0, 0, 0) END;
$
$RETURN ShortFrame (maxWorkArea (wdw))
"END MaxWindowWorkArea;
"
 PROCEDURE DetectWindow (    REF targets: ARRAY OF Window;
<noTrgs : CARDINAL;
<loc    : Point;
8VAR wdw    : Window;
8VAR result : DetectWdwResult);
"
"VAR   i      : CARDINAL;
(hdl    : CARDINAL;
(success: BOOLEAN;
(
(oldHdl : GemHandle;
"
"BEGIN
$careOfInitGem;
$saveCurrHdl (oldHdl);
 
$AESWindows.UpdateWindow (TRUE);
 
$(*  init. exit var.s
%*)
$wdw := NoWindow;
$result := noWdwDWR;
$
$(*  input check.
%*)
$IF (noTrgs = 0) OR (noTrgs > (HIGH (targets) + 1))
$THEN noTrgs := HIGH (targets)
$ELSE DEC (noTrgs) END;
$FOR i := 0 TO noTrgs DO
&IF (targets[i] # NoWindow) AND notValid (targets[i])   (* !!!SC-EVAL!!! *)
&THEN
(AESWindows.UpdateWindow (FALSE);
(restoreCurrHdl (oldHdl);
(RETURN
&END;
$END;
$
$(*  find wdw. and calc. exit var.s
%*)
%
$hdl := AESWindows.FindWindow (loc);
$findWindow (hdl, wdw, success);
$IF success THEN
$
&(*  'success' := "'wdw' is in targets[0..noTrgs]"
'*)
&i := 0; success := FALSE;
&WHILE (i <= noTrgs) AND ~ success DO
(success := (wdw = targets[i]);
(INC (i);
&END;
&
$END;
$
$IF success THEN result := foundWdwDWR
$ELSIF hdl # AESWindows.DeskHandle
$THEN
&wdw := NoWindow;
&result := unkownWdwDWR;
$END;
$
$AESWindows.UpdateWindow (FALSE);
$
$restoreCurrHdl (oldHdl);
"END DetectWindow;
"
 PROCEDURE FullArea (): Rectangle;
 (*
"BEGIN
$RETURN deskFrame
"END FullArea;
!*)
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     deskFrame,A0
(MOVE.L  (A0)+,(A3)+
(MOVE.L  (A0)+,(A3)+
$END;
"END FullArea;
"(*$L=*)
 
((*  calc. functions  *)
:
 
 PROCEDURE CalcWindowCoor (    wdw      : Window;
>screenLoc: Point;
:VAR wdwLoc   : LongPnt;
:VAR legal    : BOOLEAN);
 
"BEGIN
$IF notValid (wdw) THEN legal := FALSE; wdwLoc := LPnt (0, 0); RETURN END;
$
$wdwLoc := LPnt (LONG (screenLoc.x) - wdw^.spec.virtual.x,
4LONG (screenLoc.y) - wdw^.spec.virtual.y);
$legal := (wdwLoc.x >= 0L) AND (wdwLoc.x < wdw^.spec.virtual.w)
-AND (wdwLoc.y >= 0L) AND (wdwLoc.y < wdw^.spec.virtual.h);
"END CalcWindowCoor;
"
 PROCEDURE CalcScreenCoor (    wdw      : Window;
>wdwLoc   : LongPnt;
:VAR screenLoc: Point;
:VAR success  : BOOLEAN);
"BEGIN
$IF notValid (wdw) THEN success:= FALSE; screenLoc := Pnt (0, 0); RETURN END;
$
$wdwLoc := LPnt (wdwLoc.x + wdw^.spec.virtual.x,
4wdwLoc.y + wdw^.spec.virtual.y);
$
$success := TRUE;
$IF wdwLoc.x < LONG (MinInt) THEN success := FALSE; screenLoc.x := MinInt
$ELSIF wdwLoc.x > LONG (MaxInt) THEN success := FALSE; screenLoc.x := MaxInt 
$ELSE screenLoc.x := SHORT (wdwLoc.x) END;
$IF wdwLoc.y < LONG (MinInt) THEN success := FALSE; screenLoc.y := MinInt
$ELSIF wdwLoc.y > LONG (MaxInt) THEN success := FALSE; screenLoc.y := MaxInt 
$ELSE screenLoc.y := SHORT (wdwLoc.y) END;
"END CalcScreenCoor;
"
 PROCEDURE BorderToWorkArea (wdw: Window; borderArea: Rectangle): Rectangle;
 
"VAR   frame : Rectangle;
"
(oldHdl: GemHandle;
 
"BEGIN
$IF notValid (wdw) THEN RETURN Rect (0, 0, 0, 0) END;
$saveCurrHdl (oldHdl);
$
$frame := AESWindows.CalcWindow (AESWindows.calcWork, wdw^.aesElems,
DborderArea);
$
$restoreCurrHdl (oldHdl);
$RETURN frame
"END BorderToWorkArea;
"
"
((*  Misc. Managment  *)
((*  ===============  *)
(
 PROCEDURE envlpProc (start, child:BOOLEAN; VAR id:INTEGER);
 
"VAR     ptr     : Window;
"
"BEGIN
$IF child THEN
&IF start THEN INC (modID)           (*  new module  *)
&ELSE
&
(ptr := windowRoot;
(LOOP
*IF ptr = NIL THEN EXIT          (*  Ready *)
*ELSIF ptr^.modID >= modID THEN
,DeleteWindow (ptr);
,ptr := windowRoot;            (*  Again!  *)
*ELSE ptr := ptr^.next END;      (*  Next  *)
(END;
(
(careOfExitGem;
(DEC (modID);                      (*  release module  *)
(
&END;
$END;
"END envlpProc;
 
 PROCEDURE termProc;
 
"BEGIN
"
 (*$? TestVersion:
"WriteString ("'WindowBase' terminating."); WriteLn;
!*)
!
$envlpProc (FALSE, TRUE, VoidI);
"END termProc;
 
 PROCEDURE removalProc;
 
"BEGIN
$
 (*$? TestVersion:
"WriteString ("'WindowBase' removing...");
!*)
 
$envlpProc (FALSE, TRUE, VoidI);
$(* !protector!
$termProtector;
%*)
$exitGem;
"
 (*$? TestVersion:
"WriteString ("'WindowBase' removed."); WriteLn;
!*)
!
"END removalProc;
"
 
 VAR     termCrr         : TermCarrier;
(envlpCrr        : EnvlpCarrier;
(removalCrr      : RemovalCarrier;
(wsp             : MemArea;
!
 BEGIN
"SetEnvelope (envlpCrr, envlpProc, wsp);
"CatchProcessTerm (termCrr, termProc, wsp);
"CatchRemoval (removalCrr, removalProc, wsp);
"
"modID := 1;
"
"gemHdl := noGem;
"windowRoot := NIL;
"PassHandledMsg:= FALSE;
 END WindowBase.
  
(* $0000F8B3$000078BB$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFEEEFE9$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF6ADCD$FFF725A2$000049CE$0000956B$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$FFF725A2$0000D0D7$FFF725A2$FFF725A2$0000718FT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$0000C91F$0000CE3C$0000D0B7$0000D1B6$0000D1F7$0000D5F8$0000D636$0000DB14$0000DB97$0000DC84$0000DD1D$00004A4A$0000718F$000072F3$0000718F$0000C514*)
