DEFINITION MODULE AESMenus;


(*  Megamax-Modula 2 GEM-Library :  Die AES Menfunktionen
 *
 *  Autor: Manuel Chakravarty           Erstellt :  05.11.87
 *
 *  Version   2.2     V#0007
 *)
 
 
(*      Dieses Modul stellt die Routinen zur Verfgung, die zum
 *      Arbeiten mit Menuzeilen ntig sind. Darunter auch eine,
 *      die es einem Programm erlaubt, sich als Accessory anzumelden.
 *)
 
 
FROM GEMGlobals IMPORT PtrObjTree, PtrMaxStr;
 
 
                (*  Menu Manager  *)
                (*  ============  *)

PROCEDURE MenuBar (tree: PtrObjTree; show: BOOLEAN);

        
        (*  Diese Prozedur meldet eine Menzeile an oder ab.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'show'      -- 'TRUE': das Men wird angemeldet. Das bedeutet
         *                 da die Zeile am oberen Rand des Bildschirms
         *                 dargestellt wird und da bei einem folgende
         *                 Aufruf einer Eventprozedur (siehe AESEvents)
         *                 vom AES darauf geachtet wird, ob der Mauszei-
         *                 ger die Menzeile betritt.
         *                 'FALSE': das Men wird zwar nicht vom Bild-
         *                 schirm gelscht, aber es kann vom Anwender
         *                 nicht mehr benutzt werden.
         * 'tree'       -- mu einen Zeiger auf die Definition der Men-
         *                 zeile in Form eines Objektbaumes beinhalten.
         *)
        
PROCEDURE CheckItem (tree: PtrObjTree; item: CARDINAL; check: BOOLEAN);

        (*  Diese Prozedur setzt oder lscht den Haken links neben
         *  dem Meneintrag.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'tree'      -- die Menzeile in der der Eintrag steht.
         *  'item'      -- der Eintrag
         *  'check'     -- 'TRUE' : der Haken wird gesetzt.
         *                 'FALSE': der Haken wird gelscht.
         *)
        
PROCEDURE EnableItem (tree: PtrObjTree; item: CARDINAL; enable: BOOLEAN);

        (*  Der Eintrag einer Menzeile wird aktiviert oder deakti-
         *  viert. Der Schriftzug eines deativierten Eintrages wird
         *  aufgehellt dargestellt und kann vom Anwender nicht mehr
         *  angewhlt werden.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'item'      -- der Eintrag
         *  'tree'      -- die Menzeile, in der der Eintrag steht.
         *  'enable'    -- 'TRUE' : Eintrag wird aktiviert
         *                 'FALSE': Eintrag wird deaktiviert
         *)
        
PROCEDURE NormalTitle (tree  : PtrObjTree;
                       title : CARDINAL;
                       normal: BOOLEAN);

        (*  Der Titel in einer Menzeile wird normal oder invers
         *  dargestellt. Die inverse Darstellung bedeutet, da der
         *  Title angwhlt wurde.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'title'     -- Der Titel, der normal oder invers darge-
         *                 stellt werden soll.
         *  'tree'      -- Die Menzeile, in der der Titel steht
         *  'normal'    -- 'TRUE' : Titel normal darstellen
         *                 'FALSE': Titel invers darstellen
         *
         *)

PROCEDURE MenuText (tree: PtrObjTree; item: CARDINAL; REF text: ARRAY OF CHAR);

        (*  Diese Routine erlaubt es, einem Meneintrag einen neuen
         *  Text zuzuweisen.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'item'      -- Der Meneintrag
         *  'text'      -- Der neue Text
         *
         *  Es ist darauf zu achten, da die neue Zeichenkette nicht
         *  lnger als die Alte ist. Der Text sollte durch zwei Leer-
         *  zeichen eingeleitet werden und am Ende mit Leerzeichen
         *  aufgefllt werden. Am Ende sollte mindestens ein Leerzei-
         *  chen stehen.
         *)

PROCEDURE RegisterAcc (    title  : PtrMaxStr;
                       VAR id     : CARDINAL;
                       VAR success: BOOLEAN);
        
        (*  Diese Prozedur darf nur von Accessories verwendet werden.
         *  Sie trgt ein Accesory im Men ein.
         *
         *  Eingabeparameter
         *  ----------------
         *
         *  'title'     --'title^' ist die Zeichenkette des Accesory's
         *                das in das Men eingetragen werden soll.
         *
         *  Ausgabeparameter
         *  ----------------
         *
         *  'success'   --'TRUE' : die Anmeldung war erfolgreich
         *                'FALSE': Anmeldung war nicht erfolgreich
         *  'id'        -- enthlt, falls die Anmeldung erfolgreich war
         *                 die Identifikationsnummer des Accesorry's
         *                 die bei jeder 'accOpen' und 'accClose' Nach-
         *                 richt angegeben wird. (Siehe AESEvents)
         *
         *  Es ist darauf zu achten, da title^ eine globale Variable
         *  ist!
         *)
        

END AESMenus.