 MODULE MM2TinyShell; (*$Z+,P+,V+,R-*)
 
 (*
!*----------------------------------------------------------------------------
!* Copyright Februar 1987 Thomas Tempelmann & Manuel Chakravarty
!*----------------------------------------------------------------------------
!* Modul-Beschreibung : GEM-Tiny-Shell fr MOS / Megamax Modula-2
!*----------------------------------------------------------------------------
!* Version            : 2.3g        /     Interne Version: V#0117
!*----------------------------------------------------------------------------
!* MCH: Manuel Chakravarty
!* TT:  Thomas Tempelmann
!* MS:  Michael Seyfried, Unterer Mauergarten 17, D-W6520 Worms 24
!*----------------------------------------------------------------------------
!* Datum   Version  Autor  Bemerkung (Arbeitsbericht)
!*----------------------------------------------------------------------------
!* 01.12.90  2.1p   MCH    bernahme aller Teile der MM2Shell, die keine 
!*                         Fenster benutzen
!* 03.12.90  2.1p   MCH    Neue Workfilebehandlung und neue Resource
!* 07.12.90  2.2    TT     Anpassung an MM2Shell 2.2
!* 07.04.91  2.2b   TT     Hhe der Menzeile korrigiert; ACCs werden vor/nach
!*                         Start von Programmen geschlossen;
!*                         Batch-Befehle "POSTAMBLE1/2" zum Starten von Prgs
!*                         vor Verlassen der Shell; ExitSS-Aufruf am Ende des
!*                         Moduls _hinter_ den ShellWrite-Aufruf verlegt;
!*                         Codename von Workfiles wird nun korrekt behalten.
!* 20.05.91  2.2d   TT     Bei manueller Arbeitsdateieingabe wird die Datei
!*                         auf den Source-Pfaden gesucht.
!* 20.10.91  2.3    TT     Linker-Option-Box ermglicht Symboldatei-Erzeugung.
!*                  MS     Shell nun MultiGEM-fhig, dazu 'call' berarbeitet.
!* 14.01.93  2.3e   TT
!*----------------------------------------------------------------------------
!*)
 
 
 (*  Qualified imports for 'ShellShell'  *)
 
 IMPORT Clock, ModCtrl,
 
'GEMBase, AESMisc,
'GrafBase, GEMGlobals, GEMEnv,
'AESForms, AESObjects, AESResources, AESGraphics, AESMenus,
'AESWindows, AESEvents,
'ObjHandler, EventHandler, EasyGEM0, EasyGEM1;
 
 
 FROM SYSTEM     IMPORT LONGWORD, WORD, ADDRESS, BYTE,
7ASSEMBLER, ADR, LOAD, STORE;
 
 IMPORT Mm2tinysRsc;  (* RSC-Datei *)
 
 FROM RealCtrl   IMPORT AnyRealFormat, UsedFormat;
 
 FROM StrConv    IMPORT CardToStr, IntToStr, StrToLCard, StrToCard,
7StrToInt, LHexToStr;
 
 FROM Loader     IMPORT LoaderResults, DefaultStackSize,
7LoadModule, CallModule, UnLoadModule;
 
 FROM PathEnv    IMPORT HomeReplaced, HomeSymbol, ReplaceHome, HomePath;
 FROM PathCtrl   IMPORT PathList;
 FROM Paths      IMPORT SearchFile, ListPos;
 
 FROM Storage    IMPORT ALLOCATE, DEALLOCATE, MemAvail, AllAvail, Inconsistent;
 
 FROM Strings    IMPORT PosLen, String, Relation, Compare, Space, Upper, Empty,
7EatSpaces, Append, StrEqual, Delete, Concat, Assign,
7Split, Insert, Length, Copy, Pos;
 
 IMPORT Lists;
 
 IMPORT SysUtil0;
 
 FROM MOSConfig IMPORT StdDateMask;
 IMPORT MOSConfig;
 
 IMPORT MOSCtrl;
 
 FROM MOSGlobals IMPORT MemArea, BusFault, OddBusAddr, NoValidRETURN,
7OutOfStack, FileStr, PathStr, NameStr,
7fOK, fFileNotFound, fDriveNotReady, fWriteProtected,
7fPathNotFound, fInvalidDrive, fAccessDenied,
7fTooManyOpen, fInsufficientMemory,
7Drive, DriveSet, fEOF;
 
 FROM ShellMsg   IMPORT ScanMode, ScanAddr, TextName, ErrorMsg, DefPaths,
7ModPaths, ErrListFile, ImpPaths, SrcPaths, DefSfx,
7ImpSfx, ModSfx, CodeName, Active, LinkDesc, 
7LLRange, ScanIndex, TextLine, TextCol,
7MakeFileName, TemporaryPath, MainOutputPath,
7DefLibName, DefOutPath, ImpOutPath, ModOutPath,
7ShellPath, ImpSrcSfx, ModSrcSfx, DefSrcSfx, CodeSize,
7StdPaths, CompilerArgs, CompilerParm, ScanOpts,
7LinkMode, LinkerParm, EditorParm;
 
 IMPORT Directory;
 FROM Directory  IMPORT FileAttr, FileAttrSet, DirEntry, DirQueryProc,
7SetCurrentDir, GetCurrentDir, DefaultDrive,
7DirQuery, SetDefaultDrive, DrivesOnline,
7CreateDir, GetDefaultPath, SetFileAttr,
7ForceMediaChange, MakeFullPath, SetDefaultPath,
7FreeSpace;
 
 FROM FileNames  IMPORT StrToDrive, SplitPath, SplitName, DriveToStr,
7NameConc, ValidatePath, ConcatPath, ConcatName,
7FileName, FilePath;
 
 FROM Files      IMPORT File, Access, ReplaceMode,
7Create, Open, Close, State, ResetState, GetStateMsg,
7Remove, EOF, SetDateTime, GetDateTime;
 
 FROM Binary     IMPORT ReadBlock, ReadBytes, WriteBlock;
 
 IMPORT Text;
 
 FROM GEMScan    IMPORT InputScan, CallingChain, ChainDepth;
 
 FROM PrgCtrl    IMPORT EnvlpCarrier,
7SetEnvelope, TermProcess;
4
 FROM SysTypes   IMPORT ExcDesc, ExcSet, TRAP5;
 
 FROM Excepts    IMPORT InstallPreExc;
 
 FROM SysBuffers IMPORT ExceptsStack;
 
 FROM EasyGEM0   IMPORT WrapAlert;
 
 FROM UserBreak  IMPORT EnableBreak, DisableBreak;
 
 FROM KbdEvents  IMPORT DeInstallKbdEvents, InstallKbdEvents;
 
 FROM EasyGEM0   IMPORT SetGetMode, ShowArrow, HideMouse, ShowMouse; 
 
 FROM AESForms   IMPORT FormError, FormAlert;
 
 IMPORT InOutBase;
 
 
 CONST   (* Versionskennung der Shell.
)*)
(ShellRevision           = ' 2.3g ';
(
((*
)* Ist die folg. Konstante TRUE, wird das Modul "KbdEvents"
)* verwendet, das dafr sorgt, da Tastendrcke, bei denen
)* Shift, Control oder Alternate gedrckt werden, immer richtig
)* erkannt werden.
)* Andernfalls kann es passieren, da diese Umschalttasten
)* ignoriert werden, wenn die gewnschte Aktion erst nach
)* dem Tastendruck gestartet wird.
)* Siehe auch Hinweise im Definitions-Text des Moduls
)*)
(UseExtKeys = TRUE;
 
((*
)* Ist die folg. Konstante TRUE, startet die Shell GEM-Programme
)* korrekt mit der AES-Funktion "ShellWrite", sofern TOS 1.4
)* oder hher verwendet wird. Dies kann aber zu Problemen fhren,
)* beispielsweise, wenn die Shell von NEODESK gestartet wird,
)* weshalb sie dazu auf FALSE gesetzt werden kann.
)*)
(DoShellWrite = TRUE;
(
((*
)* Stack-Gren fr die Systemprogramme. Sie sollten vergrert
)* werden, wenn bei einem der Programme ein "Stackberlauf"
)* auftritt.
)*)
(CompilerStackSize = 16000;
(LinkerStackSize = 8000;
(EditorStackSize = 16000;
(MakeStackSize = 8000;
 
((*
)* Maximale Anzahl von Suchpfaden, die in einer Batch-Datei
)* definiert werden knnen. Ist zu erhhen, wenn bim Starten
)* der Shell oder eines Batches eine diesbezgliche Fehler-
)* meldung erscheint.
)*)
(MaxSearchPaths = 40;
 
((*
)*  Name der Datei in der alle zu compilierenden Module
)*  vom Make abgelegt werden. Das Verzeichnis (Pfad), in dem
)*  diese Datei erzeugt wird, ist der "temporre Pfad", der
)*  in der Shell-Parameter-Box anzugeben ist!
)*)
(MakeCompFileName        = 'MAKE.M2C';
 
 
 TYPE    actionType      = (doEdit, doComp, doLink, doExec, doScan, doCpEx,
;doLoad, doUnLd, doCont, doBtch, doParm, doMake,
;doMkEx, doDftM);
(MySuf           = (prg, app, tos, ttp, mos, mtp, mod, def, imp, m2p,
;m2b, m2m, m2d);
 
(Str128          = ARRAY [0..127] OF CHAR;
 
(ptrString       = POINTER TO String;
 
(PathEntry       = POINTER TO PathStr;
 
 VAR     lastFn, currFn,
(workFName, workCName       : FileStr;
(args                       : ARRAY[0..127] OF CHAR;
 
(suf: ARRAY MySuf OF ARRAY [0..2] OF CHAR;
 
 
0(*  Konfigurationsvariablen  *)
0(*  =======================  *)
 
(shellParm       : RECORD
<breakActive       : BOOLEAN;
<batchPath         : PathStr;
<parameterPath     : PathStr;
<sectors           : CARDINAL;
<tracks            : CARDINAL;
<sides             : CARDINAL;
<makeName          : String;
<(* TRUE: Nach TOS/TTP-Prgs auf Taste warten *)
<waitOnReturn      : BOOLEAN;
:END;
 
(noDirChange: BOOLEAN;
 
 
 
 PROCEDURE conc ( REF s1,s2: ARRAY OF CHAR ): Str128;
"VAR s: Str128;
&voidO: BOOLEAN;
"BEGIN
$Concat (s1,s2,s, voidO);
$RETURN s
"END conc;
 
 
 FORWARD action (what: actionType; workFile, tool: BOOLEAN);
 
 FORWARD FileAlert (errNo: INTEGER);
 FORWARD SaveParameter;
 FORWARD LoadParameter (REF name: ARRAY OF CHAR; loadInBatch: BOOLEAN);
 FORWARD ExecuteBatch (name: ARRAY OF CHAR; load: BOOLEAN);
 
 
 MODULE ShellShell;      (* Verwaltet die GEM-Aktionen der Modula-Shell *)
 
 
 IMPORT Text, SysUtil0,
 
0(*  resource indices  *)
 
'Menu, Mibox, Mshell, Mdatei, Mworkfil, Mparms,
'Mwork, Mtools, Dinfo, Mdeditwo, Mdcompwo, Mdexecwo,
'Mdlinkwo, Mdscanwo, Mdeditot, Mdcompot, Mdexecot,
'Mdlinkot, Mdscanot, Mdfolder, Mddelete, Mdquit, Wibox, Mwnew,
'Mwdelete, Mwchange, Mwwork1, Mwwork2, Mwwork3, Mwwork4,
'Mwwork5, Mwwork6, Mwwork7, Mwwork8, Mwwork9, Mwwork0,
'Mpshell, Mpeditor, Mpcomp, Mplink, Mpsave, Mienv,
'Midocu, Mihelp, Tibox, Mtool1, Mtool2, Mtool3,
'Mtool4, Mtool5, Mtool6, Mtool7, Mtool8, Mtool9,
'Mtool10, Optbox, Oquite, Opmark, Opwidth, Oppath,
'Ooutput, Oargs, Olibrary, Oerror, Oname, Oquit,
'Ook, Shellbox, Version, Scanbox, Sok, Squit,
'Saddr, Snamebox, Snedit, Snok, Snwork, Snquit,
'Argbox, Aedit, Aok, Loptbox, Locheck1, Locheck2,
'Locheck3, Locheck4, Locheck5, Locheck6, Locheck7, Locheck8,
'Lofname1, Lofname2, Lofname3, Lofname4, Lofname5, Lofname6,
'Lofname7, Lofname8, Lochecks, Lostack, Lomaxmod, Look,
'Loquit, Loname, Lonoopt, Lonamopt, Lomiddle, Lofull,
'Lofastld, Lofastco, Lofastme, Losymfil, Loadbox, Lfname, Sparmbox,
'Spmake, Spscpath, Spbreak, Spbaname, Sppaname, Spok, Spquit,
'Msgbar, Mbmsg, Eparmbox, Epname, Epsearch, Epstoper,
'Epshtemp, Epshname, Epedtemp, Epedname, Eparg, Eparname,
'Eparpos, Eparerro, Epok, Epquit, Helpbox, Hpnext,
'Hpprev, Hpquit, Hpmsgs, Hpmsg1, Hpmsg2, Hpmsg3,
'Hpmsg4, Hpmsg5, Hpmsg6, Hpmsg7, Hpmsg8, Hpmsg9,
'Hpmsg10, Hpmsg11, Hpmsg12, Hpmsg13, Hpmsg14, Infobox,
'Inpath, Inmkfile, Instack, Inblock, Inall, Incode,
'Inlength, Realform, Ihome, Inok, Inquit, Stponrtn,
'Pathalt, Optalt, Memalt, Debugalt, Noldstr, Okstr,
'Nouldstr, Noexestr, Retstr, Edstr, Workstr, Compstr,
'Linkstr, Infstr, Contstr, Parmsalt, Noparalt, Nowrkalt,
'Exitalt, Nohlpalt, Makestr, Contmalt, Editstr, Editbstr,
'Npathstr, Chworkti, Neworkti, Editti, Compti, Execti,
'Coexti, Linkti, Scanti, Foldti, Deleti,
 
%
0(*  from the library  *)
 
'ADDRESS, BYTE, WORD,
'ASSEMBLER, ADR, LOAD, STORE,
'
'(*  Storage  *)
'ALLOCATE, DEALLOCATE, MemAvail, AllAvail,
 
'(* RealCtrl *)
'AnyRealFormat, UsedFormat,
'
'(*  Strings  *)
'String, Relation,
'Concat, Insert, Split, Assign, Length, Compare, Copy, Space,
'Upper, Empty, EatSpaces, Append, StrEqual, PosLen, Delete, Pos,
'
'MOSConfig,
'DefSrcSfx, ImpSrcSfx, ModSrcSfx, StdDateMask,
'
'(*  StrConv  *)
'CardToStr, IntToStr, StrToCard, StrToLCard, LHexToStr,
 
'(*  Directory  *)
'Directory,
'FileAttr, FileAttrSet, DirEntry, DirQueryProc, Drive, DriveSet,
'DirQuery, SplitPath, SplitName, SetFileAttr, StrToDrive, FreeSpace,
'DriveToStr, DefaultDrive, CreateDir, GetCurrentDir, SetDefaultDrive,
'SetCurrentDir, FileStr, PathStr, NameStr, DrivesOnline, ValidatePath,
'ForceMediaChange, MakeFullPath, ConcatPath, ConcatName, SetDefaultPath,
'FileName, GetDefaultPath, FilePath,
'
'(*  ShellMsg  *)
'ScanMode, TextName, CodeName, DefSfx, ImpSfx, ModSfx, ScanAddr,
'ErrListFile, LinkDesc, TemporaryPath, LLRange,
'SrcPaths, ShellPath, MakeFileName, DefLibName, MainOutputPath,
'ScanOpts, DefPaths, EditorParm, CompilerParm, LinkerParm, LinkMode,
'
'
'(*  Loader  *)
'DefaultStackSize,
'
'(*  MOSGlobals  *)
'fOK, fEOF, fFileNotFound,
'
'(*  Files  *)
'File, Access,
'State, Open, Close, ResetState,
'
'(*  Binary  *)
'ReadBlock, WriteBlock,
'
'(*  GEMScan  *)
'ChainDepth,
'
'(*  MOSGloabls  *)
'MemArea,
'
'(*  Exceptions  *)
'TRAP5, ExcSet, ExcDesc,
'ExceptsStack, InstallPreExc,
'
'(*  Paths  *)
'ListPos,
'ReplaceHome, SearchFile,
'HomePath, HomeSymbol,
'
'(*  PrgCtrl  *)
'TermProcess,
'
'(*  from the outer module  *)
'CompilerArgs,
'actionType, Str128,
'lastFn, currFn, MySuf, ShellRevision,
'action, suf, args, noDirChange, shellParm, conc,
'SaveParameter, LoadParameter, FileAlert, ExecuteBatch;
 
 (*  MOS  *)
 
 FROM MOSCtrl            IMPORT RealMode;
 
 FROM Clock              IMPORT Date, Time;
 
 FROM ModCtrl            IMPORT ModQuery;
 
 FROM Lists              IMPORT List, LDir, InitList,
?CreateList, DeleteList, ResetList, AppendEntry,
?InsertEntry, NextEntry, PrevEntry, RemoveEntry,
?CurrentEntry, ListEmpty, ScanEntries,
?NoOfEntries, EndOfList;
 
 (*  Graphics  *)
 
 FROM GrafBase   IMPORT black, Pnt, Rect, PtrBitPattern, WritingMode,
7Point, Rectangle, TransRect, MinPoint, ClipRect,
7FrameRects;
5
 (*  General GEM  *)
 
 FROM GEMGlobals IMPORT Root, MaxDepth, NoObject, MaxStr,
7PtrObjTree, GemChar, MouseButton, MButtonSet,
7SpecialKeySet, ObjState, OStateSet, ObjFlag,
7OFlagSet, ObjType, FillType, SpecialKey, PtrMaxStr,
7LineType;
 
 FROM GEMEnv     IMPORT RC, GemHandle, DeviceHandle, DevParm, PtrDevParm,
7InitGem, ExitGem, GemActive, CurrGemHandle,
7SetCurrGemHandle, GemError, MouseInput, DeviceParameter;
 
 (*  AES  *)
 
 FROM AESForms           IMPORT FormDialMode,
?FormDial, FormDo, FormAlert;
 
 FROM AESObjects         IMPORT FindObject, DrawObject;
 
 FROM AESResources       IMPORT ResourcePart,
?LoadResource, FreeResource, ResourceAddr;
 
 FROM AESWindows         IMPORT SetNewDesk;
 
 FROM AESGraphics        IMPORT MouseForm,
?DragBox, MouseKeyState, GrafMouse, RubberBox;
 
 FROM AESMenus           IMPORT MenuBar, NormalTitle, EnableItem, MenuText,
?CheckItem;
 
 FROM AESEvents          IMPORT menuSelected, Event, RectEnterMode,
?MessageBuffer, MultiEvent, EventSet;
 
 FROM AESMisc            IMPORT ShellGet, ShellRead;
 
 IMPORT GEMBase;
 
 (*  Beyond GEM  *)
 
 FROM ObjHandler         IMPORT SetPtrChoice,
?SetCurrObjTree, CurrObjTree,
?ObjectState, SetObjSpace, ObjectSpace,
?ObjectFlags, BorderThickness, AssignTextStrings,
?GetTextStrings, ObjTreeError, LinkTextString,
?SetObjFlags, CreateSpecification, ObjectType,
?SetObjType, SetIconForm, GetIconForm,
?SetIconLook, GetIconLook, GetComplexColor,
?SetComplexColor, GetIconColor, SetIconColor,
?SetObjState, GetObjRelatives, RightSister;
 
 FROM EventHandler       IMPORT EventProc, WatchDogCarrier,
?HandleEvents, ShareTime, DeInstallWatchDog,
?InstallWatchDog, FlushEvents;
 
 FROM EasyGEM0           IMPORT SetGetMode, ObjEnumRef,
?ShowArrow, HideMouse, ShowMouse,
?ObjectSpaceWithAttrs, AbsObjectSpace,
?GetTextString, SetTextString, SetObjStateElem,
?ToggleObjState, ObjectStateElem, SetObjFlag,
?PrepareBox, ReleaseBox, DoSimpleBox,
?ForceDeskRedraw, DrawObjInWdw, DeskSize,
?DeselectButton, ToggleCheckBox, ToggleCheckPlus,
?SetGetBoxLCard, SetGetBoxStr, SetGetBoxEnum,
?SetGetBoxState, SetGetBoxCard, CharSize,
?ToggleSelectBox, ObjectFlag, TreeAddress,
?TextStringAddress;
 
 FROM EasyGEM1           IMPORT SelectFile;
 
 
 EXPORT TellMode, MaxTool, ToolField, NoPathsStr, EditBatStr,
'NoLoadStr, OkStr, NoUnloadStr, NoExecStr, RetStr, EdStr, MakeStr,
'WorkStr, CompStr, LinkStr, InfStr, ContMakeAlt, noParmAlt, ContStr,
'InitSS, ExitSS, ShowSS, HideSS, TalkWithUser, RequestArg, ScanBox,
'TellLoading, ClearDeskAndShowMsg, ShowBee, appl_init, appl_exit,
'maxWorkFiles, WorkField, IsSourceName, InitWorkFieldMenuIndizies,
'memErrorAlt, ShellName, LastCodeName, LastCodeSize, EditStr,
'IsMBTFile, multiGEM, multiTOS;
'
 
 CONST   minNecessaryMem = 50L * 1024L;  (*  min. 50k Speicher  *)
 
(screenColumns   = 80;           (*  screen width in chars  *)
 
(MaxTool         = 10;
(maxWorkFiles    = 10;
 
(resourceFile    = 'MM2TINYS.RSC';
(batchFile       = 'MM2TINYS.M2B';
(parameterFile   = 'MM2TINYS.M2P';
(helpFile        = 'MM2TINYS.HLP';
(fileBoxLength   = 41;           (*  Lnge des file box edit strings  *)
(maxDftPathInfo  = 43;           (*  'infoBox.Inpath' length *)
(maxCodeFileInfo = 43;           (*  'infoBox.Incode' length  *)
(maxDefLibName   = 33;           (*  'infoBox.Inmkfile' length *)
 
(msgStrLen       = 70;
(
(noRscAlt1       = '[3][Das Resource File kann|nicht geladen werden!]';
(noRscAlt2       = '[ Bye Bye... ]';
(
(noGemAlt1       = '[3][Anmeldung beim GEM|ist nicht gelungen!]';
(noGemAlt2       = '[ Pech ?! ]';
(
(memErrorAlt     = 'Fehler in Speicherverwaltung|Neustart empfohlen!';
(
(stdProtWidth    = 80;  (* Standardbreite des Compilerprotokolls *)
(
(undoKey         = BYTE (97);
(
((*  'actManager' needs these constants, that are normally defined within
)*  the resource in the large shell.
)*)
(Edit            = 0;
(Compile         = 1;
(Execute         = 2;
(Link            = 3;
(Scan            = 4;
(Resident        = 5;
(
(
 TYPE    ptrRectangle    = POINTER TO Rectangle;
(ptrList         = POINTER TO List;
(ptrString       = POINTER TO String;
(
 
 CONST   noCurrentWorkfile       = -1;   (*  more info at 'WorkField'  *)
(
 VAR
0(*  globale handles  *)
 
(dev                     : DeviceHandle;
(gemHdl                  : GemHandle;
(multiGEM                : BOOLEAN;
(multiTOS                : BOOLEAN;
(menu, desk, scanBox,
(shellBox, optBox,
(fileInfoBox, fileBox,
(shellParmBox, editorParmBox,
(sNameBox, argBox,
(linkBox, loadBox,
(fNameBox, formatBox,
(msgBar, confirmBox,
(helpBox, infoBox        : PtrObjTree;
(
(aesPB                   : GEMBase.AESPB;
(vdiPB                   : GEMBase.VDIPB;
(
(pathToLongAlt,
(cOptToLongAlt, wrgIcon2Alt,
(memFullAlt, drvSpaceMsg,
(debugAlt, 
(NoLoadStr, OkStr, NoPathsStr,
(NoUnloadStr, NoExecStr,
(RetStr, EdStr, WorkStr,
(CompStr, LinkStr, InfStr,
(ContMakeAlt, ContStr, EditStr, EditBatStr,
(parmSaveAlt, noParmAlt,
(noNewWorkAlt, loadFailedAlt,
(exitShellAlt, noHelpAlt,
(MakeStr, changeWorkTitle,
(newWorkTitle, editTitle,
(compileTitle, executeTitle,
(compExecTitle, linkTitle,
(scanTitle, folderTitle,
(deleteTitle  : PtrMaxStr;
(
(linkBoxIdx  : ARRAY[1..8] OF RECORD
8check,
8path        : CARDINAL;
6END;
(
(ToolField   : ARRAY[1..MaxTool] OF RECORD
8index       : CARDINAL; (*  Menu-Obj.  *)
8
8CASE used :BOOLEAN OF
:TRUE : name : FileStr;
8END;
6END;
 
((*  Contains all work files.
)*)
(WorkField   : RECORD
8noUsed           : CARDINAL;
8current          : INTEGER;
8elems            : ARRAY[0..maxWorkFiles - 1] OF RECORD
Mindex       : CARDINAL;
Mused        : BOOLEAN;
McodeName    : FileStr;
MsourceName  : FileStr;
KEND;
8baseHeightOfWibox: INTEGER;
6END;
(
(msgStr                  : String;
 
 
0(* Variablen, die die aktuellen Shellparameter speichern *)
 
(quitStatus              : (noQuit, quit, quickQuit);
(LastCodeName            : FileStr;
(LastCodeSize            : LONGCARD;
(
0(* Globale Infovariablen *)
(
(deskSize                : Rectangle;
(charWidth, charHeight   : CARDINAL;
(
(tellSpace               : Rectangle;    (*  Darf nur von 'TellLoading'
Q*  benutzt werden.
Q*)
 
(lastArgs: ARRAY [0..127] OF CHAR;
 
(ShellName: PathStr;
 
0(* Globale Kurzzeitvariablen *)
(
(ok      : BOOLEAN;      (*  Siehe auch 'notOKAlert'  *)
(but     : CARDINAL;
(
0(*  global dummies  *)
(
(voidC    : CARDINAL;
(voidO    : BOOLEAN;
(voidCh   : CHAR;
(voidI    : INTEGER;
(void128  : ARRAY [0..127] OF CHAR;
(voidADR  : ADDRESS;
(voidFrame: Rectangle;
 
 
8(*  Diverse Hilfsroutinen  *)
8(*  =====================  *)
 
((*  mouse  *)
(
 PROCEDURE mouseImage;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
*DC.W    $0, $0, $1, $0, $1
*DC.W    $07F0,$07F0,$07F0,$07F0,$0FF8,$1FFC,$3FFE,$3FFF
*DC.W    $3FFF,$3FFF,$1FFF,$0FFF,$0FFF,$07FF,$03FF,$03FE
*DC.W    $0000,$03E0,$03E0,$02A0,$07F0,$0E38,$1F7C,$1FFD
*DC.W    $1FFC,$1FFD,$0FF8,$07F2,$07FD,$03E0,$01CA,$01E8
$END;
"END mouseImage;
"(*$L=*)
 
 PROCEDURE ShowBee;
 
"BEGIN
$GrafMouse (userCursor, ADDRESS (mouseImage))
"END ShowBee;
 
 
 PROCEDURE appl_init;
"BEGIN
$WITH aesPB DO
&WITH pcontrl^ DO
(opcode:= 10;
(sintin:=  0;
(sintout:= 1;
(sadrin:=  0;
(sadrout:= 0;
&END;
$END;
$GEMBase.CallAES( ADR( aesPB));
"END appl_init;
 
 PROCEDURE appl_exit;
"BEGIN
$WITH aesPB DO
&WITH pcontrl^ DO
(opcode:= 19;
(sintin:=  0;
(sintout:= 1;
(sadrin:=  0;
(sadrout:= 0;
&END;
$END;
$GEMBase.CallAES( ADR( aesPB));
"END appl_exit;
 
 
((*  strings  *)
 
 (*  appendSpcTo -- Fgt Spaces an 'str' an, bis 'Length (str) = i'
!*)
(
 PROCEDURE appendSpcTo (i: CARDINAL; VAR str: ARRAY OF CHAR);
 
"VAR   l       : CARDINAL;
"
"BEGIN
$l := HIGH (str);
$IF i < l THEN l := i END;
$Append (Space (l - Length (str)), str, voidO);
"END appendSpcTo;
 
 (*  truncCopyStr -- 'source' wird nach 'dest' kopiert. Es gibt 'maxDestLen'
!*                  die Gre von 'dest' an, ist 'source' grer, so wird
!*                  der vordere Teil abgeschnitten und ein '..' vorange-
!*                  stellt.
!*)
!
 PROCEDURE truncCopyString (    source    : ARRAY OF CHAR;
?maxDestLen: CARDINAL;
;VAR dest      : ARRAY OF CHAR);
 
"VAR   sourceLen: CARDINAL;
 
"BEGIN
$sourceLen := Length (source);
$IF sourceLen > maxDestLen
$THEN
&Copy (source, sourceLen - maxDestLen - 2, sourceLen, dest, voidO);
&Insert ('..', 0, dest, voidO);
$ELSE Assign (source, dest, voidO) END;
"END truncCopyString;
&
&
((*  lists  *)
 
 (*  deleteSimpleList -- Deletes the list 'l' completly. The elements of the
!*                      list must be dynamical allocated variables and would
!*                      all be disposed.
!*                      If 'killCarrier = TRUE' then list-carrier would be
!*                      deleted.
!*)
 
 PROCEDURE deleteSimpleList (VAR l: List; killCarrier: BOOLEAN);
 
"VAR   entry: ADDRESS;
 
"BEGIN
$ResetList (l);
$entry := PrevEntry (l);
$WHILE entry # NIL DO
&RemoveEntry (l, voidO);
&DEALLOCATE (entry, 0L);
&entry := CurrentEntry (l);
$END;
$IF killCarrier THEN DeleteList (l, voidO) END;
"END deleteSimpleList;
 
"
((*  tests  *)
 
 PROCEDURE withShift (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN (leftShiftKey IN s) OR (rightShiftKey IN s)
"END withShift;
 
 PROCEDURE withBothShifts (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN (leftShiftKey IN s) AND (rightShiftKey IN s)
"END withBothShifts;
 
 PROCEDURE withCtrl (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN controlKey IN s
"END withCtrl;
 
 PROCEDURE withAlt (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN alternateKey IN s
"END withAlt;
 
"
((*  procs for AES objects  *)
(
 (*  formDo -- Is same as 'FormDo', but clears the most significant bit
!*            of 'exit' (double click).
!*)
!
 PROCEDURE formDo (tree: PtrObjTree; start: CARDINAL; VAR exit: CARDINAL);
 
"BEGIN
$FormDo (tree, start, exit);
$exit := exit MOD (MaxCard DIV 2);
"END formDo;
"
 PROCEDURE drawObject (tree: PtrObjTree; obj: CARDINAL);
 
"VAR   space   : Rectangle;
 
"BEGIN
$space := AbsObjectSpace (tree, obj);
$DrawObject (tree, Root, MaxDepth, space);
"END drawObject;
"
 PROCEDURE hideObj (obj: CARDINAL; hide: BOOLEAN);
 
"BEGIN
$SetObjFlag (CurrObjTree (), obj, hideTreeFlg, hide);
"END hideObj;
 
"
0(*  Operations on path/file names  *)
 
 (*  IsSourceName -- Is TRUE, if 'path' descibes a source file else FALSE.
!*)
 
 PROCEDURE IsSourceName (REF path: ARRAY OF CHAR): BOOLEAN;
 
"VAR   name    : NameStr;
(prefix  : ARRAY[0..64] OF CHAR;
(suffix  : ARRAY[0..2] OF CHAR;
(sufcnt  : MySuf;
(isSource: BOOLEAN;
(
"BEGIN
$SplitPath (path, prefix, name);
$SplitName (name, name, suffix);
$isSource := ~ Empty (suffix);
$IF isSource THEN
&sufcnt:= MIN (MySuf);
&LOOP
(IF StrEqual (suffix, suf[sufcnt]) THEN isSource := FALSE; EXIT
(ELSIF sufcnt = MAX (MySuf) THEN EXIT
(ELSE INC (sufcnt) END
&END;
$END;
$RETURN isSource
"END IsSourceName;
 
 PROCEDURE isMSPFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2p])
"END isMSPFile;
"
 PROCEDURE IsMBTFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2b])
"END IsMBTFile;
"
 PROCEDURE isMakeFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2m])
"END isMakeFile;
"
"
0(*  Alerts  *)
0(*  ======  *)
 
 PROCEDURE doAlert (alt: PtrMaxStr);
 
"BEGIN
$FormAlert (1, alt^, voidC);
"END doAlert;
"
 
 (*  multiStringAlert -- Setzt aus den zwei Zeichenketten eine Alarmmeldung
!*                      zusammen und gibt diese aus.
!*)
 
 PROCEDURE multiStringAlert (REF str1, str2: ARRAY OF CHAR; VAR but: CARDINAL);
 
"VAR     str     : ARRAY[0..255] OF CHAR;
"
"BEGIN
$Concat (str1, str2, str, voidO);
$FormAlert (1, str, but);
"END multiStringAlert;
 
 (*  notOKAlert -- Falls die globale Variable 'ok = FALSE' ist, so wird der
!*                bergebene FileStr 'str' innerhalb einer Alert-Box ange-
!*                zeigt.
!*)
!
 PROCEDURE notOKAlert (str: PtrMaxStr);
 
"BEGIN
$IF ~ ok THEN doAlert (str) END;
"END notOKAlert;
 
 PROCEDURE flexAlert (default: CARDINAL; REF str1,str2:ARRAY OF CHAR; alt:PtrMaxStr;
5VAR but:CARDINAL);
5
"VAR     str, strx       : ARRAY[0..255] OF CHAR;
*i, j            : INTEGER;
7
"BEGIN
$i:=Pos ('&',alt^, 0);
$j:=Pos ('&',alt^, i + 1);
$Copy (alt^, 0,i, str, voidO);
$Append (str1, str, voidO);
$IF j >= 0 THEN
&Copy (alt^, i + 1,j - i - 1, strx, voidO);
&Append (strx, str, voidO);
&Append (str2, str, voidO);
&i:=j;
$END;
$Copy (alt^, i + 1,Length (alt^) - CARDINAL (i) - 1, strx, voidO);
$Append (strx, str, voidO);
$FormAlert (default,str, but);
"END flexAlert;
"
 PROCEDURE reportOutOfMemory;
 
"BEGIN
$doAlert (memFullAlt);
"END reportOutOfMemory;
 
 
8(*  menu procs  *)
8(*  ===========  *)
 
 PROCEDURE InitWorkFieldMenuIndizies;
 
"BEGIN
$WorkField.elems[0].index := Mwwork0;
$WorkField.elems[1].index := Mwwork1;
$WorkField.elems[2].index := Mwwork2;
$WorkField.elems[3].index := Mwwork3;
$WorkField.elems[4].index := Mwwork4;
$WorkField.elems[5].index := Mwwork5;
$WorkField.elems[6].index := Mwwork6;
$WorkField.elems[7].index := Mwwork7;
$WorkField.elems[8].index := Mwwork8;
$WorkField.elems[9].index := Mwwork9;
"END InitWorkFieldMenuIndizies;
"
"
 (*  setTools -- Verndert den Menubaum so, da nur noch die in 'ToolField'
!*              vorhandenen Menu-Tool-Eintrge sichtbar sind.
!*)
 
 PROCEDURE setTools;
 
"CONST   toolNameLen = 12;
 
"VAR   f1, f2    : Rectangle;
(h         : INTEGER;
(i         : CARDINAL;
(str, str2 : FileStr;
"
"BEGIN
"
$SetCurrObjTree (menu, FALSE);
$h := 0;
$FOR i := 1 TO MaxTool DO
&WITH ToolField[i]
&DO
(IF used THEN
(
*GetTextString (menu, index, str);
*SplitPath (name, void128, str2);
*Append (Space (toolNameLen - Length (str2)), str2, voidO);
*Delete (str, 2, toolNameLen, voidO);
*Insert (str2, 2, str, voidO);
*MenuText (menu, index, str);
*f1 := ObjectSpace (index);
*h := h + f1.h
*
(END;
(hideObj (index, NOT used);
&END
$END;
$IF h = 0
$THEN
&IF NOT ObjectFlag (menu, Mtools, hideTreeFlg)
&THEN
(hideObj (Mtools, TRUE);
(f1 := ObjectSpace (Mibox);
(f2 := ObjectSpace (Mtools);
(DEC (f1.w, f2.w);
(SetObjSpace (Mibox, f1);
&END;
$ELSE
&IF ObjectFlag (menu, Mtools, hideTreeFlg) THEN
(hideObj (Mtools, FALSE);
(f1 := ObjectSpace (Mibox);
(f2 := ObjectSpace (Mtools);
(INC (f1.w, f2.w);
(SetObjSpace (Mibox, f1);
&END;
&f1 := ObjectSpace (Tibox);
&f1.h := h;
&SetObjSpace (Tibox, f1);
$END;
$
$MenuBar (menu, TRUE);
$
"END setTools;
 
 
 (*  setWorkfiles -- Verndert den Menubaum so, da nur noch die in 'WorkField'
!*                  vorhandenen Menu-Workfile-Eintrge sichtbar sind.
!*)
 
 PROCEDURE setWorkfiles;
 
"CONST workNameLen = 12;
 
"VAR   i, lastIdx: INTEGER;
(str, str2 : FileStr;
(f1, f2    : Rectangle;
"
"BEGIN
$SetCurrObjTree (menu, FALSE);
$lastIdx := 0;
$FOR i := 0 TO maxWorkFiles - 1 DO
$
&WITH WorkField.elems[i]
&DO
(GetTextString (menu, index, str);
(IF used
(THEN
*lastIdx := i;
*SplitPath (sourceName, void128, str2);
(ELSE
*str2 := '';
(END;
(Append (Space (workNameLen - Length (str2)), str2, voidO);
(Delete (str, 2, workNameLen, voidO);
(Insert (str2, 2, str, voidO);
(MenuText (menu, index, str);
*
(SetObjStateElem (menu, index, disableObj, NOT used);
(CheckItem (menu, index, FALSE);
&END
&
$END;(*FOR*)
$
$(*  Cause the work file number zero is the last in the pull down menu.
%*)
$IF WorkField.elems[0].used THEN lastIdx := 10 END;
$
$(*  Hide all work file menu entries after the last used one.
%*)
$FOR i := 1 TO maxWorkFiles - 1
$DO
&hideObj (WorkField.elems[i].index, i > lastIdx);
$END;
$hideObj (WorkField.elems[0].index, 10 > lastIdx);
$
$(*  Adjust size of the ibox, that contains the pull down menu.
%*)
$f1 := ObjectSpace (Wibox);
$f2 := ObjectSpace (Mwwork0);
$f1.h := lastIdx * f2.h + WorkField.baseHeightOfWibox;
$SetObjSpace (Wibox, f1);
$
$IF WorkField.current # noCurrentWorkfile
$THEN
&CheckItem (menu, WorkField.elems[WorkField.current].index, TRUE);
$END;
"END setWorkfiles;
 
 
 PROCEDURE animateMenuTitle (title: CARDINAL; VAR space: Rectangle);
 
"BEGIN
$NormalTitle (menu, title, FALSE);
$space := AbsObjectSpace (menu, title);
"END animateMenuTitle;
 
 PROCEDURE deAnimateMenuTitle (title: CARDINAL);
 
"BEGIN
$NormalTitle (menu, title, TRUE);
"END deAnimateMenuTitle;
"
 
0(*  Routinen fr das Dialogbox-Managment  *)
0(*  ====================================  *)
 
((*  misc. box primitives  *)
 
 TYPE    arrayOfTwoCards = ARRAY[1..2] OF CARDINAL;
 
 PROCEDURE twoCardsInArray (c1, c2: CARDINAL): arrayOfTwoCards;
 
"VAR   res: arrayOfTwoCards;
"
"BEGIN
$res[1] := c1;
$res[2] := c2;
$RETURN res
"END twoCardsInArray;
"
 
((*  box handlers  *)
"
 PROCEDURE doCompilerOptionBox;
 
"PROCEDURE setGetCompOpts (mode: SetGetMode);
"
$VAR notProtocol,
(found      : BOOLEAN;
(fname      : FileStr;
"
$BEGIN
&WITH CompilerParm DO
(SetGetBoxStr (optBox, Oname, mode, name);
(Upper (name);
(SetGetBoxState (optBox, Oquite, mode, checkObj, shortMsgs);
(SetGetBoxState (optBox, Opmark, mode, checkObj, protocol);
(IF mode = setValue THEN
*notProtocol := ~ protocol;
*SetGetBoxState (optBox, Oppath, setValue, disableObj, notProtocol);
*SetGetBoxState (optBox, Opwidth, setValue, disableObj, notProtocol);
(END;
(SetGetBoxStr (optBox, Oargs, mode, CompilerArgs);
(SetGetBoxStr (optBox, Oppath, mode, protName);
(SetGetBoxCard (optBox, Opwidth, mode, protWidth);
(IF protWidth < 10 THEN protWidth := stdProtWidth END;
(
(SetGetBoxStr (optBox, Ooutput, mode, MainOutputPath);
(ValidatePath (MainOutputPath);
(SetGetBoxStr (optBox, Olibrary, mode, DefLibName);
(IF mode = getValue THEN
*Upper (DefLibName);
*IF Length (FilePath (DefLibName)) = 0 THEN
,SearchFile (DefLibName, DefPaths, fromStart, found, DefLibName);
*END
(END;
(SetGetBoxStr (optBox, Oerror, mode, ErrListFile);
(Upper (ErrListFile);
&END;
$END setGetCompOpts;
$
 
"VAR   space, start    : Rectangle;
(exit            : CARDINAL;
"
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetCompOpts (setValue);
$PrepareBox (optBox, start, space);
$
$LOOP
&formDo (optBox, Ooutput, exit);
&
&CASE exit OF
(Ook, Oquit: DeselectButton (optBox, exit); EXIT|
(Oquite    : ToggleCheckBox (optBox, Oquite)|
(Opmark    : ToggleCheckPlus (optBox, Opmark,
EtwoCardsInArray (Oppath, Opwidth))|
&ELSE
&END;
$END;
$
$IF exit = Ook THEN setGetCompOpts (getValue) END;
$
$ReleaseBox(optBox, start, space);
$deAnimateMenuTitle (Mparms);
"END doCompilerOptionBox;
 
 PROCEDURE doLinkerOptionBox;
 
"PROCEDURE setGetLinkOpts (mode: SetGetMode);
 
$VAR i       : CARDINAL;
(valid,
(notValid: BOOLEAN;
(refs    : ARRAY [1..4] OF ObjEnumRef;
$
$BEGIN
&SetGetBoxStr (linkBox, Loname, mode, LinkerParm.name);
&Upper (LinkerParm.name);
&FOR i:= 1 TO 8 DO
(WITH linkBoxIdx[i] DO
*SetGetBoxState (linkBox, check, mode, checkObj, LinkerParm.linkList[i].valid);
*IF mode = setValue THEN
,notValid := ~ LinkerParm.linkList[i].valid;
,SetGetBoxState (linkBox, path, setValue, disableObj, notValid);
*END;
*SetGetBoxStr (linkBox, path, mode, LinkerParm.linkList[i].name);
(END
&END;
&valid := (LinkerParm.linkStackSize # 0L); notValid := ~ valid;
&SetGetBoxState (linkBox, Lochecks, mode, checkObj, valid);
&IF mode = setValue THEN
(SetGetBoxState (linkBox, Lostack, setValue, disableObj, notValid);
&END;
&SetGetBoxLCard (linkBox, Lostack, mode, LinkerParm.linkStackSize);
&IF ~ valid THEN LinkerParm.linkStackSize := 0L END;
&SetGetBoxCard (linkBox, Lomaxmod, mode, LinkerParm.maxLinkMod);
&
&SetGetBoxState (linkBox, Lofastld, mode, checkObj, LinkerParm.fastLoad);
&SetGetBoxState (linkBox, Lofastco, mode, checkObj, LinkerParm.fastCode);
&SetGetBoxState (linkBox, Lofastme, mode, checkObj, LinkerParm.fastMemory);
&
&SetGetBoxState (linkBox, Losymfil, mode, checkObj, LinkerParm.symbolFile);
&
&refs[1].obj := Lonoopt;
&refs[1].value := WORD (noOptimize);
&refs[2].obj := Lonamopt;
&refs[2].value := WORD (nameOptimize);
&refs[3].obj := Lomiddle;
&refs[3].value := WORD (partOptimize);
&refs[4].obj := Lofull;
&refs[4].value := WORD (fullOptimize);
&i := ORD (LinkerParm.optimize);
&SetGetBoxEnum (linkBox, refs, mode, i);
&LinkerParm.optimize := VAL (LinkMode, i);
$END setGetLinkOpts;
$
 
"VAR   space, start    : Rectangle;
(exit, i         : CARDINAL;
"
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetLinkOpts (setValue);
$PrepareBox (linkBox, start, space);
$
$LOOP
&formDo (linkBox, Root, exit);
&
&IF (exit = Look) OR (exit = Loquit) THEN
(DeselectButton (linkBox, exit); EXIT
&ELSIF exit = Lochecks THEN
(ToggleCheckPlus (linkBox, Lochecks, Lostack)
&ELSIF (exit = Lofastld) OR (exit = Lofastco) OR (exit = Lofastme)
&OR (exit = Losymfil) THEN
(ToggleCheckBox (linkBox, exit)
&ELSE
(FOR i := 1 TO 8 DO
*IF linkBoxIdx[i].check = exit THEN
,ToggleCheckPlus (linkBox, exit, linkBoxIdx[i].path)
*END
(END;
&END;
$END;
$
$IF exit = Look THEN setGetLinkOpts (getValue) END;
"
$ReleaseBox(linkBox, start,space);
$deAnimateMenuTitle (Mparms);
"END doLinkerOptionBox;
"
 PROCEDURE doScanBox (): BOOLEAN;
 
"VAR     but : CARDINAL;
"
"BEGIN
$ScanAddr := 0L;
$SetTextString (scanBox, Saddr, '');
$DoSimpleBox (scanBox, Rect (-1, -1, -1, -1), but);
$IF but = Sok THEN SetGetBoxLCard (scanBox, Saddr, getValue, ScanAddr) END;
$RETURN ScanAddr # 0L
"END doScanBox;
 
 FORWARD setWorkfileName (idx: CARDINAL; VAR name: ARRAY OF CHAR);
 
 (*  doChangeWork -- Inquires a file name from the user, that becomes the new
!*                  work file number 'idx'.
!*                  'idx' has to be an active work file.
!*)
 
 PROCEDURE doChangeWork (idx: INTEGER);
 
"VAR     str   : FileStr;
*ok    : BOOLEAN;
"
"BEGIN
$animateMenuTitle (Mworkfil, voidFrame);
"
$str := WorkField.elems[idx].sourceName;
$SelectFile (changeWorkTitle^, str, ok);
$
$IF ok
$THEN
&Upper (str);
&setWorkfileName (idx, str);
$END;
$
$deAnimateMenuTitle (Mworkfil);
"END doChangeWork;
 
 PROCEDURE doShellParameterBox;
 
"PROCEDURE setGetShellParm (mode: SetGetMode);
"
$BEGIN
&WITH shellParm DO
(SetGetBoxState (shellParmBox, Spbreak, mode, checkObj, breakActive);
(SetGetBoxStr (shellParmBox, Spbaname, mode, batchPath);
(Upper (batchPath);
(SetGetBoxStr (shellParmBox, Sppaname, mode, parameterPath);
(Upper (parameterPath);
(SetGetBoxStr (shellParmBox, Spscpath, mode, TemporaryPath);
(ValidatePath (TemporaryPath);
(IF TemporaryPath[0] # HomeSymbol THEN
*MakeFullPath (TemporaryPath, voidI);
(END;
(SetGetBoxStr (shellParmBox, Spmake, mode, makeName);
(Upper (makeName);
&END;
$END setGetShellParm;
$
"VAR   space, start    : Rectangle;
(exit            : CARDINAL;
"
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetShellParm (setValue);
$PrepareBox (shellParmBox, start, space);
$
$LOOP
&formDo (shellParmBox, Root, exit);
&
&CASE exit OF
(Spok, Spquit: DeselectButton (shellParmBox, exit); EXIT|
(
(Spbreak     : ToggleCheckBox (shellParmBox, exit)|
&ELSE
&END;
$END;
$
$IF exit = Spok THEN setGetShellParm (getValue) END;
$
$ReleaseBox(shellParmBox, start, space);
$deAnimateMenuTitle (Mparms);
"END doShellParameterBox;
 
 PROCEDURE doEditorParameterBox;
 
"PROCEDURE setGetEditorParm (mode: SetGetMode);
"
$VAR disable: BOOLEAN;
"
$BEGIN
&WITH EditorParm DO
(SetGetBoxStr (editorParmBox, Epname, mode, name);
(Upper (name);
(SetGetBoxState (editorParmBox, Epsearch, mode,
8checkObj, searchSources);
(SetGetBoxState (editorParmBox, Epstoper, mode,
8checkObj, waitOnError);
(SetGetBoxState (editorParmBox, Epshtemp, mode,
8checkObj, tempShellFile);
(disable := ~ tempShellFile;
(SetGetBoxState (editorParmBox, Epshname, mode, disableObj, disable);
(SetGetBoxStr (editorParmBox, Epshname, mode, tempShellName);
(
(SetGetBoxState (editorParmBox, Epedtemp, mode,
8checkObj, tempEditorFile);
(disable := ~ tempEditorFile;
(SetGetBoxState (editorParmBox, Epedname, mode, disableObj, disable);
(SetGetBoxStr (editorParmBox, Epedname, mode, tempEditorName);
 
(SetGetBoxState (editorParmBox, Eparg, mode,
8checkObj, passArgument);
(SetGetBoxState (editorParmBox, Eparname, mode,
8checkObj, passName);
(SetGetBoxState (editorParmBox, Eparerro, mode,
8checkObj, passErrorText);
(SetGetBoxState (editorParmBox, Eparpos, mode,
8checkObj, passErrorPos);
&END;
$END setGetEditorParm;
$
"VAR   start, space: Rectangle;
(exit        : CARDINAL;
 
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetEditorParm (setValue);
$PrepareBox (editorParmBox, start, space);
$
$LOOP
&formDo (editorParmBox, Root, exit);
&
&CASE exit OF
(Epok, Epquit: DeselectButton (editorParmBox, exit); EXIT|
(
(Epsearch,
(Epstoper,
(Eparg,
(Eparname,
(Eparerro,
(Eparpos     : ToggleCheckBox (editorParmBox, exit)|
(Epshtemp    : ToggleCheckPlus (editorParmBox, Epshtemp, Epshname)|
(Epedtemp    : ToggleCheckPlus (editorParmBox, Epedtemp, Epedname)|
&ELSE
&END;
$END;
$
$IF exit = Epok THEN setGetEditorParm (getValue) END;
"
$ReleaseBox(editorParmBox, start, space);
$deAnimateMenuTitle (Mparms);
"END doEditorParameterBox;
"
 PROCEDURE doHelpBox (REF fname: ARRAY OF CHAR);
 
"CONST noLines = 14;   (*  Anzahl der Zeilen in der Hilfe-Box  *)
(noRows  = 65;
 
"VAR   start, space    : Rectangle;
(but, i,
(visibleLines    : CARDINAL;
(text            : List;
(err, end, first : BOOLEAN;
(f               : File;
(str             : ptrString;
(path            : PathStr;
 
"PROCEDURE fileErr (): BOOLEAN;
$VAR state: INTEGER;
$BEGIN
&state := State (f);
&IF (state < fOK) OR (state = fEOF) THEN
)ResetState (f);
)FileAlert (state);
)RETURN TRUE
&ELSE
)RETURN FALSE
&END;
$END fileErr;
$
"PROCEDURE addLine (obj: CARDINAL);
$BEGIN
&IF NOT end THEN
(str := NextEntry (text);
(IF str = NIL THEN end := TRUE ELSE INC (visibleLines) END;
&END;
&IF end THEN
(SetTextString (helpBox, obj, '')
&ELSE
(IF Length (str^) > noRows THEN
*Delete (str^, noRows, Length (str^) - noRows, voidO);
(END;
(SetTextString (helpBox, obj, str^);
&END;
$END addLine;
$
"BEGIN
$animateMenuTitle (Mparms, start);
$
$(*  Lies Hilfe-Datei ein.
%*)
 
$Concat (ShellPath, fname, path, voidO);
$CreateList (text, err);
$IF err THEN reportOutOfMemory; deAnimateMenuTitle (Mparms); RETURN END;
$ShowBee;
$Open (f, path, readSeqTxt);
$IF (State (f)) # fOK
$THEN
&doAlert (noHelpAlt); 
&DeleteList (text, voidO);
&deAnimateMenuTitle (Mparms);
&ShowArrow;
&RETURN
$END;
$LOOP
$
&NEW (str);
&IF str = NIL THEN reportOutOfMemory; EXIT END;
&IF fileErr () THEN DISPOSE (str); EXIT END;
&Text.ReadString (f, str^);
$  AppendEntry (text, str, err);
&IF err THEN reportOutOfMemory; DISPOSE (str); EXIT END;
&IF fileErr () THEN EXIT END;
&Text.ReadLn (f);
$
$END;
$Close (f);
$ShowArrow;
$
$(*  Zeige Hilfe-Datei an.
%*)
%
$ResetList (text);
$but := Hpnext; visibleLines := 0; first := TRUE;
$REPEAT
$
&IF but = Hpprev THEN
(IF EndOfList (text) THEN INC (visibleLines) END;
(FOR i := 1 TO noLines + visibleLines DO voidADR := PrevEntry (text) END;
&END;
&SetObjStateElem (helpBox, Hpprev, disableObj, EndOfList (text));
&end := FALSE; visibleLines := 0;
&addLine (Hpmsg1); addLine (Hpmsg2); addLine (Hpmsg3);
&addLine (Hpmsg4); addLine (Hpmsg5); addLine (Hpmsg6);
&addLine (Hpmsg7); addLine (Hpmsg8); addLine (Hpmsg9);
&addLine (Hpmsg10); addLine (Hpmsg11); addLine (Hpmsg12);
&addLine (Hpmsg13); addLine (Hpmsg14);
&SetObjStateElem (helpBox, Hpnext, disableObj, EndOfList (text));
&SetObjFlag (helpBox, Hpnext, defaultFlg, NOT EndOfList (text));
&SetObjFlag (helpBox, Hpquit, defaultFlg, EndOfList (text));
&
&IF first THEN PrepareBox (helpBox, start, space); first := FALSE
&ELSE DrawObject (helpBox, Root, MaxDepth, space) END;
&formDo (helpBox, Root, but);
&DeselectButton (helpBox, but);
&
$UNTIL but = Hpquit;
$ReleaseBox (helpBox, start, space);
$
$(*  Lsche Hilfe-Datei.
%*)
$deleteSimpleList (text, TRUE);
$
$deAnimateMenuTitle (Mparms);
"END doHelpBox;
 
 
 PROCEDURE doInfoBox;
 
 (*
!* Umgebungsinformationen
!*)
 
"VAR   dftPath,
(codeFile        : FileStr;
(dftPathEditable : BOOLEAN;
(
"PROCEDURE setGetInfo (mode: SetGetMode);
"
$VAR lc: LONGCARD; s: ARRAY [0..13] OF CHAR;
"
$BEGIN
&SetObjFlag (infoBox, Inpath, editFlg, dftPathEditable);
&SetGetBoxStr (infoBox, Inpath, mode, dftPath);
&SetGetBoxLCard (infoBox, Instack, mode, DefaultStackSize);
&SetGetBoxStr (infoBox, Inmkfile, mode, MakeFileName);
&SetGetBoxState (infoBox, Stponrtn, mode, checkObj, shellParm.waitOnReturn);
&Upper (MakeFileName);
&IF mode = setValue THEN
(lc := MemAvail ();
(SetGetBoxLCard (infoBox, Inblock, setValue, lc);
(lc := AllAvail ();
(SetGetBoxLCard (infoBox, Inall, setValue, lc);
(SetGetBoxStr (infoBox, Ihome, setValue, HomePath);
(SetGetBoxStr (infoBox, Incode, setValue, codeFile);
(SetGetBoxLCard (infoBox, Inlength, setValue, LastCodeSize);
(IF UsedFormat = IEEEReal THEN
*IF RealMode = 2 THEN
,s:= 'IEEE (ST-FPU)'
*ELSE
,s:= 'IEEE (TT-FPU)'
*END
(ELSE
*s:= 'Megamax'
(END;
(SetGetBoxStr (infoBox, Realform, setValue, s);
&END;
$END setGetInfo;
$
"VAR   space, start   : Rectangle;
(exit     : CARDINAL;
(res     : INTEGER;
 
"BEGIN
$animateMenuTitle (Mparms, start);
$
$GetDefaultPath (dftPath);
$dftPathEditable := (maxDftPathInfo >= Length (dftPath));
$truncCopyString (dftPath, maxDftPathInfo, dftPath);
$truncCopyString (LastCodeName, maxCodeFileInfo, codeFile);
$setGetInfo (setValue);
$
$PrepareBox (infoBox, start, space);
$LOOP
&formDo (infoBox, Root, exit);
&CASE exit OF
(Inok, Inquit: DeselectButton (infoBox, exit); EXIT|
(Stponrtn    : ToggleCheckBox (infoBox, exit)|
&ELSE
&END;
$END;
$ReleaseBox(infoBox, start, space);
$
$IF exit = Inok THEN
&setGetInfo (getValue);
&IF dftPathEditable THEN
(ValidatePath (dftPath);
(ReplaceHome (dftPath);
(SetDefaultPath (dftPath, res);
(FileAlert (res);
&END;
$END;
$deAnimateMenuTitle (Mparms);
"END doInfoBox;
"
 
0(*  Exportierte Box-Funktionen  *)
 
 PROCEDURE ScanBox (VAR name: ARRAY OF CHAR): BOOLEAN;
 
"VAR   but: CARDINAL;
 
"BEGIN
$SetTextString (sNameBox, Snedit, name);
$DoSimpleBox (sNameBox, Rect (-1, -1, -1, -1), but);
$CASE but OF
&Snok  : GetTextString(sNameBox, Snedit, name); Upper (name)|
&Snwork: WITH WorkField DO
0IF current >= 0
0THEN Assign(elems[current].sourceName, name, voidO)
0ELSE Assign ('', name, voidO); END;
.END|
$ELSE
$END;
$RETURN but # Snquit
"END ScanBox;
 
 PROCEDURE RequestArg (VAR name: ARRAY OF CHAR);
 
"BEGIN
$SetTextString (argBox, Aedit, name);
$DoSimpleBox (argBox, Rect (0, 0, 50, 30), voidC);
$GetTextString (argBox, Aedit, name);
"END RequestArg;
 
 TYPE    TellMode        = (initTell, newTellValue, endTell);
 
 PROCEDURE TellLoading (mode: TellMode; REF fname: ARRAY OF CHAR);
 
"VAR     start   : Rectangle;
"
"BEGIN
$start := Rect (0, 0, 50, 30);
$
$CASE mode OF
&initTell            : SetTextString (loadBox, Lfname, '');
<PrepareBox (loadBox, start, tellSpace);
<ShowBee|
<
&newTellValue        : SetTextString (loadBox, Lfname, '            ');
<drawObject (loadBox, Lfname);
<SetTextString (loadBox, Lfname, FileName (fname));
<drawObject (loadBox, Lfname)|
<
&endTell             : ReleaseBox (loadBox, start, tellSpace);
<ShowArrow|
$END;
"END TellLoading;
 
"
 
8(*  misc. II  *)
8(*  ========  *)
 
 PROCEDURE enableAndDisableMenuItems;
 
"VAR   workSelected: BOOLEAN;
 
"BEGIN
$EnableItem (menu, Mwnew, WorkField.noUsed < maxWorkFiles);
$workSelected := (WorkField.current # noCurrentWorkfile);
$EnableItem (menu, Mwdelete, workSelected);
$EnableItem (menu, Mwchange, workSelected);
$EnableItem (menu, Mdeditwo, workSelected);
$EnableItem (menu, Mdcompwo, workSelected);
$EnableItem (menu, Mdexecwo, workSelected);
$EnableItem (menu, Mdlinkwo, workSelected);
$EnableItem (menu, Mdscanwo, workSelected);
"END enableAndDisableMenuItems;
 
 
0(*  Arbeitende Routinen  *)
0(*  ===================  *)
 
 FORWARD HideSS (complete: BOOLEAN);
 FORWARD ShowSS (isCompleteHidden: BOOLEAN);
 
 
 (*  setWorkfileName -- Assigns the specified workfile a new name.
!*)
 
 PROCEDURE setWorkfileName (idx: CARDINAL; VAR name: ARRAY OF CHAR);
 
"BEGIN
$Upper (name);
$WITH WorkField.elems[idx]
$DO
&Assign (name, sourceName, voidO);
&codeName := '';
$END;
$
$setWorkfiles;
"END setWorkfileName;
"
"
 (*  selectWorkfile -- Selects another work file object. Only used slots would
!*                    be selected.
!*)
!
 PROCEDURE selectWorkfile (i: INTEGER);
 
"BEGIN
$WITH WorkField DO
$
&(*  Remove check mark at old curr. work file.
'*)
&IF WorkField.current # noCurrentWorkfile
&THEN
(CheckItem (menu, elems[current].index, FALSE);
&END;
&
&(*  Set new work file, if it is used.
'*)
&IF ~ WorkField.elems[i].used THEN i := noCurrentWorkfile END;
&WorkField.current := i;
&
&(*  Set check mark at new curr. work file.
'*)
&IF WorkField.current # noCurrentWorkfile
&THEN
(CheckItem (menu, elems[current].index, TRUE);
&END;
$
$END;(*WITH*)
"END selectWorkfile;
 
 (*  makeNewWorkfile -- Tries to make another work file object.
!*)
!
 PROCEDURE makeNewWorkfile;
 
"VAR   i    : CARDINAL;
(str  : FileStr;
(ok   : BOOLEAN;
(
"BEGIN
$animateMenuTitle (Mworkfil, voidFrame);
$
$(*  find free slot.
%*)
$(* wir wollen mit Nr. 1 anfangen, erst nach Nr. 9 soll Nr. 0 kommen *)
$i := 1;
$WHILE (i <= maxWorkFiles) AND WorkField.elems[i MOD 10].used DO INC (i) END;
$IF i = 10 THEN i:= 0 END;
$
$IF i < maxWorkFiles THEN    (*  if found, then init. slot  *)
$
&str := '';
&SelectFile (newWorkTitle^, str, ok);
&
&IF ok THEN
&
(SearchFile (str, SrcPaths, fromStart, voidO, str);
(INC (WorkField.noUsed);
(WorkField.elems[i].used := TRUE;
(setWorkfileName (i, str);
(selectWorkfile (i);
(
&END;
&
$ELSE
&doAlert (noNewWorkAlt)
$END;
$
$deAnimateMenuTitle (Mworkfil);
"END makeNewWorkfile;
 
 (*  killWorkfile -- Releases the current workfile object.
!*)
 
 PROCEDURE killWorkfile;
 
"BEGIN
$animateMenuTitle (Mworkfil, voidFrame);
$
$WITH WorkField DO
&IF current # noCurrentWorkfile THEN
&
(DEC (noUsed);
(elems[current].used := FALSE;
(elems[current].sourceName := '';
(current := noCurrentWorkfile;
(setWorkfiles;                   (*  Correct menu tree  *)
(
&END;
$END;
&
$deAnimateMenuTitle (Mworkfil);
"END killWorkfile;
#
 PROCEDURE saveParameter;
 
"VAR   but: CARDINAL;
 
"BEGIN
$FormAlert (1, parmSaveAlt^, but);
$IF but = 1 THEN SaveParameter END;
"END saveParameter;
 
 (*  actManager -- Prepares the shell to execute a shell action and then calls
!*                the 'action' procedure in the outer module.
!*
!*                'obj'       -- Desktop object associated with the desired
!*                               action.
!*                'specials'  -- Special keys pressed at action selection time.
!*                'work'      -- Parameter of the action is a work file?
!*                'tool'      -- Is a executed file a tool? (to set the correct
!*                               path in 'call')
!*                'alsoExec'  -- Also excecute code after compilation?
!*                'noSelect'  -- Don't call file slector box.
!*)
"
 PROCEDURE actManager (obj     : CARDINAL;
6specials: SpecialKeySet;
5 work,
6tool,
6alsoExec,
6noSelect: BOOLEAN);
 
"PROCEDURE assignMsg (VAR name: ARRAY OF CHAR);
"
$BEGIN
&truncCopyString (name, msgStrLen, msgStr);
$END assignMsg;
$
"PROCEDURE setSourceCurrFnAndMsg;
"
$BEGIN
$
&IF ~ work AND Empty (currFn)THEN
(currFn := lastFn;
&END;
&
&IF work THEN
(WITH WorkField DO
*IF current >= 0 THEN assignMsg (elems[current].sourceName)
*ELSE msgStr := '' END;
(END;
&ELSE assignMsg (currFn) END;
&
$END setSourceCurrFnAndMsg;
$
"PROCEDURE setCodeCurrFnAndMsg;
"
$BEGIN
$
&IF ~ work AND Empty (currFn) THEN
(currFn := CodeName;
&END;
&
&IF work THEN
(WITH WorkField DO
*IF current # noCurrentWorkfile THEN
,assignMsg (elems[current].codeName)
*ELSE msgStr := '' END;
(END;
&ELSE assignMsg (currFn) END;
&
$END setCodeCurrFnAndMsg;
"
"TYPE  testProc        = PROCEDURE (REF (* name: *) ARRAY OF CHAR): BOOLEAN;
$
"PROCEDURE testWorkAndCurrFn ((*$Z-*)test: testProc(*$Z=*)): BOOLEAN;
"
$BEGIN
&WITH WorkField DO
(IF work AND (current = noCurrentWorkfile) THEN RETURN FALSE
(ELSE
*RETURN (work AND test (elems[current].sourceName)) OR test (currFn)
(END;
&END;
$END testWorkAndCurrFn;
"
"
"VAR ok: BOOLEAN;
"
"PROCEDURE ifNotWorkThenSelectFile (title: PtrMaxStr; source: BOOLEAN);
"
$BEGIN
&ok := TRUE;
&IF NOT work AND NOT noSelect
&THEN
(IF source THEN currFn := lastFn ELSE currFn := CodeName END;
(SelectFile (title^, currFn, ok);
&END;
$END ifNotWorkThenSelectFile;
$
$
"BEGIN
$CASE obj OF
&Compile  : IF alsoExec THEN ifNotWorkThenSelectFile (compExecTitle, TRUE);
1ELSE ifNotWorkThenSelectFile (compileTitle, TRUE) END;
1IF NOT ok THEN RETURN END;
1setSourceCurrFnAndMsg;
1IF testWorkAndCurrFn (isMakeFile) THEN
3IF alsoExec THEN action (doMkEx, work, tool)
3ELSE action (doMake, work, tool) END;
1ELSE
3IF alsoExec THEN action (doCpEx, work, tool)
3ELSE action (doComp, work, tool) END;
1END|
&Edit     : ifNotWorkThenSelectFile (editTitle, TRUE);
1IF NOT ok THEN RETURN END;
1setSourceCurrFnAndMsg; action (doEdit, work, tool)|
&Execute  : ifNotWorkThenSelectFile (executeTitle, FALSE);
1IF NOT ok THEN RETURN END;
1setCodeCurrFnAndMsg;
1Assign (lastFn, TextName, voidO);
1IF NOT work AND IsSourceName (currFn) THEN
3assignMsg (currFn);
3action (doExec, work, tool);
1ELSE
3IF testWorkAndCurrFn (IsMBTFile)    (*  exec. Batch-File  *) THEN
5action (doBtch, work, tool);
3ELSIF testWorkAndCurrFn (isMSPFile) (*  exec. Parm.-File  *) THEN
5action (doParm, work, tool);
3ELSIF testWorkAndCurrFn (isMakeFile)(*  exec. Make-File  *) THEN
5action (doMkEx, work, tool);
3ELSE                                (*  exec. norm. code  *)
5IF withShift (specials) THEN
7RequestArg (lastArgs);
7args := lastArgs;
5ELSE
7args := '';
5END;
5noDirChange := withAlt (specials);
5action (doExec, work, tool);
5noDirChange := FALSE;
3END;
1END;
1Assign (TextName, lastFn, voidO)|
&Link     : ifNotWorkThenSelectFile (linkTitle, FALSE);
1IF NOT ok THEN RETURN END;
1setCodeCurrFnAndMsg; action (doLink, work, tool)|
&
&Scan     : ifNotWorkThenSelectFile (scanTitle, TRUE);
1IF NOT ok THEN RETURN END;
1setSourceCurrFnAndMsg;
1IF (ChainDepth < 0) OR ~ withShift (specials)
1THEN
3IF doScanBox () THEN
5action (doScan, work, tool);
3END;
1ELSE msgStr := ''; action (doCont, TRUE, tool) END|
 (*
&Resident : setCodeCurrFnAndMsg;
1HideSS (FALSE);
1TellLoading (initTell, '');
1action (doLoad, FALSE, tool);
1TellLoading (endTell, '');
1ShowSS (FALSE)|
 *)
$ELSE
$END;
"END actManager;
9
 PROCEDURE executeTool (i: CARDINAL; specials: SpecialKeySet);
 
"VAR   code: FileStr;
 
"BEGIN
$IF ToolField[i].used AND NOT Empty (ToolField[i].name) THEN
&currFn := ToolField[i].name;
&code := CodeName;           (* Akt. Code-Datei retten *)
&actManager (Execute, specials, FALSE, TRUE, FALSE, TRUE);
&CodeName := code;           (* Akt. Code-Datei wiederherstellen *)
$END;
"END executeTool;
 
 PROCEDURE editDocu (specials: SpecialKeySet);
 
"VAR   oldText, oldLast: FileStr;
"
"BEGIN
$animateMenuTitle (Mparms, voidFrame);
$
$ConcatName (shellParm.parameterPath, suf[m2d], currFn);
$oldText := TextName;
$oldLast := lastFn;
$actManager (Edit, specials, FALSE, FALSE, FALSE, TRUE);
$TextName := oldText;
$lastFn := oldLast;
$
$deAnimateMenuTitle (Mparms);
"END editDocu;
 
 PROCEDURE makeFolder;
 
"VAR   ok     : BOOLEAN;
(name   : FileStr;
(result : INTEGER;
 
"BEGIN
$name:= '';
$SelectFile (folderTitle^, name, ok);
$IF ok & NOT Empty (FileName (name)) THEN
&CreateDir (name, result); FileAlert (result);
$END;
"END makeFolder;
 
 PROCEDURE deleteFile;
 
"VAR   ok     : BOOLEAN;
(name   : FileStr;
(result : INTEGER;
 
"BEGIN
$name:= '';
$SelectFile (deleteTitle^, name, ok);
$IF ok & NOT Empty (FileName (name)) THEN
&Directory.Delete (name, result); FileAlert (result);
$END;
"END deleteFile;
 
 
0(*  Routinen zur De-/Aktivierung der ShellShell  *)
0(*  ===========================================  *)
"
 PROCEDURE ClearDeskAndShowMsg;
 
"BEGIN
$MenuBar (NIL, FALSE);
$IF NOT multiGEM & NOT multiTOS THEN
&(* unter MultiGEM nichts in Menleise zeichnen *)
&DrawObject (msgBar, Root, MaxDepth, ObjectSpaceWithAttrs (msgBar, Root));
$END;
$FormDial (freeForm, Rect (0, 0, 0, 0), deskSize);
"END ClearDeskAndShowMsg;
 
 PROCEDURE ShowSS (isCompleteHidden: BOOLEAN);
 
"VAR   i   : INTEGER;
(name: NameStr;
 
"BEGIN
$IF isCompleteHidden THEN
$
&SetCurrGemHandle (gemHdl, ok);
&IF ~ ok THEN HALT; TermProcess (-1) END;
&
&setTools;
&setWorkfiles;
&MouseInput (TRUE);
&
&ShowArrow;
&IF ~multiTOS THEN SetNewDesk (NIL, Root); END;
&MenuBar (menu, TRUE);
&
&FormDial (freeForm, Rect (0, 0, 0, 0), deskSize);
&
$END;
"END ShowSS;
"
 
 PROCEDURE InitSS (): BOOLEAN;
 
"VAR     mayLoad, success : BOOLEAN;
*devParm : PtrDevParm;
*space, f: Rectangle;
*x, w    : INTEGER;
*eventmsg: MessageBuffer;
*mouseloc: Point;
*buttons: MButtonSet;
*keystate: SpecialKeySet;
*key: GemChar;
*clicks: CARDINAL;
*events: EventSet;
 
"BEGIN
$IF MemAvail () < minNecessaryMem THEN RETURN FALSE END;
$
$InitGem (RC,dev, success);
$IF ~ success THEN
&IF GemActive () THEN
(multiStringAlert (noGemAlt1,noGemAlt2, voidC);
&END;
&RETURN FALSE
$ELSE
&gemHdl:=CurrGemHandle ();
$END;
$ShellPath:= HomePath;
$
$GEMBase.GetPBs (gemHdl, vdiPB, aesPB);
$multiGEM:= aesPB.pglobal^.count > 1;
$multiTOS:= aesPB.pglobal^.count = -1;
$
$deskSize := DeskSize ();
$CharSize (dev, charWidth, charHeight);
$
2(*  Resource laden und Baumadressen ermitteln  *)
2
$LoadResource (resourceFile);
$IF GemError () THEN
&multiStringAlert (noRscAlt1,noRscAlt2, voidC);
&ExitGem (gemHdl);
&TermProcess (0)
$END;
$
$menu          := TreeAddress (Menu);
$msgBar        := TreeAddress (Msgbar);
$scanBox       := TreeAddress (Scanbox);
$shellBox      := TreeAddress (Shellbox);
$optBox        := TreeAddress (Optbox);
$sNameBox      := TreeAddress (Snamebox);
$argBox        := TreeAddress (Argbox);
$linkBox       := TreeAddress (Loptbox);
$loadBox       := TreeAddress (Loadbox);
$shellParmBox  := TreeAddress (Sparmbox);
$editorParmBox := TreeAddress (Eparmbox);
$helpBox       := TreeAddress (Helpbox);
$infoBox       := TreeAddress (Infobox);
$
$pathToLongAlt := TextStringAddress (Pathalt);
$cOptToLongAlt := TextStringAddress (Optalt);
$memFullAlt    := TextStringAddress (Memalt);
$debugAlt      := TextStringAddress (Debugalt);
$parmSaveAlt   := TextStringAddress (Parmsalt);
$noParmAlt     := TextStringAddress (Noparalt);
$ContMakeAlt   := TextStringAddress (Contmalt);
$noNewWorkAlt  := TextStringAddress (Nowrkalt);
$exitShellAlt  := TextStringAddress (Exitalt);
$noHelpAlt     := TextStringAddress (Nohlpalt);
$
$NoLoadStr     := TextStringAddress (Noldstr);
$OkStr         := TextStringAddress (Okstr);
$EditStr       := TextStringAddress (Editstr);
$EditBatStr    := TextStringAddress (Editbstr);
$NoPathsStr    := TextStringAddress (Npathstr);
$NoUnloadStr   := TextStringAddress (Nouldstr);
$NoExecStr     := TextStringAddress (Noexestr);
$RetStr        := TextStringAddress (Retstr);
$EdStr         := TextStringAddress (Edstr);
$WorkStr       := TextStringAddress (Workstr);
$CompStr       := TextStringAddress (Compstr);
$LinkStr       := TextStringAddress (Linkstr);
$InfStr        := TextStringAddress (Infstr);
$ContStr       := TextStringAddress (Contstr);
$MakeStr       := TextStringAddress (Makestr);
$
$changeWorkTitle := TextStringAddress (Chworkti);
$newWorkTitle    := TextStringAddress (Neworkti);
$editTitle       := TextStringAddress (Editti);
$compileTitle    := TextStringAddress (Compti);
$executeTitle    := TextStringAddress (Execti);
$compExecTitle   := TextStringAddress (Coexti);
$linkTitle       := TextStringAddress (Linkti);
$scanTitle       := TextStringAddress (Scanti);
$folderTitle     := TextStringAddress (Foldti);
$deleteTitle     := TextStringAddress (Deleti);
$
$
2(*  'msgBar'-Ausmae der Gre
3*   des Ausgabegerts anpassen
3*)
"
$devParm := DeviceParameter (dev);
$
$space.x := 0;
$space.y := 0;
$space.w := devParm^.rasterWidth + 1;
$space.h := deskSize.y-1;
$SetCurrObjTree (msgBar, FALSE);
$SetObjSpace (Root, space);
$SetObjSpace (Mbmsg, space);
$
$LinkTextString (Mbmsg, ADR (msgStr));
*
2(* Indizies ermitteln *)
2
$linkBoxIdx[1].check := Locheck1;
$linkBoxIdx[1].path  := Lofname1;
$linkBoxIdx[2].check := Locheck2;
$linkBoxIdx[2].path  := Lofname2;
$linkBoxIdx[3].check := Locheck3;
$linkBoxIdx[3].path  := Lofname3;
$linkBoxIdx[4].check := Locheck4;
$linkBoxIdx[4].path  := Lofname4;
$linkBoxIdx[5].check := Locheck5;
$linkBoxIdx[5].path  := Lofname5;
$linkBoxIdx[6].check := Locheck6;
$linkBoxIdx[6].path  := Lofname6;
$linkBoxIdx[7].check := Locheck7;
$linkBoxIdx[7].path  := Lofname7;
$linkBoxIdx[8].check := Locheck8;
$linkBoxIdx[8].path  := Lofname8;
$
$InitWorkFieldMenuIndizies;
$SetCurrObjTree (menu, FALSE);
$f := ObjectSpace (Wibox);
$WorkField.baseHeightOfWibox := f.h;
$f := ObjectSpace (Mwwork0);
$DEC (WorkField.baseHeightOfWibox, f.h * 10);
$
$SetTextString (shellBox, Version, ShellRevision);
$
$
2(*  Initalisiere 'Tools'-Indizies  *)
2
$ToolField[1].index := Mtool1;
$ToolField[2].index := Mtool2;
$ToolField[3].index := Mtool3;
$ToolField[4].index := Mtool4;
$ToolField[5].index := Mtool5;
$ToolField[6].index := Mtool6;
$ToolField[7].index := Mtool7;
$ToolField[8].index := Mtool8;
$ToolField[9].index := Mtool9;
$ToolField[10].index := Mtool10;
$
$TemporaryPath:= ShellPath;
$
$(*
%* Prfen, ob ESC gedrckt wurde, weil dann beim Batch-Ausfhren keine
%* Module geladen werden sollen.
%*)
$mayLoad:= TRUE;
$MultiEvent (EventSet {keyboard, timer}, 0, MButtonSet{}, MButtonSet{},
0lookForEntry, Rect (0,0,0,0), lookForEntry, Rect (0,0,0,0),
0eventmsg, 0, mouseloc, buttons, keystate, key, clicks, events);
$IF keyboard IN events THEN
&mayLoad:= key.ascii # 33C; (* ESC-Code *)
$END;
$LoadParameter (shellParm.parameterPath, mayLoad);
$
$ShowSS (TRUE);
$
$RETURN TRUE;
"END InitSS;
 
 PROCEDURE HideSS (complete: BOOLEAN);
 
"BEGIN
$IF complete THEN ClearDeskAndShowMsg END;
$ShowBee;
"END HideSS;
 
 PROCEDURE ExitSS;
 
"BEGIN
$msgStr := '';
$HideSS (TRUE);
$
$FreeResource;
$(* ExitGem (gemHdl); *)
"END ExitSS;
 
*
0(*  Routinen zur Event-Verarbeitung  *)
0(*  ===============================  *)
 
 (*  keyManager -- Bearbeitet alle keyboard events
!*)
 
 (*$Z-*)
 PROCEDURE keyManager (VAR ch: GemChar; VAR specials: SpecialKeySet): BOOLEAN;
 (*$Z=*)
 
"CONST   aCode   = BYTE (30);    (*  Buchstabentasten  *)
*cCode   = BYTE (46);
*eCode   = BYTE (18);
*fCode   = BYTE (33);
*iCode   = BYTE (23);
*lCode   = BYTE (38);
*nCode   = BYTE (49);
*mCode   = BYTE (50);
*oCode   = BYTE (24);
*pCode   = BYTE (25);
*qCode   = BYTE (16);
*rCode   = BYTE (19);
*sCode   = BYTE (31);
*uCode   = BYTE (22);
*xCode   = BYTE (45);
*
*code1A  = BYTE (2);     (*  Ziffern  *)
*code0A  = BYTE (11);
*code7N  = BYTE (103);
*code0N  = BYTE (112);
*
*plusCode= BYTE (27);    (*  <+>  *)
*
*clrHome = BYTE (71);    (*  <Clr>-Taste  *)
*delete  = BYTE (83);    (*  <Delete>-Taste  *)
*help    = BYTE (98);    (*  <Help>-Taste  *)
*escape  = BYTE (1);     (*  <Esc>-Taste  *)
*f1      = BYTE (59);    (*  <F1>  *)
*f10     = BYTE (68);    (*  <F10>  *)
*shiftF1 = BYTE (84);    (*  Shift + <F1>  *)
*shiftF10= BYTE (93);    (*  Shift + <F10>  *)
"
"VAR     buts    : MButtonSet;
*loc     : Point;
*
*success : BOOLEAN;
*msg     : String;
*
$PROCEDURE withoutCtrl () :BOOLEAN;
$BEGIN
&RETURN ~ (controlKey IN specials)
$END withoutCtrl;
"
"BEGIN
"
$CASE ch.scan OF
$
&(*  Commands  *)
&
&aCode    : actManager (Execute, specials, withoutCtrl (), FALSE, FALSE,
=FALSE)|
&cCode    : IF withAlt (specials) THEN doCompilerOptionBox
1ELSE 
3actManager (Compile, specials, withoutCtrl (), FALSE, FALSE,
?FALSE)
1END|
&eCode    : IF withAlt (specials) THEN doEditorParameterBox
1ELSE 
3actManager (Edit, specials, withoutCtrl (), FALSE, FALSE,
?FALSE)
1END|
&lCode    : IF withAlt (specials) THEN doLinkerOptionBox
1ELSE 
3actManager (Link, specials, withoutCtrl (), FALSE, FALSE,
?FALSE)
1END|
&sCode    : actManager (Scan, specials, withoutCtrl (), FALSE, FALSE,
=FALSE)|
&(*
&rCode    : actManager (Resident, specials, withoutCtrl (), FALSE, FALSE,
=FALSE)|
'*)
&plusCode : actManager (Compile, specials, withoutCtrl (), FALSE, TRUE,
=FALSE)|
&
&oCode    : makeFolder|
&
&pCode    : IF NOT withCtrl (specials)
1AND (WorkField.current # noCurrentWorkfile) THEN
3doChangeWork (WorkField.current);
1END|
&
&mCode    : Concat ('Making: ', MakeFileName, msg, voidO);
1truncCopyString (msg, msgStrLen, msgStr);
1action (doDftM, FALSE, FALSE)|
 
&(*  Menu: Datei  *)
&
&nCode    : makeNewWorkfile|
&delete   : killWorkfile|
&qCode    : IF withCtrl (specials) THEN quitStatus := quickQuit
1ELSE quitStatus := quit END|
&
&(*  Menu: Parameter / Info *)
&
&xCode    : IF withCtrl (specials) THEN saveParameter
1ELSE doShellParameterBox END|
&uCode    : doInfoBox|
&help     : IF withShift (specials) THEN editDocu (specials)
1ELSE doHelpBox (helpFile) END|
&
&(*  Menu: Tools  *)
&
&f1..f10  : executeTool (ORD (ch.scan) - ORD (f1) + 1, specials)|
&shiftF1..shiftF10
/: INCL (specials, leftShiftKey);
1executeTool (ORD (ch.scan) - ORD (shiftF1) + 1, specials)|
&
&(*  work files  *)
&
&code1A..code0A,
&code7N..code0N
/: selectWorkfile (ORD (ch.ascii) - ORD ('0'))|
1
$ELSE RETURN TRUE END;
$
$RETURN FALSE;
"END keyManager;
 
 (*  menuManager -- Bearbeitet alle message events, die durch Anklicken der
!*                 Menuzeile entstehen.
!*)
!
 (*$Z-*)
 PROCEDURE menuManager (title, item: CARDINAL): BOOLEAN;
 (*$Z=*)
"
"VAR     i       : CARDINAL;
*buts    : MButtonSet;
*specials: SpecialKeySet;
*loc     : Point;
*start   : Rectangle;
#
"BEGIN
$MouseKeyState (loc,buts,specials);
$CASE item OF
&
&(*  MShell  *)
%
&Dinfo     : animateMenuTitle (Mshell, start);
2DoSimpleBox (shellBox, start, voidC);
2deAnimateMenuTitle (Mshell)|
&
&(*  Datei  *)
&
&Mdfolder  : makeFolder|
&Mddelete  : deleteFile|
&Mdquit    : quitStatus := quit|
&
&(*  Bearbeiten  *)
&
&Mdeditwo  : actManager (Edit, specials, TRUE, FALSE, FALSE, FALSE)|
&Mdcompwo  : actManager (Compile, specials, TRUE, FALSE, FALSE, FALSE)|
&Mdexecwo  : actManager (Execute, specials, TRUE, FALSE, FALSE, FALSE)|
&Mdlinkwo  : actManager (Link, specials, TRUE, FALSE, FALSE, FALSE)|
&Mdscanwo  : actManager (Scan, specials, TRUE, FALSE, FALSE, FALSE)|
&Mdeditot  : actManager (Edit, specials, FALSE, FALSE, FALSE, FALSE)|
&Mdcompot  : actManager (Compile, specials, FALSE, FALSE, FALSE, FALSE)|
&Mdexecot  : actManager (Execute, specials, FALSE, FALSE, FALSE, FALSE)|
&Mdlinkot  : actManager (Link, specials, FALSE, FALSE, FALSE, FALSE)|
&Mdscanot  : actManager (Scan, specials, FALSE, FALSE, FALSE, FALSE)|
&
&(*  Arbeitsdatei  *)
&
&Mwnew     : makeNewWorkfile|
&Mwdelete  : killWorkfile|
&Mwchange  : IF WorkField.current # noCurrentWorkfile THEN
4doChangeWork (WorkField.current);
2END|
&Mwwork0   : selectWorkfile (0)|
&Mwwork1   : selectWorkfile (1)|
&Mwwork2   : selectWorkfile (2)|
&Mwwork3   : selectWorkfile (3)|
&Mwwork4   : selectWorkfile (4)|
&Mwwork5   : selectWorkfile (5)|
&Mwwork6   : selectWorkfile (6)|
&Mwwork7   : selectWorkfile (7)|
&Mwwork8   : selectWorkfile (8)|
&Mwwork9   : selectWorkfile (9)|
&
&(*  Parameter / Info *)
&
&Mpshell   : doShellParameterBox|
&Mpeditor  : doEditorParameterBox|
&Mpcomp    : doCompilerOptionBox|
&Mplink    : doLinkerOptionBox|
&Mpsave    : saveParameter|
&Mienv     : doInfoBox|
&Mihelp    : doHelpBox (helpFile)|
&Midocu    : editDocu (specials)|
&
$ELSE
&
&(*  Tools  *)
$
&FOR i := 1 TO MaxTool DO
(IF item = ToolField[i].index THEN executeTool (i, specials) END
&END;
&
$END;
$
$NormalTitle (menu,title, TRUE);
$
$RETURN FALSE;
"END menuManager;
 
 PROCEDURE TalkWithUser;
 
"VAR     worker  : ARRAY [1..2] OF EventProc;
*
*success : BOOLEAN;
*
*firstA3,
*newA3   : LONGCARD;
*
*button  : CARDINAL;
"
"BEGIN
$enableAndDisableMenuItems;
"
$worker[1].event := keyboard;
$worker[1].keyHdler := keyManager;
$worker[2].event := message;
$worker[2].msgType := menuSelected;
$worker[2].menuHdler := menuManager;
 
$STORE (11, firstA3);
"
$REPEAT
"
&HandleEvents (0, MButtonSet{}, MButtonSet{},
4lookForEntry, Rect (0,0,0,0),
4lookForEntry, Rect (0,0,0,0),
40L,
4worker, 0);
"
&STORE (11, newA3);
&IF newA3 # firstA3 THEN
(LOAD (firstA3, 11);
(FormAlert (1, '[1][Heap fault][ OK ]', voidC);
&END;
&
&enableAndDisableMenuItems;
"
&currFn := '';         (* Damit 'lastFn' zum Zuge kommen kann *)
&
&(*  handle a quit shell request
'*)
&IF quitStatus = quit THEN
(FormAlert (1, exitShellAlt^, button);
(IF button = 3 THEN quitStatus := noQuit
(ELSIF button = 1 THEN SaveParameter END;
&END;
$
$UNTIL quitStatus # noQuit;
"END TalkWithUser;
 
 (*$Z-*) 
 PROCEDURE hdlTrap5 (VAR desc: ExcDesc): BOOLEAN;
 (*$Z=*)
"BEGIN
$doAlert (debugAlt);   (*  Fehlermeldung  *)
$TermProcess (0);      (*  und ab damit  *)
$RETURN FALSE          (* Nur um des Compilers Willen  *)
"END hdlTrap5;
 
 
 VAR     i       : CARDINAL;
(hdl     : ADDRESS;
(wsp     : MemArea;
 
 BEGIN (* ShellShell *)
 
"(*  Vom Modula-System und der Shell benutzte Suffices:
#*)
"suf[prg] := 'PRG';
"suf[app] := 'APP';
"suf[tos] := 'TOS';
"suf[ttp] := 'TTP';
"suf[m2p] := 'M2P';
"suf[m2b] := 'M2B';
"suf[m2m] := 'M2M';
"suf[m2d] := 'M2D';
"(*
#* Die folgenden Endungen knnen verndert werden:
#* (Shell dann neu linken und alle Dateien mit den neuen Endungen
#* versehen - auch diejenigen in der Library "MM2DEF.M2L"!)
#*)
"suf[mod] := 'MOD';   (* Object-Files, GEM-Application *)
"suf[mos] := 'MOS';   (* Object-Files, TOS-Application *)
"suf[mtp] := 'MTP';   (* Object-Files, TTP-Application *)
"suf[imp] := 'IMP';   (* Object-Files bei Implementationsmodulen *)
"suf[def] := 'DEF';   (* Symbol-Files (bersetzte Definitionsmodule *)
"DefSrcSfx:= 'D';     (* ModRef: Definitions-Texte *)
"ImpSrcSfx:= 'I';     (* ModRef: Implementations-Texte *)
"ModSrcSfx:= 'M';     (* ModRef: Hauptmodul-Texte *)
 
"(* Fr Compiler: Suffices fr erzeugte Dateien *)
"DefSfx:= suf[def];   (* Extension f. Symboldatei-Codes *)
"ImpSfx:= suf[imp];   (* Extension f. Implementations-Codes *)
"ModSfx:= suf[mod];   (* Extension f. Hauptmodul-Codes *)
 
"(* Suffices fr Loader (CallModule, LoadModule) *)
"MOSConfig.DftSfx:= suf[mod]; (* Default-Endung bei 'CallModule' *)
"MOSConfig.ImpSfx:= suf[imp]; (* Endung der importierten Module *)
 
"(*  some box info vars
#*)
"LastCodeName := '';
"LastCodeSize := 0L;
 
"(*  default configuration
#*)
 
"MakeFileName := '';
 
"WITH shellParm DO
$breakActive := TRUE;
$batchPath := batchFile;
$
$ShellRead (ShellName, args); (* Liest Pfad/Name der Shell und Argumentzeile *)
$IF args [0] # 0C THEN
&(* M2P-Dateiname wurde in Argumentzeile bergeben *)
&Assign (args, parameterPath, voidO)
$ELSE
&(* M2P-Dateiname wird aus Shell-Pfad u. "MM2SHELL.M2P" zusammengesetzt *)
&ConcatPath (ShellName, parameterFile, parameterPath)
$END;
$ConcatName (parameterPath, suf[m2p], parameterPath);
$MakeFullPath (parameterPath, voidI);
$
$waitOnReturn := FALSE;
"END;
"
"(*  no work file.
#*)
"FOR i := 0 TO maxWorkFiles - 1 DO WorkField.elems[i].used := FALSE END;
"WorkField.noUsed := 0;
"WorkField.current := noCurrentWorkfile;
"
"WITH EditorParm DO
$name:= 'GME';
$searchSources := FALSE;
$waitOnError := FALSE;
$tempShellFile := FALSE;
$tempShellName := '';
$tempEditorFile := FALSE;
$tempEditorName := '';
$passArgument := TRUE;
$passName := TRUE;
$passErrorText := TRUE;
$passErrorPos := TRUE;
"END;
"
"ErrListFile := 'MODULA.ERR';
"MainOutputPath := '';
"WITH CompilerParm DO          (*  Compiler-Parameter:     *)
$name:= 'MM2Comp';
$shortMsgs := FALSE;         (*  - keine Kurzausgaben    *)
$protocol := FALSE;          (*  - kein Protokoll        *)
$protWidth := stdProtWidth;
$protName := '';
"END;
"
"WITH LinkerParm DO
$name := 'MM2Link';
$FOR i := MIN (LLRange) TO MAX (LLRange) DO
&linkList[i].valid := FALSE;
&linkList[i].name := '';
$END;
$optimize := fullOptimize; (*  - Vollstndige Optimierung  *)
$linkStackSize := 0;
$maxLinkMod := 100;
$fastLoad := TRUE;
$fastCode := TRUE;
$fastMemory:= TRUE;
$symbolFile:= FALSE;
$symbolArgs:= '';  (* optional: Argumente f. 'MM2LnkIO.OutputSymbols' *)
$outputName:= '';  (* optional: Name d. Ausgabedatei *)
"END;
"
"FOR i := 1 TO MaxTool DO ToolField[i].used := FALSE END;  (*  Keine Tools  *)
"
"msgStr := '';
"
"(* TRAP #5 belegen, um Fehlermeldung auszugeben, wenn in einem Modul $D+
#* verwendet wird, ohne 'Debug'-Modul importiert zu haben *)
"wsp.bottom := ADR (ExceptsStack);
"wsp.length := SIZE (ExceptsStack);
"InstallPreExc (ExcSet{TRAP5}, hdlTrap5, TRUE, wsp, hdl);
 
"quitStatus := noQuit;
 
 END ShellShell;
 
 
((***************************)
((* Hier endet 'ShellShell' *)
((***************************)
 
 
 CONST   mspFileMagic    = 10071898L + 02700000000L;    (*  ab 20: TinyShell  *)
(escKey          = 33C;
 
 TYPE    PtrStr = POINTER TO String;
(AutoCmd = (noCmd, scan, edit, compile, execute, comp_exec, exec_src,
3make_exec, dftMake, dftMake_exec, contMake);
 
 VAR  ready    : BOOLEAN;
%dummy    : INTEGER;
%handle   : INTEGER;
%strVal   : BOOLEAN;
%buttonNum: CARDINAL;
%editorsMakeCmd,
%autoCmd    : AutoCmd;
%shellStart,
%makeActive : BOOLEAN;
%callRes    : LoaderResults;
%callMsg    : String;
%exitCode   : INTEGER;
%voidO      : BOOLEAN;
%voidI      : INTEGER;
%voidC      : CARDINAL;
 
%withPost1, withPost2: BOOLEAN;
%postAmble1, postAmble2, postArgs1, postArgs2: String;
 
 
 PROCEDURE FileAlert (errNo: INTEGER);
 
"VAR     msg     : ARRAY[0..50] OF CHAR;
 
"BEGIN
$IF (errNo < fOK) AND (errNo # fDriveNotReady) AND (errNo # fWriteProtected)
$THEN
&GetStateMsg (errNo, msg);
&Concat ('[1][', msg, msg, voidO);
&Append ('][  OK  ]', msg, voidO);
&FormAlert (1, msg, voidC);
$END;
"END FileAlert;
 
 PROCEDURE SaveParameter;
 
"VAR   f      : File;
"
"PROCEDURE ioErr (): BOOLEAN;
"
$VAR ioRes: INTEGER;
"
$BEGIN
&ioRes := State (f);
&IF ioRes < fOK THEN
(ResetState (f);
(FileAlert (ioRes);
(Remove (f);
(ShowArrow;
&END;
&RETURN ioRes < fOK
$END ioErr;
$
"PROCEDURE wBlock (VAR data: ARRAY OF BYTE): BOOLEAN;
"
$BEGIN
&WriteBlock (f, data);
&RETURN ~ ioErr ()
$END wBlock;
"
"VAR   magic: LONGCARD;
(ok: BOOLEAN;
"BEGIN
$ShowBee;
$
$Create (f, HomeReplaced (shellParm.parameterPath), writeOnly, replaceOld);
$IF State (f) # fOK THEN FileAlert (State (f)); RETURN END;
$
$magic := mspFileMagic;
$LOOP (* Ist keine echte Schleife - lediglich f. einfacheres EXIT *)
&ok:= FALSE;
&IF ~ wBlock (magic) THEN EXIT END;
&IF ~ wBlock (shellParm) THEN EXIT END;
&IF ~ wBlock (WorkField) THEN EXIT END;
&IF ~ wBlock (lastFn) THEN EXIT END;
&IF ~ wBlock (CodeName) THEN EXIT END;
&IF ~ wBlock (EditorParm) THEN EXIT END;
&IF ~ wBlock (CompilerParm) THEN EXIT END;
&IF ~ wBlock (LinkerParm) THEN EXIT END;
&IF ~ wBlock (DefaultStackSize) THEN EXIT END;
&IF ~ wBlock (TemporaryPath) THEN EXIT END;
&IF ~ wBlock (MakeFileName) THEN EXIT END;
&IF ~ wBlock (DefLibName) THEN EXIT END;
&IF ~ wBlock (ErrListFile) THEN EXIT END;
&IF ~ wBlock (MainOutputPath) THEN EXIT END;
&IF ~ wBlock (CompilerArgs) THEN EXIT END;
&ok:= TRUE;
&EXIT
$END;
$IF NOT ok THEN RETURN END;
$
$Close (f);
$
$ShowArrow;
"END SaveParameter;
 
 PROCEDURE LoadParameter (REF name: ARRAY OF CHAR; loadInBatch: BOOLEAN);
 
"VAR   f      : File;
(fname  : FileStr;
 
"PROCEDURE ioErr (): BOOLEAN;
"
$VAR ioRes: INTEGER;
"
$BEGIN
&ioRes := State (f);
&IF ioRes < fOK THEN
(ResetState (f);
(FileAlert (ioRes);
(Close (f);
(ShowArrow;
&END;
&RETURN ioRes < fOK
$END ioErr;
$
"PROCEDURE rBlock (VAR data: ARRAY OF BYTE): BOOLEAN;
"
$BEGIN
&ReadBlock (f, data);
&RETURN ~ ioErr ()
$END rBlock;
 
"VAR   magic, n: LONGCARD;
(ch: CHAR;
(ok: BOOLEAN;
"
"BEGIN
$ShowBee;
$
$Assign (name, fname, voidO);
$ReplaceHome (fname);
$MakeFullPath (fname, voidI);
$Open (f, fname, readOnly);
$IF State (f) # fOK THEN FormAlert (1, noParmAlt^, voidC); RETURN END;
$
$IF ~ rBlock (magic) THEN RETURN END;
$IF magic = mspFileMagic THEN
&LOOP (* Ist keine echte Schleife - lediglich f. einfacheres EXIT *)
(ok:= FALSE;
(IF ~ rBlock (shellParm) THEN EXIT END;
(IF ~ rBlock (WorkField) THEN EXIT END;
(IF ~ rBlock (lastFn) THEN EXIT END;
(IF ~ rBlock (CodeName) THEN EXIT END;
(IF ~ rBlock (EditorParm) THEN EXIT END;
(IF ~ rBlock (CompilerParm) THEN EXIT END;
(IF ~ rBlock (LinkerParm) THEN EXIT END;
(IF ~ rBlock (DefaultStackSize) THEN EXIT END;
(IF ~ rBlock (TemporaryPath) THEN EXIT END;
(IF ~ rBlock (MakeFileName) THEN EXIT END;
(IF ~ rBlock (DefLibName) THEN EXIT END;
(IF ~ rBlock (ErrListFile) THEN EXIT END;
(IF ~ rBlock (MainOutputPath) THEN EXIT END;
(IF ~ rBlock (CompilerArgs) THEN EXIT END;
(ok:= TRUE;
(EXIT
&END;
&IF NOT ok THEN RETURN END;
 
&Assign (fname, shellParm.parameterPath, voidO);
 
$ELSE
&FormAlert (1, noParmAlt^, voidC)
$END;
$Close (f);
$
$InitWorkFieldMenuIndizies;
$
$(*  If a batch file is specified, execute it. *)
$IF NOT Empty (shellParm.batchPath) THEN
&ExecuteBatch (shellParm.batchPath, loadInBatch)
$END;
$
$ShowArrow;
"END LoadParameter;
 
 
 PROCEDURE PrepareScan;
 
"BEGIN
$ScanAddr := CallingChain [ScanIndex].relAddr;
$ScanOpts := CallingChain [ScanIndex].codeOpts;
$Assign (CallingChain [ScanIndex].sourceName, TextName, voidO);
"END PrepareScan;
 
 PROCEDURE readWorkNames;
 
"BEGIN
$WITH WorkField DO
&IF current >= 0 THEN
(workFName := elems[current].sourceName;
(workCName := elems[current].codeName;
&ELSE
(workFName := ''; workCName := '';
&END;
$END;
"END readWorkNames;
 
 PROCEDURE writeWorkName (REF source, code: ARRAY OF CHAR);
"VAR i : INTEGER;
"BEGIN (* richtige Arbeitsdatei suchen und Code speichern *)
$WITH WorkField DO
&IF current >= 0 THEN
(FOR i:= 0 TO maxWorkFiles-1 DO
*IF elems[i].used & StrEqual (source, elems[i].sourceName) THEN
,Assign (code, elems[i].codeName, voidO);
,RETURN
*END
(END
&END;
$END;
"END writeWorkName;
 
 PROCEDURE Bconout ( c: CHAR );
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVEQ   #0,D0
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #2,-(A7)
(MOVE    #3,-(A7)
(TRAP    #13
(ADDQ.L  #6,A7
$END
"END Bconout;
"(*$L=*)
 
 (*$Z-*)
 PROCEDURE Bconin (): CHAR;
 (*$Z=*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #2,-(A7)
(MOVE    #2,-(A7)
(TRAP    #13
(ADDQ.L  #4,A7
(MOVE.B  D0,(A3)+
(CLR.B   (A3)+
$END
"END Bconin;
"(*$L=*)
 
 (*$Z-*)
 PROCEDURE Bconstat (): BOOLEAN;
 (*$Z=*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #2,-(A7)
(MOVE    #1,-(A7)
(TRAP    #13
(ADDQ.L  #4,A7
(TST     D0
(SNE     D0
(ANDI    #1,D0
(MOVE.W  D0,(A3)+
$END
"END Bconstat;
"(*$L=*)
 
 PROCEDURE clrscr;
"BEGIN
$Bconout (33C); Bconout ('E');
"END clrscr;
 
 PROCEDURE curon;
"BEGIN
$Bconout (33C); Bconout ('e');
"END curon;
 
 PROCEDURE curoff;
"BEGIN
$Bconout (15C); Bconout (33C); Bconout ('f');
"END curoff;
 
 PROCEDURE bing;
"BEGIN
$Bconout (7C);
"END bing;
 
 
 PROCEDURE alert ( REF s1,s2,s3: ARRAY OF CHAR );
"VAR msg: ARRAY [0..269] OF CHAR;
"BEGIN
$Assign (s1, msg, voidO);
$WrapAlert (msg, 0);
$IF s2[0] # 0C THEN
&Append ('|', msg, strVal);
&Append (s2, msg, voidO);
&WrapAlert (msg, 0);
$END;
$Insert ('[0][',0,msg,strVal);
$Append ('][]',msg,strVal);
$Insert (s3,CARDINAL(Length(msg)-1),msg, voidO);
$FormAlert (1, msg,buttonNum);
"END alert;
"
 PROCEDURE load;
 
"VAR     r       : LoaderResults;
*msg     : ARRAY [0..79] OF CHAR;
*name    : FileStr;
"
"BEGIN
$IF Empty (currFn) THEN name := CodeName ELSE name := currFn END;
$TellLoading (newTellValue, name);
$LoadModule (name, StdPaths, name, msg, r);
$IF r # noError THEN alert (conc (name, NoLoadStr^), msg, OkStr^) END;
"END load;
 
 PROCEDURE unload;
 
"VAR     r       : LoaderResults;
*name    : FileStr;
"
"BEGIN
$IF Empty (currFn) THEN name := CodeName ELSE name := currFn END;
$UnLoadModule (name, r);
$IF r # noError THEN alert (conc (name, NoUnloadStr^), '', OkStr^) END;
"END unload;
 
 PROCEDURE closeAllWindows;
"VAR w: CARDINAL;
"BEGIN
$AESWindows.UpdateWindow (TRUE);
$LOOP
&w:= AESWindows.TopWindow ();
&IF w = 0 THEN EXIT END;
&AESWindows.CloseWindow (w);
&AESWindows.DeleteWindow (w);
$END;
$IF (GEMEnv.GEMVersion() >= $140) THEN
&(* UpdateWindow(FALSE) hier unntig - siehe ST-Magazin 3/91 Seite 92. *)
&AESWindows.ResetWindows ();
$ELSE
&AESWindows.UpdateWindow (FALSE);
$END;
"END closeAllWindows;
 
 VAR callSwitchedToTextMode: BOOLEAN;
 
 PROCEDURE call ( VAR modname: ARRAY OF CHAR; args: ARRAY OF CHAR;
1stackSize: LONGCARD; interactive, checkError, tool:BOOLEAN );
 
"TYPE SufSet = SET OF MySuf;
"
"VAR sufstr            : ARRAY[0..2] OF CHAR;
&dummy             : ARRAY[0..12] OF CHAR;
&name, path,
&oldPath           : PathStr;
&getparm           : BOOLEAN;
&prgType           : AESMisc.ProgramType;
&sufcnt, suffix    : MySuf;
&res               : INTEGER;
&dummyChar         : CHAR;
&hdl               : ADDRESS;
&prevStackSize     : LONGCARD;
 
"BEGIN
$Assign (modname, name, voidO);
$Upper (name);
 
$SplitPath (name, path, dummy);
$SplitName (dummy,dummy,sufstr);
$suffix:= mod;
$IF sufstr[0] = 0C THEN
&ConcatName (name, suf[mod], name)
$ELSE
&FOR sufcnt:= MIN (MySuf) TO MAX (MySuf) DO
(IF StrEqual (sufstr,suf[sufcnt]) THEN
*suffix := sufcnt;
(END
&END;
$END;
$prgType:= AESMisc.graphicPrgm;
$getparm:= FALSE;
$IF suffix IN SufSet {ttp,mtp} THEN getparm:= interactive END;
$IF suffix IN SufSet {ttp,mtp,tos,mos} THEN prgType:= AESMisc.textPrgm END;
 
$IF getparm THEN
&RequestArg (args);
$END;
 
$GetDefaultPath (oldPath);
$IF ~noDirChange THEN
&IF (path[0] = 0C) AND NOT tool THEN
((* Ist kein Pfad angegeben, bleibt bei Tools und
)* Systemprgs der akt. Pfad erhalten
)*)
(SearchFile (name, StdPaths, fromStart, voidO, name);
(SplitPath (name, path, dummy);
&END;
&ReplaceHome (path);
&SetDefaultPath (path, voidI)
$END;
 
$callSwitchedToTextMode := (prgType = AESMisc.textPrgm);
 
$(*$? UseExtKeys: IF NOT tool THEN DeInstallKbdEvents END; *)
$
$IF NOT multiGEM & NOT multiTOS THEN
&closeAllWindows; (* alle noch offenen Fenster (von ACCs) schlieen *)
$END;
 
$IF prgType = AESMisc.textPrgm THEN
&HideMouse;
&clrscr;
&curon;
$END;
$
$IF DoShellWrite AND (GEMEnv.GEMVersion() >= $140) THEN
&IF NOT multiTOS THEN
(AESMisc.ShellWrite (TRUE, prgType, name, args);
&END
$END;
 
$IF NOT multiGEM & NOT multiTOS THEN
&(* AC_CLOSE-Nachricht an alle Accessories schicken *)
&appl_exit; (* nach appl_exit kein AES-Aufruf mehr! *)
$END;
$
$prevStackSize:= DefaultStackSize;
$IF stackSize # 0 THEN DefaultStackSize:= stackSize END;
$CallModule (name, StdPaths, args, NIL, exitCode, callMsg, callRes);
$DefaultStackSize:= prevStackSize;
 
$IF NOT multiGEM & NOT multiTOS THEN
&(* beim GEM wieder anmelden *)
&appl_init;  (* erst jetzt wieder AES-Aufrufe erlaubt! *)
$END;
(
$IF DoShellWrite AND (GEMEnv.GEMVersion() >= $140) THEN
&IF NOT multiTOS THEN
((* Dies alles funktioniert erst ab TOS 1.4 richtig *)
(AESMisc.ShellWrite (FALSE, AESMisc.graphicPrgm, ShellName, '');
&END
$END;
$
$IF prgType = AESMisc.textPrgm THEN
&(* Nach Programmende bei TOS-Programmen auf Tastendruck warten *)
&IF interactive & shellParm.waitOnReturn
)& NOT ScanMode & (callRes = noError) THEN
(WHILE Bconstat () DO dummyChar:= Bconin () END;
(curon;
(dummyChar:= Bconin ()
&END;
&curoff;
&ShowMouse
$END;
 
$IF NOT multiGEM & NOT multiTOS THEN
&closeAllWindows; (* alle noch offenen Fenster (von ACCs) schlieen *)
$END;
 
$ClearDeskAndShowMsg;
$
$IF Inconsistent () THEN
&alert (memErrorAlt, '', OkStr^)
$END;
 
$(*$? UseExtKeys: IF NOT tool THEN InstallKbdEvents END; *)
 
$SetDefaultPath (oldPath, res);
 
$IF checkError THEN
&IF callRes # noError THEN
(IF callRes = exitFault THEN
*alert (callMsg, '', OkStr^)
(ELSE
*alert (conc (name, NoExecStr^), callMsg, OkStr^)
(END
&ELSIF ScanMode THEN
(PrepareScan;
(IF ScanBox (TextName) THEN
*autoCmd := scan
(ELSE
*autoCmd := noCmd
(END
&ELSIF exitCode # 0 THEN
(CASE exitCode OF
*fFileNotFound,
*fPathNotFound,
*fInvalidDrive: FormError (2)|
4(* "Diese Anwendung kann Datei oder Ordner nicht finden" *)
*fAccessDenied: FormError (5)|
6(* "Datei existiert bereits oder ist Schreibgeschtzt" *)
*fTooManyOpen,
*fInsufficientMemory: FormError (8)|
-(* "Es steht nicht genug Speicher fr diese Anw. zur Verfgung" *)
(ELSE
*alert (conc (RetStr^, IntToStr (exitCode, 0)), '', OkStr^)
(END
&END
$END;
$ScanMode := FALSE
"END call;
 
 
 PROCEDURE callEdit (VAR s0: ARRAY OF CHAR; errMsg: BOOLEAN);
 
"VAR s, voidStr,
&tempPath  : ARRAY [0..126] OF CHAR;
&f         : File;
&lastBreak : BOOLEAN;
&zero      : CARDINAL;
 
"PROCEDURE writeTempFile;
 
$PROCEDURE stateError (): BOOLEAN;
 
&BEGIN
(IF State (f) # fOK THEN
*FileAlert (State (f));
*ResetState (f);
*Remove (f);
*RETURN TRUE
(ELSE RETURN FALSE END;
&END stateError;
$
$PROCEDURE writeLn (VAR str: ARRAY OF CHAR): BOOLEAN;
$
&BEGIN
(Text.WriteString (f, str);
(IF stateError () THEN RETURN FALSE END;
(Text.WriteLn (f);
(IF stateError () THEN RETURN FALSE END;
(RETURN TRUE
&END writeLn;
$
$VAR s2: Str128;
&
$BEGIN
&ReplaceHome (tempPath);
&Create (f, tempPath, writeSeqTxt, replaceOld);
&IF stateError () THEN RETURN END;
&IF ~ EditorParm.passName THEN
(IF ~ writeLn (TextName) THEN RETURN END;
&END;
&IF ~ EditorParm.passErrorPos AND errMsg THEN
(Assign (CardToStr (TextLine, 0), s2, voidO);
(Append (' ', s2, voidO);
(Append (CardToStr (TextCol - 1, 0), s2, voidO);
(IF ~ writeLn (s2) THEN RETURN END;
&END;
&IF ~ EditorParm.passErrorText AND errMsg THEN
(IF ~ writeLn (ErrorMsg) THEN RETURN END;
&END;
&Close (f);
$END writeTempFile;
 
"BEGIN
$Split (s0, PosLen (' ', s0, 0), TextName, s, voidO);
$IF EditorParm.searchSources THEN
&SearchFile (TextName, SrcPaths, fromStart, voidO, TextName)
$END;
$IF EditorParm.passName THEN Insert (TextName, 0, s, voidO) END;
 
$(* Zeiger auf akt. Dateinamen dem Editor mit bergeben
&IF isToolbox THEN
(Append (' ^', s, voidO);
(Append (CardToStr (LONGCARD (ADR (TextName)), 0), s, voidO);
(Append (' ', s, voidO);
&END;
$*)
 
$IF EditorParm.tempShellFile THEN
&SplitPath (EditorParm.name, tempPath, voidStr);
&Append (EditorParm.tempShellName, tempPath, voidO);
&Append (tempPath, s, strVal);
&writeTempFile;
$END;
$
$IF ~ EditorParm.passArgument THEN s := '' END;
$
$lastBreak:= shellParm.breakActive;
$shellParm.breakActive:= FALSE;
$call (EditorParm.name, s, EditorStackSize, FALSE, FALSE, TRUE);
$shellParm.breakActive:= lastBreak;
$
$IF EditorParm.tempEditorFile THEN
&SplitPath (EditorParm.name, tempPath, voidStr);
&Append (EditorParm.tempEditorName, tempPath, voidO);
&ReplaceHome (tempPath);
&Open (f, tempPath, readSeqTxt);
&IF State (f) = fOK THEN
(Text.ReadString (f, s);
(Close (f);
(zero := 0;
(exitCode := StrToCard (s, zero, strVal);
(IF ~ strVal THEN exitCode := 0 END;
&ELSE
(exitCode:= 0
&END;
$END;
$
$autoCmd := noCmd;
$IF callRes # noError THEN
&alert (EdStr^, callMsg, OkStr^)
$ELSE
&CASE exitCode OF
(1: autoCmd := compile|
(2: autoCmd := exec_src|
(3: autoCmd := dftMake|
(4: autoCmd := dftMake_exec|
&ELSE
&END;
&IF (autoCmd = dftMake_exec) OR (autoCmd = dftMake) THEN
(IF NOT makeActive THEN
*editorsMakeCmd:= autoCmd;
*makeActive:= TRUE;
(END;
(autoCmd:= contMake
&ELSE
(IF makeActive THEN
*FormAlert (1, ContMakeAlt^, buttonNum);
*IF buttonNum = 1 THEN
,autoCmd:= contMake
*END
(END
&END
$END;
"END callEdit;
 
 PROCEDURE hdedit (wrk: BOOLEAN);
 
"VAR name1, name2: NameStr;
&dummy       : Str128;
"
"BEGIN
$IF wrk THEN
&callEdit (workFName, FALSE);
$ELSE
&callEdit (currFn, FALSE)
$END;
$Upper (TextName);
$SplitPath (TextName, dummy, name1);
$SplitPath (workFName, dummy, name2);
$IF NOT StrEqual (name1, name2) THEN lastFn := TextName END;
"END hdedit;
 
 PROCEDURE hdrun (wrk, tool: BOOLEAN);
 
"VAR   found,
(codeOK  : BOOLEAN;
(f       : File;
(cDate,
(sDate   : Clock.Date;
(cTime,
(sTime   : Clock.Time;
(sname,
(cname,
(voidStr,
(suffix  : FileStr;
 
 
"PROCEDURE longTime (d:Clock.Date; t:Clock.Time): LONGCARD;
$BEGIN
&RETURN LONG (Clock.PackDate (d)) * $10000 + LONG (Clock.PackTime (t))
$END longTime;
 
"PROCEDURE getCodeDateTime (    suffix: MySuf;
Apaths : PathList;
=VAR cname : FileStr;
=VAR found : BOOLEAN);
$VAR testName: FileStr;
(testN2: FileStr;
(path: ptrString;
$BEGIN
&found:= FALSE;
 
&ConcatName (cname, suf[suffix], testN2);
&IF NOT Empty (MainOutputPath) THEN
((* Eingestellten Ausgabe-Pfad prfen *)
(Concat (MainOutputPath, testN2, testName, voidO);
&ELSE
((* Ausgabe-Pfad aus Compiler-Pfaden prfen *)
(IF suffix = imp THEN
*Concat (ImpOutPath, testN2, testName, voidO);
(ELSE
*Concat (ModOutPath, testN2, testName, voidO);
(END
&END;
&ReplaceHome (testName);
&Open (f, testName, readOnly);
&found:= (State (f) >= fOK);
&IF NOT found THEN
((* Datei auf Default-Pfaden suchen *)
(SearchFile (testN2, paths, fromStart, found, testName);
(IF found THEN
*Open (f, testName, readOnly);
(END
&END;
&IF found THEN
(GetDateTime (f, cDate, cTime);
(Close (f);
(cname:= testName;
&END;
$END getCodeDateTime;
 
"BEGIN (* hdrun *)
$codeOK := FALSE;
$(* check, wether code is valid if source is executed *)
$IF wrk THEN
&SearchFile (workFName, SrcPaths, fromStart, found, sname);
$ELSIF IsSourceName (currFn) THEN
&SearchFile (currFn, SrcPaths, fromStart, found, sname)
$ELSE
&(* wir haben einen Code -> sofort ausfhren *)
&codeOK := TRUE
$END;
$IF NOT codeOK THEN
&IF found THEN
((* Source vorhanden *)
(IF wrk THEN
*workFName:= sname; cname:= workCName
(ELSE
*currFn:= sname; cname:= ''
(END;
(IF Empty (cname) THEN
*(* Wir mssen den Code suchen *)
*SplitPath (sname, voidStr, cname);
*SplitName (cname, cname, suffix);
*getCodeDateTime (mod, ModPaths, cname, codeOK);
*IF NOT codeOK THEN
,getCodeDateTime (mos, ModPaths, cname, codeOK) END;
*IF NOT codeOK THEN
,getCodeDateTime (mtp, ModPaths, cname, codeOK) END;
*IF NOT codeOK THEN
,getCodeDateTime (imp, ImpPaths, cname, codeOK) END;
(ELSE
*(* Code schon vorhanden *)
*Open (f, cname, readOnly);
*codeOK:= (State (f) = fOK);
*IF codeOK THEN
,GetDateTime (f, cDate, cTime);
,Close (f);
*END;
(END;
(IF codeOK THEN
*(* Code vorhanden -> Zeit der Source ermitteln und mit Code vergl. *)
*Open (f, sname, readOnly);
*GetDateTime (f, sDate, sTime);
*Close (f);
*codeOK:= longTime (cDate,cTime) >= longTime (sDate,sTime);
(END;
&ELSE
((* Source nicht vorhanden -> Fehler melden? *)
((* wenn nicht, wird einfach Compiler gestartet... (weil codeOK=FALSE) *)
&END;
&
$ELSE
&cname:= currFn
$END;
$
$IF codeOK THEN
&IF wrk THEN workCName := cname
&ELSE CodeName := cname END;
&call (cname, args, 0, TRUE, TRUE, tool)
$ELSE
&IF wrk THEN workCName:= '' END;
&TextName := sname;
&autoCmd := comp_exec
$END
$
"END hdrun;
 
 
 PROCEDURE DoEditBox (batch, mustShow: BOOLEAN; VAR cont: BOOLEAN);
"VAR s: String;
&msg: Str128;
&buttonNum: CARDINAL;
"BEGIN
$(* Signalton: *)
$bing;
$IF mustShow OR EditorParm.waitOnError THEN
&msg := '[2][][]';
&IF batch THEN
(Insert (EditBatStr^, 6, msg, voidO)
&ELSE
(Insert (EditStr^, 6, msg, voidO)
&END;
&s:= ErrorMsg;
&WrapAlert (s, 0);
&Insert (s, 4, msg, voidO);
&FormAlert (1, msg, buttonNum);
&IF buttonNum = 1 THEN
(autoCmd:= edit; cont:= FALSE;
&ELSE
(autoCmd:= noCmd; cont:= (buttonNum = 2);
&END
$ELSE
&autoCmd:= edit; cont:= FALSE;
$END
"END DoEditBox;
 
 
 (*  callComp -- Calls the compiler to compile the file 'modName'.
!*              'work = TRUE' means the workfile is compiled.
!*              'batch = TRUE' means the compiler is called while
!*              executing a batch file. In that case 'cont' states,
!*              if the execution of the batch file has to continue
!*              after this proc. returns.
!*)
 
 PROCEDURE callComp (VAR modname: ARRAY OF CHAR;
8work,
8batch  : BOOLEAN;
4VAR cont   : BOOLEAN);
 
"VAR i:INTEGER;
&s,msg:Str128;
 
"BEGIN
$(*  String mit Compileroptionen aufbauen.
%*)
$WITH CompilerParm DO
&IF shortMsgs THEN s:= ' -Q' ELSE s:= ' +Q' END;
&Append (' ', s, voidO);
&Append (CompilerArgs, s, voidO);
&IF ~ Empty (MainOutputPath) THEN
(Append (' /O', s, voidO);
(Append (MainOutputPath, s, voidO);
&END;
&IF protocol THEN
(Append (' /C', s, voidO);
(Append (CardToStr (protWidth, 0), s, voidO);
(Append (' /P', s, voidO);
(Append (protName, s, voidO);
&END;
$END;
$
$CodeName:= '';
$IF autoCmd = scan THEN ScanMode:= TRUE END;
$call (CompilerParm.name, conc (modname, s),
*CompilerStackSize, FALSE, FALSE, TRUE);
$
$cont:= TRUE;
$IF callRes # noError THEN
&alert (CompStr^, callMsg, OkStr^);
&autoCmd:= noCmd
$ELSE
&CASE exitCode OF
(0:   IF autoCmd = scan THEN
/autoCmd:= edit
-ELSIF ~ batch THEN
-
/IF makeActive THEN
1CodeName:= LastCodeName;
/ELSE
1Upper (CodeName);
1LastCodeName:= CodeName;
1LastCodeSize:= CodeSize;
/END;
/IF work THEN
1workCName:= CodeName;
1writeWorkName (TextName, CodeName);
/END;
/IF autoCmd = comp_exec THEN
1autoCmd:= execute
/ELSE
1autoCmd:= noCmd
/END;
/
-END|
(2:   DoEditBox (batch, TRUE, cont)|
(3:   DoEditBox (batch, FALSE, cont)
&ELSE
(autoCmd:= noCmd
&END
$END
"END callComp;
 
 
 PROCEDURE callLink (VAR moduleName: ARRAY OF CHAR);
 
"VAR s: ARRAY [0..124] OF CHAR;
"
"BEGIN
$Assign (moduleName, s, voidO);
$WITH LinkerParm DO
&IF optimize = partOptimize THEN
(Append (' -H', s, voidO);
&ELSIF optimize = nameOptimize THEN
(Append (' -M', s, voidO);
&ELSIF optimize = fullOptimize THEN
(Append (' -F', s, voidO);
&END;
&IF fastLoad THEN
(Append (' -0', s, voidO)
&END;
&IF fastCode THEN
(Append (' -1', s, voidO)
&END;
&IF fastMemory THEN
(Append (' -2', s, voidO)
&END;
&IF symbolFile THEN
(Append (' -S', s, voidO);
(Append (symbolArgs, s, voidO)
&END;
&IF outputName[0] # '' THEN
(Append (' -O', s, voidO);
(Append (outputName, s, voidO)
&END;
&call (name, s, LinkerStackSize, FALSE, FALSE, TRUE);
$END;
$IF callRes # noError THEN
&alert (LinkStr^, callMsg, OkStr^)
$END
"END callLink;
 
 
 PROCEDURE callMake (REF name: ARRAY OF CHAR; batch: BOOLEAN; VAR cont: BOOLEAN);
 
"BEGIN
$call (shellParm.makeName, name, MakeStackSize, FALSE, FALSE, TRUE);
$cont:= TRUE;
$IF callRes # noError THEN
&alert (MakeStr^, callMsg, OkStr^);
&autoCmd:= noCmd;
$ELSE
&CASE exitCode OF
(0: LastCodeName:= CodeName;
+LastCodeSize:= 0L;
+ConcatPath (TemporaryPath, MakeCompFileName, TextName);
+ReplaceHome (TextName);
+IF autoCmd = make_exec THEN autoCmd:= comp_exec
+ELSE autoCmd:= compile END|
(1: IF autoCmd = make_exec THEN autoCmd:= execute
+ELSE autoCmd:= noCmd END|
(2: DoEditBox (batch, FALSE, cont)
&ELSE
(autoCmd:= noCmd;
&END;
$END
"END callMake;
 
 
 PROCEDURE hdscan (wrk: BOOLEAN);
 
"BEGIN
$ErrorMsg:= '<Scanned>';
$autoCmd:= scan;
$IF wrk THEN callComp (workFName, TRUE, FALSE, voidO);
$ELSIF Empty (currFn) THEN callComp (lastFn, FALSE, FALSE, voidO)
$ELSE callComp (currFn, FALSE, FALSE, voidO) END;
"END hdscan;
 
 PROCEDURE hdcomp (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callComp (workFName, TRUE, FALSE, voidO);
$ELSE callComp (currFn, FALSE, FALSE, voidO); lastFn:= currFn; END;
"END hdcomp;
 
 PROCEDURE hdlink (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callLink (workCName)
$ELSE callLink (currFn) END;
"END hdlink;
"
 PROCEDURE hdmake (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callMake (workFName, FALSE, voidO)
$ELSE callMake (currFn, FALSE, voidO) END;
"END hdmake;
 
 PROCEDURE action (what: actionType; wrkFile, tool: BOOLEAN);
 
"TYPE aTypeSet = SET OF actionType;
"
"CONST noHideAction = aTypeSet {doLoad, doUnLd, doCont};
"
"VAR s       : Str128;
&dummy, i: CARDINAL;
&n1, n2  : ARRAY [0..11] OF CHAR;
&hidden  : BOOLEAN;
 
"BEGIN
$IF wrkFile THEN readWorkNames END;
$
$IF what IN noHideAction THEN hidden:= FALSE
$ELSE HideSS (TRUE); hidden:= TRUE END;
$
$editorsMakeCmd:= noCmd;
$makeActive:= FALSE;
$CASE what OF
&doEdit: hdedit (wrkFile)|
&doComp: hdcomp (wrkFile)|
&doExec: hdrun (wrkFile, tool);
.IF wrkFile THEN writeWorkName (workFName, workCName) END|
&doLink: hdlink (wrkFile)|
&doScan: hdscan (wrkFile)|
&doCpEx: autoCmd := comp_exec; hdcomp (wrkFile)|
&doLoad: load|
&doUnLd: unload|
&doCont: InputScan (ErrorMsg, ScanIndex);
.PrepareScan;
.IF ScanBox (TextName) THEN
0HideSS (TRUE); hidden:= TRUE;
0autoCmd:= scan;
0callComp (TextName, FALSE, FALSE, voidO)
.END|
&doBtch: IF wrkFile THEN ExecuteBatch (workFName, TRUE)
.ELSE ExecuteBatch (currFn, TRUE) END|
&doParm: IF wrkFile THEN LoadParameter (workFName, TRUE)
.ELSE LoadParameter (currFn, TRUE) END|
&doMake,
&doMkEx,
&doDftM: makeActive:= TRUE;
.autoCmd:= contMake
$ELSE
$END;
 
$REPEAT
&CASE autoCmd OF
 
(contMake:  CASE what OF
5doMake: autoCmd:= noCmd; hdmake (wrkFile)|
5doMkEx: autoCmd:= make_exec; hdmake (wrkFile)|
5doDftM: autoCmd:= dftMake
3ELSE
5autoCmd:= editorsMakeCmd
3END|
 
(edit     : Concat (TextName, ' ', s, strVal);
3IF EditorParm.passErrorPos THEN
5Append (CardToStr (TextLine, 0), s, strVal);
5Append (' ', s, strVal);
5Append (CardToStr (TextCol - 1, 0), s, strVal);
5Append (' ', s, strVal);
3END;
3IF EditorParm.passErrorText THEN
5Append ('"', s, strVal);
5Append (ErrorMsg, s, voidO);
5Append ('" ', s, strVal);
3END;
3callEdit (s, TRUE)|
 
(scan,
(compile,
(comp_exec: callComp (TextName, wrkFile, FALSE, voidO)|
(
(exec_src : autoCmd:= noCmd;
3workFName:= '';
3workCName:= '';
3wrkFile:= FALSE;
3WITH WorkField DO
5IF current >= 0 THEN
7i:= 0;
7LOOP (* workFile richtig bestimmen *)
9WITH elems[i] DO
;IF used & StrEqual (TextName, sourceName) THEN
=workFName:= sourceName;
=workCName:= codeName;
=wrkFile:= TRUE;
=EXIT
;END;
9END;
9INC (i);
9IF i = maxWorkFiles THEN
;EXIT
9END;
7END
5END;
3END;
3IF ~wrkFile THEN currFn:= TextName END;
3hdrun (wrkFile, tool);
3IF wrkFile THEN writeWorkName (workFName, workCName) END|
 
(execute  : autoCmd:= noCmd;
3call (CodeName, args, 0, TRUE, TRUE, tool)|
 
(dftMake_exec,
(dftMake  : IF autoCmd = dftMake_exec THEN autoCmd:= make_exec END;
3callMake ('' (* >> Make verw. Default-Namen aus ShellMsg *), FALSE, voidO)|
&ELSE
&END
$UNTIL autoCmd = noCmd;
$
$Assign (lastFn, TextName, voidO);
$
$IF hidden THEN ShowSS (TRUE) END;
"END action;
 
 
 
 TYPE    pathEntry       = RECORD
<used: BOOLEAN;
<path: PathStr;
:END;
 
 VAR     pathArray: ARRAY [1..MaxSearchPaths] OF pathEntry;
 
 PROCEDURE ExecuteBatch (name: ARRAY OF CHAR; load: BOOLEAN);
 
"VAR f                 : File;
&s, arg            : ARRAY[0..255] OF CHAR;
&gotLine, cont,
&doIt              : BOOLEAN;
&result            : INTEGER;
&oldDrive          : Drive;
&oldPath           : PathStr;
"
"PROCEDURE delSpc (VAR s:ARRAY OF CHAR);
$BEGIN
&WHILE s[0] = ' ' DO Delete (s,0,1, voidO) END
$END delSpc;
"
"PROCEDURE equ (a,b: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&Upper (a);
&Upper (b);
&RETURN Compare (FileName (a), FileName (b)) = equal
$END equ;
 
"PROCEDURE setLinkName (VAR n:ARRAY OF CHAR);
$VAR first: CHAR;
(i: CARDINAL;
(useEmpty: BOOLEAN;
$BEGIN
&first:=n[0];
&IF (first = '-') OR (first = '+') THEN
(Delete (n, 0, 1, voidO);
(delSpc (n);
&END;
&FOR useEmpty:= FALSE TO TRUE DO
(FOR i:= MIN (LLRange) TO  MAX (LLRange) DO
*IF equ (LinkerParm.linkList[i].name, n)
*OR (useEmpty AND Empty (LinkerParm.linkList[i].name)) THEN
,LinkerParm.linkList[i].valid:= (first # '-');
,Assign (n, LinkerParm.linkList[i].name, voidO);
,RETURN
*END
(END
&END
$END setLinkName;
"
"PROCEDURE setToolName (VAR n:ARRAY OF CHAR);
$VAR i: CARDINAL;
$BEGIN
&FOR i:=1 TO MaxTool DO
(IF ~ToolField[i].used THEN
*ToolField[i].used:= TRUE;
*Assign (n,ToolField[i].name, voidO);
*RETURN
(END
&END
$END setToolName;
"
"PROCEDURE getFirstPath (paths: PathList; VAR path: ARRAY OF CHAR);
$VAR entry: PathEntry;
$BEGIN
&Lists.ResetList (paths);
&entry:= Lists.NextEntry (paths);
&IF entry # NIL THEN
(Assign (entry^, path, voidO)
&ELSE
(path[0]:= ''
&END
$END getFirstPath;
"
"PROCEDURE killPaths (VAR paths: PathList);
"
$VAR entry: ADDRESS;
(idx  : CARDINAL;
"
$BEGIN
&Lists.ResetList (paths);
&entry:= Lists.PrevEntry (paths);
&WHILE entry # NIL DO
(idx:= 1;
(WHILE (idx <= MaxSearchPaths)
.AND (ADR (pathArray[idx].path) # entry) DO INC (idx) END;
(IF idx <= MaxSearchPaths THEN pathArray[idx].used:= FALSE END;
(Lists.RemoveEntry (paths, voidO);
(entry:= Lists.CurrentEntry (paths);
&END;
$END killPaths;
"
"PROCEDURE setP ( VAR paths: PathList );
$VAR err:BOOLEAN; c:CHAR; idx: CARDINAL;
$BEGIN
&killPaths (paths);
&idx:= 1;
&LOOP
(IF EOF (f) THEN EXIT END;
(Text.ReadString (f,s);
(IF s[0] # ' ' THEN EXIT END;
(WHILE (idx <= MaxSearchPaths) AND pathArray[idx].used DO INC (idx) END;
(IF idx <= MaxSearchPaths THEN
*EatSpaces (s);
*IF Compare ('.',s) = equal THEN s:= '' END;
*ValidatePath (s);
*Assign (s,pathArray[idx].path,err);
*Lists.AppendEntry (paths,ADR(pathArray[idx].path),err);
*pathArray[idx].used:= TRUE;
*INC (idx)
(ELSE
*alert (NoPathsStr^, '', OkStr^)
(END
&END;
&gotLine:= TRUE;
$END setP;
"
"PROCEDURE is (REF s0:ARRAY OF CHAR): BOOLEAN;
$BEGIN
&RETURN StrEqual (s0,s)
$END is;
 
"PROCEDURE prep (REF in: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&Split (in,PosLen (' ',in,0),s,arg,strVal);
&delSpc (arg);
&Upper (s);
&RETURN (s[0] # 0C) AND (s[0] # '*')
$END prep;
 
"PROCEDURE getLC (VAR l: LONGCARD);
$VAR i: CARDINAL;
$BEGIN
&i:= 0;
&l:= StrToLCard (arg, i, strVal);
$END getLC;
 
"VAR found, tell: BOOLEAN;
&i: CARDINAL;
&res : INTEGER;
 
"PROCEDURE unTell;
$BEGIN
&IF tell THEN TellLoading (endTell, ''); tell := FALSE END;
$END unTell;
 
"BEGIN
$ShowBee;
$tell:= FALSE;
$SearchFile (name, StdPaths, fromStart, found, name);
$Open (f, name, readSeqTxt);
$IF State (f) < 0 THEN
&GetStateMsg (State(f), s);
&alert (InfStr^, s, OkStr^);
$ELSE
&gotLine:= FALSE;
&cont:= TRUE;
&REPEAT
 
(IF NOT gotLine THEN Text.ReadString (f, s) END;
(gotLine:= FALSE;
(
(doIt:= FALSE;
(IF prep (s) THEN
*IF is ('IF_SHELLSTART') THEN    (*  IF-Clause  *)
,IF shellStart THEN
.doIt:= prep (arg);
,END;
*ELSIF is ('IF_EXITCODE') THEN
,i:= 0;
,IF StrToInt (arg, i, voidO) = exitCode THEN
.Copy (arg, i, 200, arg, voidO);
.doIt:= prep (arg);
,END
*ELSE
,doIt:= TRUE
*END;
(END;
 
(IF doIt THEN
H(*  misc  *)
*IF is ('WAIT') THEN
,alert (arg,'',ContStr^);
*ELSIF is ('STACKSIZE') THEN
,getLC (DefaultStackSize);
,IF DefaultStackSize < 1024L THEN DefaultStackSize:= 1024 END;
 
H(*  tools  *)
*ELSIF is ('DELETETOOLS') THEN
,FOR i:= 1 TO MaxTool DO ToolField[i].used:= FALSE END;  (*  Keine Tools  *)
*ELSIF is ('TOOL') THEN
,setToolName (arg)
H(*  loader commands  *)
*ELSIF is ('EXEC') THEN
,Split (arg, PosLen (' ', arg, 0), arg, s, strVal);
,delSpc (s);
,unTell;
,Upper (arg);
,IF IsMBTFile (arg) THEN
.ExecuteBatch (arg, load)
,ELSE
.call (arg, s, 0, FALSE, TRUE, FALSE);
,END;
,IF autoCmd # noCmd THEN cont := FALSE END;
*ELSIF is ('POSTAMBLE1') THEN
,Split (arg,PosLen (' ',arg,0),postAmble1,postArgs1,strVal);
,delSpc (postArgs1);
,withPost1:= TRUE;
*ELSIF is ('POSTAMBLE2') THEN
,Split (arg,PosLen (' ',arg,0),postAmble2,postArgs2,strVal);
,delSpc (postArgs2);
,withPost2:= TRUE;
*ELSIF is ('LOAD') THEN
,IF load THEN
.IF NOT tell THEN TellLoading (initTell, ''); tell := TRUE END;
.TellLoading (newTellValue, arg);
.LoadModule (arg, StdPaths, callMsg (* dummy *), callMsg,
:callRes);
,END
*ELSIF is ('UNLOAD') THEN
,IF load THEN
.UnLoadModule (arg, callRes)
,END
*
*ELSIF is ('LINKSTACKSIZE') THEN
,getLC (LinkerParm.linkStackSize);
*ELSIF is ('NO_OPTIMIZE') THEN
,LinkerParm.optimize:= noOptimize 
*ELSIF is ('NAME_OPTIMIZE') THEN
,LinkerParm.optimize:= nameOptimize 
*ELSIF is ('PART_OPTIMIZE') THEN
,LinkerParm.optimize:= partOptimize 
*ELSIF is ('FULL_OPTIMIZE') THEN
,LinkerParm.optimize:= fullOptimize 
*ELSIF is ('DRIVER') THEN
,setLinkName (arg)
*ELSIF is ('DELETEDRIVERS') THEN
,SysUtil0.ClearVar (LinkerParm.linkList);
 
H(*  comp./link/make  *)
*ELSIF is ('COMPILE') THEN
,autoCmd:= noCmd;
,unTell;
,callComp (arg, FALSE, TRUE, cont)
*ELSIF is ('MAKE') THEN
,autoCmd:= noCmd;
,unTell;
,callMake (arg, TRUE, cont)
*ELSIF is ('LINK') THEN
,autoCmd:= noCmd;
,unTell;
,callLink (arg)
*ELSIF is ('EDIT') THEN
,autoCmd:= noCmd;
,unTell;
,callEdit (arg, FALSE)
H(*  paths  *)
*ELSIF is ('SETDIR') THEN
,SetCurrentDir (defaultDrv, arg, voidI);
*ELSIF is ('SETDRIVE') THEN
,SetDefaultDrive (StrToDrive (arg))
*ELSIF is ('SETPATH') THEN
,SetDefaultPath (arg, voidI)
 
*ELSIF is ('DEFAULTPATH') THEN
,setP ( StdPaths );
*ELSIF is ('DEFPATH') THEN
,setP ( DefPaths );
,getFirstPath (DefPaths, DefOutPath);
*ELSIF is ('IMPPATH') THEN
,setP ( ImpPaths );
,getFirstPath (ImpPaths, ImpOutPath);
*ELSIF is ('MODPATH') THEN
,setP ( ModPaths );
,getFirstPath (ModPaths, ModOutPath);
*ELSIF is ('SOURCEPATH') THEN
,setP ( SrcPaths )
*ELSIF is ('DEFOUT') THEN
,Assign (arg, DefOutPath, voidO);
,ValidatePath (DefOutPath)
*ELSIF is ('IMPOUT') THEN
,Assign (arg, ImpOutPath, voidO);
,ValidatePath (ImpOutPath)
*ELSIF is ('MODOUT') THEN
,Assign (arg, ModOutPath, voidO);
,ValidatePath (ModOutPath)
*ELSIF is ('MAINOUTPUTPATH') THEN
,Assign (arg, MainOutputPath, voidO);
,ValidatePath (MainOutputPath);
*END;
(
(END;
(
&UNTIL EOF (f) OR NOT cont;
&Close (f);
 
&(* getFirstPath-Aufrufe hier weg und oben eingefgt *)
 
$END;
$unTell;
$ShowArrow;
"END ExecuteBatch;
 
 VAR     level   : CARDINAL;
 
 PROCEDURE envlpProc (start, inChild:BOOLEAN; VAR i:INTEGER);
 
"BEGIN
$IF ~inChild THEN
&IF start THEN
(IF level = 0 THEN
*IF shellParm.breakActive THEN voidO:=EnableBreak () END
(END;
(INC (level);
&ELSE
(DEC (level);
(IF level = 0 THEN
*IF shellParm.breakActive THEN DisableBreak END;
(END;
&END
$END;
"END envlpProc;
"
"
 VAR     oldOpen : InOutBase.OpenProc;
(oldClose: InOutBase.ClsProc;
 
 PROCEDURE myOpen (x, y: CARDINAL);
 
"BEGIN
$IF NOT callSwitchedToTextMode THEN
&HideMouse;
&clrscr;
&curon;
$END;
$oldOpen (x, y);
"END myOpen;
 
 PROCEDURE myClose;
 
"BEGIN
$IF NOT callSwitchedToTextMode THEN
&curoff;
&ShowMouse
$END;
$oldClose;
"END myClose;
 
 
 VAR     err     : BOOLEAN;
(wsp     : MemArea;
(envlpHdl: EnvlpCarrier;
(ch      : CHAR;
(idx     : CARDINAL;
 
 BEGIN (* Main of MShell *)
 
"(*  ShellMsg - Variablen initialisieren
#*)
"Active:= TRUE;
"
"(*  Pfadlisten anlegen
#*)
"Lists.CreateList (StdPaths,err);
"Lists.CreateList (DefPaths,err);
"Lists.CreateList (ImpPaths,err);
"Lists.CreateList (ModPaths,err);
"Lists.CreateList (SrcPaths,err);
"FOR idx:= 1 TO MaxSearchPaths DO pathArray[idx].used:= FALSE END;
 
"autoCmd:= noCmd;
"
"shellStart:= TRUE;
"
"IF InitSS () THEN
"
$(*  Kontrolle gestarteter Prozesse zur Ctrl-C - Aktivierung
%*)
$SetEnvelope (envlpHdl, envlpProc, wsp);
$
$(*  Link into 'InOutBase' driver procs
%*)
$oldOpen := InOutBase.OpenWdw;
$InOutBase.OpenWdw := myOpen;
$oldClose := InOutBase.CloseWdw;
$InOutBase.CloseWdw := myClose;
$
$shellStart:= FALSE;
$(*$? UseExtKeys: InstallKbdEvents; *)
$TalkWithUser;               (* Hauptschleife der Shell *)
$(*$? UseExtKeys: DeInstallKbdEvents; *)
 
$IF withPost1 THEN
&call (postAmble1, postArgs1, 0L, FALSE, TRUE, FALSE);
$END;
$IF withPost2 THEN
&call (postAmble2, postArgs2, 0L, FALSE, TRUE, FALSE);
$END;
 
$InOutBase.OpenWdw := oldOpen;
$InOutBase.CloseWdw := oldClose;
 
$(* eigenen Namen lschen, damit GEMINI die Shell nicht nochmal startet *)
$IF DoShellWrite & (GEMEnv.GEMVersion () >= $140) THEN
&IF NOT multiTOS THEN
(AESMisc.ShellWrite (FALSE, AESMisc.graphicPrgm, '', '');
&END
$END;
 
$ExitSS;
 
"ELSE
$TermProcess (fInsufficientMemory)
"END;
"
 END MM2TinyShell.
  
(* $000096BA$FFEE34BD$000126F0$000171BA$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFEC1D4A$FFF7016F$000001C2$FFF7016F$0001A06C$FFF7016F$FFEC67A7$FFF7016F$00005FE8$FFED6C22$FFF7016F$FFED6C22$00011614$FFF7016F$FFF7016F$FFF64330$00002098$FFE96D50$FFF7016F$FFF7016F$00014F4A$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFE96809$0001159C$FFEE34BD$FFF7016F$00004278$0000723D$FFF7016F$FFF7016F$000029C4T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000C82$00002FC6$000029C4$0000A2FA$000001C2$00001493$000001C2$00000781$000001C2$FFDEC118$0000A61B$0000A5CE$0000A5B0$000029C4$FFE18A32$00000C59*)
